/*
 * Decompiled with CFR 0.152.
 */
package VASSAL;

import VASSAL.tools.version.GitProperties;
import VASSAL.tools.version.VersionUtils;
import java.awt.Component;
import java.awt.GraphicsConfiguration;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.io.File;
import org.apache.commons.lang3.SystemUtils;

public final class Info {
    private static final GitProperties gitProperties;
    private static final String EXPIRY_VERSION = "3.4";
    private static final String UPDATE_VERSION = "3.2";
    private static final File homeDir;
    private static final File tmpDir;
    public static final String javaBinPath;
    private static final int instanceID;

    private Info() {
    }

    public static String getVersion() {
        return gitProperties.getVersion();
    }

    public static int getInstanceID() {
        return instanceID;
    }

    public static Rectangle getScreenBounds(Component c) {
        Rectangle bounds = new Rectangle(Toolkit.getDefaultToolkit().getScreenSize());
        GraphicsConfiguration config = c.getGraphicsConfiguration();
        Insets insets = Toolkit.getDefaultToolkit().getScreenInsets(config);
        bounds.translate(insets.left, insets.top);
        bounds.setSize(bounds.width - insets.left - insets.right, bounds.height - insets.top - insets.bottom);
        return bounds;
    }

    @Deprecated
    public static boolean isMacOSX() {
        return SystemUtils.IS_OS_MAC_OSX;
    }

    public static boolean isModuleTooNew(String version) {
        return Info.compareVersions(version, EXPIRY_VERSION) >= 0;
    }

    public static boolean hasOldFormat(String version) {
        return Info.compareVersions(version, UPDATE_VERSION) < 0;
    }

    @Deprecated
    public static int compareVersions(String v0, String v1) {
        return VersionUtils.compareVersions(v0, v1);
    }

    public static File getBaseDir() {
        return new File(System.getProperty("user.dir"));
    }

    public static File getBinDir() {
        return new File(System.getProperty("user.dir"));
    }

    public static File getDocDir() {
        String d = SystemUtils.IS_OS_MAC_OSX ? "Contents/Resources/doc" : "doc";
        return new File(Info.getBaseDir(), d);
    }

    public static File getConfDir() {
        return Info.getHomeDir();
    }

    public static File getTempDir() {
        return tmpDir;
    }

    public static File getPrefsDir() {
        return new File(Info.getConfDir(), "prefs");
    }

    public static File getHomeDir() {
        return homeDir;
    }

    @Deprecated
    public static boolean isDndEnabled() {
        return true;
    }

    @Deprecated
    public static boolean is2dEnabled() {
        return true;
    }

    static {
        String idstr;
        File f = SystemUtils.IS_OS_MAC_OSX ? new File(System.getProperty("user.home"), "Library/Application Support/VASSAL") : (SystemUtils.IS_OS_WINDOWS ? new File(System.getenv("APPDATA") + "/VASSAL") : new File(System.getProperty("user.home"), ".VASSAL"));
        homeDir = f;
        tmpDir = new File(homeDir, "tmp");
        if (!homeDir.exists()) {
            homeDir.mkdirs();
        }
        if (!tmpDir.exists()) {
            tmpDir.mkdirs();
        }
        if ((idstr = System.getProperty("VASSAL.id")) == null) {
            instanceID = 0;
        } else {
            int id;
            try {
                id = Integer.parseInt(idstr);
            }
            catch (NumberFormatException e) {
                id = -1;
            }
            instanceID = id;
        }
        gitProperties = new GitProperties();
        javaBinPath = System.getProperty("java.home") + File.separator + "bin" + File.separator + "java";
    }
}

