/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build;

import VASSAL.build.AbstractConfigurable;
import VASSAL.configure.ConfigureTree;
import VASSAL.counters.Decorator;
import VASSAL.counters.EditablePiece;

public class BadDataReport {
    private String message;
    private String data;
    private Throwable cause;

    public BadDataReport() {
    }

    public BadDataReport(String message, String data, Throwable cause) {
        this(null, null, message, data, cause);
    }

    public BadDataReport(String message, String data) {
        this(message, data, null);
    }

    public BadDataReport(EditablePiece piece, String message, String data, Throwable cause) {
        this(BadDataReport.getPieceName(piece), piece.getDescription(), message, data, cause);
    }

    public BadDataReport(EditablePiece piece, String message, String data) {
        this(BadDataReport.getPieceName(piece), piece.getDescription(), message, data, null);
    }

    public BadDataReport(EditablePiece piece, String message) {
        this(BadDataReport.getPieceName(piece), piece.getDescription(), message, "", null);
    }

    public BadDataReport(String pieceName, String traitDesc, String message, String data, Throwable cause) {
        Object m = pieceName != null && pieceName.length() > 0 ? pieceName + " " : "";
        m = (String)m + (String)(traitDesc != null && traitDesc.length() > 0 ? "[" + traitDesc + "] " : "");
        m = (String)m + (((String)m).length() > 0 ? "- " : "");
        this.message = m = (String)m + message;
        this.cause = cause;
        this.data = data;
    }

    protected static String getPieceName(EditablePiece piece) {
        if (piece instanceof Decorator) {
            return ((Decorator)((Object)piece)).getInner().getLocalizedName();
        }
        return piece.getLocalizedName();
    }

    public BadDataReport(AbstractConfigurable c, String message, String data, Throwable cause) {
        this.message = c.getConfigureName() + "[" + ConfigureTree.getConfigureName(c.getClass()) + "]: " + message;
        this.cause = cause;
        this.data = data;
    }

    public BadDataReport(AbstractConfigurable c, String messageKey, String data) {
        this(c, messageKey, data, null);
    }

    public String getMessage() {
        return this.message;
    }

    public Throwable getCause() {
        return this.cause;
    }

    public String getData() {
        return this.data;
    }
}

