/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build;

import VASSAL.build.GpIdSupport;
import VASSAL.build.widget.PieceSlot;
import VASSAL.counters.BasicPiece;
import VASSAL.counters.Decorator;
import VASSAL.counters.GamePiece;
import VASSAL.counters.PieceCloner;
import VASSAL.counters.PlaceMarker;
import java.util.ArrayList;
import java.util.HashMap;

public class GpIdChecker {
    protected GpIdSupport gpIdSupport;
    protected int maxId;
    protected boolean useName = false;
    protected boolean extensionsLoaded = false;
    final HashMap<String, SlotElement> goodSlots = new HashMap();
    final ArrayList<SlotElement> errorSlots = new ArrayList();

    public GpIdChecker() {
        this(null);
    }

    public GpIdChecker(GpIdSupport gpIdSupport) {
        this.gpIdSupport = gpIdSupport;
        this.maxId = -1;
    }

    public GpIdChecker(boolean useName) {
        this();
        this.useName = useName;
        this.extensionsLoaded = true;
    }

    public void add(PieceSlot pieceSlot) {
        this.testGpId(pieceSlot.getGpId(), new SlotElement(pieceSlot));
        GamePiece gp = pieceSlot.getPiece();
        this.checkTrait(gp, pieceSlot);
    }

    protected void checkTrait(GamePiece gp, PieceSlot slot) {
        if (gp == null || gp instanceof BasicPiece) {
            return;
        }
        if (gp instanceof PlaceMarker) {
            PlaceMarker pm = (PlaceMarker)gp;
            this.testGpId(pm.getGpId(), new SlotElement(pm, slot));
        }
        this.checkTrait(((Decorator)gp).getInner(), slot);
    }

    protected void testGpId(String id, SlotElement element) {
        if (!this.extensionsLoaded && id.contains(":")) {
            id = id.split(":")[1];
        }
        if (id == null || id.length() == 0) {
            this.errorSlots.add(element);
        } else {
            if (this.goodSlots.get(id) != null) {
                this.errorSlots.add(element);
            }
            try {
                if (this.extensionsLoaded) {
                    this.goodSlots.put(id, element);
                    System.out.println("Add Id " + id);
                } else {
                    int iid = Integer.parseInt(id);
                    this.goodSlots.put(id, element);
                    if (iid >= this.maxId) {
                        this.maxId = iid + 1;
                    }
                }
            }
            catch (Exception e) {
                this.errorSlots.add(element);
            }
        }
    }

    public boolean hasErrors() {
        return this.errorSlots.size() > 0;
    }

    public void fixErrors() {
        if (this.maxId >= this.gpIdSupport.getNextGpId()) {
            this.gpIdSupport.setNextGpId(this.maxId + 1);
        }
        for (SlotElement slotElement : this.errorSlots) {
            slotElement.updateGpId();
        }
    }

    public GamePiece createUpdatedPiece(GamePiece oldPiece) {
        SlotElement element;
        String gpid = (String)oldPiece.getProperty("PieceId");
        if (gpid != null && gpid.length() > 0 && (element = this.goodSlots.get(gpid)) != null) {
            return element.createPiece(oldPiece);
        }
        if (this.useName) {
            String oldPieceName = Decorator.getInnermost(oldPiece).getName();
            for (SlotElement el : this.goodSlots.values()) {
                GamePiece newPiece = el.getPiece();
                String newPieceName = Decorator.getInnermost(newPiece).getName();
                if (!oldPieceName.equals(newPieceName)) continue;
                return el.createPiece(oldPiece);
            }
        }
        return oldPiece;
    }

    public boolean findUpdatedPiece(GamePiece oldPiece) {
        SlotElement element;
        String gpid = (String)oldPiece.getProperty("PieceId");
        if (gpid != null && gpid.length() > 0 && (element = this.goodSlots.get(gpid)) != null) {
            return true;
        }
        if (this.useName) {
            String oldPieceName = Decorator.getInnermost(oldPiece).getName();
            for (SlotElement el : this.goodSlots.values()) {
                GamePiece newPiece = el.getPiece();
                String newPieceName = Decorator.getInnermost(newPiece).getName();
                if (!oldPieceName.equals(newPieceName)) continue;
                return true;
            }
        }
        return false;
    }

    class SlotElement {
        private PieceSlot slot = null;
        private PlaceMarker marker = null;
        private String id;

        public SlotElement() {
        }

        public SlotElement(PieceSlot ps) {
            this();
            this.slot = ps;
            this.id = ps.getGpId();
        }

        public SlotElement(PlaceMarker pm, PieceSlot ps) {
            this();
            this.marker = pm;
            this.slot = ps;
            this.id = pm.getGpId();
        }

        public String getGpId() {
            return this.id;
        }

        public void updateGpId() {
            if (this.marker == null) {
                this.slot.updateGpId();
            } else {
                this.marker.updateGpId();
            }
        }

        public GamePiece getPiece() {
            if (this.slot == null) {
                return this.marker;
            }
            return this.slot.getPiece();
        }

        public GamePiece createPiece(GamePiece oldPiece) {
            GamePiece newPiece = this.slot != null ? this.slot.getPiece() : this.marker.createMarker();
            newPiece = PieceCloner.getInstance().clonePiece(newPiece);
            this.copyState(oldPiece, newPiece);
            newPiece.setProperty("PieceId", this.getGpId());
            return newPiece;
        }

        protected void copyState(GamePiece oldPiece, GamePiece newPiece) {
            GamePiece p = newPiece;
            while (p != null) {
                if (p instanceof BasicPiece) {
                    p.setState(Decorator.getInnermost(oldPiece).getState());
                    p = null;
                    continue;
                }
                Decorator decorator = (Decorator)p;
                String type = decorator.myGetType();
                String newState = this.findStateFromType(oldPiece, type, p.getClass());
                if (newState != null && newState.length() > 0) {
                    decorator.mySetState(newState);
                }
                p = decorator.getInner();
            }
        }

        protected String findStateFromType(GamePiece oldPiece, String typeToFind, Class<? extends GamePiece> classToFind) {
            GamePiece p = oldPiece;
            while (p != null && !(p instanceof BasicPiece)) {
                Decorator d = (Decorator)Decorator.getDecorator(p, classToFind);
                if (d != null) {
                    if (d.getClass().equals(classToFind) && d.myGetType().equals(typeToFind)) {
                        return d.myGetState();
                    }
                    p = d.getInner();
                    continue;
                }
                p = null;
            }
            return null;
        }
    }
}

