/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module;

import VASSAL.build.Buildable;
import VASSAL.build.Builder;
import VASSAL.build.GameModule;
import VASSAL.command.AddPiece;
import VASSAL.command.ChangePiece;
import VASSAL.command.Command;
import VASSAL.command.CommandEncoder;
import VASSAL.command.MovePiece;
import VASSAL.command.NullCommand;
import VASSAL.command.PlayAudioClipCommand;
import VASSAL.command.RemovePiece;
import VASSAL.counters.ActionButton;
import VASSAL.counters.AreaOfEffect;
import VASSAL.counters.BasicPiece;
import VASSAL.counters.CalculatedProperty;
import VASSAL.counters.Clone;
import VASSAL.counters.CounterGlobalKeyCommand;
import VASSAL.counters.Deck;
import VASSAL.counters.Decorator;
import VASSAL.counters.Delete;
import VASSAL.counters.DynamicProperty;
import VASSAL.counters.Embellishment;
import VASSAL.counters.Embellishment0;
import VASSAL.counters.Footprint;
import VASSAL.counters.FreeRotator;
import VASSAL.counters.GamePiece;
import VASSAL.counters.GlobalHotKey;
import VASSAL.counters.Hideable;
import VASSAL.counters.Immobilized;
import VASSAL.counters.Labeler;
import VASSAL.counters.Marker;
import VASSAL.counters.MovementMarkable;
import VASSAL.counters.NonRectangular;
import VASSAL.counters.Obscurable;
import VASSAL.counters.Pivot;
import VASSAL.counters.PlaceMarker;
import VASSAL.counters.PlaySound;
import VASSAL.counters.PropertySheet;
import VASSAL.counters.Replace;
import VASSAL.counters.ReportState;
import VASSAL.counters.RestrictCommands;
import VASSAL.counters.Restricted;
import VASSAL.counters.ReturnToDeck;
import VASSAL.counters.SendToLocation;
import VASSAL.counters.SetGlobalProperty;
import VASSAL.counters.Stack;
import VASSAL.counters.SubMenu;
import VASSAL.counters.TableInfo;
import VASSAL.counters.Translate;
import VASSAL.counters.TriggerAction;
import VASSAL.counters.UsePrototype;
import VASSAL.tools.SequenceEncoder;
import java.awt.Point;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class BasicCommandEncoder
implements CommandEncoder,
Buildable {
    private static final Logger logger = LoggerFactory.getLogger(BasicCommandEncoder.class);
    private Map<String, BasicPieceFactory> basicFactories = new HashMap<String, BasicPieceFactory>();
    private Map<String, DecoratorFactory> decoratorFactories = new HashMap<String, DecoratorFactory>();
    private static final char PARAM_SEPARATOR = '/';
    public static final String ADD = "+/";
    public static final String REMOVE = "-/";
    public static final String CHANGE = "D/";
    public static final String MOVE = "M/";

    public BasicCommandEncoder() {
        this.basicFactories.put("stack", new BasicPieceFactory(){

            @Override
            public GamePiece createBasicPiece(String type) {
                return new Stack();
            }
        });
        this.basicFactories.put("piece;", new BasicPieceFactory(){

            @Override
            public GamePiece createBasicPiece(String type) {
                return new BasicPiece(type);
            }
        });
        this.basicFactories.put("deck;", new BasicPieceFactory(){

            @Override
            public GamePiece createBasicPiece(String type) {
                return new Deck(GameModule.getGameModule(), type);
            }
        });
        this.decoratorFactories.put("immob;", new DecoratorFactory(){

            @Override
            public Decorator createDecorator(String type, GamePiece inner) {
                return new Immobilized(inner, type);
            }
        });
        this.decoratorFactories.put("emb2;", new DecoratorFactory(){

            @Override
            public Decorator createDecorator(String type, GamePiece inner) {
                Embellishment e = new Embellishment(type, inner);
                if (e.getVersion() == 0) {
                    return new Embellishment0(type, inner);
                }
                return e;
            }
        });
        this.decoratorFactories.put("emb;", new DecoratorFactory(){

            @Override
            public Decorator createDecorator(String type, GamePiece inner) {
                return new Embellishment(type, inner);
            }
        });
        this.decoratorFactories.put("hide;", new DecoratorFactory(){

            @Override
            public Decorator createDecorator(String type, GamePiece inner) {
                return new Hideable(type, inner);
            }
        });
        this.decoratorFactories.put("obs;", new DecoratorFactory(){

            @Override
            public Decorator createDecorator(String type, GamePiece inner) {
                return new Obscurable(type, inner);
            }
        });
        this.decoratorFactories.put("label;", new DecoratorFactory(){

            @Override
            public Decorator createDecorator(String type, GamePiece inner) {
                return new Labeler(type, inner);
            }
        });
        this.decoratorFactories.put("table;", new DecoratorFactory(){

            @Override
            public Decorator createDecorator(String type, GamePiece inner) {
                return new TableInfo(type, inner);
            }
        });
        this.decoratorFactories.put("propertysheet;", new DecoratorFactory(){

            @Override
            public Decorator createDecorator(String type, GamePiece inner) {
                return new PropertySheet(type, inner);
            }
        });
        this.decoratorFactories.put("rotate;", new DecoratorFactory(){

            @Override
            public Decorator createDecorator(String type, GamePiece inner) {
                return new FreeRotator(type, inner);
            }
        });
        this.decoratorFactories.put("pivot;", new DecoratorFactory(){

            @Override
            public Decorator createDecorator(String type, GamePiece inner) {
                return new Pivot(type, inner);
            }
        });
        this.decoratorFactories.put("nonRect;", new DecoratorFactory(){

            @Override
            public Decorator createDecorator(String type, GamePiece inner) {
                return new NonRectangular(type, inner);
            }
        });
        this.decoratorFactories.put("mark;", new DecoratorFactory(){

            @Override
            public Decorator createDecorator(String type, GamePiece inner) {
                return new Marker(type, inner);
            }
        });
        this.decoratorFactories.put("restrict;", new DecoratorFactory(){

            @Override
            public Decorator createDecorator(String type, GamePiece inner) {
                return new Restricted(type, inner);
            }
        });
        this.decoratorFactories.put("placemark;", new DecoratorFactory(){

            @Override
            public Decorator createDecorator(String type, GamePiece inner) {
                return new PlaceMarker(type, inner);
            }
        });
        this.decoratorFactories.put("replace;", new DecoratorFactory(){

            @Override
            public Decorator createDecorator(String type, GamePiece inner) {
                return new Replace(type, inner);
            }
        });
        this.decoratorFactories.put("report;", new DecoratorFactory(){

            @Override
            public Decorator createDecorator(String type, GamePiece inner) {
                return new ReportState(type, inner);
            }
        });
        this.decoratorFactories.put("markmoved;", new DecoratorFactory(){

            @Override
            public Decorator createDecorator(String type, GamePiece inner) {
                return new MovementMarkable(type, inner);
            }
        });
        this.decoratorFactories.put("footprint;", new DecoratorFactory(){

            @Override
            public Decorator createDecorator(String type, GamePiece inner) {
                return new Footprint(type, inner);
            }
        });
        this.decoratorFactories.put("return;", new DecoratorFactory(){

            @Override
            public Decorator createDecorator(String type, GamePiece inner) {
                return new ReturnToDeck(type, inner);
            }
        });
        this.decoratorFactories.put("sendto;", new DecoratorFactory(){

            @Override
            public Decorator createDecorator(String type, GamePiece inner) {
                return new SendToLocation(type, inner);
            }
        });
        this.decoratorFactories.put("prototype;", new DecoratorFactory(){

            @Override
            public Decorator createDecorator(String type, GamePiece inner) {
                return new UsePrototype(type, inner);
            }
        });
        this.decoratorFactories.put("clone;", new DecoratorFactory(){

            @Override
            public Decorator createDecorator(String type, GamePiece inner) {
                return new Clone(type, inner);
            }
        });
        this.decoratorFactories.put("delete;", new DecoratorFactory(){

            @Override
            public Decorator createDecorator(String type, GamePiece inner) {
                return new Delete(type, inner);
            }
        });
        this.decoratorFactories.put("submenu;", new DecoratorFactory(){

            @Override
            public Decorator createDecorator(String type, GamePiece inner) {
                return new SubMenu(type, inner);
            }
        });
        this.decoratorFactories.put("translate;", new DecoratorFactory(){

            @Override
            public Decorator createDecorator(String type, GamePiece inner) {
                return new Translate(type, inner);
            }
        });
        this.decoratorFactories.put("AreaOfEffect;", new DecoratorFactory(){

            @Override
            public Decorator createDecorator(String type, GamePiece inner) {
                return new AreaOfEffect(type, inner);
            }
        });
        this.decoratorFactories.put("globalkey;", new DecoratorFactory(){

            @Override
            public Decorator createDecorator(String type, GamePiece inner) {
                return new CounterGlobalKeyCommand(type, inner);
            }
        });
        this.decoratorFactories.put("macro;", new DecoratorFactory(){

            @Override
            public Decorator createDecorator(String type, GamePiece inner) {
                return new TriggerAction(type, inner);
            }
        });
        this.decoratorFactories.put("PROP;", new DecoratorFactory(){

            @Override
            public Decorator createDecorator(String type, GamePiece inner) {
                return new DynamicProperty(type, inner);
            }
        });
        this.decoratorFactories.put("calcProp;", new DecoratorFactory(){

            @Override
            public Decorator createDecorator(String type, GamePiece inner) {
                return new CalculatedProperty(type, inner);
            }
        });
        this.decoratorFactories.put("setprop;", new DecoratorFactory(){

            @Override
            public Decorator createDecorator(String type, GamePiece inner) {
                return new SetGlobalProperty(type, inner);
            }
        });
        this.decoratorFactories.put("hideCmd;", new DecoratorFactory(){

            @Override
            public Decorator createDecorator(String type, GamePiece inner) {
                return new RestrictCommands(type, inner);
            }
        });
        this.decoratorFactories.put("playSound;", new DecoratorFactory(){

            @Override
            public Decorator createDecorator(String type, GamePiece inner) {
                return new PlaySound(type, inner);
            }
        });
        this.decoratorFactories.put("button;", new DecoratorFactory(){

            @Override
            public Decorator createDecorator(String type, GamePiece inner) {
                return new ActionButton(type, inner);
            }
        });
        this.decoratorFactories.put("globalhotkey;", new DecoratorFactory(){

            @Override
            public Decorator createDecorator(String type, GamePiece inner) {
                return new GlobalHotKey(type, inner);
            }
        });
    }

    public Decorator createDecorator(String type, GamePiece inner) {
        DecoratorFactory f;
        Decorator d = null;
        String prefix = type.substring(0, type.indexOf(59) + 1);
        if (prefix.length() == 0) {
            prefix = type;
        }
        if ((f = this.decoratorFactories.get(prefix)) != null) {
            d = f.createDecorator(type, inner);
        } else {
            System.err.println("Unknown type " + type);
            d = new Marker("mark;", inner);
        }
        return d;
    }

    protected GamePiece createBasic(String type) {
        BasicPieceFactory f;
        GamePiece p = null;
        String prefix = type.substring(0, type.indexOf(59) + 1);
        if (prefix.length() == 0) {
            prefix = type;
        }
        if ((f = this.basicFactories.get(prefix)) != null) {
            p = f.createBasicPiece(type);
        }
        return p;
    }

    public GamePiece createPiece(String type) {
        String innerType;
        SequenceEncoder.Decoder st = new SequenceEncoder.Decoder(type, '\t');
        type = st.nextToken();
        String string = innerType = st.hasMoreTokens() ? st.nextToken() : null;
        if (innerType != null) {
            Decorator d;
            GamePiece inner = this.createPiece(innerType);
            if (inner == null) {
                GameModule.getGameModule().getChatter().send("Invalid piece type - see Error Log for details");
                logger.warn("Could not create piece with type " + innerType);
                inner = new BasicPiece();
            }
            return (d = this.createDecorator(type, inner)) != null ? d : inner;
        }
        return this.createBasic(type);
    }

    @Override
    public void build(Element e) {
        Builder.build(e, this);
    }

    @Override
    public void addTo(Buildable parent) {
        ((GameModule)parent).addCommandEncoder(this);
    }

    @Override
    public void add(Buildable b) {
    }

    @Override
    public Element getBuildElement(Document doc) {
        return doc.createElement(this.getClass().getName());
    }

    @Override
    public Command decode(String command) {
        if (command.length() == 0) {
            return new NullCommand();
        }
        if (command.startsWith(ADD)) {
            command = command.substring(ADD.length());
            SequenceEncoder.Decoder st = new SequenceEncoder.Decoder(command, '/');
            String id = this.unwrapNull(st.nextToken());
            String type = st.nextToken();
            String state = st.nextToken();
            GamePiece p = this.createPiece(type);
            if (p == null) {
                return null;
            }
            p.setId(id);
            return new AddPiece(p, state);
        }
        if (command.startsWith(REMOVE)) {
            String id = command.substring(REMOVE.length());
            GamePiece target = GameModule.getGameModule().getGameState().getPieceForId(id);
            if (target == null) {
                return new RemovePiece(id);
            }
            return new RemovePiece(target);
        }
        if (command.startsWith(CHANGE)) {
            command = command.substring(CHANGE.length());
            SequenceEncoder.Decoder st = new SequenceEncoder.Decoder(command, '/');
            String id = st.nextToken();
            String newState = st.nextToken();
            String oldState = st.hasMoreTokens() ? st.nextToken() : null;
            return new ChangePiece(id, oldState, newState);
        }
        if (command.startsWith(MOVE)) {
            command = command.substring(MOVE.length());
            SequenceEncoder.Decoder st = new SequenceEncoder.Decoder(command, '/');
            String id = this.unwrapNull(st.nextToken());
            String newMapId = this.unwrapNull(st.nextToken());
            int newX = Integer.parseInt(st.nextToken());
            int newY = Integer.parseInt(st.nextToken());
            String newUnderId = this.unwrapNull(st.nextToken());
            String oldMapId = this.unwrapNull(st.nextToken());
            int oldX = Integer.parseInt(st.nextToken());
            int oldY = Integer.parseInt(st.nextToken());
            String oldUnderId = this.unwrapNull(st.nextToken());
            String playerid = st.nextToken(GameModule.getUserId());
            return new MovePiece(id, newMapId, new Point(newX, newY), newUnderId, oldMapId, new Point(oldX, oldY), oldUnderId, playerid);
        }
        return PlayAudioClipCommand.decode(command);
    }

    private String wrapNull(String s) {
        return s == null ? "null" : s;
    }

    private String unwrapNull(String s) {
        return "null".equals(s) ? null : s;
    }

    @Override
    public String encode(Command c) {
        SequenceEncoder se = new SequenceEncoder('/');
        if (c instanceof AddPiece) {
            AddPiece a = (AddPiece)c;
            return ADD + se.append(this.wrapNull(a.getTarget().getId())).append(a.getTarget().getType()).append(a.getState()).getValue();
        }
        if (c instanceof RemovePiece) {
            return REMOVE + ((RemovePiece)c).getId();
        }
        if (c instanceof ChangePiece) {
            ChangePiece cp = (ChangePiece)c;
            se.append(cp.getId()).append(cp.getNewState());
            if (cp.getOldState() != null) {
                se.append(cp.getOldState());
            }
            return CHANGE + se.getValue();
        }
        if (c instanceof MovePiece) {
            MovePiece mp = (MovePiece)c;
            se.append(mp.getId()).append(this.wrapNull(mp.getNewMapId())).append("" + mp.getNewPosition().x).append("" + mp.getNewPosition().y).append(this.wrapNull(mp.getNewUnderneathId())).append(this.wrapNull(mp.getOldMapId())).append("" + mp.getOldPosition().x).append("" + mp.getOldPosition().y).append(this.wrapNull(mp.getOldUnderneathId())).append(mp.getPlayerId());
            return MOVE + se.getValue();
        }
        if (c instanceof NullCommand) {
            return "";
        }
        if (c instanceof PlayAudioClipCommand) {
            return ((PlayAudioClipCommand)c).encode();
        }
        return null;
    }

    public static interface DecoratorFactory {
        public Decorator createDecorator(String var1, GamePiece var2);
    }

    public static interface BasicPieceFactory {
        public GamePiece createBasicPiece(String var1);
    }
}

