/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module;

import VASSAL.build.Buildable;
import VASSAL.build.GameModule;
import VASSAL.build.module.GlobalOptions;
import VASSAL.command.Command;
import VASSAL.command.CommandEncoder;
import VASSAL.configure.ColorConfigurer;
import VASSAL.configure.FontConfigurer;
import VASSAL.i18n.Resources;
import VASSAL.preferences.Prefs;
import VASSAL.tools.ErrorDialog;
import VASSAL.tools.KeyStrokeSource;
import VASSAL.tools.ScrollPane;
import VASSAL.tools.swing.SwingUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BoxLayout;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.plaf.basic.BasicTextAreaUI;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.PlainView;
import javax.swing.text.Segment;
import javax.swing.text.TabExpander;
import javax.swing.text.Utilities;
import javax.swing.text.View;
import javax.swing.text.WrappedPlainView;
import org.w3c.dom.Element;

public class Chatter
extends JPanel
implements CommandEncoder,
Buildable {
    private static final long serialVersionUID = 1L;
    protected JTextArea conversation;
    protected JTextField input;
    protected JScrollPane scroll = new ScrollPane(22, 30);
    protected static final String MY_CHAT_COLOR = "myChatColor";
    protected static final String OTHER_CHAT_COLOR = "otherChatColor";
    protected static final String GAME_MSG_COLOR = "gameMessageColor";
    protected static final String SYS_MSG_COLOR = "systemMessageColor";
    protected Color gameMsg;
    protected Color systemMsg;
    protected Color myChat;
    protected Color otherChat;

    public static String getAnonymousUserName() {
        return Resources.getString("Chat.anonymous");
    }

    public Chatter() {
        this.setLayout(new BoxLayout(this, 1));
        this.conversation = new JTextArea(10, 80);
        for (int i = 0; i < 10; ++i) {
            this.conversation.append("\n");
        }
        this.conversation.setEditable(false);
        this.conversation.setLineWrap(true);
        this.conversation.setWrapStyleWord(true);
        this.conversation.setUI(new UI());
        this.conversation.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                Chatter.this.scroll.getVerticalScrollBar().setValue(Chatter.this.scroll.getVerticalScrollBar().getMaximum());
            }
        });
        this.input = new JTextField(80);
        this.input.setFocusTraversalKeysEnabled(false);
        this.input.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Chatter.this.send(Chatter.this.formatChat(e.getActionCommand()));
                Chatter.this.input.setText("");
            }
        });
        this.input.setMaximumSize(new Dimension(this.input.getMaximumSize().width, this.input.getPreferredSize().height));
        this.scroll.setViewportView(this.conversation);
        this.add(this.scroll);
        this.add(this.input);
    }

    private String formatChat(String text) {
        String id = GlobalOptions.getInstance().getPlayerId();
        return "<" + (String)(id.length() == 0 ? "(" + Chatter.getAnonymousUserName() + ")" : id) + "> - " + text;
    }

    public JTextField getInputField() {
        return this.input;
    }

    public void show(String s) {
        this.conversation.append("\n" + s);
    }

    @Override
    public void setFont(Font f) {
        if (this.input != null) {
            if (this.input.getText().length() == 0) {
                this.input.setText("XXX");
                this.input.setFont(f);
                this.input.setText("");
            } else {
                this.input.setFont(f);
            }
        }
        if (this.conversation != null) {
            this.conversation.setFont(f);
        }
    }

    @Override
    public void build(Element e) {
    }

    @Override
    public Element getBuildElement(org.w3c.dom.Document doc) {
        return doc.createElement(this.getClass().getName());
    }

    @Override
    public void addTo(Buildable b) {
        GameModule mod = (GameModule)b;
        mod.setChatter(this);
        mod.addCommandEncoder(this);
        mod.addKeyStrokeSource(new KeyStrokeSource(this, 1));
        FontConfigurer chatFont = new FontConfigurer("ChatFont", Resources.getString("Chatter.chat_font_preference"));
        chatFont.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Chatter.this.setFont((Font)evt.getNewValue());
            }
        });
        mod.getControlPanel().add((Component)this, "Center");
        chatFont.fireUpdate();
        mod.getPrefs().addOption(Resources.getString("Chatter.chat_window"), chatFont);
        Prefs globalPrefs = Prefs.getGlobalPrefs();
        ColorConfigurer gameMsgColor = new ColorConfigurer(GAME_MSG_COLOR, Resources.getString("Chatter.game_messages_preference"), Color.magenta);
        gameMsgColor.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                Chatter.this.gameMsg = (Color)e.getNewValue();
            }
        });
        globalPrefs.addOption(Resources.getString("Chatter.chat_window"), gameMsgColor);
        this.gameMsg = (Color)globalPrefs.getValue(GAME_MSG_COLOR);
        ColorConfigurer systemMsgColor = new ColorConfigurer(SYS_MSG_COLOR, Resources.getString("Chatter.system_message_preference"), new Color(160, 160, 160));
        systemMsgColor.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                Chatter.this.systemMsg = (Color)e.getNewValue();
            }
        });
        globalPrefs.addOption(Resources.getString("Chatter.chat_window"), systemMsgColor);
        this.systemMsg = (Color)globalPrefs.getValue(SYS_MSG_COLOR);
        ColorConfigurer myChatColor = new ColorConfigurer(MY_CHAT_COLOR, Resources.getString("Chatter.my_text_preference"), Color.gray);
        myChatColor.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                Chatter.this.myChat = (Color)e.getNewValue();
            }
        });
        globalPrefs.addOption(Resources.getString("Chatter.chat_window"), myChatColor);
        this.myChat = (Color)globalPrefs.getValue(MY_CHAT_COLOR);
        ColorConfigurer otherChatColor = new ColorConfigurer(OTHER_CHAT_COLOR, Resources.getString("Chatter.other_text_preference"), Color.black);
        otherChatColor.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                Chatter.this.otherChat = (Color)e.getNewValue();
            }
        });
        globalPrefs.addOption(Resources.getString("Chatter.chat_window"), otherChatColor);
        this.otherChat = (Color)globalPrefs.getValue(OTHER_CHAT_COLOR);
    }

    @Override
    public void add(Buildable b) {
    }

    @Override
    public Command decode(String s) {
        if (s.startsWith("CHAT")) {
            return new DisplayText(this, s.substring(4));
        }
        return null;
    }

    @Override
    public String encode(Command c) {
        if (c instanceof DisplayText) {
            return "CHAT" + ((DisplayText)c).msg;
        }
        return null;
    }

    public void send(String msg) {
        if (msg != null && msg.length() > 0) {
            this.show(msg);
            GameModule.getGameModule().sendAndLog(new DisplayText(this, msg));
        }
    }

    public void keyCommand(KeyStroke e) {
        if (!(e.getKeyCode() != 0 && e.getKeyCode() != 65535 || Character.isISOControl(e.getKeyChar()))) {
            this.input.setText(this.input.getText() + e.getKeyChar());
        } else if (e.isOnKeyRelease()) {
            switch (e.getKeyCode()) {
                case 10: {
                    if (this.input.getText().length() > 0) {
                        this.send(this.formatChat(this.input.getText()));
                    }
                    this.input.setText("");
                    break;
                }
                case 8: 
                case 127: {
                    String s = this.input.getText();
                    if (s.length() <= 0) break;
                    this.input.setText(s.substring(0, s.length() - 1));
                }
            }
        }
    }

    private float drawColoredText(Graphics g, float x, float y, TabExpander ex, Document doc, int p0, int p1, javax.swing.text.Element elem) throws BadLocationException {
        Segment s = new Segment();
        doc.getText(p0, p1 - p0, s);
        g.setColor(this.getColor(elem));
        Graphics2D g2d = (Graphics2D)g;
        g2d.addRenderingHints(SwingUtils.FONT_HINTS);
        return Utilities.drawTabbedText(s, x, y, g2d, ex, p0);
    }

    protected Color getColor(javax.swing.text.Element elem) {
        Color col = null;
        try {
            String s = elem.getDocument().getText(elem.getStartOffset(), elem.getEndOffset() - elem.getStartOffset()).trim();
            if (s.length() > 0) {
                switch (s.charAt(0)) {
                    case '*': {
                        col = this.gameMsg;
                        break;
                    }
                    case '-': {
                        col = this.systemMsg;
                        break;
                    }
                    default: {
                        col = s.startsWith(this.formatChat("")) ? this.myChat : this.otherChat;
                    }
                }
            }
        }
        catch (BadLocationException e) {
            ErrorDialog.bug(e);
        }
        return col == null ? Color.black : col;
    }

    public static void main(String[] args) {
        Chatter chat = new Chatter();
        JFrame f = new JFrame();
        f.add(chat);
        f.pack();
        f.setVisible(true);
    }

    private class UI
    extends BasicTextAreaUI {
        private UI() {
        }

        @Override
        public View create(javax.swing.text.Element elem) {
            JTextComponent c = this.getComponent();
            if (c instanceof JTextArea) {
                JTextArea area = (JTextArea)c;
                View v = area.getLineWrap() ? new WrappedView(elem, area.getWrapStyleWord()) : new PView(elem);
                return v;
            }
            return null;
        }
    }

    public static class DisplayText
    extends Command {
        private String msg;
        private Chatter c;

        public DisplayText(Chatter c, String s) {
            this.c = c;
            this.msg = s;
            this.msg = this.msg.startsWith("<>") ? "<(" + Chatter.getAnonymousUserName() + ")>" + s.substring(2) : s;
        }

        @Override
        public void executeCommand() {
            this.c.show(this.msg);
        }

        @Override
        public Command myUndoCommand() {
            return new DisplayText(this.c, Resources.getString("Chatter.undo_message", this.msg));
        }

        public String getMessage() {
            return this.msg;
        }

        @Override
        public String getDetails() {
            return this.msg;
        }
    }

    private class PView
    extends PlainView {
        private PView(javax.swing.text.Element el) {
            super(el);
        }

        @Override
        protected float drawUnselectedText(Graphics2D g, float x, float y, int p0, int p1) throws BadLocationException {
            javax.swing.text.Element root = this.getElement();
            return Chatter.this.drawColoredText(g, x, y, this, this.getDocument(), p0, p1, root.getElement(root.getElementIndex(p0)));
        }
    }

    private class WrappedView
    extends WrappedPlainView {
        private WrappedView(javax.swing.text.Element el, boolean wrap) {
            super(el, wrap);
        }

        @Override
        protected float drawUnselectedText(Graphics2D g, float x, float y, int p0, int p1) throws BadLocationException {
            javax.swing.text.Element root = this.getElement();
            return Chatter.this.drawColoredText(g, x, y, this, this.getDocument(), p0, p1, root.getElement(root.getElementIndex(p0)));
        }
    }
}

