/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module;

import VASSAL.build.AbstractConfigurable;
import VASSAL.build.AutoConfigurable;
import VASSAL.build.Buildable;
import VASSAL.build.Configurable;
import VASSAL.build.GameModule;
import VASSAL.build.IllegalBuildException;
import VASSAL.build.module.ChartWindow;
import VASSAL.build.module.GameComponent;
import VASSAL.build.module.GlobalOptions;
import VASSAL.build.module.MultiActionButton;
import VASSAL.build.module.PlayerRoster;
import VASSAL.build.module.PrivateMap;
import VASSAL.build.module.ToolbarMenu;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.build.module.map.BoardPicker;
import VASSAL.build.module.map.CounterDetailViewer;
import VASSAL.build.module.map.DefaultPieceCollection;
import VASSAL.build.module.map.DrawPile;
import VASSAL.build.module.map.Drawable;
import VASSAL.build.module.map.ForwardToChatter;
import VASSAL.build.module.map.ForwardToKeyBuffer;
import VASSAL.build.module.map.GlobalMap;
import VASSAL.build.module.map.HidePiecesButton;
import VASSAL.build.module.map.HighlightLastMoved;
import VASSAL.build.module.map.ImageSaver;
import VASSAL.build.module.map.KeyBufferer;
import VASSAL.build.module.map.LOS_Thread;
import VASSAL.build.module.map.LayeredPieceCollection;
import VASSAL.build.module.map.MapCenterer;
import VASSAL.build.module.map.MapShader;
import VASSAL.build.module.map.MassKeyCommand;
import VASSAL.build.module.map.MenuDisplayer;
import VASSAL.build.module.map.PieceCollection;
import VASSAL.build.module.map.PieceMover;
import VASSAL.build.module.map.PieceRecenterer;
import VASSAL.build.module.map.Scroller;
import VASSAL.build.module.map.SelectionHighlighters;
import VASSAL.build.module.map.SetupStack;
import VASSAL.build.module.map.StackExpander;
import VASSAL.build.module.map.StackMetrics;
import VASSAL.build.module.map.TextSaver;
import VASSAL.build.module.map.Zoomer;
import VASSAL.build.module.map.boardPicker.Board;
import VASSAL.build.module.map.boardPicker.board.MapGrid;
import VASSAL.build.module.map.boardPicker.board.Region;
import VASSAL.build.module.map.boardPicker.board.RegionGrid;
import VASSAL.build.module.map.boardPicker.board.ZonedGrid;
import VASSAL.build.module.map.boardPicker.board.mapgrid.Zone;
import VASSAL.build.module.properties.ChangePropertyCommandEncoder;
import VASSAL.build.module.properties.GlobalProperties;
import VASSAL.build.module.properties.MutablePropertiesContainer;
import VASSAL.build.module.properties.MutableProperty;
import VASSAL.build.module.properties.PropertySource;
import VASSAL.build.widget.MapWidget;
import VASSAL.command.AddPiece;
import VASSAL.command.Command;
import VASSAL.command.MoveTracker;
import VASSAL.configure.BooleanConfigurer;
import VASSAL.configure.ColorConfigurer;
import VASSAL.configure.CompoundValidityChecker;
import VASSAL.configure.Configurer;
import VASSAL.configure.ConfigurerFactory;
import VASSAL.configure.IconConfigurer;
import VASSAL.configure.IntConfigurer;
import VASSAL.configure.MandatoryComponent;
import VASSAL.configure.NamedHotKeyConfigurer;
import VASSAL.configure.PlayerIdFormattedStringConfigurer;
import VASSAL.configure.VisibilityCondition;
import VASSAL.counters.ColoredBorder;
import VASSAL.counters.Deck;
import VASSAL.counters.DeckVisitor;
import VASSAL.counters.DeckVisitorDispatcher;
import VASSAL.counters.GamePiece;
import VASSAL.counters.Highlighter;
import VASSAL.counters.KeyBuffer;
import VASSAL.counters.PieceFinder;
import VASSAL.counters.PieceVisitorDispatcher;
import VASSAL.counters.Stack;
import VASSAL.i18n.Resources;
import VASSAL.i18n.TranslatableConfigurerFactory;
import VASSAL.preferences.PositionOption;
import VASSAL.preferences.Prefs;
import VASSAL.tools.AdjustableSpeedScrollPane;
import VASSAL.tools.ComponentSplitter;
import VASSAL.tools.KeyStrokeSource;
import VASSAL.tools.LaunchButton;
import VASSAL.tools.NamedKeyStroke;
import VASSAL.tools.ToolBarComponent;
import VASSAL.tools.UniqueIdManager;
import VASSAL.tools.WrapLayout;
import VASSAL.tools.menu.MenuManager;
import VASSAL.tools.swing.SwingUtils;
import java.awt.AWTEventMulticaster;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.AffineTransform;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.OverlayLayout;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import net.miginfocom.swing.MigLayout;
import org.jdesktop.animation.timing.Animator;
import org.jdesktop.animation.timing.TimingTarget;
import org.jdesktop.animation.timing.TimingTargetAdapter;
import org.w3c.dom.Element;

public class Map
extends AbstractConfigurable
implements GameComponent,
MouseListener,
MouseMotionListener,
DropTargetListener,
Configurable,
UniqueIdManager.Identifyable,
ToolBarComponent,
MutablePropertiesContainer,
PropertySource,
PlayerRoster.SideChangeListener {
    protected static boolean changeReportingEnabled = true;
    protected String mapID = "";
    protected String mapName = "";
    protected static final String MAIN_WINDOW_HEIGHT = "mainWindowHeight";
    protected static UniqueIdManager idMgr = new UniqueIdManager("Map");
    protected JPanel theMap;
    protected ArrayList<Drawable> drawComponents = new ArrayList();
    protected JLayeredPane layeredPane = new JLayeredPane();
    protected JScrollPane scroll;
    protected ComponentSplitter.SplitPane mainWindowDock;
    protected BoardPicker picker;
    protected JToolBar toolBar = new JToolBar();
    protected Zoomer zoom;
    protected StackMetrics metrics;
    protected Dimension edgeBuffer = new Dimension(0, 0);
    protected Color bgColor = Color.white;
    protected LaunchButton launchButton;
    protected boolean useLaunchButton = false;
    protected boolean useLaunchButtonEdit = false;
    protected String markMovedOption = "Always";
    protected String markUnmovedIcon = "/images/unmoved.gif";
    protected String markUnmovedText = "";
    protected String markUnmovedTooltip = Resources.getString("Map.mark_unmoved");
    protected MouseListener multicaster = null;
    protected ArrayList<MouseListener> mouseListenerStack = new ArrayList();
    protected List<Board> boards = new CopyOnWriteArrayList<Board>();
    protected int[][] boardWidths;
    protected int[][] boardHeights;
    protected PieceCollection pieces = new DefaultPieceCollection();
    protected Highlighter highlighter = new ColoredBorder();
    protected ArrayList<Highlighter> highlighters = new ArrayList();
    protected boolean clearFirst = false;
    protected boolean hideCounters = false;
    protected float pieceOpacity = 1.0f;
    protected boolean allowMultiple = false;
    protected VisibilityCondition visibilityCondition;
    protected DragGestureListener dragGestureListener;
    protected String moveWithinFormat;
    protected String moveToFormat;
    protected String createFormat;
    protected String changeFormat = "$message$";
    protected NamedKeyStroke moveKey;
    protected PropertyChangeListener globalPropertyListener;
    protected String tooltip = "";
    protected MutablePropertiesContainer propsContainer = new MutablePropertiesContainer.Impl();
    protected PropertyChangeListener repaintOnPropertyChange = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            Map.this.repaint();
        }
    };
    protected PieceMover pieceMover;
    protected KeyListener[] saveKeyListeners = null;
    public static final String NAME = "mapName";
    public static final String MARK_MOVED = "markMoved";
    public static final String MARK_UNMOVED_ICON = "markUnmovedIcon";
    public static final String MARK_UNMOVED_TEXT = "markUnmovedText";
    public static final String MARK_UNMOVED_TOOLTIP = "markUnmovedTooltip";
    public static final String EDGE_WIDTH = "edgeWidth";
    public static final String EDGE_HEIGHT = "edgeHeight";
    public static final String BACKGROUND_COLOR = "backgroundcolor";
    public static final String HIGHLIGHT_COLOR = "color";
    public static final String HIGHLIGHT_THICKNESS = "thickness";
    public static final String ALLOW_MULTIPLE = "allowMultiple";
    public static final String USE_LAUNCH_BUTTON = "launch";
    public static final String BUTTON_NAME = "buttonName";
    public static final String TOOLTIP = "tooltip";
    public static final String ICON = "icon";
    public static final String HOTKEY = "hotkey";
    public static final String SUPPRESS_AUTO = "suppressAuto";
    public static final String MOVE_WITHIN_FORMAT = "moveWithinFormat";
    public static final String MOVE_TO_FORMAT = "moveToFormat";
    public static final String CREATE_FORMAT = "createFormat";
    public static final String CHANGE_FORMAT = "changeFormat";
    public static final String MOVE_KEY = "moveKey";
    public static final String MOVING_STACKS_PICKUP_UNITS = "movingStacksPickupUnits";
    public static Map activeMap = null;
    public static final int PREFERRED_EDGE_SCROLL_DELAY = 200;
    public static final String PREFERRED_EDGE_DELAY = "PreferredEdgeDelay";
    public static final int SCROLL_ZONE = 30;
    protected int sx;
    protected int sy;
    protected int dx;
    protected int dy;
    protected Animator scroller = new Animator(-1, (TimingTarget)new TimingTargetAdapter(){
        private long t0;

        public void timingEvent(float fraction) {
            long t1 = System.currentTimeMillis();
            int dt = (int)((t1 - this.t0) / 2L);
            this.t0 = t1;
            Map.this.scroll(Map.this.sx * dt, Map.this.sy * dt);
            Rectangle vrect = Map.this.scroll.getViewport().getViewRect();
            if (Map.this.sx == -1 && vrect.x == 0 || Map.this.sx == 1 && vrect.x + vrect.width >= Map.this.theMap.getWidth()) {
                Map.this.sx = 0;
            }
            if (Map.this.sy == -1 && vrect.y == 0 || Map.this.sy == 1 && vrect.y + vrect.height >= Map.this.theMap.getHeight()) {
                Map.this.sy = 0;
            }
            if (Map.this.sx == 0 && Map.this.sy == 0) {
                Map.this.scroller.stop();
            }
        }

        public void begin() {
            this.t0 = System.currentTimeMillis();
        }
    });
    public static final String LOCATION = "location";
    public static final String OLD_LOCATION = "previousLocation";
    public static final String OLD_MAP = "previousMap";
    public static final String MAP_NAME = "mapName";
    public static final String PIECE_NAME = "pieceName";
    public static final String MESSAGE = "message";

    public Map() {
        this.getView();
        this.theMap.addMouseListener(this);
        if (this.shouldDockIntoMainWindow()) {
            this.toolBar.setLayout((LayoutManager)new MigLayout("ins 0,gapx 0,hidemode 3"));
        } else {
            this.toolBar.setLayout(new WrapLayout(0, 0, 0));
        }
        this.toolBar.setAlignmentX(0.0f);
        this.toolBar.setFloatable(false);
    }

    public static void setChangeReportingEnabled(boolean b) {
        changeReportingEnabled = b;
    }

    public static boolean isChangeReportingEnabled() {
        return changeReportingEnabled;
    }

    @Override
    public void setAttribute(String key, Object value) {
        if ("mapName".equals(key)) {
            this.setMapName((String)value);
        } else if (MARK_MOVED.equals(key)) {
            this.markMovedOption = (String)value;
        } else if (MARK_UNMOVED_ICON.equals(key)) {
            this.markUnmovedIcon = (String)value;
            if (this.pieceMover != null) {
                this.pieceMover.setAttribute(key, value);
            }
        } else if (MARK_UNMOVED_TEXT.equals(key)) {
            this.markUnmovedText = (String)value;
            if (this.pieceMover != null) {
                this.pieceMover.setAttribute(key, value);
            }
        } else if (MARK_UNMOVED_TOOLTIP.equals(key)) {
            this.markUnmovedTooltip = (String)value;
        } else if ("edge".equals(key)) {
            String s = (String)value;
            int i = s.indexOf(44);
            if (i > 0) {
                this.edgeBuffer = new Dimension(Integer.parseInt(s.substring(0, i)), Integer.parseInt(s.substring(i + 1)));
            }
        } else if (EDGE_WIDTH.equals(key)) {
            if (value instanceof String) {
                value = Integer.valueOf((String)value);
            }
            try {
                this.edgeBuffer = new Dimension((Integer)value, this.edgeBuffer.height);
            }
            catch (NumberFormatException ex) {
                throw new IllegalBuildException(ex);
            }
        } else if (EDGE_HEIGHT.equals(key)) {
            if (value instanceof String) {
                value = Integer.valueOf((String)value);
            }
            try {
                this.edgeBuffer = new Dimension(this.edgeBuffer.width, (Integer)value);
            }
            catch (NumberFormatException ex) {
                throw new IllegalBuildException(ex);
            }
        } else if (BACKGROUND_COLOR.equals(key)) {
            if (value instanceof String) {
                value = ColorConfigurer.stringToColor((String)value);
            }
            this.bgColor = (Color)value;
        } else if (ALLOW_MULTIPLE.equals(key)) {
            if (value instanceof String) {
                value = Boolean.valueOf((String)value);
            }
            this.allowMultiple = (Boolean)value;
            if (this.picker != null) {
                this.picker.setAllowMultiple(this.allowMultiple);
            }
        } else if (HIGHLIGHT_COLOR.equals(key)) {
            if (value instanceof String) {
                value = ColorConfigurer.stringToColor((String)value);
            }
            if (value != null) {
                ((ColoredBorder)this.highlighter).setColor((Color)value);
            }
        } else if (HIGHLIGHT_THICKNESS.equals(key)) {
            if (value instanceof String) {
                value = Integer.valueOf((String)value);
            }
            if (this.highlighter instanceof ColoredBorder) {
                ((ColoredBorder)this.highlighter).setThickness((Integer)value);
            }
        } else if (USE_LAUNCH_BUTTON.equals(key)) {
            if (value instanceof String) {
                value = Boolean.valueOf((String)value);
            }
            this.useLaunchButtonEdit = (Boolean)value;
            this.launchButton.setVisible(this.useLaunchButton);
        } else if (SUPPRESS_AUTO.equals(key)) {
            if (value instanceof String) {
                value = Boolean.valueOf((String)value);
            }
            if (Boolean.TRUE.equals(value)) {
                this.moveWithinFormat = "";
            }
        } else if (MOVE_WITHIN_FORMAT.equals(key)) {
            this.moveWithinFormat = (String)value;
        } else if (MOVE_TO_FORMAT.equals(key)) {
            this.moveToFormat = (String)value;
        } else if (CREATE_FORMAT.equals(key)) {
            this.createFormat = (String)value;
        } else if (CHANGE_FORMAT.equals(key)) {
            this.changeFormat = (String)value;
        } else if (MOVE_KEY.equals(key)) {
            if (value instanceof String) {
                value = NamedHotKeyConfigurer.decode((String)value);
            }
            this.moveKey = (NamedKeyStroke)value;
        } else if (TOOLTIP.equals(key)) {
            this.tooltip = (String)value;
            this.launchButton.setAttribute(key, value);
        } else {
            this.launchButton.setAttribute(key, value);
        }
    }

    @Override
    public String getAttributeValueString(String key) {
        if ("mapName".equals(key)) {
            return this.getMapName();
        }
        if (MARK_MOVED.equals(key)) {
            return this.markMovedOption;
        }
        if (MARK_UNMOVED_ICON.equals(key)) {
            return this.markUnmovedIcon;
        }
        if (MARK_UNMOVED_TEXT.equals(key)) {
            return this.markUnmovedText;
        }
        if (MARK_UNMOVED_TOOLTIP.equals(key)) {
            return this.markUnmovedTooltip;
        }
        if (EDGE_WIDTH.equals(key)) {
            return String.valueOf(this.edgeBuffer.width);
        }
        if (EDGE_HEIGHT.equals(key)) {
            return String.valueOf(this.edgeBuffer.height);
        }
        if (BACKGROUND_COLOR.equals(key)) {
            return ColorConfigurer.colorToString(this.bgColor);
        }
        if (ALLOW_MULTIPLE.equals(key)) {
            return String.valueOf(this.picker.isAllowMultiple());
        }
        if (HIGHLIGHT_COLOR.equals(key)) {
            if (this.highlighter instanceof ColoredBorder) {
                return ColorConfigurer.colorToString(((ColoredBorder)this.highlighter).getColor());
            }
            return null;
        }
        if (HIGHLIGHT_THICKNESS.equals(key)) {
            if (this.highlighter instanceof ColoredBorder) {
                return String.valueOf(((ColoredBorder)this.highlighter).getThickness());
            }
            return null;
        }
        if (USE_LAUNCH_BUTTON.equals(key)) {
            return String.valueOf(this.useLaunchButtonEdit);
        }
        if (MOVE_WITHIN_FORMAT.equals(key)) {
            return this.getMoveWithinFormat();
        }
        if (MOVE_TO_FORMAT.equals(key)) {
            return this.getMoveToFormat();
        }
        if (CREATE_FORMAT.equals(key)) {
            return this.getCreateFormat();
        }
        if (CHANGE_FORMAT.equals(key)) {
            return this.getChangeFormat();
        }
        if (MOVE_KEY.equals(key)) {
            return NamedHotKeyConfigurer.encode(this.moveKey);
        }
        if (TOOLTIP.equals(key)) {
            return this.tooltip == null || this.tooltip.length() == 0 ? this.launchButton.getAttributeValueString(this.name) : this.tooltip;
        }
        return this.launchButton.getAttributeValueString(key);
    }

    @Override
    public void build(Element e) {
        ActionListener al = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (Map.this.mainWindowDock == null && Map.this.launchButton.isEnabled() && Map.this.theMap.getTopLevelAncestor() != null) {
                    Map.this.theMap.getTopLevelAncestor().setVisible(!Map.this.theMap.getTopLevelAncestor().isVisible());
                }
            }
        };
        this.launchButton = new LaunchButton(Resources.getString("Editor.Map.map"), TOOLTIP, BUTTON_NAME, HOTKEY, ICON, al);
        this.launchButton.setEnabled(false);
        this.launchButton.setVisible(false);
        if (e != null) {
            super.build(e);
            this.getBoardPicker();
            this.getStackMetrics();
        } else {
            this.getBoardPicker();
            this.getStackMetrics();
            this.addChild(new ForwardToKeyBuffer());
            this.addChild(new Scroller());
            this.addChild(new ForwardToChatter());
            this.addChild(new MenuDisplayer());
            this.addChild(new MapCenterer());
            this.addChild(new StackExpander());
            this.addChild(new PieceMover());
            this.addChild(new KeyBufferer());
            this.addChild(new ImageSaver());
            this.addChild(new CounterDetailViewer());
            this.setMapName("Main Map");
        }
        if (this.getComponentsOf(GlobalProperties.class).isEmpty()) {
            this.addChild(new GlobalProperties());
        }
        if (this.getComponentsOf(SelectionHighlighters.class).isEmpty()) {
            this.addChild(new SelectionHighlighters());
        }
        if (this.getComponentsOf(HighlightLastMoved.class).isEmpty()) {
            this.addChild(new HighlightLastMoved());
        }
        this.setup(false);
    }

    private void addChild(Buildable b) {
        this.add(b);
        b.addTo(this);
    }

    public void setBoardPicker(BoardPicker picker) {
        if (this.picker != null) {
            GameModule.getGameModule().removeCommandEncoder(picker);
            GameModule.getGameModule().getGameState().addGameComponent(picker);
        }
        this.picker = picker;
        if (picker != null) {
            picker.setAllowMultiple(this.allowMultiple);
            GameModule.getGameModule().addCommandEncoder(picker);
            GameModule.getGameModule().getGameState().addGameComponent(picker);
        }
    }

    public BoardPicker getBoardPicker() {
        if (this.picker == null) {
            this.picker = new BoardPicker();
            this.picker.build(null);
            this.add(this.picker);
            this.picker.addTo(this);
        }
        return this.picker;
    }

    public void setZoomer(Zoomer z) {
        this.zoom = z;
    }

    public Zoomer getZoomer() {
        return this.zoom;
    }

    public void setStackMetrics(StackMetrics sm) {
        this.metrics = sm;
    }

    public StackMetrics getStackMetrics() {
        if (this.metrics == null) {
            this.metrics = new StackMetrics();
            this.metrics.build(null);
            this.add(this.metrics);
            this.metrics.addTo(this);
        }
        return this.metrics;
    }

    public double getZoom() {
        return this.zoom == null ? 1.0 : this.zoom.getZoomFactor();
    }

    @Override
    public JToolBar getToolBar() {
        return this.toolBar;
    }

    public void addDrawComponent(Drawable theComponent) {
        this.drawComponents.add(theComponent);
    }

    public void removeDrawComponent(Drawable theComponent) {
        this.drawComponents.remove(theComponent);
    }

    @Override
    public void addTo(Buildable b) {
        this.useLaunchButton = this.useLaunchButtonEdit;
        idMgr.add(this);
        GameModule g = GameModule.getGameModule();
        g.addCommandEncoder(new ChangePropertyCommandEncoder(this));
        this.validator = new CompoundValidityChecker(new MandatoryComponent(this, BoardPicker.class), new MandatoryComponent(this, StackMetrics.class)).append(idMgr);
        DragGestureListener dgl = new DragGestureListener(){

            @Override
            public void dragGestureRecognized(DragGestureEvent dge) {
                if (Map.this.dragGestureListener != null && Map.this.mouseListenerStack.isEmpty() && SwingUtils.isDragTrigger(dge)) {
                    Map.this.dragGestureListener.dragGestureRecognized(dge);
                }
            }
        };
        DragSource.getDefaultDragSource().createDefaultDragGestureRecognizer(this.theMap, 2, dgl);
        this.theMap.setDropTarget(PieceMover.DragHandler.makeDropTarget(this.theMap, 2, this));
        g.getGameState().addGameComponent(this);
        g.getToolBar().add(this.launchButton);
        if (this.shouldDockIntoMainWindow()) {
            IntConfigurer config = new IntConfigurer(MAIN_WINDOW_HEIGHT, null, (Integer)-1);
            Prefs.getGlobalPrefs().addOption(null, config);
            this.mainWindowDock = ComponentSplitter.split(ComponentSplitter.splitAncestorOf(g.getControlPanel(), -1), this.layeredPane, 1, true);
            this.mainWindowDock.setResizeWeight(0.0);
            g.addKeyStrokeSource(new KeyStrokeSource(this.theMap, 0));
        } else {
            g.addKeyStrokeSource(new KeyStrokeSource(this.theMap, 2));
        }
        this.toolBar.addHierarchyListener(new HierarchyListener(){

            @Override
            public void hierarchyChanged(HierarchyEvent e) {
                Window w = SwingUtilities.getWindowAncestor(Map.this.toolBar);
                if (w != null) {
                    w.validate();
                }
                if (Map.this.toolBar.getSize().width > 0) {
                    Map.this.toolBar.removeHierarchyListener(this);
                }
            }
        });
        GameModule.getGameModule().addSideChangeListenerToPlayerRoster(this);
        g.getPrefs().addOption(Resources.getString("Prefs.general_tab"), new IntConfigurer(PREFERRED_EDGE_DELAY, Resources.getString("Map.scroll_delay_preference"), (Integer)200));
        g.getPrefs().addOption(Resources.getString("Prefs.general_tab"), new BooleanConfigurer(MOVING_STACKS_PICKUP_UNITS, Resources.getString("Map.moving_stacks_preference"), Boolean.FALSE));
    }

    public void setPieceMover(PieceMover mover) {
        this.pieceMover = mover;
    }

    @Override
    public void removeFrom(Buildable b) {
        GameModule.getGameModule().getGameState().removeGameComponent(this);
        Window w = SwingUtilities.getWindowAncestor(this.theMap);
        if (w != null) {
            w.dispose();
        }
        GameModule.getGameModule().getToolBar().remove(this.launchButton);
        idMgr.remove(this);
        if (this.picker != null) {
            GameModule.getGameModule().removeCommandEncoder(this.picker);
            GameModule.getGameModule().getGameState().addGameComponent(this.picker);
        }
        PlayerRoster.removeSideChangeListener(this);
    }

    @Override
    public void sideChanged(String oldSide, String newSide) {
        this.repaint();
    }

    public synchronized void setBoards(Collection<Board> c) {
        this.boards.clear();
        for (Board b : c) {
            b.setMap(this);
            this.boards.add(b);
        }
        this.setBoardBoundaries();
    }

    @Override
    public Command getRestoreCommand() {
        return null;
    }

    public Board findBoard(Point p) {
        for (Board b : this.boards) {
            if (!b.bounds().contains(p)) continue;
            return b;
        }
        return null;
    }

    public Zone findZone(Point p) {
        MapGrid grid;
        Board b = this.findBoard(p);
        if (b != null && (grid = b.getGrid()) instanceof ZonedGrid) {
            Rectangle r = b.bounds();
            p.translate(-r.x, -r.y);
            return ((ZonedGrid)grid).findZone(p);
        }
        return null;
    }

    public Zone findZone(String name) {
        for (Board b : this.boards) {
            for (ZonedGrid zg : b.getAllDescendantComponentsOf(ZonedGrid.class)) {
                Zone z = zg.findZone(name);
                if (z == null) continue;
                return z;
            }
        }
        return null;
    }

    public Region findRegion(String name) {
        for (Board b : this.boards) {
            for (RegionGrid rg : b.getAllDescendantComponentsOf(RegionGrid.class)) {
                Region r = rg.findRegion(name);
                if (r == null) continue;
                return r;
            }
        }
        return null;
    }

    public Board getBoardByName(String name) {
        if (name != null) {
            for (Board b : this.boards) {
                if (!name.equals(b.getName())) continue;
                return b;
            }
        }
        return null;
    }

    public Dimension getPreferredSize() {
        Dimension size = this.mapSize();
        size.width = (int)((double)size.width * this.getZoom());
        size.height = (int)((double)size.height * this.getZoom());
        return size;
    }

    public synchronized Dimension mapSize() {
        Rectangle r = new Rectangle(0, 0);
        for (Board b : this.boards) {
            r.add(b.bounds());
        }
        r.width += this.edgeBuffer.width;
        r.height += this.edgeBuffer.height;
        return r.getSize();
    }

    public boolean isLocationRestricted(Point p) {
        Board b = this.findBoard(p);
        if (b != null) {
            Rectangle r = b.bounds();
            Point snap = new Point(p);
            snap.translate(-r.x, -r.y);
            return b.isLocationRestricted(snap);
        }
        return false;
    }

    public Point snapTo(Point p) {
        Point snap = new Point(p);
        Board b = this.findBoard(p);
        if (b == null) {
            return snap;
        }
        Rectangle r = b.bounds();
        snap.translate(-r.x, -r.y);
        snap = b.snapTo(snap);
        snap.translate(r.x, r.y);
        if (this.findBoard(snap) == null) {
            snap.translate(-r.x, -r.y);
            if (snap.x == r.width) {
                snap.x = r.width - 1;
            } else if (snap.x == -1) {
                snap.x = 0;
            }
            if (snap.y == r.height) {
                snap.y = r.height - 1;
            } else if (snap.y == -1) {
                snap.y = 0;
            }
            snap.translate(r.x, r.y);
        }
        return snap;
    }

    public Dimension getEdgeBuffer() {
        return new Dimension(this.edgeBuffer);
    }

    @Deprecated
    public Point mapCoordinates(Point p) {
        return this.componentToMap(p);
    }

    @Deprecated
    public Point componentCoordinates(Point p) {
        return this.mapToComponent(p);
    }

    protected int scale(int c, double zoom) {
        return (int)((double)c * zoom);
    }

    protected Point scale(Point p, double zoom) {
        return new Point((int)((double)p.x * zoom), (int)((double)p.y * zoom));
    }

    protected Rectangle scale(Rectangle r, double zoom) {
        return new Rectangle((int)((double)r.x * zoom), (int)((double)r.y * zoom), (int)((double)r.width * zoom), (int)((double)r.height * zoom));
    }

    public int mapToDrawing(int c, double os_scale) {
        return this.scale(c, this.getZoom() * os_scale);
    }

    public Point mapToDrawing(Point p, double os_scale) {
        return this.scale(p, this.getZoom() * os_scale);
    }

    public Rectangle mapToDrawing(Rectangle r, double os_scale) {
        return this.scale(r, this.getZoom() * os_scale);
    }

    public int mapToComponent(int c) {
        return this.scale(c, this.getZoom());
    }

    public Point mapToComponent(Point p) {
        return this.scale(p, this.getZoom());
    }

    public Rectangle mapToComponent(Rectangle r) {
        return this.scale(r, this.getZoom());
    }

    public int componentToDrawing(int c, double os_scale) {
        return this.scale(c, os_scale);
    }

    public Point componentToDrawing(Point p, double os_scale) {
        return this.scale(p, os_scale);
    }

    public Rectangle componentToDrawing(Rectangle r, double os_scale) {
        return this.scale(r, os_scale);
    }

    public int componentToMap(int c) {
        return this.scale(c, 1.0 / this.getZoom());
    }

    public Point componentToMap(Point p) {
        return this.scale(p, 1.0 / this.getZoom());
    }

    public Rectangle componentToMap(Rectangle r) {
        return this.scale(r, 1.0 / this.getZoom());
    }

    public int drawingToMap(int c, double os_scale) {
        return this.scale(c, 1.0 / (this.getZoom() * os_scale));
    }

    public Point drawingToMap(Point p, double os_scale) {
        return this.scale(p, 1.0 / (this.getZoom() * os_scale));
    }

    public Rectangle drawingToMap(Rectangle r, double os_scale) {
        return this.scale(r, 1.0 / (this.getZoom() * os_scale));
    }

    public int drawingToComponent(int c, double os_scale) {
        return this.scale(c, 1.0 / os_scale);
    }

    public Point drawingToComponent(Point p, double os_scale) {
        return this.scale(p, 1.0 / os_scale);
    }

    public Rectangle drawingToComponent(Rectangle r, double os_scale) {
        return this.scale(r, 1.0 / os_scale);
    }

    public String locationName(Point p) {
        Board b;
        String loc = this.getDeckNameAt(p);
        if (loc == null && (b = this.findBoard(p)) != null) {
            loc = b.locationName(new Point(p.x - b.bounds().x, p.y - b.bounds().y));
        }
        if (loc == null) {
            loc = Resources.getString("Map.offboard");
        }
        return loc;
    }

    public String localizedLocationName(Point p) {
        Board b;
        String loc = this.getLocalizedDeckNameAt(p);
        if (loc == null && (b = this.findBoard(p)) != null) {
            loc = b.localizedLocationName(new Point(p.x - b.bounds().x, p.y - b.bounds().y));
        }
        if (loc == null) {
            loc = Resources.getString("Map.offboard");
        }
        return loc;
    }

    public boolean isVisibleToAll() {
        return !(this instanceof PrivateMap) || this.getAttributeValueString("visible").equals("true");
    }

    public String getDeckNameContaining(Point p) {
        String deck = null;
        if (p != null) {
            for (DrawPile d : this.getComponentsOf(DrawPile.class)) {
                Rectangle box = d.boundingBox();
                if (box == null || !box.contains(p)) continue;
                deck = d.getConfigureName();
                break;
            }
        }
        return deck;
    }

    public String getDeckNameAt(Point p) {
        String deck = null;
        if (p != null) {
            for (DrawPile d : this.getComponentsOf(DrawPile.class)) {
                if (!d.getPosition().equals(p)) continue;
                deck = d.getConfigureName();
                break;
            }
        }
        return deck;
    }

    public String getLocalizedDeckNameAt(Point p) {
        String deck = null;
        if (p != null) {
            for (DrawPile d : this.getComponentsOf(DrawPile.class)) {
                if (!d.getPosition().equals(p)) continue;
                deck = d.getLocalizedConfigureName();
                break;
            }
        }
        return deck;
    }

    public void addLocalMouseListener(MouseListener l) {
        this.multicaster = AWTEventMulticaster.add(this.multicaster, l);
    }

    public void addLocalMouseListenerFirst(MouseListener l) {
        this.multicaster = AWTEventMulticaster.add(l, this.multicaster);
    }

    public void removeLocalMouseListener(MouseListener l) {
        this.multicaster = AWTEventMulticaster.remove(this.multicaster, l);
    }

    public void pushMouseListener(MouseListener l) {
        this.mouseListenerStack.add(l);
    }

    public void popMouseListener() {
        this.mouseListenerStack.remove(this.mouseListenerStack.size() - 1);
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    public MouseEvent translateEvent(MouseEvent e) {
        MouseEvent mapEvent = new MouseEvent(e.getComponent(), e.getID(), e.getWhen(), e.getModifiersEx(), e.getX(), e.getY(), e.getXOnScreen(), e.getYOnScreen(), e.getClickCount(), e.isPopupTrigger(), e.getButton());
        Point p = this.componentToMap(mapEvent.getPoint());
        mapEvent.translatePoint(p.x - mapEvent.getX(), p.y - mapEvent.getY());
        return mapEvent;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (!this.mouseListenerStack.isEmpty()) {
            this.mouseListenerStack.get(this.mouseListenerStack.size() - 1).mouseClicked(this.translateEvent(e));
        } else if (this.multicaster != null) {
            this.multicaster.mouseClicked(this.translateEvent(e));
        }
    }

    public static void clearActiveMap() {
        if (activeMap != null) {
            activeMap.repaint();
            activeMap = null;
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (!this.equals(activeMap)) {
            boolean dirty = false;
            KeyBuffer kbuf = KeyBuffer.getBuffer();
            ArrayList<GamePiece> l = new ArrayList<GamePiece>(kbuf.asList());
            for (GamePiece p : l) {
                if (p.getMap() != activeMap) continue;
                kbuf.remove(p);
                dirty = true;
            }
            if (dirty && activeMap != null) {
                activeMap.repaint();
            }
        }
        activeMap = this;
        if (!this.mouseListenerStack.isEmpty()) {
            this.mouseListenerStack.get(this.mouseListenerStack.size() - 1).mousePressed(this.translateEvent(e));
        } else if (this.multicaster != null) {
            this.multicaster.mousePressed(this.translateEvent(e));
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        Point p = e.getPoint();
        p.translate(this.theMap.getX(), this.theMap.getY());
        if (this.theMap.getBounds().contains(p)) {
            if (!this.mouseListenerStack.isEmpty()) {
                this.mouseListenerStack.get(this.mouseListenerStack.size() - 1).mouseReleased(this.translateEvent(e));
            } else if (this.multicaster != null) {
                this.multicaster.mouseReleased(this.translateEvent(e));
            }
            this.theMap.requestFocus();
        }
        this.clearFirst = true;
        this.theMap.repaint();
        activeMap = this;
    }

    public void enableKeyListeners() {
        if (this.saveKeyListeners == null) {
            return;
        }
        for (KeyListener kl : this.saveKeyListeners) {
            this.theMap.addKeyListener(kl);
        }
        this.saveKeyListeners = null;
    }

    public void disableKeyListeners() {
        if (this.saveKeyListeners != null) {
            return;
        }
        for (KeyListener kl : this.saveKeyListeners = this.theMap.getKeyListeners()) {
            this.theMap.removeKeyListener(kl);
        }
    }

    public void setDragGestureListener(DragGestureListener dragGestureListener) {
        this.dragGestureListener = dragGestureListener;
    }

    public DragGestureListener getDragGestureListener() {
        return this.dragGestureListener;
    }

    @Override
    public void dragEnter(DropTargetDragEvent dtde) {
    }

    @Override
    public void dragOver(DropTargetDragEvent dtde) {
        this.scrollAtEdge(dtde.getLocation(), 30);
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dtde) {
    }

    @Override
    public void dragExit(DropTargetEvent dte) {
        if (this.scroller.isRunning()) {
            this.scroller.stop();
        }
        this.repaint();
    }

    @Override
    public void drop(DropTargetDropEvent dtde) {
        if (dtde.getDropTargetContext().getComponent() == this.theMap) {
            MouseEvent evt = new MouseEvent(this.theMap, 502, System.currentTimeMillis(), 0, dtde.getLocation().x, dtde.getLocation().y, 1, false, 0);
            this.theMap.dispatchEvent(evt);
            dtde.dropComplete(true);
        }
        if (this.scroller.isRunning()) {
            this.scroller.stop();
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (!SwingUtils.isRightMouseButton(e)) {
            this.scrollAtEdge(e.getPoint(), 30);
        } else if (this.scroller.isRunning()) {
            this.scroller.stop();
        }
    }

    public void scrollAtEdge(Point evtPt, int dist) {
        Rectangle vrect = this.scroll.getViewport().getViewRect();
        int px = evtPt.x - vrect.x;
        int py = evtPt.y - vrect.y;
        this.sx = 0;
        if (px < dist && px >= 0) {
            this.sx = -1;
            this.dx = dist - px;
        } else if (px < vrect.width && px >= vrect.width - dist) {
            this.sx = 1;
            this.dx = dist - (vrect.width - px);
        }
        this.sy = 0;
        if (py < dist && py >= 0) {
            this.sy = -1;
            this.dy = dist - py;
        } else if (py < vrect.height && py >= vrect.height - dist) {
            this.sy = 1;
            this.dy = dist - (vrect.height - py);
        }
        this.dx /= 2;
        this.dy /= 2;
        if (this.sx != 0 || this.sy != 0) {
            if (!this.scroller.isRunning()) {
                this.scroller.setStartDelay(((Integer)GameModule.getGameModule().getPrefs().getValue(PREFERRED_EDGE_DELAY)).intValue());
                this.scroller.start();
            }
        } else if (this.scroller.isRunning()) {
            this.scroller.stop();
        }
    }

    public void repaint(boolean cf) {
        this.clearFirst = cf;
        this.theMap.repaint();
    }

    public void paintRegion(Graphics g, Rectangle visibleRect) {
        this.paintRegion(g, visibleRect, this.theMap);
    }

    public void paintRegion(Graphics g, Rectangle visibleRect, Component c) {
        this.clearMapBorder(g);
        this.drawBoardsInRegion(g, visibleRect, c);
        this.drawDrawable(g, false);
        this.drawPiecesInRegion(g, visibleRect, c);
        this.drawDrawable(g, true);
    }

    public void drawBoardsInRegion(Graphics g, Rectangle visibleRect, Component c) {
        Graphics2D g2d = (Graphics2D)g;
        double os_scale = g2d.getDeviceConfiguration().getDefaultTransform().getScaleX();
        double dzoom = this.getZoom() * os_scale;
        for (Board b : this.boards) {
            b.drawRegion(g, this.getLocation(b, dzoom), visibleRect, dzoom, c);
        }
    }

    public void drawBoardsInRegion(Graphics g, Rectangle visibleRect) {
        this.drawBoardsInRegion(g, visibleRect, this.theMap);
    }

    public void repaint() {
        this.theMap.repaint();
    }

    public void drawPiecesInRegion(Graphics g, Rectangle visibleRect, Component c) {
        GamePiece[] stack;
        if (this.hideCounters) {
            return;
        }
        Graphics2D g2d = (Graphics2D)g;
        double os_scale = g2d.getDeviceConfiguration().getDefaultTransform().getScaleX();
        double dzoom = this.getZoom() * os_scale;
        Composite oldComposite = g2d.getComposite();
        g2d.setComposite(AlphaComposite.getInstance(3, this.pieceOpacity));
        for (GamePiece gamePiece : stack = this.pieces.getPieces()) {
            Point pt = this.mapToDrawing(gamePiece.getPosition(), os_scale);
            if (gamePiece.getClass() == Stack.class) {
                this.getStackMetrics().draw((Stack)gamePiece, pt, g, this, dzoom, visibleRect);
                continue;
            }
            gamePiece.draw(g, pt.x, pt.y, c, dzoom);
            if (!Boolean.TRUE.equals(gamePiece.getProperty("Selected"))) continue;
            this.highlighter.draw(gamePiece, g, pt.x, pt.y, c, dzoom);
        }
        g2d.setComposite(oldComposite);
    }

    public void drawPiecesInRegion(Graphics g, Rectangle visibleRect) {
        this.drawPiecesInRegion(g, visibleRect, this.theMap);
    }

    public void drawPieces(Graphics g, int xOffset, int yOffset) {
        GamePiece[] stack;
        if (this.hideCounters) {
            return;
        }
        Graphics2D g2d = (Graphics2D)g;
        double os_scale = g2d.getDeviceConfiguration().getDefaultTransform().getScaleX();
        Composite oldComposite = g2d.getComposite();
        g2d.setComposite(AlphaComposite.getInstance(3, this.pieceOpacity));
        for (GamePiece gamePiece : stack = this.pieces.getPieces()) {
            Point pt = this.mapToDrawing(gamePiece.getPosition(), os_scale);
            gamePiece.draw(g, pt.x + xOffset, pt.y + yOffset, this.theMap, this.getZoom());
            if (!Boolean.TRUE.equals(gamePiece.getProperty("Selected"))) continue;
            this.highlighter.draw(gamePiece, g, pt.x - xOffset, pt.y - yOffset, this.theMap, this.getZoom());
        }
        g2d.setComposite(oldComposite);
    }

    public void drawDrawable(Graphics g, boolean aboveCounters) {
        for (Drawable drawable : this.drawComponents) {
            if (aboveCounters ^ drawable.drawAboveCounters()) continue;
            drawable.draw(g, this);
        }
    }

    public Highlighter getHighlighter() {
        return this.highlighter;
    }

    public void setHighlighter(Highlighter h) {
        this.highlighter = h;
    }

    public void addHighlighter(Highlighter h) {
        this.highlighters.add(h);
    }

    public void removeHighlighter(Highlighter h) {
        this.highlighters.remove(h);
    }

    public Iterator<Highlighter> getHighlighters() {
        return this.highlighters.iterator();
    }

    public Collection<Board> getBoards() {
        return Collections.unmodifiableCollection(this.boards);
    }

    @Deprecated
    public Enumeration<Board> getAllBoards() {
        return Collections.enumeration(this.boards);
    }

    public int getBoardCount() {
        return this.boards.size();
    }

    public Rectangle boundingBoxOf(GamePiece p) {
        Rectangle r = null;
        if (p.getMap() == this) {
            r = p.boundingBox();
            Point pos = p.getPosition();
            r.translate(pos.x, pos.y);
            if (Boolean.TRUE.equals(p.getProperty("Selected"))) {
                r.add(this.highlighter.boundingBox(p));
                Iterator<Highlighter> i = this.getHighlighters();
                while (i.hasNext()) {
                    r.add(i.next().boundingBox(p));
                }
            }
            if (p.getParent() != null) {
                Point pt = this.getStackMetrics().relativePosition(p.getParent(), p);
                r.translate(pt.x, pt.y);
            }
        }
        return r;
    }

    public Rectangle selectionBoundsOf(GamePiece p) {
        if (p.getMap() != this) {
            throw new IllegalArgumentException(Resources.getString("Map.piece_not_on_map"));
        }
        Rectangle r = p.getShape().getBounds();
        r.translate(p.getPosition().x, p.getPosition().y);
        if (p.getParent() != null) {
            Point pt = this.getStackMetrics().relativePosition(p.getParent(), p);
            r.translate(pt.x, pt.y);
        }
        return r;
    }

    public Point positionOf(GamePiece p) {
        if (p.getMap() != this) {
            throw new IllegalArgumentException(Resources.getString("Map.piece_not_on_map"));
        }
        Point point = p.getPosition();
        if (p.getParent() != null) {
            Point pt = this.getStackMetrics().relativePosition(p.getParent(), p);
            point.translate(pt.x, pt.y);
        }
        return point;
    }

    public GamePiece[] getPieces() {
        return this.pieces.getPieces();
    }

    public GamePiece[] getAllPieces() {
        return this.pieces.getAllPieces();
    }

    public void setPieceCollection(PieceCollection pieces) {
        this.pieces = pieces;
    }

    public PieceCollection getPieceCollection() {
        return this.pieces;
    }

    protected void clearMapBorder(Graphics g) {
        Graphics2D g2d = (Graphics2D)g.create();
        double os_scale = g2d.getDeviceConfiguration().getDefaultTransform().getScaleX();
        if (this.clearFirst || this.boards.isEmpty()) {
            g.setColor(this.bgColor);
            g.fillRect(0, 0, this.componentToDrawing(this.theMap.getWidth(), os_scale), this.componentToDrawing(this.theMap.getHeight(), os_scale));
            this.clearFirst = false;
        } else {
            int mw = this.componentToDrawing(this.theMap.getWidth(), os_scale);
            int mh = this.componentToDrawing(this.theMap.getHeight(), os_scale);
            int ew = this.mapToDrawing(this.edgeBuffer.width, os_scale);
            int eh = this.mapToDrawing(this.edgeBuffer.height, os_scale);
            g.setColor(this.bgColor);
            g.fillRect(0, 0, ew, mh);
            g.fillRect(0, 0, mw, eh);
            g.fillRect(mw - ew, 0, ew, mh);
            g.fillRect(0, mh - eh, mw, eh);
        }
    }

    protected void setBoardBoundaries() {
        Point relPos;
        int maxX = 0;
        int maxY = 0;
        for (Board b : this.boards) {
            relPos = b.relativePosition();
            maxX = Math.max(maxX, relPos.x);
            maxY = Math.max(maxY, relPos.y);
        }
        this.boardWidths = new int[maxX + 1][maxY + 1];
        this.boardHeights = new int[maxX + 1][maxY + 1];
        for (Board b : this.boards) {
            relPos = b.relativePosition();
            this.boardWidths[relPos.x][relPos.y] = b.bounds().width;
            this.boardHeights[relPos.x][relPos.y] = b.bounds().height;
        }
        Point offset = new Point(this.edgeBuffer.width, this.edgeBuffer.height);
        for (Board b : this.boards) {
            Point relPos2 = b.relativePosition();
            Point location = this.getLocation(relPos2.x, relPos2.y, 1.0);
            b.setLocation(location.x, location.y);
            b.translate(offset.x, offset.y);
        }
        this.theMap.revalidate();
    }

    protected Point getLocation(Board b, double zoom) {
        Point p;
        if (zoom == 1.0) {
            p = b.bounds().getLocation();
        } else {
            Point relPos = b.relativePosition();
            p = this.getLocation(relPos.x, relPos.y, zoom);
            p.translate((int)(zoom * (double)this.edgeBuffer.width), (int)(zoom * (double)this.edgeBuffer.height));
        }
        return p;
    }

    protected Point getLocation(int column, int row, double zoom) {
        Point p = new Point();
        for (int x = 0; x < column; ++x) {
            p.translate((int)Math.floor(zoom * (double)this.boardWidths[x][row]), 0);
        }
        for (int y = 0; y < row; ++y) {
            p.translate(0, (int)Math.floor(zoom * (double)this.boardHeights[column][y]));
        }
        return p;
    }

    public void drawBoards(Graphics g, int xoffset, int yoffset, double zoom, Component obs) {
        for (Board b : this.boards) {
            Point p = this.getLocation(b, zoom);
            p.translate(xoffset, yoffset);
            b.draw(g, p.x, p.y, zoom, obs);
        }
    }

    public void repaint(Rectangle r) {
        r.setLocation(this.mapToComponent(new Point(r.x, r.y)));
        r.setSize((int)((double)r.width * this.getZoom()), (int)((double)r.height * this.getZoom()));
        this.theMap.repaint(r.x, r.y, r.width, r.height);
    }

    public void setPiecesVisible(boolean show) {
        this.hideCounters = !show;
    }

    public boolean isPiecesVisible() {
        return !this.hideCounters && this.pieceOpacity != 0.0f;
    }

    public float getPieceOpacity() {
        return this.pieceOpacity;
    }

    public void setPieceOpacity(float pieceOpacity) {
        this.pieceOpacity = pieceOpacity;
    }

    @Override
    public Object getProperty(Object key) {
        Object value = null;
        MutableProperty p = this.propsContainer.getMutableProperty(String.valueOf(key));
        value = p != null ? p.getPropertyValue() : GameModule.getGameModule().getProperty(key);
        return value;
    }

    @Override
    public Object getLocalizedProperty(Object key) {
        Object value = null;
        MutableProperty p = this.propsContainer.getMutableProperty(String.valueOf(key));
        if (p != null) {
            value = p.getPropertyValue();
        }
        if (value == null) {
            value = GameModule.getGameModule().getLocalizedProperty(key);
        }
        return value;
    }

    public KeyStroke getMoveKey() {
        return this.moveKey == null ? null : this.moveKey.getKeyStroke();
    }

    protected Window createParentFrame() {
        if (GlobalOptions.getInstance().isUseSingleWindow()) {
            JDialog d = new JDialog(GameModule.getGameModule().getFrame());
            d.setDefaultCloseOperation(0);
            d.setTitle(this.getDefaultWindowTitle());
            return d;
        }
        JFrame d = new JFrame();
        d.setDefaultCloseOperation(0);
        d.setTitle(this.getDefaultWindowTitle());
        d.setJMenuBar(MenuManager.getInstance().getMenuBarFor(d));
        return d;
    }

    public boolean shouldDockIntoMainWindow() {
        if (this.useLaunchButton || !GlobalOptions.getInstance().isUseSingleWindow()) {
            return false;
        }
        for (Map m : GameModule.getGameModule().getComponentsOf(Map.class)) {
            if (m == this) {
                return true;
            }
            if (!m.shouldDockIntoMainWindow()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void setup(boolean show) {
        if (show) {
            final GameModule g = GameModule.getGameModule();
            if (this.shouldDockIntoMainWindow()) {
                this.mainWindowDock.showComponent();
                int height = (Integer)Prefs.getGlobalPrefs().getValue(MAIN_WINDOW_HEIGHT);
                if (height > 0) {
                    Container top = this.mainWindowDock.getTopLevelAncestor();
                    top.setSize(top.getWidth(), height);
                }
                if (this.toolBar.getParent() == null) {
                    g.getToolBar().addSeparator();
                    g.getToolBar().add(this.toolBar);
                }
                this.toolBar.setVisible(true);
            } else {
                if (SwingUtilities.getWindowAncestor(this.theMap) == null) {
                    final Window topWindow = this.createParentFrame();
                    topWindow.addWindowListener(new WindowAdapter(){

                        @Override
                        public void windowClosing(WindowEvent e) {
                            if (Map.this.useLaunchButton) {
                                topWindow.setVisible(false);
                            } else {
                                g.getGameState().setup(false);
                            }
                        }
                    });
                    ((RootPaneContainer)((Object)topWindow)).getContentPane().add("North", this.getToolBar());
                    ((RootPaneContainer)((Object)topWindow)).getContentPane().add("Center", this.layeredPane);
                    topWindow.setSize(600, 400);
                    PositionOption option = new PositionOption(PositionOption.key + this.getIdentifier(), topWindow);
                    g.getPrefs().addOption(option);
                }
                this.theMap.getTopLevelAncestor().setVisible(!this.useLaunchButton);
                this.theMap.revalidate();
            }
        } else {
            this.pieces.clear();
            this.boards.clear();
            if (this.mainWindowDock != null) {
                if (this.mainWindowDock.getHideableComponent().isShowing()) {
                    Prefs.getGlobalPrefs().getOption(MAIN_WINDOW_HEIGHT).setValue(this.mainWindowDock.getTopLevelAncestor().getHeight());
                }
                this.mainWindowDock.hideComponent();
                this.toolBar.setVisible(false);
            } else if (this.theMap.getTopLevelAncestor() != null) {
                this.theMap.getTopLevelAncestor().setVisible(false);
            }
        }
        this.launchButton.setEnabled(show);
        this.launchButton.setVisible(this.useLaunchButton);
    }

    public void appendToTitle(String s) {
        if (this.mainWindowDock == null) {
            Container c = this.theMap.getTopLevelAncestor();
            if (s == null) {
                if (c instanceof JFrame) {
                    ((JFrame)c).setTitle(this.getDefaultWindowTitle());
                }
                if (c instanceof JDialog) {
                    ((JDialog)c).setTitle(this.getDefaultWindowTitle());
                }
            } else {
                if (c instanceof JFrame) {
                    ((JFrame)c).setTitle(((JFrame)c).getTitle() + s);
                }
                if (c instanceof JDialog) {
                    ((JDialog)c).setTitle(((JDialog)c).getTitle() + s);
                }
            }
        }
    }

    protected String getDefaultWindowTitle() {
        return this.getLocalizedMapName().length() > 0 ? this.getLocalizedMapName() : Resources.getString("Map.window_title", GameModule.getGameModule().getLocalizedGameName());
    }

    public GamePiece findPiece(Point pt, PieceFinder finder) {
        GamePiece[] stack = this.pieces.getPieces();
        for (int i = stack.length - 1; i >= 0; --i) {
            GamePiece p = finder.select(this, stack[i], pt);
            if (p == null) continue;
            return p;
        }
        return null;
    }

    public GamePiece findAnyPiece(Point pt, PieceFinder finder) {
        GamePiece[] stack = this.pieces.getAllPieces();
        for (int i = stack.length - 1; i >= 0; --i) {
            GamePiece p = finder.select(this, stack[i], pt);
            if (p == null) continue;
            return p;
        }
        return null;
    }

    public Command placeAt(GamePiece piece, Point pt) {
        Command c = null;
        if (GameModule.getGameModule().getGameState().getPieceForId(piece.getId()) == null) {
            piece.setPosition(pt);
            this.addPiece(piece);
            GameModule.getGameModule().getGameState().addPiece(piece);
            c = new AddPiece(piece);
        } else {
            MoveTracker tracker = new MoveTracker(piece);
            piece.setPosition(pt);
            this.addPiece(piece);
            c = tracker.getMoveCommand();
        }
        return c;
    }

    public Command apply(PieceVisitorDispatcher commandFactory) {
        GamePiece[] stack = this.pieces.getPieces();
        Command c = null;
        for (int i = 0; i < stack.length && c == null; ++i) {
            c = (Command)commandFactory.accept(stack[i]);
        }
        return c;
    }

    public Command placeOrMerge(GamePiece p, Point pt) {
        Command c = this.apply(new DeckVisitorDispatcher(new Merger(this, pt, p)));
        if (c == null || c.isNull()) {
            Stack parent;
            c = this.placeAt(p, pt);
            if (!(p instanceof Stack) && !Boolean.TRUE.equals(p.getProperty("NoStack")) && (parent = this.getStackMetrics().createStack(p)) != null) {
                c = c.append(this.placeAt(parent, pt));
            }
        }
        return c;
    }

    public void addPiece(GamePiece p) {
        if (this.indexOf(p) < 0) {
            if (p.getParent() != null) {
                p.getParent().remove(p);
                p.setParent(null);
            }
            if (p.getMap() != null && p.getMap() != this) {
                p.getMap().removePiece(p);
            }
            this.pieces.add(p);
            p.setMap(this);
            this.theMap.repaint();
        }
    }

    public int indexOf(GamePiece s) {
        return this.pieces.indexOf(s);
    }

    public void removePiece(GamePiece p) {
        this.pieces.remove(p);
        this.theMap.repaint();
    }

    public void centerAt(Point p) {
        this.centerAt(p, 0, 0);
    }

    public void centerAt(Point p, int dx, int dy) {
        if (this.scroll != null) {
            p = this.mapToComponent(p);
            Rectangle r = this.theMap.getVisibleRect();
            r.x = p.x - r.width / 2;
            r.y = p.y - r.height / 2;
            Dimension d = this.getPreferredSize();
            if (r.x + r.width > d.width) {
                r.x = d.width - r.width;
            }
            if (r.y + r.height > d.height) {
                r.y = d.height - r.height;
            }
            r.width = dx > r.width ? 0 : r.width - dx;
            r.height = dy > r.height ? 0 : r.height - dy;
            this.theMap.scrollRectToVisible(r);
        }
    }

    public void ensureVisible(Rectangle r) {
        if (this.scroll != null) {
            Point p = this.mapToComponent(r.getLocation());
            r = new Rectangle(p.x, p.y, (int)(this.getZoom() * (double)r.width), (int)(this.getZoom() * (double)r.height));
            this.theMap.scrollRectToVisible(r);
        }
    }

    public void scroll(int dx, int dy) {
        Rectangle r = this.scroll.getViewport().getViewRect();
        r.translate(dx, dy);
        r = r.intersection(new Rectangle(this.getPreferredSize()));
        this.theMap.scrollRectToVisible(r);
    }

    public static String getConfigureTypeName() {
        return Resources.getString("Editor.Map.component_type");
    }

    public String getMapName() {
        return this.getConfigureName();
    }

    public String getLocalizedMapName() {
        return this.getLocalizedConfigureName();
    }

    public void setMapName(String s) {
        this.mapName = s;
        this.setConfigureName(this.mapName);
        if (this.tooltip == null || this.tooltip.length() == 0) {
            this.launchButton.setToolTipText(s != null ? Resources.getString("Map.show_hide", s) : Resources.getString("Map.show_hide", Resources.getString("Map.map")));
        }
    }

    @Override
    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("Map.htm");
    }

    @Override
    public String[] getAttributeDescriptions() {
        return new String[]{Resources.getString("Editor.Map.map_name"), Resources.getString("Editor.Map.mark_pieces_moved"), Resources.getString("Editor.Map.mark_unmoved_button_text"), Resources.getString("Editor.Map.mark_unmoved_tooltip_text"), Resources.getString("Editor.Map.mark_unmoved_button_icon"), Resources.getString("Editor.Map.horizontal"), Resources.getString("Editor.Map.vertical"), Resources.getString("Editor.Map.bkgdcolor"), Resources.getString("Editor.Map.multiboard"), Resources.getString("Editor.Map.bc_selected_counter"), Resources.getString("Editor.Map.bt_selected_counter"), Resources.getString("Editor.Map.show_hide"), Resources.getString("Editor.button_text_label"), Resources.getString("Editor.tooltip_text_label"), Resources.getString("Editor.button_icon_label"), Resources.getString("Editor.hotkey_label"), Resources.getString("Editor.Map.report_move_within"), Resources.getString("Editor.Map.report_move_to"), Resources.getString("Editor.Map.report_created"), Resources.getString("Editor.Map.report_modified"), Resources.getString("Editor.Map.key_applied_all")};
    }

    @Override
    public String[] getAttributeNames() {
        return new String[]{"mapName", MARK_MOVED, MARK_UNMOVED_TEXT, MARK_UNMOVED_TOOLTIP, MARK_UNMOVED_ICON, EDGE_WIDTH, EDGE_HEIGHT, BACKGROUND_COLOR, ALLOW_MULTIPLE, HIGHLIGHT_COLOR, HIGHLIGHT_THICKNESS, USE_LAUNCH_BUTTON, BUTTON_NAME, TOOLTIP, ICON, HOTKEY, MOVE_WITHIN_FORMAT, MOVE_TO_FORMAT, CREATE_FORMAT, CHANGE_FORMAT, MOVE_KEY};
    }

    @Override
    public Class<?>[] getAttributeTypes() {
        return new Class[]{String.class, GlobalOptions.Prompt.class, String.class, String.class, UnmovedIconConfig.class, Integer.class, Integer.class, Color.class, Boolean.class, Color.class, Integer.class, Boolean.class, String.class, String.class, IconConfig.class, NamedKeyStroke.class, MoveWithinFormatConfig.class, MoveToFormatConfig.class, CreateFormatConfig.class, ChangeFormatConfig.class, NamedKeyStroke.class};
    }

    public String getCreateFormat() {
        Board b;
        if (this.createFormat != null) {
            return this.createFormat;
        }
        String val = "$pieceName$ created in $location$";
        if (!(this.boards.isEmpty() || (b = this.boards.get(0)).getGrid() != null && b.getGrid().getGridNumbering() != null)) {
            val = "";
        }
        return val;
    }

    public String getChangeFormat() {
        return Map.isChangeReportingEnabled() ? this.changeFormat : "";
    }

    public String getMoveToFormat() {
        Board b;
        if (this.moveToFormat != null) {
            return this.moveToFormat;
        }
        String val = "$pieceName$ moves $previousLocation$ -> $location$ *";
        if (!(this.boards.isEmpty() || (b = this.boards.get(0)).getGrid() != null && b.getGrid().getGridNumbering() == null)) {
            val = "";
        }
        return val;
    }

    public String getMoveWithinFormat() {
        Board b;
        if (this.moveWithinFormat != null) {
            return this.moveWithinFormat;
        }
        String val = "$pieceName$ moves $previousLocation$ -> $location$ *";
        if (!this.boards.isEmpty() && (b = this.boards.get(0)).getGrid() == null) {
            val = "";
        }
        return val;
    }

    public Class<?>[] getAllowableConfigureComponents() {
        Class[] c = new Class[]{GlobalMap.class, LOS_Thread.class, ToolbarMenu.class, MultiActionButton.class, HidePiecesButton.class, Zoomer.class, CounterDetailViewer.class, HighlightLastMoved.class, LayeredPieceCollection.class, ImageSaver.class, TextSaver.class, DrawPile.class, SetupStack.class, MassKeyCommand.class, MapShader.class, PieceRecenterer.class};
        return c;
    }

    @Override
    public VisibilityCondition getAttributeVisibility(String name) {
        if (this.visibilityCondition == null) {
            this.visibilityCondition = new VisibilityCondition(){

                @Override
                public boolean shouldBeVisible() {
                    return Map.this.useLaunchButton;
                }
            };
        }
        if (List.of(HOTKEY, BUTTON_NAME, TOOLTIP, ICON).contains(name)) {
            return this.visibilityCondition;
        }
        if (List.of(MARK_UNMOVED_TEXT, MARK_UNMOVED_ICON, MARK_UNMOVED_TOOLTIP).contains(name)) {
            return new VisibilityCondition(){

                @Override
                public boolean shouldBeVisible() {
                    return !"Never".equals(Map.this.markMovedOption);
                }
            };
        }
        return super.getAttributeVisibility(name);
    }

    @Override
    public void setId(String id) {
        this.mapID = id;
    }

    public static Map getMapById(String id) {
        return (Map)idMgr.findInstance(id);
    }

    public static List<Map> getMapList() {
        GameModule g = GameModule.getGameModule();
        List<Map> l = g.getComponentsOf(Map.class);
        for (ChartWindow cw : g.getComponentsOf(ChartWindow.class)) {
            for (MapWidget mw : cw.getAllDescendantComponentsOf(MapWidget.class)) {
                l.add(mw.getMap());
            }
        }
        return l;
    }

    @Deprecated
    public static Iterator<Map> getAllMaps() {
        return Map.getMapList().iterator();
    }

    @Override
    public MutableProperty getMutableProperty(String name) {
        return this.propsContainer.getMutableProperty(name);
    }

    @Override
    public void addMutableProperty(String key, MutableProperty p) {
        this.propsContainer.addMutableProperty(key, p);
        p.addMutablePropertyChangeListener(this.repaintOnPropertyChange);
    }

    @Override
    public MutableProperty removeMutableProperty(String key) {
        MutableProperty p = this.propsContainer.removeMutableProperty(key);
        if (p != null) {
            p.removeMutablePropertyChangeListener(this.repaintOnPropertyChange);
        }
        return p;
    }

    @Override
    public String getMutablePropertiesContainerId() {
        return this.getMapName();
    }

    @Override
    public String getId() {
        return this.mapID;
    }

    public String getIdentifier() {
        return UniqueIdManager.getIdentifier(this);
    }

    public JComponent getView() {
        if (this.theMap == null) {
            this.theMap = new View(this);
            this.scroll = new AdjustableSpeedScrollPane(this.theMap, 20, 30);
            this.scroll.unregisterKeyboardAction(KeyStroke.getKeyStroke(34, 0));
            this.scroll.unregisterKeyboardAction(KeyStroke.getKeyStroke(33, 0));
            this.scroll.setAlignmentX(0.0f);
            this.scroll.setAlignmentY(0.0f);
            this.layeredPane.setLayout(new InsetLayout(this.layeredPane, this.scroll));
            this.layeredPane.add((Component)this.scroll, JLayeredPane.DEFAULT_LAYER);
        }
        return this.theMap;
    }

    public JLayeredPane getLayeredPane() {
        return this.layeredPane;
    }

    public static class Merger
    implements DeckVisitor {
        private Point pt;
        private Map map;
        private GamePiece p;

        public Merger(Map map, Point pt, GamePiece p) {
            this.map = map;
            this.pt = pt;
            this.p = p;
        }

        @Override
        public Object visitDeck(Deck d) {
            if (d.getPosition().equals(this.pt)) {
                return this.map.getStackMetrics().merge(d, this.p);
            }
            return null;
        }

        @Override
        public Object visitStack(Stack s) {
            if (s.getPosition().equals(this.pt) && this.map.getStackMetrics().isStackingEnabled() && !Boolean.TRUE.equals(this.p.getProperty("NoStack")) && s.topPiece() != null && this.map.getPieceCollection().canMerge(s, this.p)) {
                return this.map.getStackMetrics().merge(s, this.p);
            }
            return null;
        }

        @Override
        public Object visitDefault(GamePiece piece) {
            if (piece.getPosition().equals(this.pt) && this.map.getStackMetrics().isStackingEnabled() && !Boolean.TRUE.equals(this.p.getProperty("NoStack")) && !Boolean.TRUE.equals(piece.getProperty("Invisible")) && !Boolean.TRUE.equals(piece.getProperty("NoStack")) && this.map.getPieceCollection().canMerge(piece, this.p)) {
                return this.map.getStackMetrics().merge(piece, this.p);
            }
            return null;
        }
    }

    public static class UnmovedIconConfig
    implements ConfigurerFactory {
        @Override
        public Configurer getConfigurer(AutoConfigurable c, String key, String name) {
            return new IconConfigurer(key, name, "/images/unmoved.gif");
        }
    }

    public static class IconConfig
    implements ConfigurerFactory {
        @Override
        public Configurer getConfigurer(AutoConfigurable c, String key, String name) {
            return new IconConfigurer(key, name, "/images/map.gif");
        }
    }

    public static class MoveWithinFormatConfig
    implements TranslatableConfigurerFactory {
        @Override
        public Configurer getConfigurer(AutoConfigurable c, String key, String name) {
            return new PlayerIdFormattedStringConfigurer(key, name, new String[]{Map.PIECE_NAME, Map.LOCATION, "mapName", Map.OLD_LOCATION});
        }
    }

    public static class MoveToFormatConfig
    implements TranslatableConfigurerFactory {
        @Override
        public Configurer getConfigurer(AutoConfigurable c, String key, String name) {
            return new PlayerIdFormattedStringConfigurer(key, name, new String[]{Map.PIECE_NAME, Map.LOCATION, Map.OLD_MAP, "mapName", Map.OLD_LOCATION});
        }
    }

    public static class CreateFormatConfig
    implements TranslatableConfigurerFactory {
        @Override
        public Configurer getConfigurer(AutoConfigurable c, String key, String name) {
            return new PlayerIdFormattedStringConfigurer(key, name, new String[]{Map.PIECE_NAME, "mapName", Map.LOCATION});
        }
    }

    public static class ChangeFormatConfig
    implements TranslatableConfigurerFactory {
        @Override
        public Configurer getConfigurer(AutoConfigurable c, String key, String name) {
            return new PlayerIdFormattedStringConfigurer(key, name, new String[]{Map.MESSAGE, "menuCommand", "oldPieceName", "newPieceName", "mapName", Map.LOCATION});
        }
    }

    public static class View
    extends JPanel {
        private static final long serialVersionUID = 1L;
        protected Map map;

        public View(Map m) {
            this.setFocusTraversalKeysEnabled(false);
            this.map = m;
        }

        @Override
        public void paint(Graphics g) {
            if (GameModule.getGameModule().getGameState().isUpdating()) {
                return;
            }
            Graphics2D g2d = (Graphics2D)g;
            g2d.addRenderingHints(SwingUtils.FONT_HINTS);
            double os_scale = g2d.getDeviceConfiguration().getDefaultTransform().getScaleX();
            AffineTransform orig_t = g2d.getTransform();
            g2d.setTransform(SwingUtils.descaleTransform(orig_t));
            Rectangle r = this.map.componentToDrawing(this.getVisibleRect(), os_scale);
            g2d.setColor(this.map.bgColor);
            g2d.fillRect(r.x, r.y, r.width, r.height);
            this.map.paintRegion(g2d, r);
            g2d.setTransform(orig_t);
        }

        @Override
        public void update(Graphics g) {
            this.paint(g);
        }

        @Override
        public Dimension getPreferredSize() {
            return this.map.getPreferredSize();
        }

        public Map getMap() {
            return this.map;
        }
    }

    public static class InsetLayout
    extends OverlayLayout {
        private static final long serialVersionUID = 1L;
        private final JScrollPane base;

        public InsetLayout(Container target, JScrollPane base) {
            super(target);
            this.base = base;
        }

        @Override
        public void layoutContainer(Container target) {
            super.layoutContainer(target);
            this.base.getLayout().layoutContainer(this.base);
            Dimension viewSize = this.base.getViewport().getSize();
            Insets insets = this.base.getInsets();
            viewSize.width += insets.left;
            viewSize.height += insets.top;
            int n = target.getComponentCount();
            for (int i = 0; i < n; ++i) {
                Component c = target.getComponent(i);
                if (c == this.base || !c.isVisible()) continue;
                Rectangle b = c.getBounds();
                b.width = Math.min(b.width, viewSize.width);
                b.height = Math.min(b.height, viewSize.height);
                c.setBounds(b);
            }
        }
    }
}

