/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module;

import VASSAL.build.module.PrivateMap;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.build.module.map.CounterDetailViewer;
import VASSAL.build.module.map.HandMetrics;
import VASSAL.build.module.map.StackExpander;
import VASSAL.build.module.map.StackMetrics;
import VASSAL.counters.GamePiece;
import VASSAL.i18n.Resources;
import java.awt.Dimension;
import java.awt.Rectangle;
import org.w3c.dom.Element;

public class PlayerHand
extends PrivateMap {
    @Override
    public void build(Element el) {
        super.build(el);
        if (el == null) {
            for (StackExpander se : this.getComponentsOf(StackExpander.class)) {
                this.remove(se);
                this.removeLocalMouseListener(se);
            }
            for (CounterDetailViewer cdv : this.getComponentsOf(CounterDetailViewer.class)) {
                this.remove(cdv);
                cdv.removeFrom(this);
            }
        }
    }

    public static String getConfigureTypeName() {
        return Resources.getString("Editor.PlayerHand.component_type");
    }

    @Override
    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("PlayerHand.htm");
    }

    @Override
    public StackMetrics getStackMetrics() {
        if (this.metrics == null) {
            this.metrics = new HandMetrics();
            this.metrics.build(null);
            this.add(this.metrics);
            this.metrics.addTo(this);
        }
        return this.metrics;
    }

    @Override
    public Dimension mapSize() {
        Rectangle r = new Rectangle(0, 0, 200, 200);
        r.add(new Rectangle(super.mapSize()));
        for (GamePiece p : this.pieces.getPieces()) {
            Rectangle bb = this.boundingBoxOf(p);
            if (bb == null) continue;
            r.add(bb);
        }
        return r.getSize();
    }
}

