/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module;

import VASSAL.build.AbstractConfigurable;
import VASSAL.build.Buildable;
import VASSAL.build.Builder;
import VASSAL.build.Configurable;
import VASSAL.build.GameModule;
import VASSAL.build.module.GameComponent;
import VASSAL.build.module.GameSetupStep;
import VASSAL.build.module.GlobalOptions;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.command.Command;
import VASSAL.command.CommandEncoder;
import VASSAL.configure.Configurer;
import VASSAL.configure.IconConfigurer;
import VASSAL.configure.StringArrayConfigurer;
import VASSAL.configure.StringConfigurer;
import VASSAL.configure.StringEnumConfigurer;
import VASSAL.i18n.Localization;
import VASSAL.i18n.Resources;
import VASSAL.tools.LaunchButton;
import VASSAL.tools.SequenceEncoder;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.swing.BoxLayout;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;

public class PlayerRoster
extends AbstractConfigurable
implements CommandEncoder,
GameComponent,
GameSetupStep {
    public static final String BUTTON_ICON = "buttonIcon";
    public static final String BUTTON_TEXT = "buttonText";
    public static final String TOOL_TIP = "buttonToolTip";
    public static final String SIDES = "sides";
    public static final String COMMAND_PREFIX = "PLAYER\t";
    public static final String OBSERVER = "<observer>";
    protected List<PlayerInfo> players = new ArrayList<PlayerInfo>();
    protected List<String> sides = new ArrayList<String>();
    protected String[] untranslatedSides;
    protected LaunchButton retireButton;
    protected List<SideChangeListener> sideChangeListeners = new ArrayList<SideChangeListener>();
    protected String translatedObserver;
    private boolean pickedSide = false;
    protected StringEnumConfigurer sideConfig;

    public PlayerRoster() {
        ActionListener al = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PlayerRoster.this.launch();
            }
        };
        this.retireButton = new LaunchButton(Resources.getString("PlayerRoster.retire"), TOOL_TIP, BUTTON_TEXT, null, BUTTON_ICON, al);
        this.retireButton.setToolTipText(Resources.getString("PlayerRoster.allow_another"));
        this.retireButton.setVisible(false);
        this.translatedObserver = Resources.getString("PlayerRoster.observer");
    }

    @Override
    public void removeFrom(Buildable parent) {
        GameModule.getGameModule().getGameState().removeGameComponent(this);
        GameModule.getGameModule().removeCommandEncoder(this);
    }

    @Override
    public void remove(Buildable child) {
    }

    @Override
    public void build(Element e) {
        if (e != null) {
            NamedNodeMap attributes = e.getAttributes();
            for (int i = 0; i < attributes.getLength(); ++i) {
                Attr att = (Attr)attributes.item(i);
                if (BUTTON_ICON.equals(att.getName()) && "Retire".equals(att.getValue())) {
                    try {
                        GameModule.getGameModule().getDataArchive().getInputStream("images/" + att.getValue());
                    }
                    catch (IOException ex) {
                        continue;
                    }
                }
                this.retireButton.setAttribute(att.getName(), att.getValue());
                Localization.getInstance().saveTranslatableAttribute(this, att.getName(), att.getValue());
            }
            NodeList n = e.getElementsByTagName("*");
            this.sides.clear();
            for (int i = 0; i < n.getLength(); ++i) {
                Element el = (Element)n.item(i);
                this.sides.add(Builder.getText(el));
            }
            Localization.getInstance().saveTranslatableAttribute(this, SIDES, this.getSidesAsString());
        }
    }

    @Override
    public String getConfigureName() {
        return null;
    }

    public static String getConfigureTypeName() {
        return Resources.getString("Editor.PlayerRoster.component_type");
    }

    @Override
    public void add(Buildable child) {
    }

    @Override
    public Configurable[] getConfigureComponents() {
        return new Configurable[0];
    }

    @Override
    public Element getBuildElement(Document doc) {
        Element el = doc.createElement(this.getClass().getName());
        String att = this.retireButton.getAttributeValueString(BUTTON_TEXT);
        if (att != null) {
            el.setAttribute(BUTTON_TEXT, att);
        }
        if ((att = this.retireButton.getAttributeValueString(BUTTON_ICON)) != null) {
            el.setAttribute(BUTTON_ICON, att);
        }
        if ((att = this.retireButton.getAttributeValueString(TOOL_TIP)) != null) {
            el.setAttribute(TOOL_TIP, att);
        }
        for (String s : this.sides) {
            Element sub = doc.createElement("entry");
            sub.appendChild(doc.createTextNode(s));
            el.appendChild(sub);
        }
        return el;
    }

    @Override
    public Configurer getConfigurer() {
        return new Con();
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener l) {
    }

    @Deprecated
    public static void addSideChangeListener(SideChangeListener l) {
        GameModule.getGameModule().addSideChangeListenerToPlayerRoster(l);
    }

    public void addSideChangeListenerToInstance(SideChangeListener l) {
        this.sideChangeListeners.add(l);
    }

    public static void removeSideChangeListener(SideChangeListener l) {
        PlayerRoster r = GameModule.getGameModule().getPlayerRoster();
        if (r != null) {
            r.sideChangeListeners.remove(l);
        }
    }

    @Override
    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("GameModule.htm", "Definition_of_Player_Sides");
    }

    public Class<?>[] getAllowableConfigureComponents() {
        return new Class[0];
    }

    @Override
    public void addTo(Buildable b) {
        GameModule.getGameModule().getGameState().addGameComponent(this);
        GameModule.getGameModule().getGameState().addGameSetupStep(this);
        GameModule.getGameModule().addCommandEncoder(this);
        GameModule.getGameModule().getToolBar().add(this.retireButton);
    }

    protected void launch() {
        Object[] objectArray;
        String mySide = PlayerRoster.getMySide();
        if (mySide == null && this.allSidesAllocated()) {
            return;
        }
        if (this.allSidesAllocated()) {
            Object[] objectArray2 = new String[2];
            objectArray2[0] = Resources.getString("General.yes");
            objectArray = objectArray2;
            objectArray2[1] = Resources.getString("General.no");
        } else {
            String[] stringArray = new String[3];
            stringArray[0] = Resources.getString("PlayerRoster.become_observer");
            stringArray[1] = Resources.getString("PlayerRoster.join_another_side");
            objectArray = stringArray;
            stringArray[2] = Resources.getString("General.cancel");
        }
        Object[] options = objectArray;
        int CANCEL = options.length - 1;
        int option = JOptionPane.showOptionDialog(GameModule.getGameModule().getFrame(), Resources.getString("PlayerRoster.give_up_position", PlayerRoster.getMyLocalizedSide()), Resources.getString("PlayerRoster.retire"), 0, 3, null, options, Resources.getString("PlayerRoster.become_observer"));
        if (option != CANCEL) {
            String newSide;
            String oldSide = PlayerRoster.getMySide();
            if (option == 0) {
                newSide = OBSERVER;
            } else {
                newSide = this.promptForSide();
                if (newSide == null) {
                    return;
                }
            }
            this.remove(GameModule.getUserId());
            PlayerInfo me = new PlayerInfo(GameModule.getUserId(), GlobalOptions.getInstance().getPlayerId(), newSide);
            Add a = new Add(this, me.playerId, me.playerName, me.side);
            a.execute();
            GameModule.getGameModule().getServer().sendToOthers(a);
            newSide = PlayerRoster.getMySide();
            this.fireSideChange(oldSide, newSide);
        }
    }

    protected void fireSideChange(String oldSide, String newSide) {
        for (SideChangeListener l : this.sideChangeListeners) {
            l.sideChanged(oldSide, newSide);
        }
    }

    public static boolean isActive() {
        return GameModule.getGameModule().getPlayerRoster() != null;
    }

    @Deprecated
    protected static PlayerRoster getInstance() {
        return GameModule.getGameModule().getPlayerRoster();
    }

    public static String getMySide() {
        return PlayerRoster.getMySide(false);
    }

    public static String getMyLocalizedSide() {
        return PlayerRoster.getMySide(true);
    }

    protected static String getMySide(boolean localized) {
        PlayerRoster r = GameModule.getGameModule().getPlayerRoster();
        if (r != null) {
            for (PlayerInfo pi : r.getPlayers()) {
                if (!pi.playerId.equals(GameModule.getUserId())) continue;
                return localized ? pi.getLocalizedSide() : pi.getSide();
            }
        }
        return null;
    }

    public PlayerInfo[] getPlayers() {
        return this.players.toArray(new PlayerInfo[0]);
    }

    public void add(String playerId, String playerName, String side) {
        PlayerInfo e = new PlayerInfo(playerId, playerName, side);
        if (this.players.contains(e)) {
            this.players.set(this.players.indexOf(e), e);
        } else {
            this.players.add(e);
        }
    }

    public void remove(String playerId) {
        PlayerInfo e = new PlayerInfo(playerId, null, null);
        this.players.remove(e);
    }

    @Override
    public Command decode(String command) {
        if (command.startsWith(COMMAND_PREFIX)) {
            SequenceEncoder.Decoder st = new SequenceEncoder.Decoder(command, '\t');
            st.nextToken();
            return new Add(this, st.nextToken(), st.nextToken(), st.nextToken());
        }
        return null;
    }

    @Override
    public String encode(Command c) {
        if (c instanceof Add) {
            Add a = (Add)c;
            SequenceEncoder se = new SequenceEncoder('\t');
            se.append(a.id).append(a.name).append(a.side);
            return COMMAND_PREFIX + se.getValue();
        }
        return null;
    }

    @Override
    public Command getRestoreCommand() {
        Add c = null;
        for (PlayerInfo entry : this.players) {
            Add sub = new Add(this, entry.playerId, entry.playerName, entry.side);
            c = c == null ? sub : c.append(sub);
        }
        return c;
    }

    @Override
    public void setup(boolean gameStarting) {
        if (gameStarting) {
            PlayerInfo me = new PlayerInfo(GameModule.getUserId(), GlobalOptions.getInstance().getPlayerId(), null);
            if (this.players.contains(me)) {
                PlayerInfo saved = this.players.get(this.players.indexOf(me));
                saved.playerName = me.playerName;
            }
        } else {
            this.players.clear();
        }
        this.retireButton.setVisible(gameStarting && PlayerRoster.getMySide() != null);
        this.pickedSide = false;
    }

    @Override
    public void finish() {
        String newSide = this.untranslateSide(this.sideConfig.getValueString());
        if (newSide != null) {
            Add a = new Add(this, GameModule.getUserId(), GlobalOptions.getInstance().getPlayerId(), newSide);
            a.execute();
            GameModule.getGameModule().getServer().sendToOthers(a);
        }
        this.retireButton.setVisible(PlayerRoster.getMySide() != null);
        this.pickedSide = true;
    }

    @Override
    public Component getControls() {
        ArrayList<String> availableSides = new ArrayList<String>(this.sides);
        ArrayList<String> alreadyTaken = new ArrayList<String>();
        for (PlayerInfo p : this.players) {
            alreadyTaken.add(p.side);
        }
        availableSides.removeAll(alreadyTaken);
        availableSides.add(0, this.translatedObserver);
        this.sideConfig = new StringEnumConfigurer(null, Resources.getString("PlayerRoster.join_game_as"), availableSides.toArray(new String[0]));
        this.sideConfig.setValue(this.translatedObserver);
        return this.sideConfig.getControls();
    }

    @Override
    public String getStepTitle() {
        return Resources.getString("PlayerRoster.choose_side");
    }

    @Override
    public boolean isFinished() {
        if (this.pickedSide) {
            return true;
        }
        if (this.allSidesAllocated()) {
            return true;
        }
        PlayerInfo newPlayerInfo = new PlayerInfo(GameModule.getUserId(), GlobalOptions.getInstance().getPlayerId(), null);
        int i = this.players.indexOf(newPlayerInfo);
        if (i != -1) {
            return !OBSERVER.equals(this.players.get(i).getSide());
        }
        return false;
    }

    protected boolean allSidesAllocated() {
        int allocatedSideCount = 0;
        for (PlayerInfo p : this.players) {
            if (OBSERVER.equals(p.getSide())) continue;
            ++allocatedSideCount;
        }
        return this.sides.size() == allocatedSideCount;
    }

    protected String promptForSide() {
        ArrayList<String> availableSides = new ArrayList<String>(this.sides);
        ArrayList<String> alreadyTaken = new ArrayList<String>();
        for (PlayerInfo p : this.players) {
            alreadyTaken.add(p.side);
        }
        availableSides.removeAll(alreadyTaken);
        availableSides.add(0, this.translatedObserver);
        GameModule g = GameModule.getGameModule();
        String newSide = (String)JOptionPane.showInputDialog(g.getFrame(), Resources.getString("PlayerRoster.join_game_as"), Resources.getString("PlayerRoster.choose_side"), 3, null, availableSides.toArray(new String[0]), this.translatedObserver);
        if (this.translatedObserver.equals(newSide)) {
            newSide = OBSERVER;
        }
        return newSide;
    }

    @Override
    public String[] getAttributeNames() {
        return new String[]{BUTTON_TEXT, TOOL_TIP, SIDES};
    }

    @Override
    public Class<?>[] getAttributeTypes() {
        return new Class[]{String.class, String.class, String.class};
    }

    @Override
    public String getAttributeValueString(String key) {
        if (SIDES.equals(key)) {
            return this.getSidesAsString();
        }
        return this.retireButton.getAttributeValueString(key);
    }

    @Override
    public void setAttribute(String key, Object value) {
        if (SIDES.equals(key)) {
            this.untranslatedSides = this.sides.toArray(new String[0]);
            String[] s = StringArrayConfigurer.stringToArray((String)value);
            this.sides = new ArrayList<String>(s.length);
            for (String item : s) {
                this.sides.add(item);
            }
        } else {
            this.retireButton.setAttribute(key, value);
        }
    }

    protected String getSidesAsString() {
        String[] s = this.sides.toArray(new String[0]);
        return StringArrayConfigurer.arrayToString(s);
    }

    protected String untranslateSide(String side) {
        if (this.translatedObserver.equals(side)) {
            return OBSERVER;
        }
        if (this.untranslatedSides != null) {
            for (int i = 0; i < this.sides.size(); ++i) {
                if (!this.sides.get(i).equals(side)) continue;
                return this.untranslatedSides[i];
            }
        }
        return side;
    }

    protected String translateSide(String side) {
        if (OBSERVER.equals(side)) {
            return this.translatedObserver;
        }
        if (this.untranslatedSides != null) {
            for (int i = 0; i < this.untranslatedSides.length; ++i) {
                if (!this.untranslatedSides[i].equals(side)) continue;
                return this.sides.get(i);
            }
        }
        return side;
    }

    @Override
    public String[] getAttributeDescriptions() {
        return new String[]{Resources.getString("Editor.button_text_label"), Resources.getString("Editor.tooltip_text_label"), Resources.getString("Editor.PlayerRoster.sides_label")};
    }

    private class Con
    extends Configurer {
        private StringArrayConfigurer sidesConfig;
        private IconConfigurer iconConfig;
        private StringConfigurer textConfig;
        private StringConfigurer tooltipConfig;
        private JPanel controls;

        private Con() {
            super(null, null);
            this.controls = new JPanel();
            this.controls.setLayout(new BoxLayout(this.controls, 1));
            this.sidesConfig = new StringArrayConfigurer(null, Resources.getString("Editor.PlayerRoster.sides_available"), PlayerRoster.this.sides.toArray(new String[0]));
            this.sidesConfig.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    PlayerRoster.this.sides.clear();
                    PlayerRoster.this.sides.addAll(Arrays.asList(Con.this.sidesConfig.getStringArray()));
                }
            });
            this.controls.add(this.sidesConfig.getControls());
            this.textConfig = new StringConfigurer(PlayerRoster.BUTTON_TEXT, Resources.getString("Editor.PlayerRoster.retire_button_text"), PlayerRoster.this.retireButton.getAttributeValueString(PlayerRoster.BUTTON_TEXT));
            this.textConfig.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    PlayerRoster.this.retireButton.setAttribute(PlayerRoster.BUTTON_TEXT, Con.this.textConfig.getValueString());
                }
            });
            this.controls.add(this.textConfig.getControls());
            this.tooltipConfig = new StringConfigurer(PlayerRoster.TOOL_TIP, Resources.getString("Editor.PlayerRoster.retire_button_tooltip"), PlayerRoster.this.retireButton.getAttributeValueString(PlayerRoster.TOOL_TIP));
            this.tooltipConfig.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    PlayerRoster.this.retireButton.setAttribute(PlayerRoster.TOOL_TIP, Con.this.tooltipConfig.getValueString());
                }
            });
            this.controls.add(this.tooltipConfig.getControls());
            this.iconConfig = new IconConfigurer(PlayerRoster.BUTTON_ICON, Resources.getString("Editor.PlayerRoster.retire_button_icon"), null);
            this.iconConfig.setValue(PlayerRoster.this.retireButton.getIcon());
            this.iconConfig.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    PlayerRoster.this.retireButton.setAttribute(PlayerRoster.BUTTON_ICON, Con.this.iconConfig.getValueString());
                }
            });
            this.controls.add(this.iconConfig.getControls());
        }

        @Override
        public String getValueString() {
            return null;
        }

        @Override
        public void setValue(String s) {
        }

        @Override
        public Component getControls() {
            return this.controls;
        }
    }

    public static interface SideChangeListener {
        public void sideChanged(String var1, String var2);
    }

    public static class PlayerInfo {
        public String playerId;
        public String playerName;
        private String side;

        public PlayerInfo(String id, String name, String side) {
            if (id == null) {
                throw new NullPointerException("Player id cannot be null");
            }
            this.playerId = id;
            this.playerName = name;
            this.side = side;
        }

        public boolean equals(Object o) {
            if (o instanceof PlayerInfo && this.playerId != null) {
                return this.playerId.equals(((PlayerInfo)o).playerId);
            }
            return false;
        }

        public int hashCode() {
            return Objects.hash(this.playerId);
        }

        public String getSide() {
            return this.side;
        }

        public String getLocalizedSide() {
            return GameModule.getGameModule().getPlayerRoster().translateSide(this.side);
        }
    }

    public static class Add
    extends Command {
        private PlayerRoster roster;
        private String id;
        private String name;
        private String side;

        public Add(PlayerRoster r, String playerId, String playerName, String side) {
            this.roster = r;
            this.id = playerId;
            this.name = playerName;
            this.side = side;
        }

        @Override
        protected void executeCommand() {
            this.roster.add(this.id, this.name, this.side);
        }

        @Override
        protected Command myUndoCommand() {
            return null;
        }
    }
}

