/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module;

import VASSAL.build.AbstractConfigurable;
import VASSAL.build.BadDataReport;
import VASSAL.build.Buildable;
import VASSAL.build.GameModule;
import VASSAL.build.module.GameComponent;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.command.Command;
import VASSAL.configure.VisibilityCondition;
import VASSAL.i18n.Resources;
import VASSAL.tools.ErrorDialog;
import VASSAL.tools.menu.AbstractProxy;
import VASSAL.tools.menu.ChildProxy;
import VASSAL.tools.menu.MenuItemProxy;
import VASSAL.tools.menu.MenuManager;
import VASSAL.tools.menu.MenuProxy;
import VASSAL.tools.menu.ParentProxy;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import javax.swing.AbstractAction;

public class PredefinedSetup
extends AbstractConfigurable
implements GameComponent {
    public static final String NAME = "name";
    public static final String FILE = "file";
    public static final String USE_FILE = "useFile";
    public static final String IS_MENU = "isMenu";
    protected boolean isMenu;
    protected boolean useFile = true;
    protected String fileName;
    protected MenuItemProxy menuItem;
    protected MenuProxy menu;
    protected VisibilityCondition showFile;
    protected VisibilityCondition showUseFile;
    protected AbstractAction launchAction = new AbstractAction(){
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent e) {
            PredefinedSetup.this.launch();
        }
    };

    public PredefinedSetup() {
        this.menuItem = new MenuItemProxy(this.launchAction);
        this.menu = new MenuProxy();
        this.showFile = new VisibilityCondition(){

            @Override
            public boolean shouldBeVisible() {
                return !PredefinedSetup.this.isMenu && PredefinedSetup.this.useFile;
            }
        };
        this.showUseFile = new VisibilityCondition(){

            @Override
            public boolean shouldBeVisible() {
                return !PredefinedSetup.this.isMenu;
            }
        };
    }

    @Override
    public String[] getAttributeDescriptions() {
        return new String[]{Resources.getString("Editor.name_label"), Resources.getString("Editor.PredefinedSetup.parent_menu"), Resources.getString("Editor.PredefinedSetup.predefined_file"), Resources.getString("Editor.PredefinedSetup.saved_game")};
    }

    @Override
    public Class<?>[] getAttributeTypes() {
        return new Class[]{String.class, Boolean.class, Boolean.class, File.class};
    }

    @Override
    public String[] getAttributeNames() {
        return new String[]{NAME, IS_MENU, USE_FILE, FILE};
    }

    @Override
    public String getAttributeValueString(String key) {
        if (NAME.equals(key)) {
            return this.getConfigureName();
        }
        if (FILE.equals(key)) {
            return this.fileName;
        }
        if (USE_FILE.equals(key)) {
            return String.valueOf(this.useFile);
        }
        if (IS_MENU.equals(key)) {
            return String.valueOf(this.isMenu);
        }
        return null;
    }

    @Override
    public void setAttribute(String key, Object value) {
        if (NAME.equals(key)) {
            this.setConfigureName((String)value);
            this.menuItem.getAction().putValue("Name", value);
            this.menu.setText((String)value);
        } else if (USE_FILE.equals(key)) {
            if (value instanceof String) {
                value = Boolean.valueOf((String)value);
            }
            this.useFile = (Boolean)value;
        } else if (FILE.equals(key)) {
            if (value instanceof File) {
                value = ((File)value).getName();
            }
            this.fileName = (String)value;
        } else if (IS_MENU.equals(key)) {
            if (value instanceof String) {
                value = Boolean.valueOf((String)value);
            }
            this.setMenu((Boolean)value);
        }
    }

    @Override
    public VisibilityCondition getAttributeVisibility(String name) {
        if (FILE.equals(name)) {
            return this.showFile;
        }
        if (USE_FILE.equals(name)) {
            return this.showUseFile;
        }
        return super.getAttributeVisibility(name);
    }

    public void launch() {
        if (this.useFile && this.fileName != null) {
            try {
                GameModule.getGameModule().getGameState().loadGameInBackground(this.fileName, this.getSavedGameContents());
            }
            catch (IOException e) {
                ErrorDialog.dataError(new BadDataReport(this, Resources.getString("Error.not_found", "Setup"), this.fileName, (Throwable)e));
            }
        } else {
            GameModule.getGameModule().getGameState().setup(false);
            GameModule.getGameModule().getGameState().setup(true);
        }
    }

    public InputStream getSavedGameContents() throws IOException {
        return GameModule.getGameModule().getDataArchive().getInputStream(this.fileName);
    }

    private ChildProxy<?> getMenuInUse() {
        return this.isMenu ? this.menu : this.menuItem;
    }

    private void setMenu(boolean isMenu) {
        if (isMenu == this.isMenu) {
            return;
        }
        ChildProxy<?> inUse = this.getMenuInUse();
        ParentProxy parent = inUse.getParent();
        if (parent != null) {
            AbstractProxy notInUse = this.isMenu ? this.menuItem : this.menu;
            parent.insert(notInUse, parent.getIndex(inUse));
            parent.remove(inUse);
        }
        this.isMenu = isMenu;
    }

    @Override
    public void addTo(Buildable parent) {
        if (parent instanceof GameModule) {
            MenuManager.getInstance().addToSection("PredefinedSetup", this.getMenuInUse());
        } else if (parent instanceof PredefinedSetup) {
            PredefinedSetup setup = (PredefinedSetup)parent;
            setup.menu.add(this.getMenuInUse());
        }
        MenuManager.getInstance().removeAction("GameState.new_game");
        GameModule.getGameModule().getGameState().addGameComponent(this);
        GameModule.getGameModule().getWizardSupport().addPredefinedSetup(this);
    }

    @Override
    public void removeFrom(Buildable parent) {
        if (parent instanceof GameModule) {
            MenuManager.getInstance().removeFromSection("PredefinedSetup", this.getMenuInUse());
        } else if (parent instanceof PredefinedSetup) {
            PredefinedSetup setup = (PredefinedSetup)parent;
            setup.menu.remove(this.getMenuInUse());
        }
        GameModule.getGameModule().getGameState().removeGameComponent(this);
        GameModule.getGameModule().getWizardSupport().removePredefinedSetup(this);
    }

    public Class<?>[] getAllowableConfigureComponents() {
        Class[] classArray;
        if (this.isMenu) {
            Class[] classArray2 = new Class[1];
            classArray = classArray2;
            classArray2[0] = PredefinedSetup.class;
        } else {
            classArray = new Class[]{};
        }
        return classArray;
    }

    public static String getConfigureTypeName() {
        return Resources.getString("Editor.PredefinedSetup.component_type");
    }

    @Override
    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("GameModule.htm", "PredefinedSetup");
    }

    public boolean isMenu() {
        return this.isMenu;
    }

    public boolean isUseFile() {
        return this.useFile;
    }

    public String getFileName() {
        return this.fileName;
    }

    @Override
    public Command getRestoreCommand() {
        return null;
    }

    @Override
    public void setup(boolean gameStarting) {
        this.launchAction.setEnabled(!gameStarting);
    }
}

