/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module.documentation;

import VASSAL.Info;
import VASSAL.build.AbstractConfigurable;
import VASSAL.build.Buildable;
import VASSAL.build.GameModule;
import VASSAL.build.module.ModuleExtension;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.i18n.Resources;
import VASSAL.tools.imageop.ImageOp;
import VASSAL.tools.imageop.Op;
import VASSAL.tools.menu.MenuManager;
import VASSAL.tools.swing.AboutWindow;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import javax.swing.AbstractAction;
import javax.swing.Action;

public class AboutScreen
extends AbstractConfigurable {
    protected ImageOp op;
    protected Image image;
    protected String title;
    protected String fileName;
    protected Action launch = new AbstractAction(){
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent e) {
            AboutScreen.this.launch();
        }
    };
    public static final String TITLE = "title";
    public static final String FILE = "fileName";

    public AboutScreen() {
    }

    public AboutScreen(ImageOp op) {
        this();
        if (op == null) {
            throw new IllegalArgumentException();
        }
        this.op = op;
    }

    public void launch() {
        if (this.op == null) {
            return;
        }
        GameModule g = GameModule.getGameModule();
        if (g == null) {
            return;
        }
        StringBuilder sb = new StringBuilder("<html><center>");
        sb.append(Resources.getString("AboutScreen.module_version", g.getLocalizedGameName(), g.getGameVersion()));
        for (ModuleExtension ext : g.getComponentsOf(ModuleExtension.class)) {
            sb.append("<br/>").append(Resources.getString("AboutScreen.extension_version", ext.getName(), ext.getVersion()));
        }
        sb.append("<br/>").append(Resources.getString("AboutScreen.vassal_version", Info.getVersion()));
        sb.append("</center></html>");
        AboutWindow w = new AboutWindow(g.getFrame(), this.op.getImage(), sb.toString());
        w.setVisible(true);
        w.toFront();
    }

    public static String getConfigureTypeName() {
        return "About Screen";
    }

    @Override
    public String[] getAttributeNames() {
        return new String[]{TITLE, FILE};
    }

    @Override
    public String[] getAttributeDescriptions() {
        return new String[]{"Menu Entry:  ", "Image:  "};
    }

    @Override
    public Class<?>[] getAttributeTypes() {
        return new Class[]{String.class, Image.class};
    }

    @Override
    public String getAttributeValueString(String key) {
        if (TITLE.equals(key)) {
            return this.title;
        }
        if (FILE.equals(key)) {
            return this.fileName;
        }
        return null;
    }

    @Override
    public void setAttribute(String key, Object val) {
        if (TITLE.equals(key)) {
            this.title = (String)val;
            if (this.title != null && this.title.equals(Resources.getString("AboutScreen.about_vassal"))) {
                this.title = Resources.getString("Documentation.about_module");
            }
            this.setConfigureName(this.title);
            this.launch.putValue("Name", this.title);
        } else if (FILE.equals(key)) {
            if (val instanceof File) {
                val = ((File)val).getName();
            }
            this.fileName = (String)val;
            this.op = null;
            if (this.fileName != null) {
                this.fileName = this.fileName.trim();
                if (this.fileName.length() > 0) {
                    this.op = Op.load(this.fileName);
                    BufferedImage img = this.op.getImage();
                    if (img != null) {
                        GameModule.getGameModule().getWizardSupport().setBackgroundImage(this.op.getImage());
                    } else {
                        this.op = null;
                    }
                }
            }
        }
    }

    public Class<?>[] getAllowableConfigureComponents() {
        return new Class[0];
    }

    @Override
    public void removeFrom(Buildable b) {
        MenuManager.getInstance().removeAction("Documentation.about_module");
    }

    @Override
    public void addTo(Buildable b) {
        MenuManager.getInstance().addAction("Documentation.about_module", this.launch);
    }

    @Override
    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("HelpMenu.htm", "AboutScreen");
    }
}

