/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module.gamepieceimage;

import VASSAL.build.module.gamepieceimage.GamePieceImage;
import VASSAL.build.module.gamepieceimage.GamePieceLayout;
import VASSAL.build.module.gamepieceimage.ImageItem;
import VASSAL.build.module.gamepieceimage.Item;
import VASSAL.build.module.gamepieceimage.ShapeItem;
import VASSAL.build.module.gamepieceimage.SymbolItem;
import VASSAL.build.module.gamepieceimage.TextBoxItem;
import VASSAL.build.module.gamepieceimage.TextItem;
import VASSAL.build.module.gamepieceimage.Visualizer;
import VASSAL.configure.Configurer;
import VASSAL.configure.IntConfigurer;
import VASSAL.configure.StringConfigurer;
import VASSAL.tools.ScrollPane;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;

public class LayoutConfigurer
extends Configurer {
    protected static final String ADD_SYMBOL = "Symbol";
    protected static final String ADD_IMAGE = "Image";
    protected static final String ADD_TEXT = "Label";
    protected static final String ADD_TEXTBOX = "Text Box";
    protected static final String ADD_SHAPE = "Shape";
    protected static final String REMOVE = "Remove";
    protected static final String UP = "Up";
    protected static final String DOWN = "Down";
    protected static final int NO_CURRENT_ITEM = -1;
    protected JPanel panel;
    protected ItemPanel itemPanel;
    protected JPanel itemConfigPanel;
    protected Component currentItemControls;
    protected int currentItem = -1;
    protected Box visBox;
    protected Visualizer visualizer = new Visualizer();
    protected JLabel visLabel;
    protected Box filler;
    protected GamePieceLayout layout;
    protected StringConfigurer defName;
    protected NewIntConfigurer height;
    protected NewIntConfigurer width;

    protected LayoutConfigurer() {
        super(null, null);
    }

    protected LayoutConfigurer(String key, String name, GamePieceLayout def) {
        super(key, name);
        this.layout = def;
    }

    @Override
    public Object getValue() {
        if (this.layout != null) {
            this.layout.setConfigureName(this.defName.getValueString());
            this.layout.setHeight((Integer)this.height.getValue());
            this.layout.setWidth((Integer)this.width.getValue());
        }
        return this.layout;
    }

    @Override
    public void setValue(String s) {
        if (this.itemPanel != null) {
            this.itemPanel.reshow();
        }
    }

    @Override
    public Component getControls() {
        if (this.panel == null) {
            this.panel = new JPanel();
            this.panel.setLayout(new BoxLayout(this.panel, 1));
            this.filler = Box.createHorizontalBox();
            this.filler.setPreferredSize(new Dimension(50, 10));
            this.panel.add(this.filler);
            this.visBox = Box.createHorizontalBox();
            this.visBox.setAlignmentX(0.5f);
            this.visualizer = new Visualizer(this.layout);
            this.visBox.add(new ScrollPane(this.visualizer));
            this.panel.add(this.visBox);
            this.filler = Box.createHorizontalBox();
            this.filler.setPreferredSize(new Dimension(50, 10));
            this.panel.add(this.filler);
            this.itemPanel = new ItemPanel();
            this.panel.add(this.itemPanel);
            this.filler = Box.createHorizontalBox();
            this.filler.setPreferredSize(new Dimension(50, 10));
            this.panel.add(this.filler);
            Window w = SwingUtilities.getWindowAncestor(this.itemPanel);
            if (w != null) {
                w.pack();
            }
        }
        return this.panel;
    }

    @Override
    public String getValueString() {
        return null;
    }

    protected void repack() {
        Window w = SwingUtilities.getWindowAncestor(this.panel);
        if (w != null) {
            w.pack();
        }
        if (this.visualizer != null) {
            this.visualizer.rebuild();
        }
    }

    protected class NewIntConfigurer
    extends IntConfigurer {
        NewIntConfigurer(String name, String key, Integer i) {
            super(name, key, i);
        }

        public void setColumns(int cols) {
            this.nameField.setColumns(cols);
        }

        public int getIntValue() {
            return (Integer)this.getValue();
        }
    }

    protected class ItemPanel
    extends JPanel
    implements ActionListener {
        private static final long serialVersionUID = 1L;
        protected JTable table;
        protected AbstractTableModel model;
        protected JScrollPane scrollPane;
        protected JButton addSymbolBtn;
        protected JButton addTextBtn;
        protected JButton addTextBoxBtn;
        protected JButton addImageBtn;
        protected JButton addShapeBtn;
        protected JButton remBtn;
        protected JButton upBtn;
        protected JButton dnBtn;
        protected JPanel mainPanel;

        public ItemPanel() {
            this.setLayout(new BoxLayout(this, 1));
            this.mainPanel = new JPanel();
            this.mainPanel.setBorder(BorderFactory.createLineBorder(Color.black));
            this.mainPanel.setLayout(new BoxLayout(this.mainPanel, 1));
            Box box = Box.createHorizontalBox();
            box.add(new JLabel("Items"));
            this.mainPanel.add(box);
            this.model = new MyTableModel();
            this.table = new JTable(this.model);
            this.table.setSelectionMode(0);
            if (LayoutConfigurer.this.layout.getItemCount() > 0) {
                this.table.getSelectionModel().setSelectionInterval(0, 0);
            }
            ListSelectionModel rowSM = this.table.getSelectionModel();
            rowSM.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    if (e.getValueIsAdjusting()) {
                        return;
                    }
                    ListSelectionModel lsm = (ListSelectionModel)e.getSource();
                    if (lsm.isSelectionEmpty()) {
                        ItemPanel.this.showItem(-1);
                    } else {
                        int selectedRow = lsm.getMinSelectionIndex();
                        ItemPanel.this.showItem(selectedRow);
                    }
                }
            });
            this.scrollPane = new ScrollPane(this.table);
            this.table.setPreferredScrollableViewportSize(new Dimension(300, 100));
            this.mainPanel.add(this.scrollPane);
            box = Box.createHorizontalBox();
            this.addSymbolBtn = new JButton(LayoutConfigurer.ADD_SYMBOL);
            this.addSymbolBtn.setToolTipText("Add a Symbol to the Layout");
            this.addSymbolBtn.addActionListener(this);
            box.add(this.addSymbolBtn);
            this.addTextBtn = new JButton(LayoutConfigurer.ADD_TEXT);
            this.addTextBtn.setToolTipText("Add Text to the Layout");
            this.addTextBtn.addActionListener(this);
            box.add(this.addTextBtn);
            this.addTextBoxBtn = new JButton(LayoutConfigurer.ADD_TEXTBOX);
            this.addTextBoxBtn.setToolTipText("Add Text Box to the Layout");
            this.addTextBoxBtn.addActionListener(this);
            box.add(this.addTextBoxBtn);
            this.addImageBtn = new JButton(LayoutConfigurer.ADD_IMAGE);
            this.addImageBtn.setToolTipText("Add an Image to the Layout");
            this.addImageBtn.addActionListener(this);
            box.add(this.addImageBtn);
            this.addShapeBtn = new JButton(LayoutConfigurer.ADD_SHAPE);
            this.addShapeBtn.setToolTipText("Add a Colored Shape to the Layout");
            this.addShapeBtn.addActionListener(this);
            box.add(this.addShapeBtn);
            this.mainPanel.add(box);
            box = Box.createHorizontalBox();
            this.remBtn = new JButton(LayoutConfigurer.REMOVE);
            this.remBtn.setToolTipText("Remove the selected Item");
            this.remBtn.addActionListener(this);
            box.add(this.remBtn);
            this.upBtn = new JButton(LayoutConfigurer.UP);
            this.upBtn.setToolTipText("Move the selected Item up the list (draw earlier)");
            this.upBtn.addActionListener(this);
            box.add(this.upBtn);
            this.dnBtn = new JButton(LayoutConfigurer.DOWN);
            this.dnBtn.setToolTipText("Move the selected Item down the list (draw later)");
            this.dnBtn.addActionListener(this);
            box.add(this.dnBtn);
            this.mainPanel.add(box);
            this.add(this.mainPanel);
            box = Box.createHorizontalBox();
            box.setPreferredSize(new Dimension(50, 10));
            this.add(box);
            LayoutConfigurer.this.itemConfigPanel = new JPanel();
            LayoutConfigurer.this.itemConfigPanel.setBorder(BorderFactory.createLineBorder(Color.black));
            this.add(new ScrollPane(LayoutConfigurer.this.itemConfigPanel));
            this.showItem(0);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String action = e.getActionCommand();
            int pos = LayoutConfigurer.this.layout.getItemCount();
            int sel = this.table.getSelectedRow();
            if (action.equals(LayoutConfigurer.ADD_SYMBOL)) {
                this.addItem(new SymbolItem(LayoutConfigurer.this.layout, LayoutConfigurer.ADD_SYMBOL + pos));
            } else if (action.equals(LayoutConfigurer.ADD_TEXT)) {
                TextItem item = new TextItem(LayoutConfigurer.this.layout, "Text" + pos);
                this.addItem(item);
            } else if (action.equals(LayoutConfigurer.ADD_TEXTBOX)) {
                TextBoxItem item = new TextBoxItem(LayoutConfigurer.this.layout, "TextBox" + pos);
                this.addItem(item);
            } else if (action.equals(LayoutConfigurer.ADD_IMAGE)) {
                this.addItem(new ImageItem(LayoutConfigurer.this.layout, LayoutConfigurer.ADD_IMAGE + pos));
            } else if (action.equals(LayoutConfigurer.ADD_SHAPE)) {
                this.addItem(new ShapeItem(LayoutConfigurer.this.layout, LayoutConfigurer.ADD_SHAPE + pos));
            } else if (action.equals(LayoutConfigurer.REMOVE)) {
                if (sel >= 0) {
                    LayoutConfigurer.this.layout.removeItem(sel);
                    this.model.fireTableRowsDeleted(sel, sel);
                }
                if (LayoutConfigurer.this.layout.getItemCount() > 1) {
                    if (sel >= LayoutConfigurer.this.layout.getItemCount()) {
                        this.table.getSelectionModel().setSelectionInterval(LayoutConfigurer.this.layout.getItemCount() - 1, LayoutConfigurer.this.layout.getItemCount() - 1);
                    } else {
                        this.table.getSelectionModel().setSelectionInterval(sel, sel);
                    }
                }
            } else if (action.equals(LayoutConfigurer.UP)) {
                if (sel > 0) {
                    this.moveItem(sel, sel - 1);
                }
            } else if (action.equals(LayoutConfigurer.DOWN) && sel < pos - 1) {
                this.moveItem(sel, sel + 1);
            }
            this.rebuildViz();
        }

        protected void addItem(Item item) {
            LayoutConfigurer.this.layout.addItem(item);
            int pos = LayoutConfigurer.this.layout.getItemCount() - 1;
            this.model.fireTableRowsInserted(pos, pos);
            this.table.getSelectionModel().setSelectionInterval(pos, pos);
        }

        protected void moveItem(int from, int to) {
            LayoutConfigurer.this.layout.moveItem(from, to);
            this.model.fireTableRowsUpdated(from, to);
            this.table.getSelectionModel().setSelectionInterval(to, to);
            this.rebuildViz();
        }

        protected void rebuildViz() {
            LayoutConfigurer.this.layout.setImageDefn(new GamePieceImage(LayoutConfigurer.this.layout));
            LayoutConfigurer.this.visualizer.rebuild();
        }

        protected void showItem(int itemNo) {
            if (LayoutConfigurer.this.currentItemControls != null) {
                LayoutConfigurer.this.itemConfigPanel.remove(LayoutConfigurer.this.currentItemControls);
                LayoutConfigurer.this.currentItemControls = null;
                LayoutConfigurer.this.currentItem = -1;
            }
            if (itemNo != -1 && LayoutConfigurer.this.layout.getItemCount() > 0 && itemNo < LayoutConfigurer.this.layout.getItemCount()) {
                Item item = LayoutConfigurer.this.layout.getItem(itemNo);
                Configurer c = item.getConfigurer();
                LayoutConfigurer.this.currentItemControls = c.getControls();
                LayoutConfigurer.this.itemConfigPanel.add(LayoutConfigurer.this.currentItemControls);
                LayoutConfigurer.this.currentItem = itemNo;
            }
            this.reshow();
        }

        public void reshow() {
            LayoutConfigurer.this.repack();
            this.rebuildViz();
            LayoutConfigurer.this.itemConfigPanel.repaint();
        }

        class MyTableModel
        extends AbstractTableModel {
            private static final long serialVersionUID = 1L;
            private String[] columnNames = new String[]{"Name", "Type", "Position"};

            MyTableModel() {
            }

            @Override
            public int getColumnCount() {
                return this.columnNames.length;
            }

            @Override
            public int getRowCount() {
                return LayoutConfigurer.this.layout.getItemCount();
            }

            @Override
            public String getColumnName(int col) {
                return this.columnNames[col];
            }

            @Override
            public Object getValueAt(int row, int col) {
                if (col == 0) {
                    return LayoutConfigurer.this.layout.getItem(row).getConfigureName();
                }
                if (col == 1) {
                    return LayoutConfigurer.this.layout.getItem(row).getDisplayName();
                }
                if (col == 2) {
                    return LayoutConfigurer.this.layout.getItem(row).getLocation();
                }
                return null;
            }

            public Class<String> getColumnClass(int c) {
                return String.class;
            }
        }
    }
}

