/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module.gamepieceimage;

import VASSAL.build.AutoConfigurable;
import VASSAL.build.module.gamepieceimage.ColorSwatch;
import VASSAL.build.module.gamepieceimage.ColorSwatchConfigurer;
import VASSAL.build.module.gamepieceimage.GamePieceImage;
import VASSAL.build.module.gamepieceimage.ItemInstance;
import VASSAL.build.module.gamepieceimage.TextItem;
import VASSAL.configure.Configurer;
import VASSAL.configure.ConfigurerFactory;
import VASSAL.configure.VisibilityCondition;
import VASSAL.tools.SequenceEncoder;

public class TextItemInstance
extends ItemInstance {
    protected static final String VALUE = "value";
    protected static final String OUTLINE_COLOR = "outlineColor";
    protected String val = "";
    protected ColorSwatch outlineColor = ColorSwatch.getRed();
    private VisibilityCondition valueCond = new VisibilityCondition(){

        @Override
        public boolean shouldBeVisible() {
            return !((TextItem)TextItemInstance.this.getItem()).isFixed();
        }
    };

    public TextItemInstance() {
        this.val = "Xx";
        this.outlineColor = ColorSwatch.getRed();
    }

    public TextItemInstance(String nam, String typ, String loc, String val) {
        super(nam, typ, loc);
        if (val == null) {
            switch (nam.length()) {
                case 0: {
                    this.setValue("Xx");
                    break;
                }
                case 1: {
                    this.setValue(nam);
                    break;
                }
                default: {
                    this.setValue(nam.substring(0, 2));
                    break;
                }
            }
        } else {
            this.setValue(val);
        }
    }

    public TextItemInstance(String code, GamePieceImage defn) {
        super(defn);
        this.decode(code);
    }

    public void setValue(String value) {
        this.val = value;
    }

    public String getValue() {
        return this.val;
    }

    public boolean isOutline() {
        TextItem item = (TextItem)this.getItem();
        return item == null ? false : item.isOutline();
    }

    public ColorSwatch getOutlineColor() {
        return this.outlineColor;
    }

    public void setOutlineColor(ColorSwatch c) {
        this.outlineColor = c;
    }

    @Override
    public String encode() {
        SequenceEncoder se = new SequenceEncoder(';');
        se.append(this.getType());
        se.append(this.getName());
        se.append(this.getLocation());
        se.append(this.getFgColor().encode());
        se.append(this.getBgColor().encode());
        se.append(this.getValue());
        se.append(this.getOutlineColor().encode());
        return se.getValue();
    }

    public void decode(String code) {
        SequenceEncoder.Decoder sd = new SequenceEncoder.Decoder(code, ';');
        this.setType(sd.nextToken(""));
        this.setName(sd.nextToken(""));
        this.setLocation(sd.nextToken(""));
        this.setFgColor(new ColorSwatch(sd.nextToken("")));
        this.setBgColor(new ColorSwatch(sd.nextToken("")));
        this.setValue(sd.nextToken(""));
        this.setOutlineColor(new ColorSwatch(sd.nextToken("")));
    }

    @Override
    public String[] getAttributeDescriptions() {
        return new String[]{"Value:  ", "Foreground Color:  ", "Background Color:  ", "Outline Color:  "};
    }

    @Override
    public Class<?>[] getAttributeTypes() {
        return new Class[]{String.class, FgColorSwatchConfig.class, BgColorSwatchConfig.class, OutlineColorSwatchConfig.class};
    }

    @Override
    public String[] getAttributeNames() {
        return new String[]{VALUE, "fgColor", "bgColor", OUTLINE_COLOR};
    }

    @Override
    public void setAttribute(String key, Object o) {
        if (VALUE.equals(key)) {
            this.val = (String)o;
        } else if ("fgColor".equals(key)) {
            if (o instanceof String) {
                o = new ColorSwatch((String)o);
            }
            this.fgColor = (ColorSwatch)o;
        } else if ("bgColor".equals(key)) {
            if (o instanceof String) {
                o = new ColorSwatch((String)o);
            }
            this.bgColor = (ColorSwatch)o;
        } else if (OUTLINE_COLOR.equals(key)) {
            if (o instanceof String) {
                o = new ColorSwatch((String)o);
            }
            this.outlineColor = (ColorSwatch)o;
        }
        if (this.myConfig != null) {
            this.myConfig.rebuildViz();
        }
    }

    @Override
    public String getAttributeValueString(String key) {
        if (VALUE.equals(key)) {
            return this.val;
        }
        if ("fgColor".equals(key)) {
            return this.fgColor.encode();
        }
        if ("bgColor".equals(key)) {
            return this.bgColor.encode();
        }
        if (OUTLINE_COLOR.equals(key)) {
            return this.outlineColor.encode();
        }
        return null;
    }

    @Override
    public VisibilityCondition getAttributeVisibility(String name) {
        if (VALUE.equals(name)) {
            return this.valueCond;
        }
        if (OUTLINE_COLOR.equals(name)) {
            return new VisibilityCondition(){

                @Override
                public boolean shouldBeVisible() {
                    return TextItemInstance.this.isOutline();
                }
            };
        }
        return super.getAttributeVisibility(name);
    }

    public static class FgColorSwatchConfig
    implements ConfigurerFactory {
        @Override
        public Configurer getConfigurer(AutoConfigurable c, String key, String name) {
            return new ColorSwatchConfigurer(key, name, ((ItemInstance)c).getFgColor());
        }
    }

    public static class BgColorSwatchConfig
    implements ConfigurerFactory {
        @Override
        public Configurer getConfigurer(AutoConfigurable c, String key, String name) {
            return new ColorSwatchConfigurer(key, name, ((ItemInstance)c).getBgColor());
        }
    }

    public static class OutlineColorSwatchConfig
    implements ConfigurerFactory {
        @Override
        public Configurer getConfigurer(AutoConfigurable c, String key, String name) {
            return new ColorSwatchConfigurer(key, name, ((TextItemInstance)c).getOutlineColor());
        }
    }
}

