/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module.map;

import VASSAL.build.AutoConfigurable;
import VASSAL.build.Buildable;
import VASSAL.build.Configurable;
import VASSAL.build.GameModule;
import VASSAL.build.module.GameComponent;
import VASSAL.build.module.Map;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.build.module.map.CounterDetailViewer;
import VASSAL.build.module.map.Drawable;
import VASSAL.command.Command;
import VASSAL.configure.AutoConfigurer;
import VASSAL.configure.ColorConfigurer;
import VASSAL.configure.Configurer;
import VASSAL.configure.ConfigurerFactory;
import VASSAL.configure.IconConfigurer;
import VASSAL.configure.VisibilityCondition;
import VASSAL.counters.GamePiece;
import VASSAL.i18n.ComponentI18nData;
import VASSAL.i18n.Resources;
import VASSAL.i18n.Translatable;
import VASSAL.tools.KeyStrokeSource;
import VASSAL.tools.LaunchButton;
import VASSAL.tools.NamedKeyStroke;
import VASSAL.tools.ScrollPane;
import VASSAL.tools.swing.SwingUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.AffineTransform;
import java.beans.PropertyChangeListener;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class GlobalMap
implements AutoConfigurable,
GameComponent,
Drawable {
    private static final long serialVersionUID = 2L;
    protected Map map;
    protected double scale = 0.19444444;
    protected Color rectColor = Color.black;
    protected final LaunchButton launch;
    protected CounterDetailViewer mouseOverViewer;
    protected final ScrollPane scroll;
    protected final View view = new View();
    protected ComponentI18nData myI18nData;
    protected static final String SCALE = "scale";
    protected static final String COLOR = "color";
    protected static final String HOTKEY = "hotkey";
    protected static final String ICON_NAME = "icon";
    protected static final String TOOLTIP = "tooltip";
    protected static final String BUTTON_TEXT = "buttonText";
    protected static final String DEFAULT_ICON = "/images/overview.gif";

    public GlobalMap() {
        this.view.addMouseListener(this.view);
        this.scroll = new GlobalMapScrollPane(this.view);
        this.scroll.setBorder(BorderFactory.createEtchedBorder(0));
        this.scroll.setAlignmentX(0.0f);
        this.scroll.setAlignmentY(0.0f);
        ActionListener al = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GlobalMap.this.scroll.setVisible(!GlobalMap.this.scroll.isVisible());
            }
        };
        this.launch = new LaunchButton(null, TOOLTIP, BUTTON_TEXT, HOTKEY, ICON_NAME, al);
        this.launch.setAttribute(TOOLTIP, "Show/Hide overview window");
        this.launch.setAttribute(HOTKEY, NamedKeyStroke.getNamedKeyStroke(79, 192));
    }

    @Override
    public void addTo(Buildable b) {
        this.map = (Map)b;
        this.mouseOverViewer = new CounterViewer();
        GameModule.getGameModule().getGameState().addGameComponent(this);
        GameModule.getGameModule().addKeyStrokeSource(new KeyStrokeSource(this.view, 0));
        this.map.addDrawComponent(this);
        this.map.getToolBar().add(this.launch);
        if (b instanceof Translatable) {
            this.getI18nData().setOwningComponent((Translatable)b);
        }
        this.map.getLayeredPane().add((Component)this.scroll, JLayeredPane.PALETTE_LAYER);
    }

    @Override
    public void add(Buildable b) {
    }

    @Override
    public void remove(Buildable b) {
    }

    @Override
    public void removeFrom(Buildable b) {
        this.map = (Map)b;
        this.map.removeDrawComponent(this);
        this.map.getToolBar().remove(this.launch);
        GameModule.getGameModule().getGameState().removeGameComponent(this);
        this.map.getLayeredPane().remove(this.scroll);
    }

    @Override
    public void build(Element e) {
        AutoConfigurable.Util.buildAttributes(e, this);
    }

    @Override
    public String[] getAttributeNames() {
        return new String[]{TOOLTIP, BUTTON_TEXT, ICON_NAME, HOTKEY, SCALE, COLOR};
    }

    @Override
    public VisibilityCondition getAttributeVisibility(String name) {
        return null;
    }

    @Override
    public void setAttribute(String key, Object value) {
        if (SCALE.equals(key)) {
            if (value instanceof String) {
                value = Double.valueOf((String)value);
            }
            this.scale = (Double)value;
        } else if (COLOR.equals(key)) {
            if (value instanceof String) {
                value = ColorConfigurer.stringToColor((String)value);
            }
            this.rectColor = (Color)value;
        } else {
            this.launch.setAttribute(key, value);
        }
    }

    @Override
    public String getAttributeValueString(String key) {
        if (SCALE.equals(key)) {
            return String.valueOf(this.scale);
        }
        if (COLOR.equals(key)) {
            return ColorConfigurer.colorToString(this.rectColor);
        }
        return this.launch.getAttributeValueString(key);
    }

    @Override
    public String[] getAttributeDescriptions() {
        return new String[]{Resources.getString("Editor.tooltip_text_label"), Resources.getString("Editor.button_text_label"), Resources.getString("Editor.button_icon_label"), Resources.getString("Editor.GlobalMap.show_hide"), Resources.getString("Editor.GlobalMap.scale_factor"), Resources.getString("Editor.GlobalMap.hilight")};
    }

    @Override
    public Class<?>[] getAttributeTypes() {
        return new Class[]{String.class, String.class, IconConfig.class, NamedKeyStroke.class, Double.class, Color.class};
    }

    @Override
    public void draw(Graphics g, Map m) {
        this.view.repaint();
    }

    @Override
    public boolean drawAboveCounters() {
        return true;
    }

    public Point componentToMap(Point p) {
        return new Point((int)Math.round((double)p.x / this.scale) + this.map.getEdgeBuffer().width, (int)Math.round((double)p.y / this.scale) + this.map.getEdgeBuffer().height);
    }

    public Point mapToComponent(Point p) {
        return new Point((int)((double)(p.x - this.map.getEdgeBuffer().width) * this.scale), (int)((double)(p.y - this.map.getEdgeBuffer().height) * this.scale));
    }

    public Point mapToDrawing(Point p, double os_scale) {
        double dscale = this.scale * os_scale;
        return new Point((int)((double)(p.x - this.map.getEdgeBuffer().width) * dscale), (int)((double)(p.y - this.map.getEdgeBuffer().height) * dscale));
    }

    public Rectangle mapToDrawing(Rectangle r, double os_scale) {
        double dscale = this.scale * os_scale;
        return new Rectangle((int)((double)(r.x - this.map.getEdgeBuffer().width) * dscale), (int)((double)(r.y - this.map.getEdgeBuffer().height) * dscale), (int)((double)r.width * dscale), (int)((double)r.height * dscale));
    }

    public String getToolTipText(MouseEvent e) {
        return null;
    }

    @Override
    public Command getRestoreCommand() {
        return null;
    }

    @Override
    public void setup(boolean show) {
        if (show) {
            this.scroll.setMaximumSize(this.scroll.getPreferredSize());
        } else {
            this.scroll.setVisible(false);
        }
        if (show && !this.map.getComponentsOf(CounterDetailViewer.class).isEmpty()) {
            this.view.addMouseListener(this.mouseOverViewer);
            this.view.addMouseMotionListener(this.mouseOverViewer);
            this.scroll.addKeyListener(this.mouseOverViewer);
        } else {
            this.view.removeMouseListener(this.mouseOverViewer);
            this.view.removeMouseMotionListener(this.mouseOverViewer);
            this.scroll.removeKeyListener(this.mouseOverViewer);
        }
    }

    public static String getConfigureTypeName() {
        return Resources.getString("Editor.GlobalMap.component_type");
    }

    @Override
    public String getConfigureName() {
        return null;
    }

    @Override
    public Configurer getConfigurer() {
        return new AutoConfigurer(this);
    }

    @Override
    public Configurable[] getConfigureComponents() {
        return new Configurable[0];
    }

    public Class<?>[] getAllowableConfigureComponents() {
        return new Class[0];
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener l) {
    }

    @Override
    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("Map.htm", "OverviewWindow");
    }

    @Override
    public Element getBuildElement(Document doc) {
        return AutoConfigurable.Util.getBuildElement(doc, this);
    }

    @Override
    public ComponentI18nData getI18nData() {
        if (this.myI18nData == null) {
            this.myI18nData = new ComponentI18nData(this, "GlobalMap");
        }
        return this.myI18nData;
    }

    protected class View
    extends JPanel
    implements MouseListener {
        private static final long serialVersionUID = 1L;

        protected View() {
        }

        @Override
        protected void paintComponent(Graphics g) {
            Graphics2D g2d = (Graphics2D)g;
            double os_scale = g2d.getDeviceConfiguration().getDefaultTransform().getScaleX();
            AffineTransform orig_t = g2d.getTransform();
            g2d.setTransform(SwingUtils.descaleTransform(orig_t));
            double dscale = GlobalMap.this.scale * os_scale;
            GlobalMap.this.map.drawBoards(g, -Math.round((float)dscale * (float)GlobalMap.this.map.getEdgeBuffer().width), -Math.round((float)dscale * (float)GlobalMap.this.map.getEdgeBuffer().height), dscale, this);
            for (GamePiece gp : GlobalMap.this.map.getPieces()) {
                Point p = GlobalMap.this.mapToDrawing(gp.getPosition(), os_scale);
                gp.draw(g, p.x, p.y, this, dscale);
            }
            GlobalMap.this.mouseOverViewer.draw(g, GlobalMap.this.map);
            g.setColor(GlobalMap.this.rectColor);
            Rectangle vr = GlobalMap.this.mapToDrawing(GlobalMap.this.map.componentToMap(GlobalMap.this.map.getView().getVisibleRect()), os_scale);
            g.drawRect(vr.x, vr.y, vr.width, vr.height);
            g.drawRect(vr.x - 1, vr.y - 1, vr.width + 2, vr.height + 2);
            g2d.setTransform(orig_t);
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (SwingUtils.isLeftMouseButton(e)) {
                GlobalMap.this.map.centerAt(GlobalMap.this.componentToMap(e.getPoint()));
            }
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension((int)((double)(GlobalMap.this.map.mapSize().width - 2 * GlobalMap.this.map.getEdgeBuffer().width) * GlobalMap.this.scale), (int)((double)(GlobalMap.this.map.mapSize().height - 2 * GlobalMap.this.map.getEdgeBuffer().height) * GlobalMap.this.scale));
        }
    }

    protected class GlobalMapScrollPane
    extends ScrollPane {
        private static final long serialVersionUID = 1L;

        public GlobalMapScrollPane(Component view) {
            super(view, 20, 30);
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension d = GlobalMap.this.view.getPreferredSize();
            Insets i = this.getInsets();
            d.width += i.left + i.right;
            d.height += i.top + i.bottom;
            return d;
        }

        @Override
        public Dimension getMaximumSize() {
            Dimension d = this.getPreferredSize();
            if (this.verticalScrollBar.isVisible()) {
                d.width += this.verticalScrollBar.getPreferredSize().width;
            }
            if (this.horizontalScrollBar.isVisible()) {
                d.height += this.horizontalScrollBar.getPreferredSize().height;
            }
            return d;
        }

        @Override
        public void setBounds(Rectangle r) {
            Dimension availSize = GlobalMap.this.map.getView().getParent().getSize();
            Dimension viewSize = GlobalMap.this.view.getPreferredSize();
            Insets i = this.getInsets();
            viewSize.width += i.left + i.right;
            viewSize.height += i.top + i.bottom;
            boolean hsbNeeded = availSize.width < viewSize.width;
            boolean vsbNeeded = availSize.height < viewSize.height;
            Dimension realSize = new Dimension();
            realSize.width = availSize.width < viewSize.width ? availSize.width : (vsbNeeded ? Math.min(availSize.width, viewSize.width + this.verticalScrollBar.getPreferredSize().width) : viewSize.width);
            realSize.height = availSize.height < viewSize.height ? availSize.height : (hsbNeeded ? Math.min(availSize.height, viewSize.height + this.horizontalScrollBar.getPreferredSize().height) : viewSize.height);
            super.setBounds(0, 0, realSize.width, realSize.height);
        }

        @Override
        public void setVisible(boolean visible) {
            LayoutManager l;
            super.setVisible(visible);
            if (visible && (l = this.getParent().getLayout()) instanceof Map.InsetLayout) {
                l.layoutContainer(this.getParent());
            }
        }
    }

    protected class CounterViewer
    extends CounterDetailViewer {
        public CounterViewer() {
            this.map = GlobalMap.this.map;
            this.view = GlobalMap.this.view;
        }

        @Override
        protected List<GamePiece> getDisplayablePieces() {
            Point oldPoint = this.currentMousePosition.getPoint();
            Point mapPoint = GlobalMap.this.map.mapToComponent(GlobalMap.this.componentToMap(oldPoint));
            this.currentMousePosition.translatePoint(mapPoint.x - oldPoint.x, mapPoint.y - oldPoint.y);
            List<GamePiece> l = super.getDisplayablePieces();
            this.currentMousePosition.translatePoint(oldPoint.x - mapPoint.x, oldPoint.y - mapPoint.y);
            return l;
        }

        @Override
        protected double getZoom() {
            return GlobalMap.this.scale;
        }
    }

    public static class IconConfig
    implements ConfigurerFactory {
        @Override
        public Configurer getConfigurer(AutoConfigurable c, String key, String name) {
            return new IconConfigurer(key, name, GlobalMap.DEFAULT_ICON);
        }
    }
}

