/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module.map;

import VASSAL.build.AbstractConfigurable;
import VASSAL.build.AutoConfigurable;
import VASSAL.build.Buildable;
import VASSAL.build.module.Map;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.build.module.map.CompoundPieceCollection;
import VASSAL.build.module.map.LayeredPieceCollection;
import VASSAL.configure.StringArrayConfigurer;
import VASSAL.configure.StringEnum;
import VASSAL.configure.VisibilityCondition;
import VASSAL.i18n.Resources;
import VASSAL.tools.LaunchButton;
import VASSAL.tools.NamedKeyStroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.stream.Stream;
import javax.swing.Icon;

public class LayerControl
extends AbstractConfigurable {
    public static final String NAME = "name";
    public static final String TOOLTIP = "tooltip";
    public static final String BUTTON_TEXT = "text";
    public static final String BUTTON_ICON = "icon";
    public static final String BUTTON_HOTKEY = "hotkey";
    public static final String COMMAND = "command";
    public static final String SKIP = "skip";
    public static final String LAYERS = "layers";
    public static final String CMD_ROTATE_UP = "Rotate Layer Order Up";
    public static final String CMD_ROTATE_DN = "Rotate Layer Order Down";
    public static final String CMD_ENABLE = "Make Layer Active";
    public static final String CMD_DISABLE = "Make Layer Inactive";
    public static final String CMD_TOGGLE = "Switch Layer between Active and Inactive";
    public static final String CMD_RESET = "Reset All Layers";
    protected LaunchButton launch;
    protected static final String[] COMMANDS = new String[]{"Rotate Layer Order Up", "Rotate Layer Order Down", "Reset All Layers", "Make Layer Active", "Make Layer Inactive", "Switch Layer between Active and Inactive"};
    protected String command = "Reset All Layers";
    protected boolean skip = true;
    protected String[] layers = new String[0];
    protected LayeredPieceCollection pieceLayers;
    protected CompoundPieceCollection pieceCollection;

    public LayerControl() {
        this.launch = new LaunchButton("Reset Layers", TOOLTIP, BUTTON_TEXT, BUTTON_HOTKEY, BUTTON_ICON, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LayerControl.this.launch();
            }
        });
    }

    public void launch() {
        if (this.command.equals(CMD_RESET)) {
            this.pieceCollection.reset();
        } else if (this.command.equals(CMD_ROTATE_UP)) {
            this.pieceCollection.rotate(true, this.skip);
        } else if (this.command.equals(CMD_ROTATE_DN)) {
            this.pieceCollection.rotate(false, this.skip);
        } else if (this.command.equals(CMD_ENABLE)) {
            for (int i = 0; i < this.layers.length; ++i) {
                try {
                    Integer.parseInt(this.layers[i]);
                    this.pieceCollection.setLayerEnabled(i, true);
                    continue;
                }
                catch (NumberFormatException e) {
                    this.pieceCollection.setLayerEnabled(this.layers[i], true);
                }
            }
        } else if (this.command.equals(CMD_DISABLE)) {
            for (int i = 0; i < this.layers.length; ++i) {
                try {
                    Integer.parseInt(this.layers[i]);
                    this.pieceCollection.setLayerEnabled(i, false);
                    continue;
                }
                catch (NumberFormatException e) {
                    this.pieceCollection.setLayerEnabled(this.layers[i], false);
                }
            }
        } else if (this.command.equals(CMD_TOGGLE)) {
            for (int i = 0; i < this.layers.length; ++i) {
                try {
                    Integer.parseInt(this.layers[i]);
                    this.pieceCollection.toggleLayerEnabled(i);
                    continue;
                }
                catch (NumberFormatException e) {
                    this.pieceCollection.toggleLayerEnabled(this.layers[i]);
                }
            }
        } else {
            return;
        }
        this.getMap().repaint();
    }

    public LaunchButton getLaunchButton() {
        return this.launch;
    }

    @Override
    public String[] getAttributeDescriptions() {
        return new String[]{Resources.getString("Editor.button_text_label"), Resources.getString("Editor.tooltip_text_label"), Resources.getString("Editor.button_icon_label"), Resources.getString("Editor.hotkey_label"), Resources.getString("Editor.LayerControl.action"), Resources.getString("Editor.LayerControl.skip_layer"), Resources.getString("Editor.LayerControl.affect_layer")};
    }

    @Override
    public Class<?>[] getAttributeTypes() {
        return new Class[]{String.class, String.class, Icon.class, NamedKeyStroke.class, CommandConfig.class, Boolean.class, String[].class};
    }

    @Override
    public String[] getAttributeNames() {
        return new String[]{BUTTON_TEXT, TOOLTIP, BUTTON_ICON, BUTTON_HOTKEY, COMMAND, SKIP, LAYERS};
    }

    @Override
    public String getAttributeValueString(String key) {
        if (NAME.equals(key)) {
            return this.getConfigureName();
        }
        if (COMMAND.equals(key)) {
            return this.command;
        }
        if (SKIP.equals(key)) {
            return String.valueOf(this.skip);
        }
        if (LAYERS.equals(key)) {
            return StringArrayConfigurer.arrayToString(this.layers);
        }
        return this.launch.getAttributeValueString(key);
    }

    @Override
    public void setAttribute(String key, Object value) {
        if (NAME.equals(key)) {
            this.setConfigureName((String)value);
            if (this.launch.getAttributeValueString(TOOLTIP) == null) {
                this.launch.setAttribute(TOOLTIP, value);
            }
        } else if (COMMAND.equals(key)) {
            this.command = (String)value;
        } else if (SKIP.equals(key)) {
            if (value instanceof String) {
                value = Boolean.valueOf((String)value);
            }
            this.skip = (Boolean)value;
        } else if (LAYERS.equals(key)) {
            if (value instanceof String) {
                value = StringArrayConfigurer.stringToArray((String)value);
            }
            this.layers = value;
        } else {
            this.launch.setAttribute(key, value);
        }
    }

    @Override
    public VisibilityCondition getAttributeVisibility(String name) {
        if (SKIP.equals(name)) {
            return new VisibilityCondition(){

                @Override
                public boolean shouldBeVisible() {
                    return LayerControl.this.command.equals(LayerControl.CMD_ROTATE_UP) || LayerControl.this.command.equals(LayerControl.CMD_ROTATE_DN);
                }
            };
        }
        if (LAYERS.equals(name)) {
            return new VisibilityCondition(){

                @Override
                public boolean shouldBeVisible() {
                    return Stream.of(LayerControl.CMD_ENABLE, LayerControl.CMD_DISABLE, LayerControl.CMD_TOGGLE).anyMatch(s -> LayerControl.this.command.equals(s));
                }
            };
        }
        return null;
    }

    @Override
    public void addTo(Buildable parent) {
        this.pieceLayers = (LayeredPieceCollection)parent;
        this.pieceLayers.getToolBar().add(this.launch);
        this.pieceCollection = this.pieceLayers.getPieceCollection();
    }

    public Map getMap() {
        return this.pieceLayers.getMap();
    }

    public Class<?>[] getAllowableConfigureComponents() {
        return new Class[0];
    }

    @Override
    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("GamePieceLayers.htm");
    }

    public static String getConfigureTypeName() {
        return Resources.getString("Editor.LayerControl.component_type");
    }

    @Override
    public void removeFrom(Buildable parent) {
        if (this.getMap() != null) {
            this.getMap().getToolBar().remove(this.launch);
        }
    }

    public static class CommandConfig
    extends StringEnum {
        @Override
        public String[] getValidValues(AutoConfigurable target) {
            return COMMANDS;
        }
    }
}

