/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module.map;

import VASSAL.build.AbstractConfigurable;
import VASSAL.build.AutoConfigurable;
import VASSAL.build.Buildable;
import VASSAL.build.IllegalBuildException;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.build.module.map.SelectionHighlighters;
import VASSAL.configure.ColorConfigurer;
import VASSAL.configure.Configurer;
import VASSAL.configure.ConfigurerFactory;
import VASSAL.configure.IconConfigurer;
import VASSAL.configure.PropertyExpression;
import VASSAL.configure.VisibilityCondition;
import VASSAL.counters.GamePiece;
import VASSAL.counters.Highlighter;
import VASSAL.i18n.Resources;
import VASSAL.tools.image.ImageUtils;
import VASSAL.tools.imageop.ScaledImagePainter;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.util.List;

public class SelectionHighlighter
extends AbstractConfigurable
implements Highlighter {
    public static final String NAME = "name";
    public static final String MATCH = "match";
    public static final String COLOR = "color";
    public static final String THICKNESS = "thickness";
    public static final String USE_IMAGE = "useImage";
    public static final String IMAGE = "image";
    public static final String X_OFFSET = "xoffset";
    public static final String Y_OFFSET = "yoffset";
    protected PropertyExpression matchProperties = new PropertyExpression();
    protected Color color = Color.RED;
    protected int thickness = 3;
    protected boolean useImage = false;
    protected String imageName = "";
    protected int x = 0;
    protected int y = 0;
    protected VisibilityCondition visibilityCondition;
    protected ScaledImagePainter imagePainter = new ScaledImagePainter();

    @Override
    public void draw(GamePiece p, Graphics g, int x, int y, Component obs, double zoom) {
        Graphics2D g2d = (Graphics2D)g;
        if (this.accept(p)) {
            if (this.useImage) {
                int x1 = x - (int)((double)this.imagePainter.getImageSize().width * zoom / 2.0);
                int y1 = y - (int)((double)this.imagePainter.getImageSize().height * zoom / 2.0);
                this.imagePainter.draw(g, x1, y1, zoom, obs);
            } else {
                if (this.color == null || this.thickness <= 0) {
                    return;
                }
                Shape s = p.getShape();
                Stroke str = g2d.getStroke();
                g2d.setStroke(new BasicStroke(Math.max(1L, Math.round(zoom * (double)this.thickness))));
                g2d.setColor(this.color);
                AffineTransform t = AffineTransform.getScaleInstance(zoom, zoom);
                t.translate((double)x / zoom, (double)y / zoom);
                g2d.draw(t.createTransformedShape(s));
                g2d.setStroke(str);
            }
        }
    }

    @Override
    public Rectangle boundingBox(GamePiece p) {
        Rectangle r = p.getShape().getBounds();
        if (this.accept(p)) {
            if (this.useImage) {
                r.add(ImageUtils.getBounds(this.imagePainter.getImageSize()));
            } else {
                r.translate(-this.thickness, -this.thickness);
                r.setSize(r.width + 2 * this.thickness, r.height + 2 * this.thickness);
            }
        }
        return r;
    }

    protected boolean accept(GamePiece p) {
        return this.matchProperties.isNull() ? true : this.matchProperties.accept(p);
    }

    public static String getConfigureTypeName() {
        return Resources.getString("Editor.SelectionHighlight.component_type");
    }

    @Override
    public String[] getAttributeDescriptions() {
        return new String[]{Resources.getString("Editor.name_label"), Resources.getString("Editor.SelectionHighlight.active_property"), Resources.getString("Editor.SelectionHighlight.use_image"), Resources.getString("Editor.SelectionHighlight.border_color"), Resources.getString("Editor.SelectionHighlight.border_thickness"), Resources.getString("Editor.SelectionHighlight.image"), Resources.getString("Editor.SelectionHighlight.offset_x"), Resources.getString("Editor.SelectionHighlight.offset_y")};
    }

    @Override
    public Class<?>[] getAttributeTypes() {
        return new Class[]{String.class, PropertyExpression.class, Boolean.class, Color.class, Integer.class, IconConfig.class, Integer.class, Integer.class};
    }

    @Override
    public String[] getAttributeNames() {
        return new String[]{NAME, MATCH, USE_IMAGE, COLOR, THICKNESS, IMAGE, X_OFFSET, Y_OFFSET};
    }

    @Override
    public VisibilityCondition getAttributeVisibility(String name) {
        if (COLOR.equals(name) || THICKNESS.equals(name)) {
            return new VisibilityCondition(){

                @Override
                public boolean shouldBeVisible() {
                    return !SelectionHighlighter.this.useImage;
                }
            };
        }
        if (List.of(IMAGE, X_OFFSET, Y_OFFSET).contains(name)) {
            return new VisibilityCondition(){

                @Override
                public boolean shouldBeVisible() {
                    return SelectionHighlighter.this.useImage;
                }
            };
        }
        return super.getAttributeVisibility(name);
    }

    @Override
    public void setAttribute(String key, Object value) {
        if (key.equals(NAME)) {
            this.setConfigureName((String)value);
        } else if (key.equals(MATCH)) {
            this.matchProperties.setExpression((String)value);
        } else if (key.equals(USE_IMAGE)) {
            if (value instanceof String) {
                value = Boolean.valueOf((String)value);
            }
            this.useImage = (Boolean)value;
        } else if (key.equals(COLOR)) {
            if (value instanceof String) {
                value = ColorConfigurer.stringToColor((String)value);
            }
            if (value != null) {
                this.color = (Color)value;
            }
        } else if (key.equals(THICKNESS)) {
            if (value instanceof String) {
                value = Integer.valueOf((String)value);
            }
            this.thickness = (Integer)value;
        } else if (key.equals(IMAGE)) {
            this.imageName = (String)value;
            this.imagePainter.setImageName(this.imageName);
        } else {
            if (key.equals(X_OFFSET)) {
                if (value instanceof String) {
                    value = Integer.valueOf((String)value);
                }
                try {
                    this.x = (Integer)value;
                }
                catch (NumberFormatException ex) {
                    throw new IllegalBuildException(ex);
                }
            }
            if (key.equals(Y_OFFSET)) {
                if (value instanceof String) {
                    value = Integer.valueOf((String)value);
                }
                try {
                    this.y = (Integer)value;
                }
                catch (NumberFormatException ex) {
                    throw new IllegalBuildException(ex);
                }
            }
        }
    }

    @Override
    public String getAttributeValueString(String key) {
        if (key.equals(NAME)) {
            return this.getConfigureName();
        }
        if (key.equals(MATCH)) {
            return this.matchProperties.getExpression();
        }
        if (key.equals(USE_IMAGE)) {
            return String.valueOf(this.useImage);
        }
        if (key.equals(COLOR)) {
            return ColorConfigurer.colorToString(this.color);
        }
        if (key.equals(THICKNESS)) {
            return String.valueOf(this.thickness);
        }
        if (key.equals(IMAGE)) {
            return this.imageName;
        }
        if (key.equals(X_OFFSET)) {
            return String.valueOf(this.x);
        }
        if (key.equals(Y_OFFSET)) {
            return String.valueOf(this.y);
        }
        return null;
    }

    @Override
    public void removeFrom(Buildable parent) {
        ((SelectionHighlighters)parent).removeHighlighter(this);
    }

    @Override
    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("Map.htm", "SelectionHighlighter");
    }

    public Class<?>[] getAllowableConfigureComponents() {
        return new Class[0];
    }

    @Override
    public void addTo(Buildable parent) {
        ((SelectionHighlighters)parent).addHighlighter(this);
    }

    public static class IconConfig
    implements ConfigurerFactory {
        @Override
        public Configurer getConfigurer(AutoConfigurable c, String key, String name) {
            return new IconConfigurer(key, name, ((SelectionHighlighter)c).imageName);
        }
    }
}

