/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module.map;

import VASSAL.build.AbstractConfigurable;
import VASSAL.build.AutoConfigurable;
import VASSAL.build.Buildable;
import VASSAL.build.GameModule;
import VASSAL.build.module.Map;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.configure.Configurer;
import VASSAL.configure.ConfigurerFactory;
import VASSAL.configure.IconConfigurer;
import VASSAL.counters.GamePiece;
import VASSAL.i18n.Resources;
import VASSAL.tools.LaunchButton;
import VASSAL.tools.NamedKeyStroke;
import VASSAL.tools.WriteErrorDialog;
import VASSAL.tools.filechooser.FileChooser;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import javax.swing.JOptionPane;

public class TextSaver
extends AbstractConfigurable {
    protected static final String HOTKEY = "hotkey";
    protected static final String BUTTON_TEXT = "buttonText";
    protected static final String TOOLTIP = "tooltip";
    protected static final String ICON_NAME = "icon";
    protected Map map;
    protected LaunchButton launch;

    public TextSaver() {
        ActionListener al = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TextSaver.this.apply();
            }
        };
        this.launch = new LaunchButton("Save Text", TOOLTIP, BUTTON_TEXT, HOTKEY, ICON_NAME, al);
        this.launch.setAttribute(TOOLTIP, "Save map contents as plain text file");
    }

    @Override
    public String[] getAttributeNames() {
        return new String[]{BUTTON_TEXT, TOOLTIP, ICON_NAME, HOTKEY};
    }

    @Override
    public String[] getAttributeDescriptions() {
        return new String[]{Resources.getString("Editor.button_text_label"), Resources.getString("Editor.tooltip_text_label"), Resources.getString("Editor.button_icon_label"), Resources.getString("Editor.hotkey_label")};
    }

    @Override
    public Class<?>[] getAttributeTypes() {
        return new Class[]{String.class, String.class, IconConfig.class, NamedKeyStroke.class};
    }

    @Override
    public void setAttribute(String key, Object value) {
        this.launch.setAttribute(key, value);
    }

    @Override
    public String getAttributeValueString(String key) {
        return this.launch.getAttributeValueString(key);
    }

    @Override
    public void addTo(Buildable b) {
        this.map = (Map)b;
        this.map.getToolBar().add(this.launch);
    }

    @Override
    public void removeFrom(Buildable b) {
        this.map = (Map)b;
        this.map.getToolBar().remove(this.launch);
        this.map.getToolBar().revalidate();
    }

    public void apply() {
        switch (JOptionPane.showConfirmDialog(null, "Write contents as seen by opponents?", "", 0)) {
            case 1: {
                this.writeMapAsText();
                break;
            }
            case 0: {
                String myId = GameModule.getUserId();
                GameModule.setUserId("yendoR117");
                this.writeMapAsText();
                GameModule.setUserId(myId);
            }
        }
    }

    protected void writeMapAsText() {
        FileChooser fc = GameModule.getGameModule().getFileChooser();
        if (fc.showSaveDialog(this.map.getView()) != 0) {
            return;
        }
        File file = fc.getSelectedFile();
        try (FileWriter fw = new FileWriter(file);
             BufferedWriter bw = new BufferedWriter(fw);
             PrintWriter p = new PrintWriter(bw);){
            for (GamePiece gp : this.map.getPieces()) {
                String s = gp.getName();
                if (s.length() <= 0) continue;
                p.println(this.map.locationName(gp.getPosition()) + ": " + s);
            }
        }
        catch (IOException e) {
            WriteErrorDialog.error(e, file);
        }
    }

    @Override
    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("Map.htm", "TextCapture");
    }

    public static String getConfigureTypeName() {
        return Resources.getString("Editor.TextCapture.component_type");
    }

    public Class<?>[] getAllowableConfigureComponents() {
        return new Class[0];
    }

    public static class IconConfig
    implements ConfigurerFactory {
        @Override
        public Configurer getConfigurer(AutoConfigurable c, String key, String name) {
            return new IconConfigurer(key, name, ((TextSaver)c).launch.getAttributeValueString(TextSaver.ICON_NAME));
        }
    }
}

