/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module.properties;

import VASSAL.build.BadDataReport;
import VASSAL.build.module.properties.PropertyChanger;
import VASSAL.build.module.properties.PropertyChangerConfigurer;
import VASSAL.build.module.properties.PropertySource;
import VASSAL.i18n.Resources;
import VASSAL.tools.ErrorDialog;
import VASSAL.tools.FormattedString;

public class IncrementProperty
implements PropertyChanger {
    protected Constraints constraints;
    protected FormattedString format = new FormattedString();
    protected PropertyChangerConfigurer prop;

    public IncrementProperty(PropertyChangerConfigurer prop, String incr, Constraints constraints) {
        this.prop = prop;
        this.constraints = constraints;
        this.format.setFormat(incr);
    }

    @Override
    public String getNewValue(String oldValue) {
        int value = 0;
        try {
            value = oldValue == null || oldValue.length() == 0 ? 0 : Integer.parseInt(oldValue);
        }
        catch (NumberFormatException e) {
            ErrorDialog.dataError(new BadDataReport(Resources.getString("Error.non_number_error"), "Increment " + this.prop.getName() + ": oldValue =" + oldValue, e));
            return oldValue;
        }
        try {
            int incr = Integer.parseInt(this.format.getText(this.constraints.getPropertySource()));
            if (this.constraints.isWrap()) {
                value = value + incr > this.constraints.getMaximumValue() ? this.constraints.getMinimumValue() + (value + incr - this.constraints.getMaximumValue() - 1) : (value + incr < this.constraints.getMinimumValue() ? this.constraints.getMaximumValue() + (value + incr - this.constraints.getMinimumValue() + 1) : (value += incr));
            } else {
                value += incr;
                value = Math.min(this.constraints.getMaximumValue(), value);
                value = Math.max(this.constraints.getMinimumValue(), value);
            }
            return String.valueOf(value);
        }
        catch (NumberFormatException e) {
            ErrorDialog.dataError(new BadDataReport(Resources.getString("Error.non_number_error"), "Increment " + this.prop.getName() + ": format=" + this.format.getFormat() + ", value=" + this.format.getText(this.constraints), e));
            return oldValue;
        }
    }

    public String getIncrement() {
        return this.format.getFormat();
    }

    public static interface Constraints
    extends PropertySource {
        public int getMinimumValue();

        public int getMaximumValue();

        public boolean isWrap();

        public PropertySource getPropertySource();
    }
}

