/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.chat.jabber;

import VASSAL.build.GameModule;
import VASSAL.chat.ChatServerConnection;
import VASSAL.chat.ChatServerFactory;
import VASSAL.chat.CommandDecoder;
import VASSAL.chat.jabber.JabberClient;
import VASSAL.chat.jabber.ModuleAccountInfo;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JabberClientFactory
extends ChatServerFactory {
    private static final Logger logger = LoggerFactory.getLogger(JabberClientFactory.class);
    public static final String JABBER_SERVER_TYPE = "jabber";
    public static final String JABBER_PWD = "jabberPassword";
    public static final String JABBER_LOGIN = "jabberLogin";
    public static final String JABBER_PORT = "jabberPort";
    public static final String JABBER_HOST = "jabberHost";
    public static final String DEFAULT_JABBER_PORT = "5222";
    public static final String DEFAULT_JABBER_HOST = "localhost";

    @Override
    public ChatServerConnection buildServer(Properties serverConfig) {
        String host = serverConfig.getProperty(JABBER_HOST, DEFAULT_JABBER_HOST);
        int port = 5222;
        try {
            port = Integer.parseInt(serverConfig.getProperty(JABBER_PORT, DEFAULT_JABBER_PORT));
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
        ModuleAccountInfo account = new ModuleAccountInfo(serverConfig.getProperty(JABBER_LOGIN), serverConfig.getProperty(JABBER_PWD));
        JabberClient client = new JabberClient(GameModule.getGameModule(), host, port, account);
        client.addPropertyChangeListener("Status", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                String mess = (String)evt.getNewValue();
                GameModule.getGameModule().warn(mess);
                logger.error("", (Object)mess);
            }
        });
        client.addPropertyChangeListener("Msg", new CommandDecoder());
        return client;
    }
}

