/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.chat.node;

import VASSAL.build.GameModule;
import VASSAL.chat.ChatServerConnection;
import VASSAL.chat.ChatServerFactory;
import VASSAL.chat.CommandDecoder;
import VASSAL.chat.HttpMessageServer;
import VASSAL.chat.node.NodeServerInfo;
import VASSAL.chat.node.SocketNodeClient;
import VASSAL.chat.peer2peer.PeerPoolInfo;
import VASSAL.i18n.Resources;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeClientFactory
extends ChatServerFactory {
    private static final Logger logger = LoggerFactory.getLogger(NodeClientFactory.class);
    private static final String UNNAMED_MODULE = Resources.getString("Chat.unknown_module");
    private static final String UNKNOWN_USER = Resources.getString("Chat.unknown_user");
    public static final String NODE_TYPE = "node";
    public static final String NODE_HOST = "nodeHost";
    public static final String NODE_PORT = "nodePort";

    @Override
    public ChatServerConnection buildServer(Properties param) {
        final String host = param.getProperty(NODE_HOST, "game.vassalengine.org");
        final int port = Integer.parseInt(param.getProperty(NODE_PORT, "5050"));
        NodeServerInfo nodeServerInfo = new NodeServerInfo(){

            @Override
            public String getHostName() {
                return host;
            }

            @Override
            public int getPort() {
                return port;
            }
        };
        PeerPoolInfo publicInfo = new PeerPoolInfo(){

            @Override
            public String getModuleName() {
                return GameModule.getGameModule() == null ? UNNAMED_MODULE : GameModule.getGameModule().getGameName();
            }

            @Override
            public String getUserName() {
                return GameModule.getGameModule() == null ? UNKNOWN_USER : (String)GameModule.getGameModule().getPrefs().getValue("RealName");
            }
        };
        HttpMessageServer httpMessageServer = new HttpMessageServer(publicInfo);
        SocketNodeClient server = new SocketNodeClient(GameModule.getGameModule().getGameName(), GameModule.getUserId() + "." + System.currentTimeMillis(), GameModule.getGameModule(), nodeServerInfo, httpMessageServer, httpMessageServer);
        GameModule.getGameModule().getPrefs().getOption("RealName").fireUpdate();
        GameModule.getGameModule().getPrefs().getOption("Profile").fireUpdate();
        server.addPropertyChangeListener("Status", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                String mess = (String)evt.getNewValue();
                GameModule.getGameModule().warn(mess);
                logger.error("", (Object)mess);
            }
        });
        server.addPropertyChangeListener("Msg", new CommandDecoder());
        return server;
    }
}

