/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.command;

import VASSAL.build.GameModule;
import VASSAL.build.module.GlobalOptions;
import VASSAL.command.Command;
import VASSAL.counters.BoundsTracker;
import VASSAL.counters.GamePiece;
import VASSAL.counters.StateMergeable;

public class ChangePiece
extends Command {
    protected String newState;
    protected String oldState;
    private String id;
    private Command undo;

    public ChangePiece(String id, String oldState, String newState) {
        this.id = id;
        this.newState = newState;
        this.oldState = oldState;
    }

    @Deprecated
    public ChangePiece(String id, String newState) {
        this(id, null, newState);
    }

    @Override
    protected void executeCommand() {
        GamePiece target = GameModule.getGameModule().getGameState().getPieceForId(this.id);
        if (target != null) {
            BoundsTracker bounds = new BoundsTracker();
            bounds.addPiece(target);
            if (this.oldState != null) {
                if (target instanceof StateMergeable) {
                    ((StateMergeable)((Object)target)).mergeState(this.newState, this.oldState);
                } else {
                    target.setState(this.newState);
                }
            } else {
                this.oldState = target.getState();
                target.setState(this.newState);
            }
            bounds.addPiece(target);
            bounds.repaint();
            if (target.getMap() != null && GlobalOptions.getInstance().centerOnOpponentsMove() && !Boolean.TRUE.equals(target.getProperty("Invisible"))) {
                target.getMap().ensureVisible(target.getMap().selectionBoundsOf(target));
            }
        }
    }

    @Override
    public Command append(Command c) {
        Command last = this;
        Command[] sub = this.getSubCommands();
        if (sub.length > 0) {
            last = sub[sub.length - 1];
        }
        if (c instanceof ChangePiece && last instanceof ChangePiece && ((ChangePiece)c).id != null && ((ChangePiece)c).id.equals(last.id) && ((ChangePiece)c).newState != null) {
            last.newState = ((ChangePiece)c).newState;
            for (Command command : sub = c.getSubCommands()) {
                this.append(command);
            }
            return this;
        }
        return super.append(c);
    }

    @Override
    protected Command myUndoCommand() {
        if (this.undo == null && this.oldState != null) {
            this.undo = new ChangePiece(this.id, this.newState, this.oldState);
        }
        return this.undo;
    }

    public String getId() {
        return this.id;
    }

    public String getNewState() {
        return this.newState;
    }

    public String getOldState() {
        return this.oldState;
    }

    @Override
    public boolean isNull() {
        return this.newState.equals(this.oldState) && this.isAtomic();
    }

    @Override
    public String getDetails() {
        return "id=" + this.id + ",oldState=" + this.oldState + ",newState=" + this.newState;
    }
}

