/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.configure;

import VASSAL.build.AbstractBuildable;
import VASSAL.build.AbstractConfigurable;
import VASSAL.build.Buildable;
import VASSAL.build.GameModule;
import VASSAL.build.module.map.BoardPicker;
import VASSAL.build.module.map.boardPicker.Board;
import VASSAL.build.module.map.boardPicker.board.ZonedGrid;
import VASSAL.build.module.properties.GlobalProperties;
import VASSAL.build.module.properties.PropertyNameSource;
import VASSAL.configure.ConfigureTree;
import VASSAL.configure.StringConfigurer;
import VASSAL.counters.Decorator;
import VASSAL.counters.EditablePiece;
import VASSAL.counters.GamePiece;
import VASSAL.script.expression.FunctionBuilder;
import VASSAL.script.expression.IntBuilder;
import VASSAL.script.expression.StrBuilder;
import VASSAL.tools.icon.IconFactory;
import VASSAL.tools.menu.MenuScroller;
import bsh.BeanShellExpressionValidator;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.image.BufferedImage;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import net.miginfocom.swing.MigLayout;

public class BeanShellExpressionConfigurer
extends StringConfigurer {
    protected static int maxScrollItems = 0;
    protected static final int MAX_SCROLL_ITEMS = 40;
    protected JPanel expressionPanel;
    protected JPanel detailPanel;
    protected Validator validator;
    protected JButton extraDetails;
    protected Icon up;
    protected Icon down;
    protected StringConfigurer errorMessage;
    protected JLabel variables;
    protected JLabel methods;
    protected EditablePiece target;

    public BeanShellExpressionConfigurer(String key, String name) {
        this(key, name, "");
    }

    public BeanShellExpressionConfigurer(String key, String name, String val) {
        this(key, name, val, null);
    }

    public BeanShellExpressionConfigurer(String key, String name, String val, GamePiece piece) {
        super(key, name, val);
        this.target = piece instanceof EditablePiece ? (EditablePiece)piece : null;
        this.strip();
        this.up = IconFactory.getIcon("go-up", 0);
        this.down = IconFactory.getIcon("go-down", 0);
        this.extraDetails = new JButton("Insert");
        this.extraDetails.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BeanShellExpressionConfigurer.this.doPopup();
            }
        });
    }

    protected void strip() {
        String s = this.getValueString().trim();
        if (s.startsWith("{") && s.endsWith("}")) {
            this.setValue(s.substring(1, s.length() - 1));
        }
    }

    @Override
    public String getValueString() {
        return (String)this.value;
    }

    @Override
    public void setValue(String s) {
        if (!this.noUpdate && this.nameField != null) {
            this.nameField.setText(s);
        }
        this.setValue((Object)s);
    }

    @Override
    public Component getControls() {
        if (this.p == null) {
            this.expressionPanel = new JPanel((LayoutManager)new MigLayout("fillx,ins 0", "[][grow][][]"));
            this.expressionPanel.add(new JLabel(this.getName()));
            this.validator = new Validator();
            this.nameField = new JTextField(30);
            this.nameField.setText(this.getValueString());
            this.expressionPanel.add((Component)this.nameField, "growx");
            this.nameField.addKeyListener(new KeyAdapter(){

                @Override
                public void keyReleased(KeyEvent evt) {
                    BeanShellExpressionConfigurer.this.noUpdate = true;
                    BeanShellExpressionConfigurer.this.setValue(BeanShellExpressionConfigurer.this.nameField.getText());
                    BeanShellExpressionConfigurer.this.validator.validate();
                    BeanShellExpressionConfigurer.this.noUpdate = false;
                }
            });
            this.expressionPanel.add(this.validator);
            this.expressionPanel.add((Component)this.extraDetails, "wrap");
            this.validator.validate();
            this.detailPanel = new JPanel();
            this.detailPanel.setLayout(new BoxLayout(this.detailPanel, 1));
            this.errorMessage = new StringConfigurer(null, "Error Message:  ", "");
            this.errorMessage.getControls().setEnabled(false);
            this.variables = new JLabel("Vassal Properties:  ");
            this.methods = new JLabel("Methods:  ");
            this.detailPanel.add(this.errorMessage.getControls());
            this.detailPanel.add(this.variables);
            this.detailPanel.add(this.methods);
            this.detailPanel.setVisible(false);
            this.p = new JPanel();
            this.p.setLayout(new BoxLayout(this.p, 1));
            this.p.add(this.expressionPanel);
            this.p.add(this.detailPanel);
        }
        return this.p;
    }

    protected void doPopup() {
        JPopupMenu popup = this.createPopup();
        popup.show(this.extraDetails, 0, 0);
    }

    protected void toggleDetails() {
        this.extraDetails.setIcon(this.detailPanel.isVisible() ? this.down : this.up);
        this.detailPanel.setVisible(!this.detailPanel.isVisible());
        this.repack();
    }

    protected void repack() {
        Window w = SwingUtilities.getWindowAncestor(this.p);
        if (w != null) {
            w.pack();
        }
    }

    protected JPopupMenu createPopup() {
        JPopupMenu popup = new JPopupMenu();
        JMenu constantMenu = new JMenu("Constant");
        JMenuItem integerItem = new JMenuItem("Number");
        integerItem.setToolTipText("A number");
        integerItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BeanShellExpressionConfigurer.this.buildInteger();
            }
        });
        constantMenu.add(integerItem);
        JMenuItem stringItem = new JMenuItem("String");
        stringItem.setToolTipText("A character string");
        stringItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BeanShellExpressionConfigurer.this.buildString();
            }
        });
        constantMenu.add(stringItem);
        popup.add(constantMenu);
        JMenu propertyMenu = new JMenu("Property");
        if (this.target != null) {
            JMenu pieceMenu = new JMenu("Piece Property");
            this.addProp(pieceMenu, "Moved");
            this.addProp(pieceMenu, "Selected");
            this.addProp(pieceMenu, "PieceId");
            this.addPieceProps(pieceMenu, this.target);
            propertyMenu.add(pieceMenu);
        }
        JMenu globalsMenu = new JMenu("Global Property");
        this.buildGlobalMenu(globalsMenu, GameModule.getGameModule(), true);
        propertyMenu.add(globalsMenu);
        JMenu vassalMenu = new JMenu("Vassal Property");
        this.addProp(vassalMenu, "PlayerSide");
        this.addProp(vassalMenu, "PlayerName");
        this.addProp(vassalMenu, "PlayerId");
        propertyMenu.add(vassalMenu);
        popup.add(propertyMenu);
        JMenu operatorMenu = new JMenu("Operator");
        this.addOperator(operatorMenu, "+", "Add");
        this.addOperator(operatorMenu, "-", "Subtract");
        this.addOperator(operatorMenu, "*", "Multiply");
        this.addOperator(operatorMenu, "/", "Divide");
        this.addOperator(operatorMenu, "%", "Modulus");
        popup.add(operatorMenu);
        JMenu comparisonMenu = new JMenu("Comparison");
        this.addOperator(comparisonMenu, "==", "Equals");
        this.addOperator(comparisonMenu, "!=", "Not equals");
        this.addOperator(comparisonMenu, ">", "Greater than");
        this.addOperator(comparisonMenu, ">=", "Greater than or equal to");
        this.addOperator(comparisonMenu, "<", "Less than");
        this.addOperator(comparisonMenu, "<=", "Less than or equal to");
        this.addOperator(comparisonMenu, "=~", "Matches Regular Expression");
        this.addOperator(comparisonMenu, "!~", "Does not match Regular Expression");
        popup.add(comparisonMenu);
        JMenu logicalMenu = new JMenu("Logical");
        this.addOperator(logicalMenu, "&&", "And");
        this.addOperator(logicalMenu, "||", "Or");
        this.addOperator(logicalMenu, "(", "Left parenthesis");
        this.addOperator(logicalMenu, ")", "Right parenthesis");
        popup.add(logicalMenu);
        JMenu functionMenu = new JMenu("Function");
        this.addFunction(functionMenu, "Alert", "Display text in a Dialog box", new String[]{"Text to display"});
        this.addFunction(functionMenu, "Compare", "Compare two Strings or other objects", new String[]{"Object 1", "Object 2"});
        this.addFunction(functionMenu, "GetProperty", "Get a property by name", new String[]{"Property name"});
        this.addFunction(functionMenu, "If", "Return a different result depending on a logical expression", new String[]{"Logical expression", "Result if true", "Result if false"});
        this.addFunction(functionMenu, "SumStack", "Sum the values of the named property in all counters in the same stack", new String[]{"Property name"});
        popup.add(functionMenu);
        return popup;
    }

    protected void addFunction(JMenu menu, final String op, final String desc, final String[] parms) {
        JMenuItem item = new JMenuItem(op);
        item.setToolTipText(desc);
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BeanShellExpressionConfigurer.this.buildFunction(op, desc, parms);
            }
        });
        menu.add(item);
    }

    protected void buildFunction(String op, String desc, String[] parmDesc) {
        StringConfigurer result = new StringConfigurer(null, "", "");
        new FunctionBuilder(result, (JDialog)this.p.getTopLevelAncestor(), op, desc, parmDesc, this.target).setVisible(true);
        if (result.getValue() != null && result.getValueString().length() > 0) {
            this.insertName(result.getValueString());
        }
    }

    protected void buildInteger() {
        StringConfigurer result = new StringConfigurer(null, "", "");
        new IntBuilder(result, (JDialog)this.p.getTopLevelAncestor()).setVisible(true);
        if (result.getValue() != null && result.getValueString().length() > 0) {
            this.insertName(result.getValueString());
        }
    }

    protected void buildString() {
        StringConfigurer result = new StringConfigurer(null, "", "");
        new StrBuilder(result, (JDialog)this.p.getTopLevelAncestor()).setVisible(true);
        if (result.getValue() != null && result.getValueString().length() > 0) {
            this.insertName(result.getValueString());
        }
    }

    protected void addOperator(JMenu menu, final String op, String desc) {
        JMenuItem item = new JMenuItem(op);
        item.setToolTipText(desc);
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BeanShellExpressionConfigurer.this.insertName(op);
            }
        });
        menu.add(item);
    }

    protected void addProp(JMenu menu, String propName) {
        this.addProp(menu, propName, false);
    }

    protected void addProp(JMenu menu, final String propName, boolean sort) {
        if (propName == null) {
            return;
        }
        JMenuItem item = new JMenuItem(propName);
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BeanShellExpressionConfigurer.this.insertPropertyName(propName);
            }
        });
        if (sort) {
            int pos = -1;
            for (int i = 0; i < menu.getItemCount() && pos < 0; ++i) {
                if (propName.compareTo(menu.getItem(i).getText()) > 0) continue;
                pos = i;
            }
            menu.add((Component)item, pos);
        } else {
            menu.add(item);
        }
    }

    protected void addPieceProps(JMenu menu, EditablePiece piece) {
        if (piece == null) {
            return;
        }
        JMenu pieceMenu = null;
        if (piece instanceof PropertyNameSource) {
            List<String> propNames = ((PropertyNameSource)((Object)piece)).getPropertyNames();
            for (String propName : propNames) {
                if (pieceMenu == null) {
                    pieceMenu = new JMenu();
                    pieceMenu.setText(piece.getDescription());
                }
                JMenuItem item = new JMenuItem(propName);
                item.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        BeanShellExpressionConfigurer.this.insertPropertyName(((JMenuItem)e.getSource()).getText());
                    }
                });
                pieceMenu.add(item);
            }
            if (pieceMenu != null) {
                menu.add(pieceMenu);
            }
            if (piece instanceof Decorator) {
                this.addPieceProps(menu, (EditablePiece)((Decorator)((Object)piece)).getInner());
            }
        }
    }

    protected void buildGlobalMenu(JMenu parentMenu, AbstractBuildable target, boolean useParentMenu) {
        String n;
        List<Buildable> buildables = target.getBuildables();
        Object menuName = ConfigureTree.getConfigureName(target.getClass());
        if (target instanceof AbstractConfigurable && (n = ((AbstractConfigurable)target).getConfigureName()) != null && n.length() > 0) {
            menuName = (String)menuName + " " + n;
        }
        JMenu myMenu = new JMenu((String)menuName);
        List<String> propNames = target.getPropertyNames();
        for (String propName : propNames) {
            this.addProp(useParentMenu ? parentMenu : myMenu, propName, true);
        }
        for (Buildable b : buildables) {
            if (b instanceof AbstractConfigurable) {
                boolean useParent = b instanceof GlobalProperties || b instanceof Board || b instanceof ZonedGrid;
                this.buildGlobalMenu(useParentMenu ? parentMenu : myMenu, (AbstractConfigurable)b, useParent);
                continue;
            }
            if (!(b instanceof BoardPicker)) continue;
            this.buildGlobalMenu(myMenu, (AbstractBuildable)b, true);
        }
        if (!useParentMenu & myMenu.getItemCount() > 0) {
            MenuScroller.setScrollerFor(myMenu, this.getMaxScrollItems(), 100);
            int pos = -1;
            for (int i = 0; i < parentMenu.getItemCount() && pos < 0; ++i) {
                if (myMenu.getText().compareTo(parentMenu.getItem(i).getText()) > 0) continue;
                pos = i;
            }
            parentMenu.add((Component)myMenu, pos);
        }
    }

    protected int getMaxScrollItems() {
        if (maxScrollItems == 0) {
            Dimension itemSize = new JMenuItem("Testing").getPreferredSize();
            maxScrollItems = (int)(0.8 * (double)Toolkit.getDefaultToolkit().getScreenSize().height / (double)itemSize.height);
        }
        return maxScrollItems;
    }

    protected void insertPropertyName(String name) {
        this.insertName(this.cleanName(name));
    }

    protected void insertName(String name) {
        Object work = this.nameField.getText();
        int pos = this.nameField.getCaretPosition();
        if (this.nameField.getSelectedText() != null) {
            int start = this.nameField.getSelectionStart();
            int end = this.nameField.getSelectionEnd();
            work = ((String)work).substring(0, start) + ((String)work).substring(end);
            if (pos >= start && pos <= end) {
                pos = start;
            }
        }
        String news = ((String)work).substring(0, pos) + name + ((String)work).substring(pos);
        this.nameField.setText(news);
        this.nameField.setCaretPosition(pos + name.length());
        this.noUpdate = true;
        this.setValue(this.nameField.getText());
        this.validator.validate();
        this.noUpdate = false;
        this.nameField.repaint();
        this.nameField.requestFocusInWindow();
    }

    protected String cleanName(String name) {
        boolean valid = true;
        for (int i = 0; i < name.length() && valid; ++i) {
            char c = name.charAt(i);
            valid = i == 0 ? Character.isJavaIdentifierStart(c) : Character.isJavaIdentifierPart(c);
        }
        return valid ? name : "GetProperty(\"" + name + "\")";
    }

    protected void setDetails(String error, List<String> v, List<String> m) {
        this.errorMessage.setValue(error);
        String s = "Vassal Properties:  " + (v == null ? "" : v.toString());
        this.variables.setText(s);
        s = "Methods:  " + (m == null ? "" : m.toString());
        this.methods.setText(s);
    }

    protected void setDetails() {
        this.setDetails("", null, null);
    }

    class Validator
    extends JLabel {
        protected static final int INVALID = 0;
        protected static final int VALID = 1;
        protected static final int UNKNOWN = 2;
        protected Icon tick;
        protected Icon cross;
        protected ImageIcon none;
        protected int status = 2;
        protected boolean validating = false;
        protected boolean dirty = false;
        protected ValidationThread validationThread = new ValidationThread();
        private static final long serialVersionUID = 1L;

        public Validator() {
            this.cross = IconFactory.getIcon("no", 0);
            this.tick = IconFactory.getIcon("yes", 0);
            BufferedImage image = new BufferedImage(this.cross.getIconWidth(), this.cross.getIconHeight(), 2);
            this.none = new ImageIcon(image);
            this.setStatus(2);
        }

        public void setStatus(int status) {
            if (status == 1) {
                this.setIcon(this.tick);
            } else if (status == 0) {
                this.setIcon(this.cross);
            } else {
                this.setIcon(this.none);
            }
            this.status = status;
        }

        public int getStatus() {
            return this.status;
        }

        @Override
        public void validate() {
            if (this.validating) {
                this.dirty = true;
            } else {
                this.validating = true;
                BeanShellExpressionConfigurer.this.validator.setStatus(2);
                SwingUtilities.invokeLater(this.validationThread);
            }
        }

        class ValidationThread
        implements Runnable {
            ValidationThread() {
            }

            @Override
            public void run() {
                if (BeanShellExpressionConfigurer.this.getValueString().length() == 0) {
                    BeanShellExpressionConfigurer.this.validator.setStatus(2);
                    BeanShellExpressionConfigurer.this.setDetails();
                } else {
                    BeanShellExpressionValidator v = new BeanShellExpressionValidator(BeanShellExpressionConfigurer.this.getValueString());
                    if (v.isValid()) {
                        BeanShellExpressionConfigurer.this.validator.setStatus(1);
                        BeanShellExpressionConfigurer.this.setDetails(v.getError(), v.getVariables(), v.getMethods());
                    } else {
                        BeanShellExpressionConfigurer.this.validator.setStatus(0);
                        BeanShellExpressionConfigurer.this.setDetails(v.getError(), v.getVariables(), v.getMethods());
                    }
                }
                Validator.this.validating = false;
                if (Validator.this.dirty) {
                    Validator.this.dirty = false;
                    Validator.this.validate();
                }
            }
        }
    }
}

