/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.configure;

import VASSAL.build.GameModule;
import VASSAL.configure.ValidationReport;
import VASSAL.tools.ScrollPane;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;

public class ValidationReportDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private CallBack callback;

    public ValidationReportDialog(ValidationReport report, CallBack cb) {
        super((Frame)GameModule.getGameModule().getFrame(), false);
        this.setTitle("Problems found in module");
        this.callback = cb;
        Box reportBox = Box.createVerticalBox();
        this.add(reportBox);
        JPanel buttonPanel = new JPanel();
        this.add((Component)buttonPanel, "South");
        List<String> warnings = report.getWarnings();
        switch (warnings.size()) {
            case 0: {
                reportBox.add(new JLabel("No problems found"));
                buttonPanel.add(this.createOkButton());
                break;
            }
            case 1: {
                reportBox.add(new JLabel("A problem was found in this module."));
                reportBox.add(new JLabel(warnings.get(0) + "."));
                buttonPanel.add(this.createOkButton());
                buttonPanel.add(this.createCancelButton());
                break;
            }
            default: {
                reportBox.add(new JLabel("The following problems were found in this module."));
                reportBox.add(new JLabel("If not fixed, they could cause bugs during game play."));
                JList<String> list = new JList<String>(warnings.toArray(new String[0]));
                list.setVisibleRowCount(Math.min(list.getVisibleRowCount(), warnings.size()));
                reportBox.add(new ScrollPane(list));
                buttonPanel.add(this.createOkButton());
                buttonPanel.add(this.createCancelButton());
            }
        }
        this.pack();
        this.setLocationRelativeTo(null);
    }

    private JButton createCancelButton() {
        JButton cancel = new JButton("Cancel");
        cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ValidationReportDialog.this.callback.cancel();
                ValidationReportDialog.this.dispose();
            }
        });
        return cancel;
    }

    private JButton createOkButton() {
        JButton ok = new JButton("Ignore, save anyway");
        ok.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ValidationReportDialog.this.callback.ok();
                ValidationReportDialog.this.dispose();
            }
        });
        return ok;
    }

    public static interface CallBack {
        public void ok();

        public void cancel();
    }
}

