/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.counters;

import VASSAL.build.BadDataReport;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.command.Command;
import VASSAL.configure.BeanShellExpressionConfigurer;
import VASSAL.configure.StringConfigurer;
import VASSAL.counters.Decorator;
import VASSAL.counters.EditablePiece;
import VASSAL.counters.GamePiece;
import VASSAL.counters.KeyCommand;
import VASSAL.counters.PieceEditor;
import VASSAL.i18n.Resources;
import VASSAL.script.expression.BeanShellExpression;
import VASSAL.script.expression.Expression;
import VASSAL.script.expression.ExpressionException;
import VASSAL.tools.ErrorDialog;
import VASSAL.tools.RecursionLimitException;
import VASSAL.tools.RecursionLimiter;
import VASSAL.tools.SequenceEncoder;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.KeyStroke;

public class CalculatedProperty
extends Decorator
implements EditablePiece,
RecursionLimiter.Loopable {
    public static final String ID = "calcProp;";
    protected static int counter = 0;
    protected String name = "";
    protected Expression expression;

    public CalculatedProperty() {
        this(ID, null);
    }

    public CalculatedProperty(String type, GamePiece inner) {
        this.mySetType(type);
        this.setInner(inner);
    }

    @Override
    public Rectangle boundingBox() {
        return this.piece.boundingBox();
    }

    @Override
    public void draw(Graphics g, int x, int y, Component obs, double zoom) {
        this.piece.draw(g, x, y, obs, zoom);
    }

    @Override
    public String getName() {
        return this.piece.getName();
    }

    @Override
    protected KeyCommand[] myGetKeyCommands() {
        return new KeyCommand[0];
    }

    @Override
    public String myGetState() {
        return "";
    }

    @Override
    public String myGetType() {
        SequenceEncoder se = new SequenceEncoder(';');
        se.append(this.name).append(this.getExpression());
        return ID + se.getValue();
    }

    @Override
    public Command myKeyEvent(KeyStroke stroke) {
        return null;
    }

    @Override
    public void mySetState(String newState) {
    }

    @Override
    public Shape getShape() {
        return this.piece.getShape();
    }

    @Override
    public String getDescription() {
        Object desc = "Calculated Property";
        if (this.name != null && this.name.length() > 0) {
            desc = (String)desc + " - " + this.name;
        }
        return desc;
    }

    @Override
    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("CalculatedProperty.htm");
    }

    @Override
    public void mySetType(String type) {
        SequenceEncoder.Decoder st = new SequenceEncoder.Decoder(type, ';');
        st.nextToken();
        this.name = st.nextToken("");
        this.expression = BeanShellExpression.createExpression(st.nextToken(""));
    }

    protected String getExpression() {
        return this.expression.getExpression();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getProperty(Object key) {
        String result = "";
        if (this.name.length() > 0 && this.name.equals(key)) {
            try {
                RecursionLimiter.startExecution(this);
                String string = result = this.evaluate();
                return string;
            }
            catch (RecursionLimitException e) {
                RecursionLimiter.infiniteLoop(e);
            }
            finally {
                RecursionLimiter.endExecution();
            }
            return result;
        }
        return super.getProperty(key);
    }

    @Override
    public Object getLocalizedProperty(Object key) {
        if (this.name.length() > 0 && this.name.equals(key)) {
            return this.getProperty(key);
        }
        return super.getLocalizedProperty(key);
    }

    protected String evaluate() {
        try {
            return this.expression.evaluate(Decorator.getOutermost(this));
        }
        catch (ExpressionException e) {
            ErrorDialog.dataError(new BadDataReport(Resources.getString("Error.expression_error"), this.piece.getProperty("BasicName") + "-Calculated Property[" + this.name + "]=" + this.getExpression() + ", Error=" + e.getError(), e));
            return "";
        }
    }

    @Override
    public PieceEditor getEditor() {
        return new Ed(this);
    }

    @Override
    public String getComponentName() {
        return this.piece.getName();
    }

    @Override
    public String getComponentTypeName() {
        return this.getDescription();
    }

    @Override
    public List<String> getPropertyNames() {
        ArrayList<String> l = new ArrayList<String>();
        l.add(this.name);
        return l;
    }

    public static class Ed
    implements PieceEditor {
        protected StringConfigurer nameConfig;
        protected BeanShellExpressionConfigurer expressionConfig;
        protected StringConfigurer defaultValueConfig;
        protected JPanel box = new JPanel();

        public Ed(CalculatedProperty piece) {
            this.box.setLayout(new BoxLayout(this.box, 1));
            this.nameConfig = new StringConfigurer(null, "Property Name:  ", piece.name);
            this.box.add(this.nameConfig.getControls());
            this.expressionConfig = new BeanShellExpressionConfigurer(null, "Expression:  ", piece.getExpression(), Decorator.getOutermost(piece));
            this.box.add(this.expressionConfig.getControls());
        }

        @Override
        public Component getControls() {
            return this.box;
        }

        @Override
        public String getState() {
            return "";
        }

        @Override
        public String getType() {
            SequenceEncoder se = new SequenceEncoder(';');
            se.append(this.nameConfig.getValueString()).append(this.expressionConfig.getValueString());
            return CalculatedProperty.ID + se.getValue();
        }
    }
}

