/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.counters;

import VASSAL.build.GameModule;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.command.ChangeTracker;
import VASSAL.command.Command;
import VASSAL.configure.BooleanConfigurer;
import VASSAL.configure.FormattedExpressionConfigurer;
import VASSAL.configure.IntConfigurer;
import VASSAL.configure.NamedHotKeyConfigurer;
import VASSAL.configure.PropertyNameExpressionConfigurer;
import VASSAL.configure.StringConfigurer;
import VASSAL.counters.Decorator;
import VASSAL.counters.GamePiece;
import VASSAL.counters.KeyCommand;
import VASSAL.counters.MultiImagePicker;
import VASSAL.counters.PieceEditor;
import VASSAL.i18n.PieceI18nData;
import VASSAL.i18n.Resources;
import VASSAL.i18n.TranslatablePiece;
import VASSAL.script.expression.Expression;
import VASSAL.script.expression.ExpressionException;
import VASSAL.tools.FormattedString;
import VASSAL.tools.NamedKeyStroke;
import VASSAL.tools.SequenceEncoder;
import VASSAL.tools.icon.IconFactory;
import VASSAL.tools.image.ImageUtils;
import VASSAL.tools.imageop.ScaledImagePainter;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.geom.Area;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import net.miginfocom.swing.MigLayout;

public class Embellishment
extends Decorator
implements TranslatablePiece {
    public static final String OLD_ID = "emb;";
    public static final String ID = "emb2;";
    public static final String IMAGE = "_Image";
    public static final String NAME = "_Name";
    public static final String LEVEL = "_Level";
    public static final String ACTIVE = "_Active";
    protected String activateKey = "";
    protected String upKey;
    protected String downKey;
    protected int activateModifiers;
    protected int upModifiers;
    protected int downModifiers;
    protected String upCommand;
    protected String downCommand;
    protected String activateCommand;
    protected String resetCommand;
    protected FormattedString resetLevel = new FormattedString("1");
    protected boolean loopLevels;
    protected NamedKeyStroke resetKey;
    protected boolean followProperty;
    protected String propertyName = "";
    protected Expression followPropertyExpression;
    protected int firstLevelValue;
    protected NamedKeyStroke rndKey;
    private String rndText = "";
    protected int value = -1;
    protected int nValues;
    protected int xOff;
    protected int yOff;
    protected String[] imageName;
    protected String[] commonName;
    protected Rectangle[] size;
    protected ScaledImagePainter[] imagePainter;
    protected boolean drawUnderneathWhenSelected = false;
    protected String name = "";
    protected KeyCommand[] commands;
    protected KeyCommand up = null;
    protected KeyCommand down = null;
    protected Rectangle lastBounds = null;
    protected Area lastShape = null;
    public static final int BASE_VERSION = 0;
    public static final int CURRENT_VERSION = 1;
    protected int version;
    protected boolean alwaysActive;
    protected NamedKeyStroke activateKeyStroke;
    protected NamedKeyStroke increaseKeyStroke;
    protected NamedKeyStroke decreaseKeyStroke;

    public Embellishment() {
        this("emb2;Activate", null);
    }

    public Embellishment(String type, GamePiece d) {
        this.mySetType(type);
        this.setInner(d);
    }

    public boolean isActive() {
        return this.value > 0;
    }

    public void setActive(boolean val) {
        this.value = val ? Math.abs(this.value) : -Math.abs(this.value);
    }

    public int getValue() {
        return Math.abs(this.value) - 1;
    }

    public void setValue(int val) {
        int theVal = val;
        if (val >= this.nValues) {
            Embellishment.reportDataError(this, Resources.getString("Error.bad_layer"), "Layer=" + val);
            theVal = this.nValues;
        }
        this.value = this.value > 0 ? theVal + 1 : -theVal - 1;
    }

    @Override
    public void mySetType(String s) {
        if (!s.startsWith(ID)) {
            this.originalSetType(s);
        } else {
            s = s.substring(ID.length());
            SequenceEncoder.Decoder st = new SequenceEncoder.Decoder(s, ';');
            this.activateCommand = st.nextToken("");
            this.activateModifiers = st.nextInt(128);
            this.activateKey = st.nextToken("A");
            this.upCommand = st.nextToken("");
            this.upModifiers = st.nextInt(128);
            this.upKey = st.nextToken("");
            this.downCommand = st.nextToken("");
            this.downModifiers = st.nextInt(128);
            this.downKey = st.nextToken("");
            this.resetCommand = st.nextToken("");
            this.resetKey = st.nextNamedKeyStroke();
            this.resetLevel = new FormattedString(st.nextToken("1"));
            this.drawUnderneathWhenSelected = st.nextBoolean(false);
            this.xOff = st.nextInt(0);
            this.yOff = st.nextInt(0);
            this.imageName = st.nextStringArray(0);
            this.commonName = st.nextStringArray(this.imageName.length);
            this.loopLevels = st.nextBoolean(true);
            this.name = st.nextToken("");
            this.rndKey = st.nextNamedKeyStroke(null);
            this.rndText = st.nextToken("");
            this.followProperty = st.nextBoolean(false);
            this.propertyName = st.nextToken("");
            this.firstLevelValue = st.nextInt(1);
            this.version = st.nextInt(0);
            this.alwaysActive = st.nextBoolean(false);
            this.activateKeyStroke = st.nextNamedKeyStroke();
            this.increaseKeyStroke = st.nextNamedKeyStroke();
            this.decreaseKeyStroke = st.nextNamedKeyStroke();
            if (this.version == 0) {
                boolean bl = this.alwaysActive = this.activateKey.length() == 0;
                if (this.activateKey.length() <= 1 && this.upKey.length() <= 1 && this.downKey.length() <= 1) {
                    this.activateKeyStroke = this.activateKey.length() == 0 ? NamedKeyStroke.NULL_KEYSTROKE : new NamedKeyStroke(this.activateKey.charAt(0), this.activateModifiers);
                    this.increaseKeyStroke = this.upKey.length() == 0 ? NamedKeyStroke.NULL_KEYSTROKE : new NamedKeyStroke(this.upKey.charAt(0), this.upModifiers);
                    this.decreaseKeyStroke = this.downKey.length() == 0 ? NamedKeyStroke.NULL_KEYSTROKE : new NamedKeyStroke(this.downKey.charAt(0), this.downModifiers);
                    this.version = 1;
                }
            }
            this.value = this.activateKey.length() > 0 ? -1 : 1;
            this.nValues = this.imageName.length;
            this.size = new Rectangle[this.imageName.length];
            this.imagePainter = new ScaledImagePainter[this.imageName.length];
            for (int i = 0; i < this.imageName.length; ++i) {
                this.imagePainter[i] = new ScaledImagePainter();
                this.imagePainter[i].setImageName(this.imageName[i]);
            }
        }
        this.commands = null;
    }

    private void originalSetType(String s) {
        SequenceEncoder.Decoder st = new SequenceEncoder.Decoder(s, ';');
        st.nextToken();
        SequenceEncoder.Decoder st2 = new SequenceEncoder.Decoder(st.nextToken(), ';');
        this.activateKey = st2.nextToken().toUpperCase();
        if (this.activateKey.length() > 0) {
            this.activateKeyStroke = new NamedKeyStroke(KeyStroke.getKeyStroke(this.activateKey));
        }
        this.activateModifiers = 128;
        if (st2.hasMoreTokens()) {
            this.resetCommand = st2.nextToken();
            this.resetKey = st2.nextNamedKeyStroke(null);
            this.resetLevel.setFormat(st2.nextToken("0"));
        } else {
            this.resetKey = null;
            this.resetCommand = "";
            this.resetLevel.setFormat("0");
        }
        this.activateCommand = st.nextToken();
        this.drawUnderneathWhenSelected = this.activateCommand.startsWith("_");
        if (this.drawUnderneathWhenSelected) {
            this.activateCommand = this.activateCommand.substring(1);
        }
        this.value = this.activateKey.length() > 0 ? -1 : 1;
        this.upKey = st.nextToken().toUpperCase();
        this.upCommand = st.nextToken();
        this.upModifiers = 128;
        this.downKey = st.nextToken().toUpperCase();
        this.downCommand = st.nextToken();
        this.downModifiers = 128;
        this.xOff = st.nextInt(0);
        this.yOff = st.nextInt(0);
        ArrayList<String> l = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            l.add(st.nextToken());
        }
        this.nValues = l.size();
        this.imageName = new String[l.size()];
        this.commonName = new String[l.size()];
        this.size = new Rectangle[this.imageName.length];
        this.imagePainter = new ScaledImagePainter[this.imageName.length];
        for (int i = 0; i < this.imageName.length; ++i) {
            String sub = (String)l.get(i);
            SequenceEncoder.Decoder subSt = new SequenceEncoder.Decoder(sub, ',');
            this.imageName[i] = subSt.nextToken();
            this.imagePainter[i] = new ScaledImagePainter();
            this.imagePainter[i].setImageName(this.imageName[i]);
            if (!subSt.hasMoreTokens()) continue;
            this.commonName[i] = subSt.nextToken();
        }
        this.loopLevels = true;
        this.alwaysActive = this.activateKey.length() == 0;
        this.activateKeyStroke = this.activateKey.length() == 0 ? NamedKeyStroke.NULL_KEYSTROKE : new NamedKeyStroke(this.activateKey.charAt(0), this.activateModifiers);
        this.increaseKeyStroke = this.upKey.length() == 0 ? NamedKeyStroke.NULL_KEYSTROKE : new NamedKeyStroke(this.upKey.charAt(0), this.upModifiers);
        this.decreaseKeyStroke = this.downKey.length() == 0 ? NamedKeyStroke.NULL_KEYSTROKE : new NamedKeyStroke(this.downKey.charAt(0), this.downModifiers);
        this.version = 1;
    }

    @Override
    public String getLocalizedName() {
        return this.getName(true);
    }

    @Override
    public String getName() {
        return this.getName(false);
    }

    public String getName(boolean localized) {
        Object name;
        String cname;
        this.checkPropertyLevel();
        String string = cname = 0 < this.value && this.value - 1 < this.commonName.length ? this.getCommonName(localized, this.value - 1) : null;
        if (cname != null && cname.length() > 0) {
            SequenceEncoder.Decoder st = new SequenceEncoder.Decoder(cname, '+');
            String first = st.nextToken();
            if (st.hasMoreTokens()) {
                String second = st.nextToken();
                name = first.length() == 0 ? (localized ? this.piece.getLocalizedName() : this.piece.getName()) + second : first + (localized ? this.piece.getLocalizedName() : this.piece.getName());
            } else {
                name = first;
            }
        } else {
            name = localized ? this.piece.getLocalizedName() : this.piece.getName();
        }
        return name;
    }

    public String getLayerName() {
        return this.name == null ? "" : this.name;
    }

    @Override
    public void mySetState(String s) {
        SequenceEncoder.Decoder st = new SequenceEncoder.Decoder(s, ';');
        this.value = st.nextInt(-1);
    }

    @Override
    public String myGetType() {
        SequenceEncoder se = new SequenceEncoder(';');
        se.append(this.activateCommand).append(this.activateModifiers).append(this.activateKey).append(this.upCommand).append(this.upModifiers).append(this.upKey).append(this.downCommand).append(this.downModifiers).append(this.downKey).append(this.resetCommand).append(this.resetKey).append(this.resetLevel.getFormat()).append(this.drawUnderneathWhenSelected).append(this.xOff).append(this.yOff).append(this.imageName).append(this.commonName).append(this.loopLevels).append(this.name).append(this.rndKey).append(this.rndText).append(this.followProperty).append(this.propertyName).append(this.firstLevelValue).append(this.version).append(this.alwaysActive).append(this.activateKeyStroke).append(this.increaseKeyStroke).append(this.decreaseKeyStroke);
        return ID + se.getValue();
    }

    @Deprecated
    public String oldGetType() {
        SequenceEncoder se = new SequenceEncoder(';');
        SequenceEncoder se2 = new SequenceEncoder(this.activateKey, ';');
        se2.append(this.resetCommand).append(this.resetKey).append(String.valueOf(this.resetLevel));
        se.append(se2.getValue()).append((String)(this.drawUnderneathWhenSelected ? "_" + this.activateCommand : this.activateCommand)).append(this.upKey).append(this.upCommand).append(this.downKey).append(this.downCommand).append(this.xOff).append(this.yOff);
        for (int i = 0; i < this.nValues; ++i) {
            if (this.commonName[i] != null) {
                SequenceEncoder sub = new SequenceEncoder(this.imageName[i], ',');
                se.append(sub.append(this.commonName[i]).getValue());
                continue;
            }
            se.append(this.imageName[i]);
        }
        return ID + se.getValue();
    }

    @Override
    public String myGetState() {
        SequenceEncoder se = new SequenceEncoder(';');
        return se.append(String.valueOf(this.value)).getValue();
    }

    @Override
    public void draw(Graphics g, int x, int y, Component obs, double zoom) {
        boolean drawUnder;
        boolean bl = drawUnder = this.drawUnderneathWhenSelected && Boolean.TRUE.equals(this.getProperty("Selected"));
        if (!drawUnder) {
            this.piece.draw(g, x, y, obs, zoom);
        }
        this.checkPropertyLevel();
        if (!this.isActive()) {
            if (drawUnder) {
                this.piece.draw(g, x, y, obs, zoom);
            }
            return;
        }
        int i = this.value - 1;
        if (i < this.imagePainter.length && this.imagePainter[i] != null) {
            Rectangle r = this.getCurrentImageBounds();
            this.imagePainter[i].draw(g, x + (int)(zoom * (double)r.x), y + (int)(zoom * (double)r.y), zoom, obs);
        }
        if (drawUnder) {
            this.piece.draw(g, x, y, obs, zoom);
        }
    }

    protected void checkPropertyLevel() {
        if (!this.followProperty || this.propertyName.length() == 0) {
            return;
        }
        if (this.followPropertyExpression == null) {
            this.followPropertyExpression = Expression.createSimplePropertyExpression(this.propertyName);
        }
        String val = "";
        try {
            int v;
            val = this.followPropertyExpression.evaluate(Decorator.getOutermost(this));
            if (val == null || val.length() == 0) {
                val = String.valueOf(this.firstLevelValue);
            }
            if ((v = Integer.parseInt(val) - this.firstLevelValue + 1) <= 0) {
                v = 1;
            }
            if (v > this.nValues) {
                v = this.nValues;
            }
            this.value = this.isActive() ? v : -v;
        }
        catch (NumberFormatException e) {
            Embellishment.reportDataError(this, Resources.getString("Error.non_number_error"), "followProperty[" + this.propertyName + "]=" + val, e);
        }
        catch (ExpressionException e) {
            Embellishment.reportDataError(this, Resources.getString("Error.expression_error"), "followProperty[" + this.propertyName + "]", e);
        }
    }

    @Override
    public KeyCommand[] myGetKeyCommands() {
        if (this.commands == null) {
            ArrayList<KeyCommand> l = new ArrayList<KeyCommand>();
            GamePiece outer = Decorator.getOutermost(this);
            if (this.activateCommand != null && this.activateCommand.length() > 0 && !this.alwaysActive) {
                KeyCommand k = new KeyCommand(this.activateCommand, this.activateKeyStroke, outer, (TranslatablePiece)this);
                k.setEnabled(this.nValues > 0);
                l.add(k);
            }
            if (!this.followProperty) {
                if (this.nValues > 1) {
                    if (this.upCommand != null && this.upCommand.length() > 0 && this.increaseKeyStroke != null && !this.increaseKeyStroke.isNull()) {
                        this.up = new KeyCommand(this.upCommand, this.increaseKeyStroke, outer, (TranslatablePiece)this);
                        l.add(this.up);
                    }
                    if (this.downCommand != null && this.downCommand.length() > 0 && this.decreaseKeyStroke != null && !this.decreaseKeyStroke.isNull()) {
                        this.down = new KeyCommand(this.downCommand, this.decreaseKeyStroke, outer, (TranslatablePiece)this);
                        l.add(this.down);
                    }
                }
                if (this.resetKey != null && !this.resetKey.isNull() && this.resetCommand.length() > 0) {
                    l.add(new KeyCommand(this.resetCommand, this.resetKey, outer, (TranslatablePiece)this));
                }
                if (this.rndKey != null && !this.rndKey.isNull() && this.rndText.length() > 0) {
                    l.add(new KeyCommand(this.rndText, this.rndKey, outer, (TranslatablePiece)this));
                }
            }
            this.commands = l.toArray(new KeyCommand[0]);
        }
        if (this.up != null) {
            this.up.setEnabled(this.loopLevels || Math.abs(this.value) < this.imageName.length);
        }
        if (this.down != null) {
            this.down.setEnabled(this.loopLevels || Math.abs(this.value) > 1);
        }
        return this.commands;
    }

    @Override
    public Command myKeyEvent(KeyStroke stroke) {
        ChangeTracker tracker = new ChangeTracker(this);
        if (this.activateKeyStroke.equals(stroke) && this.nValues > 0 && !this.alwaysActive) {
            this.value = -this.value;
        }
        if (!this.followProperty) {
            if (this.increaseKeyStroke.equals(stroke)) {
                this.doIncrease();
            }
            if (this.decreaseKeyStroke.equals(stroke)) {
                this.doDecrease();
            }
            if (this.resetKey != null && this.resetKey.equals(stroke)) {
                GamePiece outer = Decorator.getOutermost(this);
                String levelText = this.resetLevel.getText(outer);
                try {
                    int level = Integer.parseInt(levelText);
                    this.setValue(Math.abs(level) - 1);
                    this.setActive(level > 0);
                }
                catch (NumberFormatException e) {
                    Embellishment.reportDataError(this, Resources.getString("Error.non_number_error"), this.resetLevel.debugInfo(levelText, "resetLevel"), e);
                }
            }
            if (this.rndKey != null && this.rndKey.equals(stroke)) {
                int val = GameModule.getGameModule().getRNG().nextInt(this.nValues) + 1;
                this.value = this.value > 0 ? val : -val;
            }
        }
        return tracker.isChanged() ? tracker.getChangeCommand() : null;
    }

    protected void doIncrease() {
        int val = Math.abs(this.value);
        if (++val > this.nValues) {
            val = this.loopLevels ? 1 : this.nValues;
        }
        this.value = this.value > 0 ? val : -val;
    }

    protected void doDecrease() {
        int val = Math.abs(this.value);
        if (--val < 1) {
            val = this.loopLevels ? this.nValues : 1;
        }
        this.value = this.value > 0 ? val : -val;
    }

    @Deprecated
    protected Image getCurrentImage() throws IOException {
        if (this.value <= 0 || this.imageName[this.value - 1] == null || this.imageName[this.value - 1].length() == 0 || this.imagePainter[this.value - 1] == null || this.imagePainter[this.value - 1].getSource() == null) {
            return null;
        }
        return this.imagePainter[this.value - 1].getSource().getImage();
    }

    @Override
    public Rectangle boundingBox() {
        Rectangle r = this.piece.boundingBox();
        if (this.value > 0) {
            r.add(this.getCurrentImageBounds());
        }
        return r;
    }

    public Rectangle getCurrentImageBounds() {
        if (this.value > 0) {
            int i = this.value - 1;
            if (i >= this.size.length) {
                return new Rectangle();
            }
            if (this.size[i] == null) {
                if (this.imagePainter[i] != null) {
                    this.size[i] = ImageUtils.getBounds(this.imagePainter[i].getImageSize());
                    this.size[i].translate(this.xOff, this.yOff);
                } else {
                    this.size[i] = new Rectangle();
                }
            }
            return this.size[i];
        }
        return new Rectangle();
    }

    @Override
    public Shape getShape() {
        Shape innerShape = this.piece.getShape();
        if (this.value > 0 && !this.drawUnderneathWhenSelected) {
            Rectangle r = this.getCurrentImageBounds();
            if (innerShape.contains(r.x, r.y, r.width, r.height)) {
                return innerShape;
            }
            Area a = new Area(innerShape);
            if (!r.equals(this.lastBounds)) {
                this.lastShape = new Area(r);
                this.lastBounds = new Rectangle(r);
            }
            a.add(this.lastShape);
            return a;
        }
        return innerShape;
    }

    @Override
    public String getDescription() {
        String displayName = this.name;
        if ((this.name == null || this.name.length() == 0) && this.imageName.length > 0 && this.imageName[0] != null && this.imageName[0].length() > 0) {
            displayName = this.imageName[0];
        }
        if (displayName == null || displayName.length() == 0) {
            return "Layer";
        }
        return "Layer - " + displayName;
    }

    @Override
    public Object getProperty(Object key) {
        if (key.equals(this.name + IMAGE)) {
            this.checkPropertyLevel();
            if (this.value > 0) {
                return this.imageName[Math.abs(this.value) - 1];
            }
            return "";
        }
        if (key.equals(this.name + NAME)) {
            this.checkPropertyLevel();
            if (this.value > 0) {
                return this.strip(this.commonName[Math.abs(this.value) - 1]);
            }
            return "";
        }
        if (key.equals(this.name + LEVEL)) {
            this.checkPropertyLevel();
            return String.valueOf(this.value);
        }
        if (key.equals(this.name + ACTIVE)) {
            return String.valueOf(this.isActive());
        }
        if (key.equals("visibleState")) {
            this.checkPropertyLevel();
            Object s = String.valueOf(super.getProperty(key));
            s = (String)s + this.value;
            if (this.drawUnderneathWhenSelected) {
                s = (String)s + this.getProperty("Selected");
            }
            return s;
        }
        return super.getProperty(key);
    }

    @Override
    public Object getLocalizedProperty(Object key) {
        if (key.equals(this.name + IMAGE) || key.equals(this.name + LEVEL) || key.equals(this.name + ACTIVE) || key.equals("visibleState")) {
            return this.getProperty(key);
        }
        if (key.equals(this.name + NAME)) {
            this.checkPropertyLevel();
            if (this.value > 0) {
                return this.strip(this.getLocalizedCommonName(Math.abs(this.value) - 1));
            }
            return "";
        }
        return super.getLocalizedProperty(key);
    }

    protected String strip(String s) {
        if (s == null) {
            return null;
        }
        if (s.startsWith("+")) {
            return s.substring(1);
        }
        if (s.endsWith("+")) {
            return s.substring(0, s.length() - 1);
        }
        return s;
    }

    protected String getCommonName(boolean localized, int i) {
        return localized ? this.getLocalizedCommonName(i) : this.commonName[i];
    }

    protected String getLocalizedCommonName(int i) {
        String name = this.commonName[i];
        if (name == null) {
            return null;
        }
        String translation = this.getTranslation(this.strip(name));
        if (name.startsWith("+")) {
            return "+" + translation;
        }
        if (name.endsWith("+")) {
            return translation + "+";
        }
        return translation;
    }

    @Override
    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("Layer.htm");
    }

    @Override
    public PieceEditor getEditor() {
        return new Ed(this);
    }

    public int getVersion() {
        return this.version;
    }

    public static Embellishment getLayerWithMatchingActivateCommand(GamePiece piece, KeyStroke stroke, boolean active) {
        Embellishment layer = (Embellishment)Decorator.getDecorator(piece, Embellishment.class);
        while (layer != null) {
            for (int i = 0; i < layer.activateKey.length(); ++i) {
                if (!stroke.equals(KeyStroke.getKeyStroke((int)layer.activateKey.charAt(i), layer.activateModifiers))) continue;
                if (active && layer.isActive()) {
                    return layer;
                }
                if (active || layer.isActive()) break;
                return layer;
            }
            layer = (Embellishment)Decorator.getDecorator(layer.piece, Embellishment.class);
        }
        return null;
    }

    public static Embellishment getLayerWithMatchingActivateCommand(GamePiece piece, NamedKeyStroke stroke, boolean active) {
        return Embellishment.getLayerWithMatchingActivateCommand(piece, stroke.getKeyStroke(), active);
    }

    @Override
    public List<String> getPropertyNames() {
        ArrayList<String> l = new ArrayList<String>();
        l.add(this.name + IMAGE);
        l.add(this.name + LEVEL);
        l.add(this.name + ACTIVE);
        l.add(this.name + NAME);
        return l;
    }

    @Override
    public PieceI18nData getI18nData() {
        String prefix;
        PieceI18nData data = new PieceI18nData(this);
        String string = prefix = this.name.length() > 0 ? this.name + ": " : "";
        if (this.activateKey.length() > 0) {
            data.add(this.activateCommand, prefix + "Activate command");
        }
        if (!this.followProperty) {
            data.add(this.upCommand, prefix + "Increase command");
            data.add(this.downCommand, prefix + "Decrease command");
            data.add(this.resetCommand, prefix + "Reset command");
            data.add(this.rndText, prefix + "Random command");
        }
        for (int i = 0; i < this.commonName.length; ++i) {
            data.add(this.strip(this.commonName[i]), prefix + "Level " + (i + 1) + " name");
        }
        return data;
    }

    protected static class Ed
    implements PieceEditor {
        private MultiImagePicker images;
        private StringConfigurer activateCommand;
        private StringConfigurer upCommand;
        private StringConfigurer downCommand;
        private StringConfigurer rndCommand;
        private JTextField xOffInput = new JTextField(2);
        private JTextField yOffInput = new JTextField(2);
        private JTextField levelNameInput = new JTextField(10);
        private JRadioButton prefix = new JRadioButton("is prefix");
        private JRadioButton suffix = new JRadioButton("is suffix");
        private JCheckBox drawUnderneath = new JCheckBox("Underneath when highlighted?");
        private FormattedExpressionConfigurer resetLevel = new FormattedExpressionConfigurer(null, "Reset to level:  ");
        private StringConfigurer resetCommand;
        private JCheckBox loop = new JCheckBox("Loop through levels?");
        private JPanel controls;
        private List<String> names;
        private List<Integer> isPrefix;
        private static final Integer NEITHER = 0;
        private static final Integer PREFIX = 1;
        private static final Integer SUFFIX = 2;
        private BooleanConfigurer followConfig;
        private PropertyNameExpressionConfigurer propertyConfig;
        private IntConfigurer firstLevelConfig;
        private StringConfigurer nameConfig;
        private JButton up;
        private JButton down;
        private int version;
        private BooleanConfigurer alwaysActiveConfig;
        private NamedHotKeyConfigurer activateConfig;
        private NamedHotKeyConfigurer increaseConfig;
        private NamedHotKeyConfigurer decreaseConfig;
        private NamedHotKeyConfigurer resetConfig;
        private NamedHotKeyConfigurer rndKeyConfig;
        private JLabel activateLabel;
        private JLabel increaseLabel;
        private JLabel decreaseLabel;
        private JLabel resetLabel;
        private JLabel rndLabel;
        private JLabel actionLabel;
        private JLabel menuLabel;
        private JLabel keyLabel;
        private JLabel optionLabel;

        public Ed(Embellishment e) {
            this.version = e.version;
            this.controls = new JPanel();
            this.controls.setLayout((LayoutManager)new MigLayout("hidemode 2,fillx", "[]rel[]rel[]rel[]"));
            this.nameConfig = new StringConfigurer(null, "Name: ", e.getName());
            this.controls.add(this.nameConfig.getControls(), "span 4,wrap,growx");
            this.alwaysActiveConfig = new BooleanConfigurer(null, "Always active?", e.alwaysActive);
            this.alwaysActiveConfig.addPropertyChangeListener(evt -> this.showHideFields());
            this.controls.add(this.alwaysActiveConfig.getControls(), "span 2");
            this.controls.add((Component)this.drawUnderneath, "span 2,wrap");
            this.controls.add((Component)this.loop, "span 2");
            Box offsetControls = Box.createHorizontalBox();
            this.xOffInput.setMaximumSize(this.xOffInput.getPreferredSize());
            this.xOffInput.setText("0");
            this.yOffInput.setMaximumSize(this.xOffInput.getPreferredSize());
            this.yOffInput.setText("0");
            offsetControls.add(new JLabel("Offset: "));
            offsetControls.add(this.xOffInput);
            offsetControls.add(new JLabel(","));
            offsetControls.add(this.yOffInput);
            this.controls.add((Component)offsetControls, "span 2,wrap");
            this.followConfig = new BooleanConfigurer(null, "Levels follow expression value?");
            this.controls.add(this.followConfig.getControls(), "span 2");
            Box levelBox = Box.createHorizontalBox();
            this.propertyConfig = new PropertyNameExpressionConfigurer(null, "Follow Expression:  ");
            levelBox.add(this.propertyConfig.getControls());
            this.firstLevelConfig = new IntConfigurer(null, " Level 1 = ", (Integer)e.firstLevelValue);
            levelBox.add(this.firstLevelConfig.getControls());
            this.controls.add((Component)levelBox, "span 2,wrap");
            this.followConfig.addPropertyChangeListener(e1 -> this.showHideFields());
            this.actionLabel = new JLabel("Action");
            Font defaultFont = this.actionLabel.getFont();
            Font boldFont = new Font(defaultFont.getFamily(), 1, defaultFont.getSize());
            this.actionLabel.setFont(boldFont);
            this.controls.add(this.actionLabel);
            this.menuLabel = new JLabel("Menu Command");
            this.menuLabel.setFont(boldFont);
            this.controls.add((Component)this.menuLabel, "align center");
            this.keyLabel = new JLabel("Key");
            this.keyLabel.setFont(boldFont);
            this.controls.add((Component)this.keyLabel, "align center");
            this.optionLabel = new JLabel("Option");
            this.optionLabel.setFont(boldFont);
            this.controls.add((Component)this.optionLabel, "align center,wrap");
            this.activateConfig = new NamedHotKeyConfigurer(null, "", e.activateKeyStroke);
            this.increaseConfig = new NamedHotKeyConfigurer(null, "", e.increaseKeyStroke);
            this.decreaseConfig = new NamedHotKeyConfigurer(null, "", e.decreaseKeyStroke);
            this.resetConfig = new NamedHotKeyConfigurer(null, "", e.resetKey);
            this.rndKeyConfig = new NamedHotKeyConfigurer(null, "", e.rndKey);
            this.activateLabel = new JLabel("Activate Layer");
            this.controls.add(this.activateLabel);
            this.activateCommand = new StringConfigurer(null, "", e.activateCommand);
            this.controls.add(this.activateCommand.getControls(), "align center");
            this.controls.add(this.activateConfig.getControls(), "wrap");
            this.increaseLabel = new JLabel("Increase Level");
            this.controls.add(this.increaseLabel);
            this.upCommand = new StringConfigurer(null, "", e.upCommand);
            this.controls.add(this.upCommand.getControls(), "align center");
            this.controls.add(this.increaseConfig.getControls(), "wrap");
            this.decreaseLabel = new JLabel("Decrease Level");
            this.controls.add(this.decreaseLabel);
            this.downCommand = new StringConfigurer(null, "", e.downCommand);
            this.controls.add(this.downCommand.getControls(), "align center");
            this.controls.add(this.decreaseConfig.getControls(), "wrap");
            this.resetLabel = new JLabel("Reset to Level");
            this.controls.add(this.resetLabel);
            this.resetCommand = new StringConfigurer(null, "", e.resetCommand);
            this.controls.add(this.resetCommand.getControls(), "align center");
            this.controls.add(this.resetConfig.getControls());
            this.controls.add(this.resetLevel.getControls(), "wrap");
            this.rndLabel = new JLabel("Randomize");
            this.controls.add(this.rndLabel);
            this.rndCommand = new StringConfigurer(null, "", e.rndText);
            this.controls.add(this.rndCommand.getControls(), "align center");
            this.controls.add(this.rndKeyConfig.getControls(), "wrap");
            this.images = this.getImagePicker();
            this.images.addListSelectionListener(e12 -> this.setUpDownEnabled());
            this.controls.add((Component)this.images, "span 4,split,grow");
            this.up = new JButton(IconFactory.getIcon("go-up", 0));
            this.up.addActionListener(e13 -> this.moveSelectedUp());
            this.down = new JButton(IconFactory.getIcon("go-down", 0));
            this.down.addActionListener(e14 -> this.moveSelectedDown());
            Box upDownPanel = Box.createVerticalBox();
            upDownPanel.add(Box.createVerticalGlue());
            upDownPanel.add(this.up);
            upDownPanel.add(this.down);
            upDownPanel.add(Box.createVerticalGlue());
            this.controls.add((Component)upDownPanel, "wrap");
            Box box = Box.createHorizontalBox();
            box.add(new JLabel("Level Name:  "));
            this.levelNameInput.setMaximumSize(this.levelNameInput.getPreferredSize());
            this.levelNameInput.addKeyListener(new KeyAdapter(){

                @Override
                public void keyReleased(KeyEvent evt) {
                    this.changeLevelName();
                }
            });
            box.add(this.levelNameInput);
            this.controls.add((Component)box, "span 2,growx");
            box = Box.createHorizontalBox();
            this.prefix.addActionListener(evt -> {
                if (this.prefix.isSelected()) {
                    this.suffix.setSelected(false);
                }
                this.changeLevelName();
            });
            this.suffix.addActionListener(evt -> {
                if (this.suffix.isSelected()) {
                    this.prefix.setSelected(false);
                }
                this.changeLevelName();
            });
            box.add(this.prefix);
            box.add(this.suffix);
            this.controls.add((Component)box, "span 2,center,wrap");
            JPanel buttonPanel = new JPanel((LayoutManager)new MigLayout("ins 0", "[grow 1]rel[grow 1]"));
            JButton b = new JButton("Add Level");
            b.addActionListener(evt -> {
                this.names.add(null);
                this.isPrefix.add(null);
                this.images.addEntry();
            });
            buttonPanel.add((Component)b, "growx");
            b = new JButton("Remove Level");
            b.addActionListener(evt -> {
                int index = this.images.getList().getSelectedIndex();
                if (index >= 0) {
                    this.names.remove(index);
                    this.isPrefix.remove(index);
                    this.images.removeEntryAt(index);
                }
            });
            buttonPanel.add((Component)b, "growx");
            this.controls.add((Component)buttonPanel, "span 4,center,growx,wrap");
            this.images.getList().addListSelectionListener(evt -> this.updateLevelName());
            this.showHideFields();
            this.reset(e);
        }

        protected void moveSelectedUp() {
            int selected = this.images.getList().getSelectedIndex();
            int count = this.images.getList().getModel().getSize();
            if (count > 1 && selected > 0) {
                this.swap(selected, selected - 1);
            }
        }

        protected void moveSelectedDown() {
            int selected = this.images.getList().getSelectedIndex();
            int count = this.images.getList().getModel().getSize();
            if (count > 1 && selected < count - 1) {
                this.swap(selected, selected + 1);
            }
        }

        protected void swap(int index1, int index2) {
            String name = this.names.get(index1);
            this.names.set(index1, this.names.get(index2));
            this.names.set(index2, name);
            Integer prefix = this.isPrefix.get(index1);
            this.isPrefix.set(index1, this.isPrefix.get(index2));
            this.isPrefix.set(index2, prefix);
            this.images.swap(index1, index2);
        }

        protected void setUpDownEnabled() {
            int selected = this.images.getList().getSelectedIndex();
            int count = this.images.getList().getModel().getSize();
            this.up.setEnabled(count > 1 && selected > 0);
            this.down.setEnabled(count > 1 && selected < count - 1);
        }

        protected void showHideFields() {
            boolean alwaysActive = this.alwaysActiveConfig.getValueBoolean();
            if (alwaysActive) {
                this.activateLabel.setVisible(false);
                this.activateCommand.getControls().setVisible(false);
                this.activateConfig.getControls().setVisible(false);
            } else {
                this.activateLabel.setVisible(true);
                this.activateCommand.getControls().setVisible(true);
                this.activateConfig.getControls().setVisible(true);
            }
            boolean controlled = this.followConfig.booleanValue() == false;
            this.loop.setEnabled(controlled);
            this.propertyConfig.getControls().setVisible(!controlled);
            this.firstLevelConfig.getControls().setVisible(!controlled);
            this.increaseLabel.setVisible(controlled);
            this.upCommand.getControls().setVisible(controlled);
            this.increaseConfig.getControls().setVisible(controlled);
            this.decreaseLabel.setVisible(controlled);
            this.downCommand.getControls().setVisible(controlled);
            this.decreaseConfig.getControls().setVisible(controlled);
            this.resetLabel.setVisible(controlled);
            this.resetCommand.getControls().setVisible(controlled);
            this.resetConfig.getControls().setVisible(controlled);
            this.resetLevel.getControls().setVisible(controlled);
            this.rndLabel.setVisible(controlled);
            this.rndCommand.getControls().setVisible(controlled);
            this.rndKeyConfig.getControls().setVisible(controlled);
            boolean labelsVisible = !alwaysActive || controlled;
            this.actionLabel.setVisible(labelsVisible);
            this.menuLabel.setVisible(labelsVisible);
            this.keyLabel.setVisible(labelsVisible);
            this.optionLabel.setVisible(labelsVisible);
            Decorator.repack(this.controls);
        }

        private void updateLevelName() {
            int index = this.images.getList().getSelectedIndex();
            if (index < 0) {
                this.levelNameInput.setText(null);
            } else {
                this.levelNameInput.setText(this.names.get(index));
                this.prefix.setSelected(PREFIX.equals(this.isPrefix.get(index)));
                this.suffix.setSelected(SUFFIX.equals(this.isPrefix.get(index)));
            }
        }

        private void changeLevelName() {
            int index = this.images.getList().getSelectedIndex();
            if (index >= 0) {
                String s = this.levelNameInput.getText();
                this.names.set(index, s);
                if (this.prefix.isSelected()) {
                    this.isPrefix.set(index, PREFIX);
                } else if (this.suffix.isSelected()) {
                    this.isPrefix.set(index, SUFFIX);
                } else {
                    this.isPrefix.set(index, NEITHER);
                }
            }
        }

        protected MultiImagePicker getImagePicker() {
            return new MultiImagePicker();
        }

        @Override
        public String getState() {
            return this.alwaysActiveConfig.getValueBoolean() ? "1" : "-1";
        }

        @Override
        public String getType() {
            SequenceEncoder se = new SequenceEncoder(';');
            ArrayList<String> imageNames = new ArrayList<String>();
            ArrayList<String> commonNames = new ArrayList<String>();
            int i = 0;
            for (String n : this.images.getImageNameList()) {
                imageNames.add(n);
                String commonName = this.names.get(i);
                if (commonName != null && commonName.length() > 0) {
                    commonName = PREFIX.equals(this.isPrefix.get(i)) ? new SequenceEncoder(commonName, '+').append("").getValue() : (SUFFIX.equals(this.isPrefix.get(i)) ? new SequenceEncoder("", '+').append(commonName).getValue() : new SequenceEncoder(commonName, '+').getValue());
                }
                commonNames.add(commonName);
                ++i;
            }
            try {
                Integer.parseInt(this.xOffInput.getText());
            }
            catch (NumberFormatException xNAN) {
                this.xOffInput.setText("0");
            }
            try {
                Integer.parseInt(this.yOffInput.getText());
            }
            catch (NumberFormatException yNAN) {
                this.yOffInput.setText("0");
            }
            se.append(this.activateCommand.getValueString()).append("").append("").append(this.upCommand.getValueString()).append("").append("").append(this.downCommand.getValueString()).append("").append("").append(this.resetCommand.getValueString()).append(this.resetConfig.getValueString()).append(this.resetLevel.getValueString()).append(this.drawUnderneath.isSelected()).append(this.xOffInput.getText()).append(this.yOffInput.getText()).append(imageNames.toArray(new String[0])).append(commonNames.toArray(new String[0])).append(this.loop.isSelected()).append(this.nameConfig.getValueString()).append(this.rndKeyConfig.getValueString()).append(this.rndCommand.getValueString() == null ? "" : this.rndCommand.getValueString().trim()).append(this.followConfig.getValueString()).append(this.propertyConfig.getValueString()).append(this.firstLevelConfig.getValueString()).append(this.version).append(this.alwaysActiveConfig.getValueString()).append(this.activateConfig.getValueString()).append(this.increaseConfig.getValueString()).append(this.decreaseConfig.getValueString());
            return Embellishment.ID + se.getValue();
        }

        @Override
        public Component getControls() {
            return this.controls;
        }

        public void reset(Embellishment e) {
            this.nameConfig.setValue(e.name);
            this.names = new ArrayList<String>();
            this.isPrefix = new ArrayList<Integer>();
            for (int i = 0; i < e.commonName.length; ++i) {
                String s = e.commonName[i];
                Integer is = NEITHER;
                if (s != null && s.length() > 0) {
                    SequenceEncoder.Decoder st = new SequenceEncoder.Decoder(s, '+');
                    String first = st.nextToken();
                    if (st.hasMoreTokens()) {
                        String second = st.nextToken();
                        if (first.length() == 0) {
                            s = second;
                            is = SUFFIX;
                        } else {
                            s = first;
                            is = PREFIX;
                        }
                    } else {
                        s = first;
                    }
                }
                this.names.add(s);
                this.isPrefix.add(is);
            }
            this.alwaysActiveConfig.setValue(e.alwaysActive);
            this.drawUnderneath.setSelected(e.drawUnderneathWhenSelected);
            this.loop.setSelected(e.loopLevels);
            this.images.clear();
            this.activateCommand.setValue(e.activateCommand);
            this.upCommand.setValue(e.upCommand);
            this.downCommand.setValue(e.downCommand);
            this.resetConfig.setValue(e.resetKey);
            this.resetCommand.setValue(e.resetCommand);
            this.resetLevel.setValue(e.resetLevel.getFormat());
            this.xOffInput.setText(String.valueOf(e.xOff));
            this.yOffInput.setText(String.valueOf(e.yOff));
            this.images.setImageList(e.imageName);
            this.followConfig.setValue(e.followProperty);
            this.propertyConfig.setValue(e.propertyName);
            if (this.images.getImageNameList().isEmpty()) {
                this.names.add(null);
                this.isPrefix.add(null);
                this.images.addEntry();
            }
            this.updateLevelName();
            this.showHideFields();
        }
    }
}

