/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.counters;

import VASSAL.command.Command;
import VASSAL.command.NullCommand;
import VASSAL.counters.BoundsTracker;
import VASSAL.counters.GamePiece;
import VASSAL.counters.PieceCloner;
import VASSAL.counters.PieceSorter;
import VASSAL.counters.Stack;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import javax.swing.KeyStroke;

public class KeyBuffer {
    private static KeyBuffer theBuffer;
    private List<GamePiece> pieces;
    private BoundsTracker bounds;
    private Comparator<GamePiece> pieceSorter = new PieceSorter();

    private KeyBuffer() {
        this.pieces = new ArrayList<GamePiece>();
        this.bounds = new BoundsTracker();
    }

    public static void init(KeyBuffer kb) {
        if (theBuffer == null) {
            theBuffer = kb;
        }
    }

    public static KeyBuffer getBuffer() {
        if (theBuffer == null) {
            theBuffer = new KeyBuffer();
        }
        return theBuffer;
    }

    public void add(GamePiece p) {
        if (p != null && !this.pieces.contains(p)) {
            this.pieces.add(p);
            p.setProperty("Selected", Boolean.TRUE);
        }
    }

    public void clear() {
        for (GamePiece p : this.pieces) {
            p.setProperty("Selected", null);
        }
        this.pieces.clear();
    }

    public void remove(GamePiece p) {
        if (p != null) {
            p.setProperty("Selected", null);
            this.pieces.remove(p);
        }
    }

    public boolean contains(GamePiece p) {
        if (p instanceof Stack) {
            return this.pieces.containsAll(((Stack)p).asList());
        }
        return this.pieces.contains(p);
    }

    public boolean isEmpty() {
        return this.pieces.isEmpty();
    }

    public Command keyCommand(KeyStroke stroke) {
        GamePiece top;
        this.sort(this.pieceSorter);
        Command comm = new NullCommand();
        this.bounds.clear();
        ArrayList<GamePiece> targets = new ArrayList<GamePiece>(this.pieces);
        if (targets.size() > 0 && (top = targets.get(0)).getMap() != null && (stroke.equals(top.getMap().getStackMetrics().getMoveBottomKey()) || stroke.equals(top.getMap().getStackMetrics().getMoveUpKey()))) {
            Collections.reverse(targets);
        }
        for (GamePiece p : targets) {
            this.bounds.addPiece(p);
            p.setProperty("snapshot", PieceCloner.getInstance().clonePiece(p));
            Command c2 = p.keyEvent(stroke);
            comm = comm.append(c2);
            this.bounds.addPiece(p);
        }
        this.bounds.repaint();
        return comm;
    }

    public List<GamePiece> asList() {
        return Collections.unmodifiableList(this.pieces);
    }

    public Iterator<GamePiece> getPiecesIterator() {
        return this.pieces.iterator();
    }

    @Deprecated
    public Enumeration<GamePiece> getPieces() {
        return Collections.enumeration(this.pieces);
    }

    public void sort(Comparator<GamePiece> comp) {
        this.pieces.sort(comp);
    }

    public boolean containsChild(Stack stack) {
        return stack.asList().stream().anyMatch(this::contains);
    }
}

