/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.counters;

import VASSAL.build.module.documentation.HelpFile;
import VASSAL.command.ChangeTracker;
import VASSAL.command.Command;
import VASSAL.configure.BooleanConfigurer;
import VASSAL.configure.ColorConfigurer;
import VASSAL.configure.FormattedStringConfigurer;
import VASSAL.configure.IntConfigurer;
import VASSAL.configure.NamedHotKeyConfigurer;
import VASSAL.configure.StringConfigurer;
import VASSAL.counters.Decorator;
import VASSAL.counters.GamePiece;
import VASSAL.counters.KeyCommand;
import VASSAL.counters.PieceEditor;
import VASSAL.i18n.PieceI18nData;
import VASSAL.i18n.TranslatablePiece;
import VASSAL.tools.FormattedString;
import VASSAL.tools.NamedKeyStroke;
import VASSAL.tools.RecursionLimitException;
import VASSAL.tools.RecursionLimiter;
import VASSAL.tools.SequenceEncoder;
import VASSAL.tools.image.ImageUtils;
import VASSAL.tools.imageop.AbstractTileOpImpl;
import VASSAL.tools.imageop.ScaledImagePainter;
import VASSAL.tools.opcache.Op;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.plaf.basic.BasicHTML;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class Labeler
extends Decorator
implements TranslatablePiece,
RecursionLimiter.Loopable {
    public static final String ID = "label;";
    protected Color textBg = Color.black;
    protected Color textFg = Color.white;
    public static final int CENTER = 0;
    public static final int RIGHT = 1;
    public static final int LEFT = 2;
    public static final int TOP = 3;
    public static final int BOTTOM = 4;
    public static int HORIZONTAL_ALIGNMENT = 0;
    public static int VERTICAL_ALIGNMENT = 3;
    private String label = "";
    private String lastCachedLabel;
    private NamedKeyStroke labelKey;
    private String menuCommand = "Change Label";
    private Font font = new Font("Dialog", 0, 10);
    private KeyCommand[] commands;
    private FormattedString nameFormat = new FormattedString("$pieceName$ ($label$)");
    private FormattedString labelFormat = new FormattedString("");
    private static final String PIECE_NAME = "pieceName";
    private static final String BAD_PIECE_NAME = "PieceName";
    private static final String LABEL = "label";
    protected ScaledImagePainter imagePainter = new ScaledImagePainter();
    private char verticalJust = (char)98;
    private char horizontalJust = (char)99;
    private char verticalPos = (char)116;
    private char horizontalPos = (char)99;
    private int verticalOffset = 0;
    private int horizontalOffset = 0;
    protected int rotateDegrees;
    protected String propertyName;
    protected KeyCommand menuKeyCommand;
    protected String description;
    private Point position = null;
    protected Rectangle lastRect = null;
    protected Area lastShape = null;

    public Labeler() {
        this(ID, null);
    }

    public Labeler(String s, GamePiece d) {
        this.mySetType(s);
        this.setInner(d);
    }

    @Override
    public void mySetType(String type) {
        this.commands = null;
        SequenceEncoder.Decoder st = new SequenceEncoder.Decoder(type, ';');
        st.nextToken();
        this.labelKey = st.nextNamedKeyStroke(null);
        this.menuCommand = st.nextToken("Change Label");
        int fontSize = st.nextInt(10);
        this.textBg = st.nextColor(null);
        this.textFg = st.nextColor(Color.black);
        this.verticalPos = st.nextChar('t');
        this.verticalOffset = st.nextInt(0);
        this.horizontalPos = st.nextChar('c');
        this.horizontalOffset = st.nextInt(0);
        this.verticalJust = st.nextChar('b');
        this.horizontalJust = st.nextChar('c');
        this.nameFormat.setFormat(this.clean(st.nextToken("$pieceName$ ($label$)")));
        String fontFamily = st.nextToken("Dialog");
        int fontStyle = st.nextInt(0);
        this.font = new Font(fontFamily, fontStyle, fontSize);
        this.rotateDegrees = st.nextInt(0);
        this.propertyName = st.nextToken("TextLabel");
        this.description = st.nextToken("");
    }

    protected String clean(String s) {
        return s.replace("$PieceName$", "$pieceName$");
    }

    @Override
    public Object getLocalizedProperty(Object key) {
        if (key.equals(this.propertyName)) {
            return this.getLocalizedLabel();
        }
        if ("visibleState".equals(key)) {
            return this.getLocalizedLabel() + this.piece.getProperty(key);
        }
        return super.getLocalizedProperty(key);
    }

    @Override
    public Object getProperty(Object key) {
        if (key.equals(this.propertyName)) {
            return this.getLabel();
        }
        if ("visibleState".equals(key)) {
            return this.getLabel() + this.piece.getProperty(key);
        }
        return super.getProperty(key);
    }

    @Override
    public String myGetType() {
        SequenceEncoder se = new SequenceEncoder(';');
        se.append(this.labelKey).append(this.menuCommand).append(this.font.getSize());
        String s = ColorConfigurer.colorToString(this.textBg);
        se.append(s == null ? "" : s);
        s = ColorConfigurer.colorToString(this.textFg);
        se.append(s == null ? "" : s).append(String.valueOf(this.verticalPos)).append(String.valueOf(this.verticalOffset)).append(String.valueOf(this.horizontalPos)).append(String.valueOf(this.horizontalOffset)).append(String.valueOf(this.verticalJust)).append(String.valueOf(this.horizontalJust)).append(this.nameFormat.getFormat()).append(this.font.getFamily()).append(this.font.getStyle()).append(String.valueOf(this.rotateDegrees)).append(this.propertyName).append(this.description);
        return ID + se.getValue();
    }

    @Override
    public String myGetState() {
        return this.label;
    }

    @Override
    public void mySetState(String s) {
        this.setLabel(s.trim());
    }

    @Override
    public String getName() {
        String result = "";
        if (this.label.length() == 0) {
            result = this.piece.getName();
        } else {
            this.nameFormat.setProperty(PIECE_NAME, this.piece.getName());
            if (!RecursionLimiter.isReportingInfiniteLoop()) {
                this.nameFormat.setProperty(LABEL, this.getLabel());
            }
            try {
                RecursionLimiter.startExecution(this);
                result = this.nameFormat.getText(Decorator.getOutermost(this));
            }
            catch (RecursionLimitException e) {
                e.printStackTrace();
            }
            finally {
                RecursionLimiter.endExecution();
            }
        }
        return result;
    }

    @Override
    public String getLocalizedName() {
        if (this.label.length() == 0) {
            return this.piece.getLocalizedName();
        }
        FormattedString f = new FormattedString(this.getTranslation(this.nameFormat.getFormat()));
        f.setProperty(PIECE_NAME, this.piece.getLocalizedName());
        f.setProperty(LABEL, this.getLocalizedLabel());
        return f.getLocalizedText(Decorator.getOutermost(this));
    }

    public static void drawLabel(Graphics g, String text, int x, int y, int hAlign, int vAlign, Color fgColor, Color bgColor) {
        Labeler.drawLabel(g, text, x, y, new Font("Dialog", 0, 10), hAlign, vAlign, fgColor, bgColor, null);
    }

    public static void drawLabel(Graphics g, String text, int x, int y, Font f, int hAlign, int vAlign, Color fgColor, Color bgColor, Color borderColor) {
        g.setFont(f);
        int width = g.getFontMetrics().stringWidth(text + "  ");
        int height = g.getFontMetrics().getHeight();
        int x0 = x;
        int y0 = y;
        switch (hAlign) {
            case 0: {
                x0 = x - width / 2;
                break;
            }
            case 2: {
                x0 = x - width;
            }
        }
        switch (vAlign) {
            case 0: {
                y0 = y - height / 2;
                break;
            }
            case 4: {
                y0 = y - height;
            }
        }
        if (bgColor != null) {
            g.setColor(bgColor);
            g.fillRect(x0, y0, width, height);
        }
        if (borderColor != null) {
            g.setColor(borderColor);
            g.drawRect(x0, y0, width, height);
        }
        g.setColor(fgColor);
        ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.drawString(" " + text + " ", x0, y0 + g.getFontMetrics().getHeight() - g.getFontMetrics().getDescent());
    }

    @Override
    public void draw(Graphics g, int x, int y, Component obs, double zoom) {
        this.updateCachedImage();
        this.piece.draw(g, x, y, obs, zoom);
        Point p = this.getLabelPosition();
        int labelX = x + (int)(zoom * (double)p.x);
        int labelY = y + (int)(zoom * (double)p.y);
        AffineTransform saveXForm = null;
        Graphics2D g2d = (Graphics2D)g;
        if (this.rotateDegrees != 0) {
            saveXForm = g2d.getTransform();
            AffineTransform newXForm = AffineTransform.getRotateInstance(Math.toRadians(this.rotateDegrees), x, y);
            g2d.transform(newXForm);
        }
        this.imagePainter.draw(g, labelX, labelY, zoom, obs);
        if (this.rotateDegrees != 0) {
            g2d.setTransform(saveXForm);
        }
    }

    protected void updateCachedImage() {
        String label = this.getLocalizedLabel();
        if (label != null && !label.equals(this.lastCachedLabel)) {
            this.imagePainter.setSource(null);
            this.lastCachedLabel = null;
            this.position = null;
        }
        if (this.imagePainter.getSource() == null && label != null && label.length() > 0) {
            this.lastCachedLabel = label;
            this.imagePainter.setSource(new LabelOp(this.lastCachedLabel, this.font, this.textFg, this.textBg));
        }
    }

    private Point getLabelPosition() {
        if (this.position != null) {
            return this.position;
        }
        int x = this.horizontalOffset;
        int y = this.verticalOffset;
        this.updateCachedImage();
        Dimension lblSize = this.imagePainter.getImageSize();
        Rectangle selBnds = this.piece.getShape().getBounds();
        switch (this.verticalPos) {
            case 't': {
                y += selBnds.y;
                break;
            }
            case 'b': {
                y += selBnds.y + selBnds.height;
            }
        }
        switch (this.horizontalPos) {
            case 'l': {
                x += selBnds.x;
                break;
            }
            case 'r': {
                x += selBnds.x + selBnds.width;
            }
        }
        switch (this.verticalJust) {
            case 'b': {
                y -= lblSize.height;
                break;
            }
            case 'c': {
                y -= lblSize.height / 2;
            }
        }
        switch (this.horizontalJust) {
            case 'c': {
                x -= lblSize.width / 2;
                break;
            }
            case 'r': {
                x -= lblSize.width;
            }
        }
        Point result = new Point(x, y);
        if (lblSize.height > 0 && lblSize.width > 0) {
            this.position = result;
        }
        return result;
    }

    public void setLabel(String s) {
        if (s == null) {
            s = "";
        }
        this.position = null;
        int index = ((String)s).indexOf("$" + this.propertyName + "$");
        while (index >= 0) {
            s = ((String)s).substring(0, index) + ((String)s).substring(index + this.propertyName.length() + 2);
            index = ((String)s).indexOf("$" + this.propertyName + "$");
        }
        this.label = s;
        this.labelFormat.setProperty(BAD_PIECE_NAME, this.piece.getName());
        this.labelFormat.setFormat(this.label);
        if (this.getMap() != null && this.label != null && this.label.length() > 0) {
            this.imagePainter.setSource(new LabelOp(this.getLocalizedLabel(), this.font, this.textFg, this.textBg));
        } else {
            this.imagePainter.setSource(null);
        }
    }

    public void setBackground(Color textBg) {
        this.textBg = textBg;
    }

    public void setForeground(Color textFg) {
        this.textFg = textFg;
    }

    public String getLabel() {
        return this.labelFormat.getText(Decorator.getOutermost(this));
    }

    public String getLocalizedLabel() {
        FormattedString f = new FormattedString(this.getTranslation(this.labelFormat.getFormat()));
        return f.getLocalizedText(Decorator.getOutermost(this));
    }

    @Override
    public Rectangle boundingBox() {
        Rectangle r = this.piece.boundingBox();
        r.add(new Rectangle(this.getLabelPosition(), this.imagePainter.getImageSize()));
        return r;
    }

    @Override
    public Shape getShape() {
        Shape innerShape = this.piece.getShape();
        if (!this.labelKey.isNull()) {
            return innerShape;
        }
        Rectangle r = new Rectangle(this.getLabelPosition(), this.imagePainter.getImageSize());
        if (innerShape.contains(r.x, r.y, r.width, r.height)) {
            return innerShape;
        }
        Area a = new Area(innerShape);
        if (!r.equals(this.lastRect)) {
            this.lastShape = new Area(r);
            this.lastRect = new Rectangle(r);
        }
        a.add(this.lastShape);
        return a;
    }

    @Override
    public KeyCommand[] myGetKeyCommands() {
        if (this.commands == null) {
            this.menuKeyCommand = new KeyCommand(this.menuCommand, this.labelKey, Decorator.getOutermost(this), (TranslatablePiece)this);
            this.commands = this.labelKey == null || this.labelKey.isNull() || this.menuCommand == null || this.menuCommand.length() == 0 ? new KeyCommand[0] : new KeyCommand[]{this.menuKeyCommand};
        }
        return this.commands;
    }

    @Override
    public Command myKeyEvent(KeyStroke stroke) {
        this.myGetKeyCommands();
        Command c = null;
        if (this.menuKeyCommand.matches(stroke)) {
            ChangeTracker tracker = new ChangeTracker(this);
            String s = (String)JOptionPane.showInputDialog(this.getMap() == null ? null : this.getMap().getView().getTopLevelAncestor(), this.menuKeyCommand.getName(), null, 3, null, null, this.label);
            if (s == null) {
                tracker = null;
            } else {
                this.setLabel(s);
                c = tracker.getChangeCommand();
            }
        }
        return c;
    }

    @Override
    public String getDescription() {
        return "Text Label" + (String)(this.description.length() > 0 ? " - " + this.description : "");
    }

    @Override
    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("Label.htm");
    }

    @Override
    public PieceEditor getEditor() {
        return new Ed(this);
    }

    @Override
    public List<String> getPropertyNames() {
        ArrayList<String> l = new ArrayList<String>();
        if (this.propertyName.length() > 0) {
            l.add(this.propertyName);
        }
        return l;
    }

    @Override
    public PieceI18nData getI18nData() {
        return this.getI18nData(new String[]{this.labelFormat.getFormat(), this.nameFormat.getFormat(), this.menuCommand}, new String[]{"Label Text", "Label Format", "Change Label Command"});
    }

    @Override
    public String getComponentTypeName() {
        return this.piece.getName();
    }

    @Override
    public String getComponentName() {
        return this.getDescription();
    }

    protected static class LabelOp
    extends AbstractTileOpImpl {
        private final String txt;
        private final Font font;
        private final Color fg;
        private final Color bg;
        private final int hash;

        public LabelOp(String txt, Font font, Color fg, Color bg) {
            this.txt = txt;
            this.font = font;
            this.fg = fg;
            this.bg = bg;
            this.hash = new HashCodeBuilder().append((Object)txt).append((Object)font).append((Object)fg).append((Object)bg).toHashCode();
        }

        @Override
        public List<Op<?>> getSources() {
            return Collections.emptyList();
        }

        @Override
        public BufferedImage eval() throws Exception {
            JLabel label = this.buildDimensions();
            if (this.size.width <= 0 || this.size.height <= 0) {
                return ImageUtils.NULL_IMAGE;
            }
            BufferedImage im = ImageUtils.createCompatibleImage(this.size.width, this.size.height, this.bg == null || this.bg.getTransparency() != 1);
            Graphics2D g = im.createGraphics();
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            if (this.bg != null) {
                g.setColor(this.bg);
                g.fillRect(0, 0, this.size.width, this.size.height);
            }
            if (this.fg != null) {
                if (label != null) {
                    label.paint(g);
                } else {
                    g.setColor(this.fg);
                    g.setFont(this.font);
                    FontMetrics fm = g.getFontMetrics(this.font);
                    g.drawString(this.txt, 0, this.size.height - fm.getDescent());
                }
            }
            g.dispose();
            return im;
        }

        private JLabel buildDimensions() {
            JLabel label;
            if (BasicHTML.isHTMLString(this.txt)) {
                label = new JLabel(this.txt);
                label.setForeground(this.fg);
                label.setFont(this.font);
                this.size = label.getPreferredSize();
                label.setSize(this.size);
            } else {
                label = null;
                Graphics2D g = ImageUtils.NULL_IMAGE.createGraphics();
                FontMetrics fm = g.getFontMetrics(this.font);
                this.size = new Dimension(fm.stringWidth(this.txt), fm.getHeight());
                g.dispose();
            }
            return label;
        }

        @Override
        protected void fixSize() {
            this.size = this.getSizeFromCache();
            if (this.size == null) {
                this.buildDimensions();
                if (this.size.width <= 0 || this.size.height <= 0) {
                    this.size.height = 1;
                    this.size.width = 1;
                }
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof LabelOp)) {
                return false;
            }
            LabelOp lop = (LabelOp)o;
            return (this.txt == null ? lop.txt == null : this.txt.equals(lop.txt)) && (this.font == null ? lop.font == null : this.font.equals(lop.font)) && (this.fg == null ? lop.fg == null : this.fg.equals(lop.fg)) && (this.bg == null ? lop.bg == null : this.bg.equals(lop.bg));
        }

        public int hashCode() {
            return this.hash;
        }
    }

    private static class Ed
    implements PieceEditor {
        private NamedHotKeyConfigurer labelKeyInput;
        private JPanel controls = new JPanel();
        private StringConfigurer command;
        private StringConfigurer initialValue;
        private ColorConfigurer fg;
        private ColorConfigurer bg;
        private JComboBox<Character> hPos;
        private JComboBox<Character> vPos;
        private JComboBox<Character> hJust;
        private JComboBox<Character> vJust;
        private IntConfigurer hOff;
        private IntConfigurer vOff;
        private IntConfigurer fontSize;
        private ListCellRenderer renderer;
        private FormattedStringConfigurer format;
        private JComboBox<String> fontFamily;
        private IntConfigurer rotate;
        private BooleanConfigurer bold;
        private BooleanConfigurer italic;
        private StringConfigurer propertyNameConfig;
        private StringConfigurer descConfig;

        public Ed(Labeler l) {
            String[] s;
            this.controls.setLayout(new BoxLayout(this.controls, 1));
            this.descConfig = new StringConfigurer(null, "Description:  ", l.description);
            this.controls.add(this.descConfig.getControls());
            this.initialValue = new StringConfigurer(null, "Text:  ", l.label);
            this.controls.add(this.initialValue.getControls());
            this.format = new FormattedStringConfigurer(null, "Name format:  ", new String[]{Labeler.PIECE_NAME, Labeler.LABEL});
            this.format.setValue(l.nameFormat.getFormat());
            this.controls.add(this.format.getControls());
            this.command = new StringConfigurer(null, "Menu Command:  ", l.menuCommand);
            this.controls.add(this.command.getControls());
            this.labelKeyInput = new NamedHotKeyConfigurer(null, "Keyboard Command:  ", l.labelKey);
            this.controls.add(this.labelKeyInput.getControls());
            Box b = Box.createHorizontalBox();
            b.add(new JLabel("Font:  "));
            this.fontFamily = new JComboBox();
            for (String value : s = new String[]{"Serif", "SansSerif", "Monospaced", "Dialog", "DialogInput"}) {
                this.fontFamily.addItem(value);
            }
            this.fontFamily.setSelectedItem(l.font.getFamily());
            b.add(this.fontFamily);
            this.controls.add(b);
            b = Box.createHorizontalBox();
            this.fontSize = new IntConfigurer(null, "Font size:  ", (Integer)l.font.getSize());
            b.add(this.fontSize.getControls());
            b.add(new JLabel("  Bold?"));
            int fontStyle = l.font.getStyle();
            this.bold = new BooleanConfigurer(null, "", (Boolean)(fontStyle != 0 && fontStyle != 2 ? 1 : 0));
            b.add(this.bold.getControls());
            b.add(new JLabel("  Italic?"));
            this.italic = new BooleanConfigurer(null, "", (Boolean)(fontStyle != 0 && fontStyle != 1 ? 1 : 0));
            b.add(this.italic.getControls());
            this.controls.add(b);
            b = Box.createHorizontalBox();
            this.fg = new ColorConfigurer(null, "Text Color:  ", l.textFg);
            b.add(this.fg.getControls());
            this.bg = new ColorConfigurer(null, "  Background Color:  ", l.textBg);
            b.add(this.bg.getControls());
            this.controls.add(b);
            this.renderer = new MyRenderer();
            Character[] rightLeft = new Character[]{Character.valueOf('c'), Character.valueOf('r'), Character.valueOf('l')};
            Character[] topBottom = new Character[]{Character.valueOf('c'), Character.valueOf('t'), Character.valueOf('b')};
            b = Box.createHorizontalBox();
            b.add(new JLabel("Vertical position:  "));
            this.vPos = new JComboBox<Character>(topBottom);
            this.vPos.setRenderer(this.renderer);
            this.vPos.setSelectedItem(Character.valueOf(l.verticalPos));
            b.add(this.vPos);
            this.vOff = new IntConfigurer(null, "  Offset:  ", (Integer)l.verticalOffset);
            b.add(this.vOff.getControls());
            this.controls.add(b);
            b = Box.createHorizontalBox();
            b.add(new JLabel("Horizontal position:  "));
            this.hPos = new JComboBox<Character>(rightLeft);
            this.hPos.setRenderer(this.renderer);
            this.hPos.setSelectedItem(Character.valueOf(l.horizontalPos));
            b.add(this.hPos);
            this.hOff = new IntConfigurer(null, "  Offset:  ", (Integer)l.horizontalOffset);
            b.add(this.hOff.getControls());
            this.controls.add(b);
            b = Box.createHorizontalBox();
            b.add(new JLabel("Vertical text justification:  "));
            this.vJust = new JComboBox<Character>(topBottom);
            this.vJust.setRenderer(this.renderer);
            this.vJust.setSelectedItem(Character.valueOf(l.verticalJust));
            b.add(this.vJust);
            this.controls.add(b);
            b = Box.createHorizontalBox();
            b.add(new JLabel("Horizontal text justification:  "));
            this.hJust = new JComboBox<Character>(rightLeft);
            this.hJust.setRenderer(this.renderer);
            this.hJust.setSelectedItem(Character.valueOf(l.horizontalJust));
            b.add(this.hJust);
            this.controls.add(b);
            this.rotate = new IntConfigurer(null, "Rotate Text (Degrees):  ", (Integer)l.rotateDegrees);
            this.controls.add(this.rotate.getControls());
            this.propertyNameConfig = new StringConfigurer(null, "Property Name:  ", l.propertyName);
            this.controls.add(this.propertyNameConfig.getControls());
        }

        @Override
        public String getState() {
            return this.initialValue.getValueString();
        }

        @Override
        public String getType() {
            SequenceEncoder se = new SequenceEncoder(';');
            se.append(this.labelKeyInput.getValueString()).append(this.command.getValueString());
            Integer i = (Integer)this.fontSize.getValue();
            if (i == null || i <= 0) {
                i = 10;
            }
            se.append(i.toString()).append(this.bg.getValueString()).append(this.fg.getValueString()).append(this.vPos.getSelectedItem().toString());
            i = (Integer)this.vOff.getValue();
            if (i == null) {
                i = 0;
            }
            se.append(i.toString()).append(this.hPos.getSelectedItem().toString());
            i = (Integer)this.hOff.getValue();
            if (i == null) {
                i = 0;
            }
            se.append(i.toString()).append(this.vJust.getSelectedItem().toString()).append(this.hJust.getSelectedItem().toString()).append(this.format.getValueString()).append(this.fontFamily.getSelectedItem().toString());
            int style = 0 + (this.bold.booleanValue() != false ? 1 : 0) + (this.italic.booleanValue() != false ? 2 : 0);
            se.append("" + style);
            i = (Integer)this.rotate.getValue();
            if (i == null) {
                i = 0;
            }
            se.append(i.toString()).append(this.propertyNameConfig.getValueString()).append(this.descConfig.getValueString());
            return Labeler.ID + se.getValue();
        }

        @Override
        public Component getControls() {
            return this.controls;
        }

        private static class MyRenderer
        extends DefaultListCellRenderer {
            private static final long serialVersionUID = 1L;

            private MyRenderer() {
            }

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean sel, boolean focus) {
                super.getListCellRendererComponent((JList<?>)list, value, index, sel, focus);
                switch (((Character)value).charValue()) {
                    case 't': {
                        this.setText("Top");
                        break;
                    }
                    case 'b': {
                        this.setText("Bottom");
                        break;
                    }
                    case 'c': {
                        this.setText("Center");
                        break;
                    }
                    case 'l': {
                        this.setText("Left");
                        break;
                    }
                    case 'r': {
                        this.setText("Right");
                    }
                }
                return this;
            }
        }
    }
}

