/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.counters;

import VASSAL.build.GameModule;
import VASSAL.build.module.Map;
import VASSAL.command.AddPiece;
import VASSAL.counters.BasicPiece;
import VASSAL.counters.Decorator;
import VASSAL.counters.EditablePiece;
import VASSAL.counters.GamePiece;
import VASSAL.counters.UsePrototype;
import VASSAL.tools.ReflectionUtils;

public class PieceCloner {
    private static PieceCloner instance = new PieceCloner();

    protected PieceCloner() {
    }

    public static PieceCloner getInstance() {
        return instance;
    }

    public GamePiece clonePiece(GamePiece piece) {
        GamePiece clone = null;
        if (piece instanceof BasicPiece) {
            clone = GameModule.getGameModule().createPiece(piece.getType());
            Map m = piece.getMap();
            piece.setMap(null);
            clone.setState(piece.getState());
            piece.setMap(m);
        } else if (piece instanceof UsePrototype) {
            clone = this.clonePiece(((UsePrototype)piece).getExpandedInner());
        } else if (piece instanceof EditablePiece && piece instanceof Decorator) {
            try {
                clone = (GamePiece)piece.getClass().getConstructor(new Class[0]).newInstance(new Object[0]);
                ((Decorator)clone).setInner(this.clonePiece(((Decorator)piece).getInner()));
                ((EditablePiece)clone).mySetType(((Decorator)piece).myGetType());
                ((Decorator)clone).mySetState(((Decorator)piece).myGetState());
            }
            catch (Throwable t) {
                ReflectionUtils.handleNewInstanceFailure(t, piece.getClass());
            }
        } else {
            clone = ((AddPiece)GameModule.getGameModule().decode(GameModule.getGameModule().encode(new AddPiece(piece)))).getTarget();
            Map m = piece.getMap();
            piece.setMap(null);
            clone.setState(piece.getState());
            piece.setMap(m);
        }
        return clone;
    }
}

