/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.counters;

import VASSAL.build.GameModule;
import VASSAL.build.GpIdSupport;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.build.module.documentation.HelpWindow;
import VASSAL.build.module.documentation.HelpWindowExtension;
import VASSAL.build.widget.PieceSlot;
import VASSAL.counters.ActionButton;
import VASSAL.counters.AreaOfEffect;
import VASSAL.counters.BasicPiece;
import VASSAL.counters.CalculatedProperty;
import VASSAL.counters.Clone;
import VASSAL.counters.CounterGlobalKeyCommand;
import VASSAL.counters.Decorator;
import VASSAL.counters.Delete;
import VASSAL.counters.DynamicProperty;
import VASSAL.counters.EditablePiece;
import VASSAL.counters.Embellishment;
import VASSAL.counters.Footprint;
import VASSAL.counters.FreeRotator;
import VASSAL.counters.GamePiece;
import VASSAL.counters.GlobalHotKey;
import VASSAL.counters.Hideable;
import VASSAL.counters.Immobilized;
import VASSAL.counters.Labeler;
import VASSAL.counters.Marker;
import VASSAL.counters.MovementMarkable;
import VASSAL.counters.NonRectangular;
import VASSAL.counters.Obscurable;
import VASSAL.counters.PieceEditor;
import VASSAL.counters.Pivot;
import VASSAL.counters.PlaceMarker;
import VASSAL.counters.PlaySound;
import VASSAL.counters.PropertySheet;
import VASSAL.counters.Replace;
import VASSAL.counters.ReportState;
import VASSAL.counters.RestrictCommands;
import VASSAL.counters.Restricted;
import VASSAL.counters.ReturnToDeck;
import VASSAL.counters.SendToLocation;
import VASSAL.counters.SetGlobalProperty;
import VASSAL.counters.SubMenu;
import VASSAL.counters.TableInfo;
import VASSAL.counters.Translate;
import VASSAL.counters.TriggerAction;
import VASSAL.counters.UsePrototype;
import VASSAL.tools.BrowserSupport;
import VASSAL.tools.ErrorDialog;
import VASSAL.tools.ReflectionUtils;
import VASSAL.tools.swing.SwingUtils;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BoxLayout;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import net.miginfocom.swing.MigLayout;

public class PieceDefiner
extends JPanel
implements HelpWindowExtension {
    private static final long serialVersionUID = 1L;
    protected static DefaultListModel availableModel;
    protected DefaultListModel inUseModel;
    protected ListCellRenderer r;
    protected PieceSlot slot;
    private GamePiece piece;
    protected static TraitClipboard clipBoard;
    protected String pieceId = "";
    protected JLabel pieceIdLabel = new JLabel("");
    protected GpIdSupport gpidSupport;
    protected boolean changed;
    private JPanel availablePanel;
    private JScrollPane availableScroll;
    protected JList availableList;
    private JButton helpButton;
    private JButton importButton;
    private JPanel addRemovePanel;
    private JButton addButton;
    private JButton removeButton;
    private JPanel inUsePanel;
    private JScrollPane inUseScroll;
    private JList inUseList;
    private JButton propsButton;
    private JPanel moveUpDownPanel;
    private JButton moveUpButton;
    private JButton moveDownButton;
    protected JButton copyButton;
    protected JButton pasteButton;

    public PieceDefiner() {
        PieceDefiner.initDefinitions();
        this.inUseModel = new DefaultListModel();
        this.r = new Renderer();
        this.slot = new PieceSlot();
        this.initComponents();
        this.availableList.setSelectedIndex(0);
        this.setChanged(false);
        this.gpidSupport = GameModule.getGameModule().getGpIdSupport();
    }

    public PieceDefiner(String id, GpIdSupport s) {
        this();
        this.pieceId = id;
        this.pieceIdLabel.setText("Id: " + id);
        this.gpidSupport = s;
    }

    public PieceDefiner(GpIdSupport s) {
        this();
        this.gpidSupport = s;
    }

    protected static void initDefinitions() {
        if (availableModel == null) {
            availableModel = new DefaultListModel();
            availableModel.addElement(new BasicPiece());
            availableModel.addElement(new Delete());
            availableModel.addElement(new Clone());
            availableModel.addElement(new Embellishment());
            availableModel.addElement(new UsePrototype());
            availableModel.addElement(new Labeler());
            availableModel.addElement(new ReportState());
            availableModel.addElement(new TriggerAction());
            availableModel.addElement(new GlobalHotKey());
            availableModel.addElement(new ActionButton());
            availableModel.addElement(new FreeRotator());
            availableModel.addElement(new Pivot());
            availableModel.addElement(new Hideable());
            availableModel.addElement(new Obscurable());
            availableModel.addElement(new SendToLocation());
            availableModel.addElement(new CounterGlobalKeyCommand());
            availableModel.addElement(new Translate());
            availableModel.addElement(new ReturnToDeck());
            availableModel.addElement(new Immobilized());
            availableModel.addElement(new PropertySheet());
            availableModel.addElement(new TableInfo());
            availableModel.addElement(new PlaceMarker());
            availableModel.addElement(new Replace());
            availableModel.addElement(new NonRectangular());
            availableModel.addElement(new PlaySound());
            availableModel.addElement(new MovementMarkable());
            availableModel.addElement(new Footprint());
            availableModel.addElement(new AreaOfEffect());
            availableModel.addElement(new SubMenu());
            availableModel.addElement(new RestrictCommands());
            availableModel.addElement(new Restricted());
            availableModel.addElement(new Marker());
            availableModel.addElement(new DynamicProperty());
            availableModel.addElement(new CalculatedProperty());
            availableModel.addElement(new SetGlobalProperty());
        }
    }

    public static void addDefinition(GamePiece definition) {
        PieceDefiner.initDefinitions();
        availableModel.addElement(definition);
    }

    public void setPiece(GamePiece piece) {
        this.inUseModel.clear();
        while (piece instanceof Decorator) {
            Class<?> pieceClass = piece.getClass();
            this.inUseModel.insertElementAt(piece, 0);
            boolean contains = false;
            int j = availableModel.size();
            for (int i = 0; i < j; ++i) {
                if (!pieceClass.isInstance(availableModel.elementAt(i))) continue;
                contains = true;
                break;
            }
            if (!contains) {
                try {
                    availableModel.addElement(pieceClass.getConstructor(new Class[0]).newInstance(new Object[0]));
                }
                catch (Throwable t) {
                    ReflectionUtils.handleNewInstanceFailure(t, pieceClass);
                }
            }
            piece = ((Decorator)piece).piece;
        }
        if (piece == null) {
            this.inUseModel.insertElementAt(new BasicPiece(), 0);
        } else {
            this.inUseModel.insertElementAt(piece, 0);
        }
        this.inUseList.setSelectedIndex(0);
        this.refresh();
    }

    @Override
    @Deprecated
    public void setBaseWindow(HelpWindow w) {
    }

    private void refresh() {
        this.piece = this.inUseModel.getSize() > 0 ? (GamePiece)this.inUseModel.lastElement() : null;
        this.slot.setPiece(this.piece);
        this.slot.getComponent().repaint();
    }

    public GamePiece getPiece() {
        return this.piece;
    }

    public void setChanged(boolean b) {
        this.changed = b;
    }

    public boolean isChanged() {
        return this.changed;
    }

    private void initComponents() {
        this.setLayout(new BoxLayout(this, 1));
        this.add(this.slot.getComponent());
        JPanel controls = new JPanel();
        controls.setLayout(new BoxLayout(controls, 0));
        this.availablePanel = new JPanel();
        this.availableScroll = new JScrollPane();
        this.availableList = new JList();
        this.helpButton = new JButton();
        this.importButton = new JButton();
        this.addRemovePanel = new JPanel();
        this.addButton = new JButton();
        this.removeButton = new JButton();
        this.inUsePanel = new JPanel();
        this.inUseScroll = new JScrollPane();
        this.inUseList = new JList();
        this.propsButton = new JButton();
        this.moveUpDownPanel = new JPanel();
        this.moveUpButton = new JButton();
        this.moveDownButton = new JButton();
        this.copyButton = new JButton();
        this.pasteButton = new JButton();
        this.availablePanel.setLayout(new BoxLayout(this.availablePanel, 1));
        this.availableList.setModel(availableModel);
        this.availableList.setSelectionMode(0);
        this.availableList.setCellRenderer(this.r);
        this.availableList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                Object o = PieceDefiner.this.availableList.getSelectedValue();
                PieceDefiner.this.helpButton.setEnabled(o instanceof EditablePiece && ((EditablePiece)o).getHelpFile() != null);
                PieceDefiner.this.addButton.setEnabled(o instanceof Decorator);
            }
        });
        this.availableScroll.setViewportView(this.availableList);
        this.availableScroll.setBorder(new TitledBorder("Available Traits"));
        this.availablePanel.add(this.availableScroll);
        this.helpButton.setText("Help");
        this.helpButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PieceDefiner.this.showHelpForPiece();
            }
        });
        this.availablePanel.add(this.helpButton);
        this.importButton.setText("Import");
        this.importButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                String className = JOptionPane.showInputDialog(PieceDefiner.this, (Object)"Enter fully-qualified name of Java class to import");
                PieceDefiner.this.importPiece(className);
            }
        });
        this.availablePanel.add(this.importButton);
        controls.add(this.availablePanel);
        this.addRemovePanel.setLayout(new BoxLayout(this.addRemovePanel, 1));
        this.addButton.setText("Add ->");
        this.addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Object selected = PieceDefiner.this.availableList.getSelectedValue();
                if (selected instanceof Decorator) {
                    if (PieceDefiner.this.inUseModel.getSize() > 0) {
                        Decorator c = (Decorator)selected;
                        PieceDefiner.this.addTrait(c);
                        if (PieceDefiner.this.inUseModel.lastElement().getClass() == c.getClass() && !PieceDefiner.this.edit(PieceDefiner.this.inUseModel.size() - 1) && !PieceDefiner.this.inUseModel.isEmpty()) {
                            PieceDefiner.this.removeTrait(PieceDefiner.this.inUseModel.size() - 1);
                        }
                    }
                } else if (selected instanceof GamePiece && PieceDefiner.this.inUseModel.getSize() == 0) {
                    GamePiece p = null;
                    try {
                        p = (GamePiece)selected.getClass().getConstructor(new Class[0]).newInstance(new Object[0]);
                    }
                    catch (Throwable t) {
                        ReflectionUtils.handleNewInstanceFailure(t, selected.getClass());
                    }
                    if (p != null) {
                        PieceDefiner.this.setPiece(p);
                        if (PieceDefiner.this.inUseModel.getSize() > 0 && !PieceDefiner.this.edit(0)) {
                            PieceDefiner.this.removeTrait(0);
                        }
                    }
                }
            }
        });
        this.addButton.setAlignmentX(0.5f);
        this.addRemovePanel.add(this.addButton);
        this.removeButton.setText("<- Remove");
        this.removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                int index = PieceDefiner.this.inUseList.getSelectedIndex();
                if (index >= 0) {
                    PieceDefiner.this.removeTrait(index);
                    if (PieceDefiner.this.inUseModel.getSize() > 0) {
                        PieceDefiner.this.inUseList.setSelectedIndex(Math.min(PieceDefiner.this.inUseModel.getSize() - 1, Math.max(index, 0)));
                    }
                }
            }
        });
        this.removeButton.setAlignmentX(0.5f);
        this.addRemovePanel.add(this.removeButton);
        this.pieceIdLabel.setAlignmentX(0.5f);
        this.addRemovePanel.add(this.pieceIdLabel);
        controls.add(this.addRemovePanel);
        this.inUsePanel.setLayout(new BoxLayout(this.inUsePanel, 1));
        this.inUseList.setModel(this.inUseModel);
        this.inUseList.setSelectionMode(0);
        this.inUseList.setCellRenderer(this.r);
        this.inUseList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                Object o = PieceDefiner.this.inUseList.getSelectedValue();
                PieceDefiner.this.propsButton.setEnabled(o instanceof EditablePiece);
                int index = PieceDefiner.this.inUseList.getSelectedIndex();
                boolean copyAndRemove = PieceDefiner.this.inUseModel.size() > 0 && (index > 0 || !(PieceDefiner.this.inUseModel.getElementAt(0) instanceof BasicPiece));
                PieceDefiner.this.copyButton.setEnabled(copyAndRemove);
                PieceDefiner.this.removeButton.setEnabled(copyAndRemove);
                PieceDefiner.this.pasteButton.setEnabled(clipBoard != null);
                PieceDefiner.this.moveUpButton.setEnabled(index > 1);
                PieceDefiner.this.moveDownButton.setEnabled(index > 0 && index < PieceDefiner.this.inUseModel.size() - 1);
            }
        });
        this.inUseList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                int index;
                if (e.getClickCount() == 2 && SwingUtils.isLeftMouseButton(e) && (index = PieceDefiner.this.inUseList.locationToIndex(e.getPoint())) >= 0) {
                    PieceDefiner.this.edit(index);
                }
            }
        });
        this.inUseScroll.setViewportView(this.inUseList);
        this.inUseScroll.setBorder(new TitledBorder("Current Traits"));
        this.inUsePanel.add(this.inUseScroll);
        this.propsButton.setText("Properties");
        this.propsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                int index = PieceDefiner.this.inUseList.getSelectedIndex();
                if (index >= 0) {
                    PieceDefiner.this.edit(index);
                }
            }
        });
        this.inUsePanel.add(this.propsButton);
        controls.add(this.inUsePanel);
        this.moveUpDownPanel.setLayout(new BoxLayout(this.moveUpDownPanel, 1));
        this.moveUpButton.setText("Move Up");
        this.moveUpButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                int index = PieceDefiner.this.inUseList.getSelectedIndex();
                if (index > 1 && index < PieceDefiner.this.inUseModel.size()) {
                    PieceDefiner.this.moveDecoratorUp(index);
                }
            }
        });
        this.moveUpDownPanel.add(this.moveUpButton);
        this.moveDownButton.setText("Move Down");
        this.moveDownButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                int index = PieceDefiner.this.inUseList.getSelectedIndex();
                if (index > 0 && index < PieceDefiner.this.inUseModel.size() - 1) {
                    PieceDefiner.this.moveDecoratorDown(index);
                }
            }
        });
        this.moveUpDownPanel.add(this.moveDownButton);
        this.copyButton.setText("Copy");
        this.copyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PieceDefiner.this.pasteButton.setEnabled(true);
                int index = PieceDefiner.this.inUseList.getSelectedIndex();
                clipBoard = new TraitClipboard((Decorator)PieceDefiner.this.inUseModel.get(index));
            }
        });
        this.moveUpDownPanel.add(this.copyButton);
        this.pasteButton.setText("Paste");
        this.pasteButton.setEnabled(clipBoard != null);
        this.pasteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                if (clipBoard != null) {
                    PieceDefiner.this.paste();
                }
            }
        });
        this.moveUpDownPanel.add(this.pasteButton);
        controls.add(this.moveUpDownPanel);
        this.add(controls);
    }

    protected void paste() {
        Decorator c = (Decorator)GameModule.getGameModule().createPiece(clipBoard.getType(), null);
        if (c instanceof PlaceMarker) {
            ((PlaceMarker)c).updateGpId(GameModule.getGameModule().getGpIdSupport());
        }
        c.setInner((GamePiece)this.inUseModel.lastElement());
        this.inUseModel.addElement(c);
        c.mySetState(clipBoard.getState());
        this.refresh();
    }

    protected void moveDecoratorDown(int index) {
        GamePiece selm1 = (GamePiece)this.inUseModel.elementAt(index - 1);
        Decorator sel = (Decorator)this.inUseModel.elementAt(index);
        Decorator selp1 = (Decorator)this.inUseModel.elementAt(index + 1);
        Decorator selp2 = index < this.inUseModel.size() - 2 ? (Decorator)this.inUseModel.elementAt(index + 2) : null;
        selp1.setInner(selm1);
        sel.setInner(selp1);
        if (selp2 != null) {
            selp2.setInner(sel);
        }
        this.inUseModel.setElementAt(selp1, index);
        this.inUseModel.setElementAt(sel, index + 1);
        ((GamePiece)this.inUseModel.lastElement()).setProperty("Outer", null);
        this.inUseList.setSelectedIndex(index + 1);
        this.refresh();
        this.setChanged(true);
    }

    protected void moveDecoratorUp(int index) {
        GamePiece selm2 = (GamePiece)this.inUseModel.elementAt(index - 2);
        Decorator sel = (Decorator)this.inUseModel.elementAt(index);
        Decorator selm1 = (Decorator)this.inUseModel.elementAt(index - 1);
        Decorator selp1 = index < this.inUseModel.size() - 1 ? (Decorator)this.inUseModel.elementAt(index + 1) : null;
        sel.setInner(selm2);
        selm1.setInner(sel);
        if (selp1 != null) {
            selp1.setInner(selm1);
        }
        this.inUseModel.setElementAt(selm1, index);
        this.inUseModel.setElementAt(sel, index - 1);
        ((GamePiece)this.inUseModel.lastElement()).setProperty("Outer", null);
        this.inUseList.setSelectedIndex(index - 1);
        this.refresh();
        this.setChanged(true);
    }

    protected void importPiece(String className) {
        if (className == null) {
            return;
        }
        Object o = null;
        try {
            o = GameModule.getGameModule().getDataArchive().loadClass(className).getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Throwable t) {
            ReflectionUtils.handleImportClassFailure(t, className);
        }
        if (o == null) {
            return;
        }
        if (o instanceof GamePiece) {
            availableModel.addElement(o);
        } else {
            ErrorDialog.show("Error.not_a_gamepiece", className);
        }
    }

    private void showHelpForPiece() {
        Object o = this.availableList.getSelectedValue();
        if (o instanceof EditablePiece) {
            HelpFile h = ((EditablePiece)o).getHelpFile();
            BrowserSupport.openURL(h.getContents().toString());
        }
    }

    protected boolean edit(int index) {
        Object o = this.inUseModel.elementAt(index);
        if (!(o instanceof EditablePiece)) {
            return false;
        }
        EditablePiece p = (EditablePiece)o;
        if (p.getEditor() != null) {
            Ed ed = null;
            Window w = SwingUtilities.getWindowAncestor(this);
            ed = w instanceof Frame ? new Ed((Frame)w, p) : (w instanceof Dialog ? new Ed((Dialog)w, p) : new Ed((Frame)null, p));
            String oldState = p.getState();
            String oldType = p.getType();
            ed.setVisible(true);
            PieceEditor c = ed.getEditor();
            if (c != null) {
                p.mySetType(c.getType());
                if (p instanceof Decorator) {
                    ((Decorator)((Object)p)).mySetState(c.getState());
                } else {
                    p.setState(c.getState());
                }
                if (!p.getType().equals(oldType) || !p.getState().equals(oldState)) {
                    this.setChanged(true);
                }
                this.refresh();
                return true;
            }
        }
        return false;
    }

    protected void removeTrait(int index) {
        this.inUseModel.removeElementAt(index);
        if (index < this.inUseModel.size()) {
            ((Decorator)this.inUseModel.elementAt(index)).setInner((GamePiece)this.inUseModel.elementAt(index - 1));
        }
        this.refresh();
        this.setChanged(true);
    }

    protected void addTrait(Decorator c) {
        Class<?> cClass = c.getClass();
        Decorator d = null;
        try {
            d = (Decorator)cClass.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Throwable t) {
            ReflectionUtils.handleNewInstanceFailure(t, cClass);
        }
        if (d != null) {
            if (d instanceof PlaceMarker) {
                ((PlaceMarker)d).updateGpId(this.gpidSupport);
            }
            d.setInner((GamePiece)this.inUseModel.lastElement());
            this.inUseModel.addElement(d);
            this.setChanged(true);
        }
        this.refresh();
    }

    private static class Renderer
    extends DefaultListCellRenderer {
        private static final long serialVersionUID = 1L;

        private Renderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean selected, boolean hasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, index, selected, hasFocus);
            if (value instanceof EditablePiece) {
                this.setText(((EditablePiece)value).getDescription());
            } else {
                String s = value.getClass().getName();
                this.setText(s.substring(s.lastIndexOf(46) + 1));
            }
            return this;
        }
    }

    private static class TraitClipboard {
        private String type;
        private String state;

        public TraitClipboard(Decorator copy) {
            this.type = copy.myGetType();
            this.state = copy.myGetState();
        }

        public String getType() {
            return this.type;
        }

        public String getState() {
            return this.state;
        }
    }

    protected static class Ed
    extends JDialog {
        private static final long serialVersionUID = 1L;
        PieceEditor ed;

        private Ed(Frame owner, EditablePiece p) {
            super(owner, p.getDescription() + " properties", true);
            this.initialize(p);
        }

        private Ed(Dialog owner, EditablePiece p) {
            super(owner, p.getDescription() + " properties", true);
            this.initialize(p);
        }

        private void initialize(final EditablePiece p) {
            this.ed = p.getEditor();
            this.setLayout((LayoutManager)new MigLayout("ins dialog,fill", "[]unrel[]", ""));
            this.add(this.ed.getControls(), "spanx 3,grow,push,wrap");
            JButton b = new JButton("Ok");
            b.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    this.dispose();
                }
            });
            this.add((Component)b, "tag ok");
            b = new JButton("Cancel");
            b.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    ed = null;
                    this.dispose();
                }
            });
            this.add((Component)b, "tag cancel");
            if (p.getHelpFile() != null) {
                b = new JButton("Help");
                b.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent evt) {
                        p.getHelpFile().showWindow(this);
                    }
                });
                this.add((Component)b, "tag help");
            }
            this.pack();
            this.setLocationRelativeTo(this.getOwner());
        }

        public PieceEditor getEditor() {
            return this.ed;
        }
    }
}

