/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.counters;

import VASSAL.build.Configurable;
import VASSAL.build.GameModule;
import VASSAL.build.GpIdSupport;
import VASSAL.build.module.Chatter;
import VASSAL.build.module.Map;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.build.widget.CardSlot;
import VASSAL.build.widget.PieceSlot;
import VASSAL.command.AddPiece;
import VASSAL.command.ChangeTracker;
import VASSAL.command.Command;
import VASSAL.configure.BooleanConfigurer;
import VASSAL.configure.ChooseComponentPathDialog;
import VASSAL.configure.ConfigurerWindow;
import VASSAL.configure.IntConfigurer;
import VASSAL.configure.NamedHotKeyConfigurer;
import VASSAL.configure.StringConfigurer;
import VASSAL.counters.BasicPiece;
import VASSAL.counters.Decorator;
import VASSAL.counters.FreeRotator;
import VASSAL.counters.GamePiece;
import VASSAL.counters.KeyBuffer;
import VASSAL.counters.KeyCommand;
import VASSAL.counters.PieceCloner;
import VASSAL.counters.PieceEditor;
import VASSAL.counters.Stack;
import VASSAL.i18n.PieceI18nData;
import VASSAL.i18n.Resources;
import VASSAL.i18n.TranslatablePiece;
import VASSAL.tools.ComponentPathBuilder;
import VASSAL.tools.NamedKeyStroke;
import VASSAL.tools.SequenceEncoder;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.util.stream.Stream;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;

public class PlaceMarker
extends Decorator
implements TranslatablePiece {
    public static final String ID = "placemark;";
    protected KeyCommand command;
    protected NamedKeyStroke key;
    protected String markerSpec;
    protected String markerText = "";
    protected int xOffset = 0;
    protected int yOffset = 0;
    protected boolean matchRotation = false;
    protected KeyCommand[] commands;
    protected NamedKeyStroke afterBurnerKey;
    protected String description = "";
    protected String gpId = "";
    protected String newGpId;
    protected GpIdSupport gpidSupport;
    protected static final int STACK_TOP = 0;
    protected static final int STACK_BOTTOM = 1;
    protected static final int ABOVE = 2;
    protected static final int BELOW = 3;
    protected int placement = 0;
    protected boolean above;

    public PlaceMarker() {
        this("placemark;Place Marker;M;null;null;null", null);
    }

    public PlaceMarker(String type, GamePiece inner) {
        this.mySetType(type);
        this.setInner(inner);
    }

    @Override
    public Rectangle boundingBox() {
        return this.piece.boundingBox();
    }

    @Override
    public void draw(Graphics g, int x, int y, Component obs, double zoom) {
        this.piece.draw(g, x, y, obs, zoom);
    }

    @Override
    public String getName() {
        return this.piece.getName();
    }

    @Override
    protected KeyCommand[] myGetKeyCommands() {
        this.command.setEnabled(this.getMap() != null && this.markerSpec != null);
        return this.commands;
    }

    @Override
    public String myGetState() {
        return "";
    }

    @Override
    public String myGetType() {
        SequenceEncoder se = new SequenceEncoder(';');
        se.append(this.command.getName()).append(this.key).append(this.markerSpec == null ? "null" : this.markerSpec).append(this.markerText == null ? "null" : this.markerText).append(this.xOffset).append(this.yOffset).append(this.matchRotation).append(this.afterBurnerKey).append(this.description).append(this.gpId).append(this.placement).append(this.above);
        return ID + se.getValue();
    }

    @Override
    public Command myKeyEvent(KeyStroke stroke) {
        this.myGetKeyCommands();
        if (this.command.matches(stroke)) {
            return this.placeMarker();
        }
        return null;
    }

    protected Command placeMarker() {
        String location;
        Map m = this.getMap();
        if (m == null) {
            return null;
        }
        GamePiece marker = this.createMarker();
        if (marker == null) {
            return null;
        }
        Command c = null;
        GamePiece outer = PlaceMarker.getOutermost(this);
        Point p = this.getPosition();
        p.translate(this.xOffset, -this.yOffset);
        if (this.matchRotation) {
            FreeRotator myRotation = (FreeRotator)Decorator.getDecorator(outer, FreeRotator.class);
            FreeRotator markerRotation = (FreeRotator)Decorator.getDecorator(marker, FreeRotator.class);
            if (myRotation != null && markerRotation != null) {
                markerRotation.setAngle(myRotation.getAngle());
                Point myPosition = this.getPosition().getLocation();
                Point2D markerPosition = p.getLocation();
                markerPosition = AffineTransform.getRotateInstance(myRotation.getAngleInRadians(), ((Point2D)myPosition).getX(), ((Point2D)myPosition).getY()).transform(markerPosition, null);
                p = new Point((int)markerPosition.getX(), (int)markerPosition.getY());
            }
        }
        if (!Boolean.TRUE.equals(marker.getProperty("IgnoreGrid"))) {
            p = this.getMap().snapTo(p);
        }
        if (m.getStackMetrics().isStackingEnabled() && !Boolean.TRUE.equals(marker.getProperty("NoStack")) && !Boolean.TRUE.equals(outer.getProperty("NoStack")) && m.getPieceCollection().canMerge(outer, marker)) {
            Stack parent = this.getParent();
            GamePiece target = outer;
            int index = -1;
            switch (this.placement) {
                case 2: {
                    target = outer;
                    break;
                }
                case 3: {
                    index = parent == null ? 0 : parent.indexOf(outer);
                    break;
                }
                case 1: {
                    index = 0;
                    break;
                }
                case 0: {
                    target = parent == null ? outer : parent;
                }
            }
            c = m.getStackMetrics().merge(target, marker);
            if (index >= 0) {
                ChangeTracker ct = new ChangeTracker(parent);
                parent.insert(marker, index);
                c = c.append(ct.getChangeCommand());
            }
        } else {
            c = m.placeAt(marker, p);
        }
        if (this.afterBurnerKey != null && !this.afterBurnerKey.isNull()) {
            marker.setProperty("snapshot", PieceCloner.getInstance().clonePiece(marker));
            c.append(marker.keyEvent(this.afterBurnerKey.getKeyStroke()));
        }
        if (this.getProperty("Selected") == Boolean.TRUE) {
            this.selectMarker(marker);
        }
        if (this.markerText != null && Stream.of("ObscuredToOthers", "Obscured", "InvisibleToOthers").noneMatch(s -> Boolean.TRUE.equals(outer.getProperty(s))) && (location = m.locationName(this.getPosition())) != null) {
            Chatter.DisplayText display = new Chatter.DisplayText(GameModule.getGameModule().getChatter(), " * " + location + ":  " + outer.getName() + " " + this.markerText + " * ");
            display.execute();
            c = c == null ? display : c.append(display);
        }
        return c;
    }

    protected void selectMarker(GamePiece marker) {
        if (marker.getProperty("selectEventFilter") == null && marker.getParent() != null && marker.getParent().equals(this.getParent())) {
            KeyBuffer.getBuffer().add(marker);
        }
    }

    public GamePiece createMarker() {
        GamePiece piece = this.createBaseMarker();
        if (piece == null) {
            piece = new BasicPiece();
            this.newGpId = this.getGpId();
        } else {
            piece = PieceCloner.getInstance().clonePiece(piece);
        }
        piece.setProperty("PieceId", this.newGpId);
        return piece;
    }

    public GamePiece createBaseMarker() {
        if (this.markerSpec == null) {
            return null;
        }
        GamePiece piece = null;
        if (this.isMarkerStandalone()) {
            AddPiece comm = (AddPiece)GameModule.getGameModule().decode(this.markerSpec);
            piece = comm.getTarget();
            piece.setState(comm.getState());
            this.newGpId = this.getGpId();
        } else {
            try {
                Configurable[] c = ComponentPathBuilder.getInstance().getPath(this.markerSpec);
                Configurable conf = c[c.length - 1];
                if (conf instanceof PieceSlot) {
                    piece = ((PieceSlot)conf).getPiece();
                    this.newGpId = ((PieceSlot)conf).getGpId();
                }
            }
            catch (ComponentPathBuilder.PathFormatException e) {
                PlaceMarker.reportDataError(this, Resources.getString("Resources.place_error"), e.getMessage() + " markerSpec=" + this.markerSpec, e);
            }
        }
        return piece;
    }

    public boolean isMarkerStandalone() {
        return this.markerSpec != null && this.markerSpec.startsWith("+/");
    }

    @Override
    public void mySetState(String newState) {
    }

    @Override
    public Shape getShape() {
        return this.piece.getShape();
    }

    @Override
    public String getDescription() {
        Object d = "Place Marker";
        if (this.description.length() > 0) {
            d = (String)d + " - " + this.description;
        }
        return d;
    }

    @Override
    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("Marker.htm");
    }

    @Override
    public void mySetType(String type) {
        SequenceEncoder.Decoder st = new SequenceEncoder.Decoder(type, ';');
        st.nextToken();
        String name = st.nextToken();
        this.key = st.nextNamedKeyStroke(null);
        this.command = new KeyCommand(name, this.key, (GamePiece)this, (TranslatablePiece)this);
        this.commands = name.length() > 0 && this.key != null ? new KeyCommand[]{this.command} : new KeyCommand[0];
        this.markerSpec = st.nextToken();
        if ("null".equals(this.markerSpec)) {
            this.markerSpec = null;
        }
        this.markerText = st.nextToken("null");
        if ("null".equals(this.markerText)) {
            this.markerText = null;
        }
        this.xOffset = st.nextInt(0);
        this.yOffset = st.nextInt(0);
        this.matchRotation = st.nextBoolean(false);
        this.afterBurnerKey = st.nextNamedKeyStroke(null);
        this.description = st.nextToken("");
        this.setGpId(st.nextToken(""));
        this.placement = st.nextInt(0);
        this.above = st.nextBoolean(false);
        this.gpidSupport = GameModule.getGameModule().getGpIdSupport();
    }

    @Override
    public PieceEditor getEditor() {
        return new Ed(this);
    }

    @Override
    public PieceI18nData getI18nData() {
        return this.getI18nData(this.command.getName(), this.getCommandDescription(this.description, "Place Marker command"));
    }

    public String getGpId() {
        return this.gpId;
    }

    public void setGpId(String s) {
        this.gpId = s;
    }

    public void updateGpId(GpIdSupport s) {
        this.gpidSupport = s;
        this.updateGpId();
    }

    public void updateGpId() {
        this.setGpId(this.gpidSupport.generateGpId());
    }

    protected static class Ed
    implements PieceEditor {
        private NamedHotKeyConfigurer keyInput;
        private StringConfigurer commandInput;
        private PieceSlot pieceInput;
        private JPanel p = new JPanel();
        private String markerSlotPath;
        protected JButton defineButton = new JButton("Define Marker");
        protected JButton selectButton = new JButton("Select");
        protected IntConfigurer xOffsetConfig = new IntConfigurer(null, "Horizontal offset:  ");
        protected IntConfigurer yOffsetConfig = new IntConfigurer(null, "Vertical offset:  ");
        protected BooleanConfigurer matchRotationConfig = this.createMatchRotationConfig();
        protected BooleanConfigurer aboveConfig = this.createAboveConfig();
        protected JComboBox<String> placementConfig;
        protected NamedHotKeyConfigurer afterBurner;
        protected StringConfigurer descConfig;
        private String slotId;

        protected Ed(PlaceMarker piece) {
            this.descConfig = new StringConfigurer(null, "Description:  ", piece.description);
            this.keyInput = new NamedHotKeyConfigurer(null, "Keyboard Command:  ", piece.key);
            this.afterBurner = new NamedHotKeyConfigurer(null, "Keystroke to apply after placement:  ", piece.afterBurnerKey);
            this.commandInput = new StringConfigurer(null, "Command:  ", piece.command.getName());
            GamePiece marker = piece.createBaseMarker();
            this.pieceInput = new PieceSlot(marker);
            this.pieceInput.updateGpId(piece.gpidSupport);
            this.pieceInput.setGpId(piece.getGpId());
            this.markerSlotPath = piece.markerSpec;
            this.p = new JPanel();
            this.p.setLayout(new BoxLayout(this.p, 1));
            this.p.add(this.descConfig.getControls());
            this.p.add(this.commandInput.getControls());
            this.p.add(this.keyInput.getControls());
            Box b = Box.createHorizontalBox();
            b.add(this.pieceInput.getComponent());
            this.defineButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    markerSlotPath = null;
                    new ConfigurerWindow(pieceInput.getConfigurer()).setVisible(true);
                }
            });
            b.add(this.defineButton);
            this.selectButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ChoosePieceDialog d = new ChoosePieceDialog((Frame)SwingUtilities.getAncestorOfClass(Frame.class, p), PieceSlot.class);
                    d.setVisible(true);
                    if (d.getTarget() instanceof PieceSlot) {
                        pieceInput.setPiece(((PieceSlot)d.getTarget()).getPiece());
                    }
                    if (d.getPath() != null) {
                        markerSlotPath = ComponentPathBuilder.getInstance().getId(d.getPath());
                        slotId = "";
                    } else {
                        markerSlotPath = null;
                    }
                }
            });
            b.add(this.selectButton);
            this.p.add(b);
            this.xOffsetConfig.setValue(piece.xOffset);
            this.p.add(this.xOffsetConfig.getControls());
            this.yOffsetConfig.setValue(piece.yOffset);
            this.p.add(this.yOffsetConfig.getControls());
            this.matchRotationConfig.setValue(piece.matchRotation);
            this.p.add(this.matchRotationConfig.getControls());
            if (this.aboveConfig != null) {
                this.aboveConfig.setValue(piece.above);
                this.p.add(this.aboveConfig.getControls());
                ((JCheckBox)this.matchRotationConfig.getControls()).addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        aboveConfig.getControls().setVisible(((JCheckBox)matchRotationConfig.getControls()).isSelected());
                    }
                });
                this.aboveConfig.getControls().setVisible(piece.matchRotation);
            }
            this.placementConfig = new JComboBox<String>(new String[]{"On top of stack", "On bottom of stack", "Above this piece", "Below this piece"});
            this.placementConfig.setSelectedIndex(piece.placement);
            Box placementBox = Box.createHorizontalBox();
            placementBox.add(new JLabel("Place marker:  "));
            placementBox.add(this.placementConfig);
            this.p.add(placementBox);
            this.p.add(this.afterBurner.getControls());
            this.slotId = piece.getGpId();
        }

        protected BooleanConfigurer createMatchRotationConfig() {
            return new BooleanConfigurer(null, "Match Rotation?");
        }

        protected BooleanConfigurer createAboveConfig() {
            return null;
        }

        @Override
        public Component getControls() {
            return this.p;
        }

        @Override
        public String getState() {
            return "";
        }

        @Override
        public String getType() {
            SequenceEncoder se = new SequenceEncoder(';');
            se.append(this.commandInput.getValueString());
            se.append(this.keyInput.getValueString());
            if (this.pieceInput.getPiece() == null) {
                se.append("null");
            } else if (this.markerSlotPath != null) {
                se.append(this.markerSlotPath);
            } else {
                String spec = GameModule.getGameModule().encode(new AddPiece(this.pieceInput.getPiece()));
                se.append(spec);
            }
            se.append("null");
            se.append(this.xOffsetConfig.getValueString());
            se.append(this.yOffsetConfig.getValueString());
            se.append(this.matchRotationConfig.getValueString());
            se.append(this.afterBurner.getValueString());
            se.append(this.descConfig.getValueString());
            se.append(this.slotId);
            se.append(this.placementConfig.getSelectedIndex());
            se.append(this.aboveConfig == null ? "false" : this.aboveConfig.getValueString());
            return PlaceMarker.ID + se.getValue();
        }

        public static class ChoosePieceDialog
        extends ChooseComponentPathDialog {
            private static final long serialVersionUID = 1L;

            public ChoosePieceDialog(Frame owner, Class<PieceSlot> targetClass) {
                super(owner, targetClass);
            }

            @Override
            protected boolean isValidTarget(Object selected) {
                return super.isValidTarget(selected) || CardSlot.class.isInstance(selected);
            }
        }
    }
}

