/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.counters;

import VASSAL.build.GameModule;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.command.Command;
import VASSAL.command.PlayAudioClipCommand;
import VASSAL.configure.AudioClipConfigurer;
import VASSAL.configure.BooleanConfigurer;
import VASSAL.configure.NamedHotKeyConfigurer;
import VASSAL.configure.StringConfigurer;
import VASSAL.counters.Decorator;
import VASSAL.counters.GamePiece;
import VASSAL.counters.KeyCommand;
import VASSAL.counters.PieceEditor;
import VASSAL.i18n.PieceI18nData;
import VASSAL.i18n.Resources;
import VASSAL.i18n.TranslatablePiece;
import VASSAL.tools.AudioClip;
import VASSAL.tools.FormattedString;
import VASSAL.tools.NamedKeyStroke;
import VASSAL.tools.SequenceEncoder;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import java.io.IOException;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.KeyStroke;

public class PlaySound
extends Decorator
implements TranslatablePiece {
    public static final String ID = "playSound;";
    protected String menuText;
    protected NamedKeyStroke stroke;
    protected boolean sendToOthers;
    protected KeyCommand command;
    protected KeyCommand[] commands;
    protected FormattedString format = new FormattedString();

    public PlaySound() {
        this(ID, null);
    }

    public PlaySound(String type, GamePiece piece) {
        this.mySetType(type);
        this.setInner(piece);
    }

    @Override
    public void mySetState(String newState) {
    }

    @Override
    public String myGetState() {
        return "";
    }

    @Override
    public String myGetType() {
        SequenceEncoder se = new SequenceEncoder(';');
        se.append(this.format.getFormat()).append(this.menuText).append(this.stroke).append(this.sendToOthers);
        return ID + se.getValue();
    }

    @Override
    protected KeyCommand[] myGetKeyCommands() {
        if (this.commands == null) {
            this.command = new KeyCommand(this.menuText, this.stroke, Decorator.getOutermost(this), (TranslatablePiece)this);
            this.commands = this.menuText.length() > 0 && this.stroke != null && !this.stroke.isNull() ? new KeyCommand[]{this.command} : new KeyCommand[0];
        }
        return this.commands;
    }

    @Override
    public Command myKeyEvent(KeyStroke stroke) {
        this.myGetKeyCommands();
        PlayAudioClipCommand c = null;
        if (this.command.matches(stroke)) {
            String clipName = this.format.getText(Decorator.getOutermost(this));
            c = new PlayAudioClipCommand(clipName);
            try {
                AudioClip clip = GameModule.getGameModule().getDataArchive().getCachedAudioClip(clipName);
                if (clip != null) {
                    clip.play();
                }
            }
            catch (IOException e) {
                PlaySound.reportDataError(this, Resources.getString("Error.not_found", "Audio Clip"), "Clip=" + clipName, e);
            }
        }
        return c;
    }

    @Override
    public void draw(Graphics g, int x, int y, Component obs, double zoom) {
        this.piece.draw(g, x, y, obs, zoom);
    }

    @Override
    public Rectangle boundingBox() {
        return this.piece.boundingBox();
    }

    @Override
    public Shape getShape() {
        return this.piece.getShape();
    }

    @Override
    public String getName() {
        return this.piece.getName();
    }

    @Override
    public String getDescription() {
        return this.format.getFormat().length() == 0 ? "Play Sound" : "Play Sound - " + this.format.getFormat();
    }

    @Override
    public void mySetType(String type) {
        SequenceEncoder.Decoder st = new SequenceEncoder.Decoder(type, ';');
        st.nextToken();
        this.format = new FormattedString(st.nextToken(""));
        this.menuText = st.nextToken("Play Sound");
        this.stroke = st.nextNamedKeyStroke('P');
        this.sendToOthers = st.nextBoolean(false);
        this.commands = null;
    }

    @Override
    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("PlaySound.htm");
    }

    @Override
    public PieceEditor getEditor() {
        return new Ed(this);
    }

    @Override
    public PieceI18nData getI18nData() {
        return this.getI18nData(this.menuText, "Play Sound command");
    }

    public static class Ed
    implements PieceEditor {
        private StringConfigurer menuConfig;
        private NamedHotKeyConfigurer keyConfig;
        private AudioClipConfigurer soundConfig;
        private BooleanConfigurer sendConfig;
        private JPanel panel;

        public Ed(PlaySound p) {
            this.menuConfig = new StringConfigurer(null, "Menu Text:  ", p.menuText);
            this.keyConfig = new NamedHotKeyConfigurer(null, "Keyboard Command:  ", p.stroke);
            this.soundConfig = new AudioClipConfigurer(null, "Sound Clip:  ", GameModule.getGameModule().getArchiveWriter());
            this.soundConfig.setValue(p.format.getFormat());
            this.soundConfig.setEditable(true);
            this.sendConfig = new BooleanConfigurer(null, "Send sound to other players?", p.sendToOthers);
            this.panel = new JPanel();
            this.panel.setLayout(new BoxLayout(this.panel, 1));
            this.panel.add(this.menuConfig.getControls());
            this.panel.add(this.keyConfig.getControls());
            this.panel.add(this.soundConfig.getControls());
            this.panel.add(this.sendConfig.getControls());
        }

        @Override
        public Component getControls() {
            return this.panel;
        }

        @Override
        public String getType() {
            SequenceEncoder se = new SequenceEncoder(';');
            se.append(this.soundConfig.getValueString()).append(this.menuConfig.getValueString()).append(this.keyConfig.getValueString()).append(this.sendConfig.getValueString());
            return PlaySound.ID + se.getValue();
        }

        @Override
        public String getState() {
            return "";
        }
    }
}

