/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.counters;

import VASSAL.build.module.documentation.HelpFile;
import VASSAL.command.Command;
import VASSAL.configure.NamedKeyStrokeArrayConfigurer;
import VASSAL.configure.PropertyExpression;
import VASSAL.configure.PropertyExpressionConfigurer;
import VASSAL.configure.StringConfigurer;
import VASSAL.counters.Decorator;
import VASSAL.counters.EditablePiece;
import VASSAL.counters.GamePiece;
import VASSAL.counters.KeyCommand;
import VASSAL.counters.PieceEditor;
import VASSAL.tools.NamedKeyStroke;
import VASSAL.tools.SequenceEncoder;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import java.util.ArrayList;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;

public class RestrictCommands
extends Decorator
implements EditablePiece {
    public static final String ID = "hideCmd;";
    protected static final String HIDE = "Hide";
    protected static final String DISABLE = "Disable";
    protected String name = "";
    protected PropertyExpression propertyMatch = new PropertyExpression();
    protected String action = "Hide";
    protected NamedKeyStroke[] watchKeys = new NamedKeyStroke[0];

    public RestrictCommands() {
        this(ID, null);
    }

    public RestrictCommands(String type, GamePiece inner) {
        this.mySetType(type);
        this.setInner(inner);
    }

    @Override
    public Rectangle boundingBox() {
        return this.piece.boundingBox();
    }

    @Override
    public void draw(Graphics g, int x, int y, Component obs, double zoom) {
        this.piece.draw(g, x, y, obs, zoom);
    }

    @Override
    public String getName() {
        return this.piece.getName();
    }

    @Override
    protected KeyCommand[] myGetKeyCommands() {
        return new KeyCommand[0];
    }

    @Override
    public String myGetState() {
        return "";
    }

    @Override
    public String myGetType() {
        SequenceEncoder se = new SequenceEncoder(';');
        se.append(this.name).append(this.action).append(this.propertyMatch.getExpression()).append(NamedKeyStrokeArrayConfigurer.encode(this.watchKeys));
        return ID + se.getValue();
    }

    @Override
    public Command myKeyEvent(KeyStroke stroke) {
        return null;
    }

    @Override
    public Command keyEvent(KeyStroke stroke) {
        if (!this.matchesFilter()) {
            return super.keyEvent(stroke);
        }
        for (NamedKeyStroke watchKey : this.watchKeys) {
            if (!watchKey.equals(stroke)) continue;
            return null;
        }
        return super.keyEvent(stroke);
    }

    @Override
    protected KeyCommand[] getKeyCommands() {
        KeyCommand[] commands = super.getKeyCommands();
        ArrayList<KeyCommand> newCommands = new ArrayList<KeyCommand>(commands.length);
        if (this.matchesFilter()) {
            for (KeyCommand command : commands) {
                boolean matches = false;
                for (int j = 0; j < this.watchKeys.length && !matches; ++j) {
                    matches = this.watchKeys[j].equals(command.getKeyStroke());
                }
                if (matches) {
                    if (!this.action.equals(DISABLE)) continue;
                    KeyCommand newCommand = new KeyCommand(command);
                    newCommand.setEnabled(false);
                    newCommands.add(newCommand);
                    continue;
                }
                newCommands.add(command);
            }
            commands = newCommands.toArray(new KeyCommand[0]);
        }
        return commands;
    }

    protected boolean matchesFilter() {
        GamePiece outer = Decorator.getOutermost(this);
        return this.propertyMatch.isNull() || this.propertyMatch.accept(outer);
    }

    @Override
    public void mySetState(String newState) {
    }

    @Override
    public Shape getShape() {
        return this.piece.getShape();
    }

    @Override
    public String getDescription() {
        Object s = "Restrict Commands";
        if (this.name.length() > 0) {
            s = (String)s + " - " + this.name;
        }
        return s;
    }

    @Override
    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("RestrictCommands.htm");
    }

    @Override
    public void mySetType(String type) {
        SequenceEncoder.Decoder st = new SequenceEncoder.Decoder(type, ';');
        st.nextToken();
        this.name = st.nextToken("");
        this.action = st.nextToken(HIDE);
        this.propertyMatch.setExpression(st.nextToken(""));
        String keys = st.nextToken("");
        if (keys.indexOf(44) > 0) {
            this.watchKeys = NamedKeyStrokeArrayConfigurer.decode(keys);
        } else {
            this.watchKeys = new NamedKeyStroke[keys.length()];
            for (int i = 0; i < this.watchKeys.length; ++i) {
                this.watchKeys[i] = new NamedKeyStroke(keys.charAt(i), 128);
            }
        }
    }

    @Override
    public PieceEditor getEditor() {
        return new Ed(this);
    }

    public static class Ed
    implements PieceEditor {
        protected StringConfigurer name;
        protected PropertyExpressionConfigurer propertyMatch;
        protected NamedKeyStrokeArrayConfigurer watchKeys;
        protected JComboBox actionOption;
        protected JPanel box = new JPanel();

        public Ed(RestrictCommands piece) {
            this.box.setLayout(new BoxLayout(this.box, 1));
            this.name = new StringConfigurer(null, "Description:  ", piece.name);
            this.box.add(this.name.getControls());
            this.actionOption = new JComboBox();
            this.actionOption.addItem(RestrictCommands.HIDE);
            this.actionOption.addItem(RestrictCommands.DISABLE);
            this.actionOption.setSelectedIndex(piece.action.equals(RestrictCommands.HIDE) ? 0 : 1);
            Box b = Box.createHorizontalBox();
            b.add(new JLabel("Restriction:  "));
            b.add(this.actionOption);
            this.box.add(b);
            this.propertyMatch = new PropertyExpressionConfigurer(null, "Restrict when properties match:  ", piece.propertyMatch, Decorator.getOutermost(piece));
            this.box.add(this.propertyMatch.getControls());
            this.watchKeys = new NamedKeyStrokeArrayConfigurer(null, "Restrict these Key Commands  ", piece.watchKeys);
            this.box.add(this.watchKeys.getControls());
        }

        @Override
        public Component getControls() {
            return this.box;
        }

        @Override
        public String getState() {
            return "";
        }

        @Override
        public String getType() {
            SequenceEncoder se = new SequenceEncoder(';');
            se.append(this.name.getValueString()).append(this.actionOption.getSelectedIndex() == 0 ? RestrictCommands.HIDE : RestrictCommands.DISABLE).append(this.propertyMatch.getValueString()).append(this.watchKeys.getValueString());
            return RestrictCommands.ID + se.getValue();
        }
    }
}

