/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.counters;

import VASSAL.build.GameModule;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.command.ChangePiece;
import VASSAL.command.Command;
import VASSAL.configure.IntConfigurer;
import VASSAL.configure.NamedHotKeyConfigurer;
import VASSAL.configure.StringConfigurer;
import VASSAL.counters.Decorator;
import VASSAL.counters.GamePiece;
import VASSAL.counters.KeyCommand;
import VASSAL.counters.PieceEditor;
import VASSAL.i18n.PieceI18nData;
import VASSAL.i18n.TranslatablePiece;
import VASSAL.tools.NamedKeyStroke;
import VASSAL.tools.ScrollPane;
import VASSAL.tools.SequenceEncoder;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BoxLayout;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.KeyStroke;

public class TableInfo
extends Decorator
implements TranslatablePiece {
    public static final String ID = "table;";
    protected String values;
    protected String oldState;
    protected int nRows;
    protected int nCols;
    protected String command;
    protected NamedKeyStroke launchKey;
    protected KeyCommand launch;
    protected JTable table;
    protected JDialog frame;

    public TableInfo() {
        this("table;2;2;Show Data;S", null);
    }

    public TableInfo(String type, GamePiece p) {
        this.mySetType(type);
        this.setInner(p);
    }

    public int getRowCount() {
        return this.nRows;
    }

    public int getColumnCount() {
        return this.nCols;
    }

    @Override
    public void mySetType(String s) {
        s = s.substring(ID.length());
        SequenceEncoder.Decoder st = new SequenceEncoder.Decoder(s, ';');
        this.nRows = st.nextInt(2);
        this.nCols = st.nextInt(2);
        this.command = st.nextToken();
        this.launchKey = st.nextNamedKeyStroke(null);
        this.frame = null;
        this.table = null;
    }

    @Override
    public void draw(Graphics g, int x, int y, Component obs, double zoom) {
        this.piece.draw(g, x, y, obs, zoom);
    }

    @Override
    public String getName() {
        return this.piece.getName();
    }

    @Override
    public Rectangle boundingBox() {
        return this.piece.boundingBox();
    }

    @Override
    public Shape getShape() {
        return this.piece.getShape();
    }

    @Override
    public String myGetState() {
        if (this.table == null) {
            return this.values;
        }
        SequenceEncoder se = new SequenceEncoder(',');
        for (int row = 0; row < this.nRows; ++row) {
            for (int col = 0; col < this.nCols; ++col) {
                String s = (String)this.table.getValueAt(row, col);
                se.append(s == null ? "" : s);
            }
        }
        return se.getValue();
    }

    @Override
    public void mySetState(String state) {
        if (this.table == null) {
            this.values = state;
        } else {
            this.setValues(state);
        }
    }

    private void setValues(String val) {
        SequenceEncoder.Decoder st = new SequenceEncoder.Decoder(val, ',');
        for (int row = 0; row < this.nRows; ++row) {
            for (int col = 0; col < this.nCols; ++col) {
                this.table.setValueAt(st.nextToken(), row, col);
            }
        }
    }

    @Override
    public String myGetType() {
        SequenceEncoder se = new SequenceEncoder(';');
        se.append(this.nRows).append(this.nCols).append(this.command).append(this.launchKey);
        return ID + se.getValue();
    }

    @Override
    protected KeyCommand[] myGetKeyCommands() {
        if (this.launch == null) {
            this.launch = new KeyCommand(this.command, this.launchKey, Decorator.getOutermost(this), (TranslatablePiece)this);
        }
        return new KeyCommand[]{this.launch};
    }

    @Override
    public Command myKeyEvent(KeyStroke stroke) {
        this.myGetKeyCommands();
        if (this.launch.matches(stroke)) {
            if (this.frame == null) {
                this.frame = new JDialog((Frame)null, false);
                this.table = new JTable(this.nRows, this.nCols);
                this.setValues(this.values);
                this.table.setTableHeader(null);
                ScrollPane scroll = new ScrollPane(this.table);
                scroll.getViewport().setPreferredSize(this.table.getPreferredSize());
                this.frame.add(scroll);
                Point p = GameModule.getGameModule().getFrame().getLocation();
                if (this.getMap() != null) {
                    p = this.getMap().getView().getLocationOnScreen();
                    Point p2 = this.getMap().mapToComponent(this.getPosition());
                    p.translate(p2.x, p2.y);
                }
                this.frame.setLocation(p.x, p.y);
                this.frame.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent evt) {
                        TableInfo.this.table.editingStopped(null);
                        GamePiece outer = Decorator.getOutermost(TableInfo.this);
                        if (outer.getId() != null) {
                            GameModule.getGameModule().sendAndLog(new ChangePiece(outer.getId(), TableInfo.this.oldState, outer.getState()));
                        }
                    }
                });
                this.frame.pack();
            }
            this.frame.setTitle(this.getName());
            this.oldState = Decorator.getOutermost(this).getState();
            this.frame.setVisible(true);
            return null;
        }
        return null;
    }

    @Override
    public String getDescription() {
        return "Spreadsheet";
    }

    @Override
    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("Spreadsheet.htm");
    }

    @Override
    public PieceEditor getEditor() {
        return new Ed(this);
    }

    @Override
    public PieceI18nData getI18nData() {
        return this.getI18nData(this.command, "Table Info command");
    }

    private static class Ed
    implements PieceEditor {
        private IntConfigurer rowConfig = new IntConfigurer(null, "Number of rows:  ");
        private IntConfigurer colConfig = new IntConfigurer(null, "Number of columns:  ");
        private StringConfigurer commandConfig = new StringConfigurer(null, "Menu Command:  ");
        private NamedHotKeyConfigurer keyConfig;
        private JPanel panel;

        public Ed(TableInfo p) {
            this.rowConfig.setValue(p.nRows);
            this.colConfig.setValue(p.nCols);
            this.commandConfig.setValue(p.command);
            this.keyConfig = new NamedHotKeyConfigurer(null, "Keyboard Command:  ", p.launchKey);
            this.panel = new JPanel();
            this.panel.setLayout(new BoxLayout(this.panel, 1));
            this.panel.add(this.commandConfig.getControls());
            this.panel.add(this.keyConfig.getControls());
            this.panel.add(this.rowConfig.getControls());
            this.panel.add(this.colConfig.getControls());
        }

        @Override
        public Component getControls() {
            return this.panel;
        }

        @Override
        public String getType() {
            SequenceEncoder se = new SequenceEncoder(';');
            se.append(this.rowConfig.getValueString()).append(this.colConfig.getValueString()).append(this.commandConfig.getValueString()).append(this.keyConfig.getValueString());
            return TableInfo.ID + se.getValue();
        }

        @Override
        public String getState() {
            StringBuilder buf = new StringBuilder();
            int n = (Integer)this.rowConfig.getValue() * (Integer)this.colConfig.getValue();
            while (--n > 0) {
                buf.append(',');
            }
            return buf.toString();
        }
    }
}

