/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.i18n;

import VASSAL.Info;
import VASSAL.build.module.gamepieceimage.StringEnumConfigurer;
import VASSAL.i18n.BundleHelper;
import VASSAL.preferences.Prefs;
import VASSAL.tools.ErrorDialog;
import java.awt.Component;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.UIManager;

public class Resources {
    private static Resources instance;
    protected BundleHelper vassalBundle;
    protected BundleHelper editorBundle;
    private VassalPropertyClassLoader bundleLoader = new VassalPropertyClassLoader();
    public static final String LOCALE_PREF_KEY = "Locale";
    protected final List<Locale> supportedLocales = new ArrayList<Locale>(Arrays.asList(Locale.ENGLISH, Locale.GERMAN, Locale.FRENCH, Locale.ITALIAN, new Locale("es"), Locale.JAPANESE, new Locale("nl")));
    protected Locale locale = Locale.getDefault();
    protected static String DATE_FORMAT;
    protected static final String MODULE_BUNDLE = "Module";
    public static final String VASSAL = "General.VASSAL";
    public static final String ADD = "General.add";
    public static final String REMOVE = "General.remove";
    public static final String INSERT = "General.insert";
    public static final String YES = "General.yes";
    public static final String NO = "General.no";
    public static final String CANCEL = "General.cancel";
    public static final String SAVE = "General.save";
    public static final String OK = "General.ok";
    public static final String MENU = "General.menu";
    public static final String LOAD = "General.load";
    public static final String QUIT = "General.quit";
    public static final String EDIT = "General.edit";
    public static final String NEW = "General.new";
    public static final String FILE = "General.file";
    public static final String TOOLS = "General.tools";
    public static final String HELP = "General.help";
    public static final String CLOSE = "General.close";
    public static final String DATE_DISPLAY = "General.date_display";
    public static final String NEXT = "General.next";
    public static final String REFRESH = "General.refresh";
    public static final String SELECT = "General.select";
    public static final String EDITOR_PREFIX = "Editor.";
    public static final String BUTTON_TEXT = "Editor.button_text_label";
    public static final String TOOLTIP_TEXT = "Editor.tooltip_text_label";
    public static final String BUTTON_ICON = "Editor.button_icon_label";
    public static final String HOTKEY_LABEL = "Editor.hotkey_label";
    public static final String COLOR_LABEL = "Editor.color_label";
    public static final String NAME_LABEL = "Editor.name_label";
    public static final String DESCRIPTION = "Editor.description_label";
    protected static final String BASE_BUNDLE = "VASSAL.properties";
    protected static final String EN_BUNDLE = "VASSAL_en.properties";

    private Resources() {
        this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Resources getInstance() {
        Class<Resources> clazz = Resources.class;
        synchronized (Resources.class) {
            if (instance == null) {
                instance = new Resources();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private void init() {
        Locale myLocale = Locale.getDefault();
        ResourceBundle rb = ResourceBundle.getBundle("VASSAL.i18n.VASSAL", myLocale, this.bundleLoader);
        if (rb.getLocale().getLanguage().equals(myLocale.getLanguage())) {
            this.addLocale(myLocale);
        }
        ArrayList<String> languages = new ArrayList<String>();
        for (Locale l : this.supportedLocales) {
            languages.add(l.getLanguage());
        }
        Prefs p = Prefs.getGlobalPrefs();
        String savedLocale = p.getStoredValue(LOCALE_PREF_KEY);
        myLocale = savedLocale == null ? this.supportedLocales.iterator().next() : new Locale(savedLocale);
        this.setInstanceLocale(myLocale);
        StringEnumConfigurer localeConfig = new StringEnumConfigurer(LOCALE_PREF_KEY, this.getInstanceString("Prefs.language"), languages.toArray(new String[0])){

            @Override
            public Component getControls() {
                if (this.box == null) {
                    Component c = super.getControls();
                    this.box.setRenderer(new DefaultListCellRenderer(){
                        private static final long serialVersionUID = 1L;

                        @Override
                        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                            JLabel l = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                            l.setText(new Locale((String)value).getDisplayLanguage());
                            return l;
                        }
                    });
                    return c;
                }
                return super.getControls();
            }
        };
        localeConfig.setValue(this.locale.getLanguage());
        p.addOption(this.getInstanceString("Prefs.general_tab"), localeConfig);
    }

    public static Collection<Locale> getSupportedLocales() {
        return Resources.getInstance().supportedLocales;
    }

    public static void addSupportedLocale(Locale l) {
        Resources.getInstance().addLocale(l);
    }

    private void addLocale(Locale l) {
        if (!this.supportedLocales.contains(l = new Locale(l.getLanguage()))) {
            this.supportedLocales.add(0, l);
            StringEnumConfigurer config = (StringEnumConfigurer)Prefs.getGlobalPrefs().getOption(LOCALE_PREF_KEY);
            if (config != null) {
                ArrayList<String> valid = new ArrayList<String>(Arrays.asList(config.getValidValues()));
                valid.add(0, l.getLanguage());
                config.setValidValues(valid.toArray(new String[0]));
            }
        }
    }

    public static Collection<String> getVassalKeys() {
        return Collections.list(Resources.getInstance().vassalBundle.getResourceBundle().getKeys());
    }

    public Collection<String> getEditorKeys() {
        return Collections.list(this.editorBundle.getResourceBundle().getKeys());
    }

    public static String getString(String id) {
        return Resources.getInstance().getInstanceString(id);
    }

    private String getInstanceString(String id) {
        return this.getBundleForKey(id).getString(id);
    }

    protected BundleHelper getBundleForKey(String id) {
        return id.startsWith(EDITOR_PREFIX) ? this.getEditorBundle() : this.getVassalBundle();
    }

    protected BundleHelper getEditorBundle() {
        if (this.editorBundle == null) {
            this.editorBundle = new BundleHelper(ResourceBundle.getBundle("VASSAL.i18n.Editor", this.locale, this.bundleLoader));
        }
        return this.editorBundle;
    }

    protected BundleHelper getVassalBundle() {
        if (this.vassalBundle == null) {
            this.vassalBundle = new BundleHelper(ResourceBundle.getBundle("VASSAL.i18n.VASSAL", this.locale, this.bundleLoader));
        }
        return this.vassalBundle;
    }

    @Deprecated
    public static String getVassalString(String id) {
        return Resources.getInstance().getVassalBundle().getString(id);
    }

    @Deprecated
    public static String getEditorString(String id) {
        return Resources.getInstance().getEditorBundle().getString(id);
    }

    @Deprecated
    public static String getString(ResourceBundle bundle, String id) {
        String s = null;
        try {
            s = bundle.getString(id);
        }
        catch (Exception ex) {
            System.err.println("No Translation: " + id);
        }
        if (s == null) {
            s = id;
        }
        return s;
    }

    public static String getString(String id, Object ... params) {
        return Resources.getInstance().getBundleForKey(id).getString(id, params);
    }

    public static void setLocale(Locale l) {
        Resources.getInstance().setInstanceLocale(l);
    }

    private void setInstanceLocale(Locale l) {
        this.locale = l;
        this.editorBundle = null;
        this.vassalBundle = null;
        UIManager.put("OptionPane.yesButtonText", this.getInstanceString(YES));
        UIManager.put("OptionPane.cancelButtonText", this.getInstanceString(CANCEL));
        UIManager.put("OptionPane.noButtonText", this.getInstanceString(NO));
        UIManager.put("OptionPane.okButtonText", this.getInstanceString(OK));
    }

    public static Locale getLocale() {
        return Resources.getInstance().locale;
    }

    public static String formatDate(Date date) {
        return new MessageFormat(DATE_FORMAT).format(new Object[]{date});
    }

    static {
        DATE_FORMAT = "{0,date}";
    }

    public class VassalPropertyClassLoader
    extends ClassLoader {
        @Override
        public URL getResource(String name) {
            URL url = this.getAResource(name);
            if (url == null && name.endsWith(Resources.EN_BUNDLE)) {
                url = this.getAResource(name.substring(0, name.lastIndexOf(47) + 1) + Resources.BASE_BUNDLE);
            }
            return url;
        }

        public URL getAResource(String name) {
            URL url = null;
            String propFileName = name.substring(name.lastIndexOf(47) + 1);
            File propFile = new File(Info.getHomeDir(), propFileName);
            if (propFile.exists()) {
                try {
                    url = propFile.toURI().toURL();
                }
                catch (MalformedURLException e) {
                    ErrorDialog.bug(e);
                }
            }
            if (url == null) {
                url = this.getClass().getClassLoader().getResource(name);
            }
            return url;
        }
    }
}

