/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.launch;

import VASSAL.Info;
import VASSAL.build.GameModule;
import VASSAL.i18n.Resources;
import VASSAL.launch.BasicModule;
import VASSAL.launch.LoadModuleAction;
import VASSAL.launch.ModuleEditorWindow;
import VASSAL.tools.ArchiveWriter;
import VASSAL.tools.io.ZipArchive;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import javax.swing.JFrame;

public class EditModuleAction
extends LoadModuleAction {
    private static final long serialVersionUID = 1L;

    public EditModuleAction(Component comp) {
        super(comp);
        this.putValue("Name", Resources.getString("Main.edit_module"));
    }

    public EditModuleAction(File moduleFile) {
        super(moduleFile);
        this.putValue("Name", Resources.getString("Main.edit_module"));
    }

    @Override
    protected void loadModule(File f) throws IOException {
        GameModule.init(new BasicModule(new ArchiveWriter(new ZipArchive(f))));
        JFrame frame = GameModule.getGameModule().getFrame();
        frame.setVisible(true);
        GameModule.getGameModule().updateLastSave();
        ModuleEditorWindow w = new ModuleEditorWindow(GameModule.getGameModule());
        w.setLocation(0, frame.getY() + frame.getHeight());
        w.setSize(Info.getScreenBounds((Component)frame).width / 2, w.getHeight());
        w.setVisible(true);
    }
}

