/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.launch;

import VASSAL.Info;
import VASSAL.build.GameModule;
import VASSAL.build.module.ExtensionsLoader;
import VASSAL.i18n.Resources;
import VASSAL.launch.AbstractLaunchAction;
import VASSAL.launch.ExceptionHandler;
import VASSAL.launch.LaunchRequest;
import VASSAL.launch.LaunchRequestException;
import VASSAL.launch.MacOSXStartUp;
import VASSAL.launch.StartUp;
import VASSAL.tools.ErrorDialog;
import VASSAL.tools.ThrowableUtils;
import VASSAL.tools.concurrent.listener.EventListener;
import VASSAL.tools.ipc.IPCMessenger;
import VASSAL.tools.ipc.SimpleIPCMessage;
import VASSAL.tools.logging.LoggedOutputStream;
import VASSAL.tools.menu.MenuManager;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.net.InetAddress;
import java.net.Socket;
import javax.swing.SwingUtilities;
import org.apache.commons.lang3.SystemUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Launcher {
    private static final Logger logger = LoggerFactory.getLogger(Launcher.class);
    protected IPCMessenger ipc = null;
    protected final LaunchRequest lr;
    private static Launcher instance = null;

    public static Launcher getInstance() {
        return instance;
    }

    protected Launcher(String[] args) {
        if (instance != null) {
            throw new IllegalStateException();
        }
        instance = this;
        LaunchRequest lreq = null;
        try {
            lreq = LaunchRequest.parseArgs(args);
        }
        catch (LaunchRequestException e) {
            System.err.println("VASSAL: " + e.getMessage());
            System.exit(1);
        }
        this.lr = lreq;
        boolean standalone = this.lr.standalone;
        StartUp start = SystemUtils.IS_OS_MAC_OSX ? new MacOSXStartUp() : new StartUp();
        start.startErrorLog();
        System.setErr(new PrintStream(new LoggedOutputStream(), true));
        logger.info(this.getClass().getSimpleName());
        Thread.setDefaultUncaughtExceptionHandler(new ExceptionHandler());
        start.initSystemProperties();
        if (!standalone) {
            try {
                int port = Integer.parseInt(System.getProperty("VASSAL.port"));
                InetAddress lo = InetAddress.getByName(null);
                Socket cs = new Socket(lo, port);
                this.ipc = new IPCMessenger(cs);
                this.ipc.addEventListener(CloseRequest.class, new CloseRequestListener());
                this.ipc.start();
                this.ipc.send(new StartedNotice(Info.getInstanceID()));
            }
            catch (IOException e) {
                ErrorDialog.show(e, "Error.communication_error", Resources.getString(this.getClass().getSimpleName() + ".app_name"));
                System.exit(1);
            }
        }
        this.createMenuManager();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    Launcher.this.launch();
                }
                catch (ExtensionsLoader.LoadExtensionException | IOException e2) {
                    this.warn(e2);
                }
            }

            private void warn(Exception e1) {
                if (Launcher.this.ipc == null) {
                    ErrorDialog.showDetails(e1, ThrowableUtils.getStackTrace(e1), "Error.module_load_failed", e1.getMessage());
                } else {
                    try {
                        Launcher.this.ipc.send(new AbstractLaunchAction.NotifyOpenModuleFailed(Launcher.this.lr, e1));
                    }
                    catch (IOException e2) {
                        ErrorDialog.showDetails(e1, ThrowableUtils.getStackTrace(e1), "Error.module_load_failed", e1.getMessage());
                        ErrorDialog.show(e2, "Error.communication_error", Resources.getString(this.getClass().getSimpleName() + ".app_name"));
                    }
                }
                System.exit(1);
            }
        });
    }

    protected abstract void launch() throws IOException;

    protected abstract MenuManager createMenuManager();

    public void sendSaveCmd(File f) {
        if (this.ipc != null) {
            try {
                this.ipc.send(new AbstractLaunchAction.NotifySaveFileOk(f));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static class CloseRequest
    extends SimpleIPCMessage {
        private static final long serialVersionUID = 1L;
    }

    protected class CloseRequestListener
    implements EventListener<CloseRequest> {
        private boolean shutdown;

        protected CloseRequestListener() {
        }

        @Override
        public void receive(Object src, CloseRequest msg) {
            final GameModule module = GameModule.getGameModule();
            if (module != null) {
                try {
                    SwingUtilities.invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            module.getFrame().toFront();
                            CloseRequestListener.this.shutdown = module.shutDown();
                        }
                    });
                }
                catch (InterruptedException e) {
                    logger.error("", (Throwable)e);
                    this.shutdown = false;
                }
                catch (InvocationTargetException e) {
                    ErrorDialog.bug(e);
                    this.shutdown = false;
                }
            }
            if (this.shutdown) {
                if (Launcher.this.ipc != null) {
                    try {
                        Launcher.this.ipc.send(new CloseAccept(-msg.getId()));
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                System.exit(0);
            } else if (Launcher.this.ipc != null) {
                try {
                    Launcher.this.ipc.send(new CloseReject(-msg.getId()));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static class StartedNotice
    extends SimpleIPCMessage {
        private static final long serialVersionUID = 1L;
        public final long pid;

        public StartedNotice(long pid) {
            this.pid = pid;
        }
    }

    public static class CloseReject
    extends SimpleIPCMessage {
        private static final long serialVersionUID = 1L;
        public final long pid;

        public CloseReject(long pid) {
            this.pid = pid;
        }
    }

    public static class CloseAccept
    extends SimpleIPCMessage {
        private static final long serialVersionUID = 1L;
        public final long pid;

        public CloseAccept(long pid) {
            this.pid = pid;
        }
    }
}

