/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.launch;

import VASSAL.Info;
import VASSAL.tools.ErrorDialog;
import java.lang.reflect.InvocationTargetException;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import org.apache.commons.lang3.SystemUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StartUp {
    private static final Logger logger = LoggerFactory.getLogger(StartUp.class);

    public void initSystemProperties() {
        this.initHTTPProxyProperties();
        this.initSystemSpecificProperties();
        this.initUIProperties();
    }

    protected void initHTTPProxyProperties() {
        String httpProxyHost = "http.proxyHost";
        String proxyHost = "proxyHost";
        if (System.getProperty("http.proxyHost") == null && System.getProperty("proxyHost") != null) {
            System.setProperty("http.proxyHost", System.getProperty("proxyHost"));
        }
        String httpProxyPort = "http.proxyPort";
        String proxyPort = "proxyPort";
        if (System.getProperty("http.proxyPort") == null && System.getProperty("proxyPort") != null) {
            System.setProperty("http.proxyPort", System.getProperty("proxyPort"));
        }
    }

    protected void initUIProperties() {
        System.setProperty("swing.aatext", "true");
        System.setProperty("swing.boldMetal", "false");
        System.setProperty("awt.useSystemAAFontSettings", "on");
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    if (SystemUtils.IS_OS_MAC_OSX) {
                        Thread.currentThread().setContextClassLoader(ClassLoader.getSystemClassLoader());
                    }
                    if (!SystemUtils.IS_OS_WINDOWS) {
                        try {
                            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                        }
                        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException e) {
                            ErrorDialog.bug(e);
                        }
                    }
                    UIManager.put("PopupMenu.consumeEventOnClose", Boolean.FALSE);
                }
            });
        }
        catch (InterruptedException | InvocationTargetException e) {
            ErrorDialog.bug(e);
        }
    }

    protected void initSystemSpecificProperties() {
    }

    public void startErrorLog() {
        logger.info("Starting");
        logger.info("OS " + System.getProperty("os.name") + " " + System.getProperty("os.version"));
        logger.info("Java version " + System.getProperty("java.version"));
        logger.info("VASSAL version " + Info.getVersion());
    }
}

