/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.script;

import VASSAL.build.GameModule;
import VASSAL.build.module.Map;
import VASSAL.build.module.properties.PropertySource;
import VASSAL.counters.GamePiece;
import VASSAL.counters.Stack;
import VASSAL.script.AbstractInterpreter;
import VASSAL.script.expression.ExpressionException;
import VASSAL.tools.WarningDialog;
import bsh.BeanShellExpressionValidator;
import bsh.EvalError;
import bsh.NameSpace;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExpressionInterpreter
extends AbstractInterpreter {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(ExpressionInterpreter.class);
    protected static final String INIT_SCRIPT = "/VASSAL/script/init_expression.bsh";
    protected static final String THIS = "_interp";
    protected static final String SOURCE = "_source";
    protected static final String MAGIC1 = "_xyzzy";
    protected static final String MAGIC2 = "_plugh";
    protected static final String MAGIC3 = "_plover";
    protected static NameSpace topLevelNameSpace;
    protected NameSpace expressionNameSpace;
    protected String expression;
    protected PropertySource source;
    protected List<String> variables = new ArrayList<String>();
    protected static HashMap<String, ExpressionInterpreter> cache;

    public static ExpressionInterpreter createInterpreter(String expr) throws ExpressionException {
        String e = expr == null ? "" : ExpressionInterpreter.strip(expr);
        ExpressionInterpreter interpreter = cache.get(e);
        if (interpreter == null) {
            interpreter = new ExpressionInterpreter(e);
            cache.put(e, interpreter);
        }
        return interpreter;
    }

    protected static String strip(String expr) {
        String s = expr.trim();
        if (s.startsWith("{") && s.endsWith("}")) {
            return s.substring(1, s.length() - 1);
        }
        return expr;
    }

    private ExpressionInterpreter(String expr) throws ExpressionException {
        this.expression = expr;
        this.setClassLoader(this.getClass().getClassLoader());
        if (topLevelNameSpace == null) {
            this.initialiseStatic();
        }
        this.expressionNameSpace = new NameSpace(topLevelNameSpace, "expression");
        this.variables = new BeanShellExpressionValidator(this.expression).getVariables();
        this.setNameSpace(this.expressionNameSpace);
        if (this.expression.length() > 0) {
            try {
                this.eval("String _plugh() { _plover=" + this.expression + "; return _plover.toString();}");
            }
            catch (EvalError e) {
                throw new ExpressionException(this.getExpression());
            }
        }
        this.setVar(THIS, this);
    }

    protected void initialiseStatic() {
        topLevelNameSpace = new NameSpace(null, this.getClassManager(), "topLevel");
        this.setNameSpace(topLevelNameSpace);
        this.getNameSpace().importClass("VASSAL.build.module.properties.PropertySource");
        this.getNameSpace().importClass("VASSAL.script.ExpressionInterpreter");
        URL ini = this.getClass().getResource(INIT_SCRIPT);
        logger.info("Attempting to load /VASSAL/script/init_expression.bsh URI generated=" + ini);
        try (InputStream is = ini.openStream();
             InputStreamReader isr = new InputStreamReader(is);
             BufferedReader in = new BufferedReader(isr);){
            try {
                this.eval(in);
            }
            catch (EvalError e) {
                logger.error("Error trying to read init script: " + ini);
                WarningDialog.show(e, "", new Object[0]);
            }
        }
        catch (IOException e) {
            logger.error("Error trying to read init script: " + ini);
            WarningDialog.show(e, "", new Object[0]);
        }
    }

    public String getExpression() {
        return this.expression;
    }

    public String evaluate(PropertySource ps) throws ExpressionException {
        return this.evaluate(ps, false);
    }

    public String evaluate(PropertySource ps, boolean localized) throws ExpressionException {
        if (this.getExpression().length() == 0) {
            return "";
        }
        this.source = ps == null ? GameModule.getGameModule() : ps;
        this.setNameSpace(this.expressionNameSpace);
        for (String var : this.variables) {
            String value;
            String name = var;
            if (name.length() > 2 && name.startsWith("$") && name.endsWith("$")) {
                name = name.substring(1, name.length() - 1);
            }
            Object prop = localized ? this.source.getLocalizedProperty(name) : this.source.getProperty(name);
            String string = value = prop == null ? "" : prop.toString();
            if (value == null) {
                this.setVar(var, "");
                continue;
            }
            if ("true".equals(value)) {
                this.setVar(var, true);
                continue;
            }
            if ("false".equals(value)) {
                this.setVar(var, false);
                continue;
            }
            try {
                this.setVar(var, Integer.valueOf(value));
            }
            catch (NumberFormatException e) {
                try {
                    this.setVar(var, Float.valueOf(value).floatValue());
                }
                catch (NumberFormatException e1) {
                    this.setVar(var, value);
                }
            }
        }
        this.setVar(THIS, this);
        this.setVar(SOURCE, this.source);
        String result = "";
        try {
            this.eval("_xyzzy=_plugh()");
            result = this.get(MAGIC1).toString();
        }
        catch (EvalError e) {
            String s = e.getRawMessage();
            String search = "_plugh();'' : ";
            int pos = s.indexOf("_plugh();'' : ");
            throw new ExpressionException(this.getExpression(), s.substring(pos + "_plugh();'' : ".length()));
        }
        return result;
    }

    public String evaluate() throws ExpressionException {
        return this.getExpression().length() == 0 ? "" : this.evaluate(GameModule.getGameModule());
    }

    public Object wrap(String value) {
        if (value == null) {
            return "";
        }
        if ("true".equals(value)) {
            return Boolean.TRUE;
        }
        if ("false".equals(value)) {
            return Boolean.FALSE;
        }
        try {
            return Integer.valueOf(value);
        }
        catch (NumberFormatException e) {
            return value;
        }
    }

    public Object getProperty(String name) {
        Object value = this.source.getProperty(name);
        return value == null ? "" : this.wrap(value.toString());
    }

    public Object getLocalizedProperty(String name) {
        Object value = this.source.getLocalizedProperty(name);
        return value == null ? "" : this.wrap(value.toString());
    }

    public Object sumStack(String property, PropertySource ps) {
        Stack s;
        int result = 0;
        if (ps instanceof GamePiece && (s = ((GamePiece)ps).getParent()) != null) {
            for (GamePiece gamePiece : s.asList()) {
                try {
                    result += Integer.parseInt(gamePiece.getProperty(property).toString());
                }
                catch (Exception exception) {}
            }
        }
        return result;
    }

    public Object sumLocation(String property, PropertySource ps) {
        GamePiece p;
        Map m;
        int result = 0;
        if (ps instanceof GamePiece && (m = (p = (GamePiece)ps).getMap()) != null) {
            GamePiece[] pieces;
            String here = m.locationName(p.getPosition());
            for (GamePiece piece : pieces = m.getPieces()) {
                if (!here.equals(m.locationName(piece.getPosition()))) continue;
                if (piece instanceof Stack) {
                    Stack s = (Stack)piece;
                    for (GamePiece gamePiece : s.asList()) {
                        try {
                            result += Integer.parseInt(gamePiece.getProperty(property).toString());
                        }
                        catch (NumberFormatException numberFormatException) {}
                    }
                    continue;
                }
                try {
                    result += Integer.parseInt(piece.getProperty(property).toString());
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        return result;
    }

    static {
        cache = new HashMap();
    }
}

