/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.script.expression;

import VASSAL.build.GameModule;
import VASSAL.build.module.properties.PropertySource;
import VASSAL.counters.GamePiece;
import VASSAL.counters.PieceFilter;
import VASSAL.script.expression.BeanShellExpression;
import VASSAL.script.expression.ExpressionException;
import VASSAL.script.expression.FormattedStringExpression;
import VASSAL.script.expression.IntExpression;
import VASSAL.script.expression.NullExpression;
import VASSAL.script.expression.PropertyMatchExpression;
import VASSAL.script.expression.SinglePropertyExpression;
import VASSAL.script.expression.StringExpression;
import java.util.Map;

public abstract class Expression {
    private String expression;

    public void setExpression(String s) {
        this.expression = s;
    }

    public String getExpression() {
        return this.expression;
    }

    public abstract String evaluate(PropertySource var1, Map<String, String> var2, boolean var3) throws ExpressionException;

    public String evaluate() throws ExpressionException {
        return this.evaluate(null, null, false);
    }

    public String evaluate(PropertySource ps) throws ExpressionException {
        return this.evaluate(ps, null, false);
    }

    public String evaluate(PropertySource ps, boolean localized) throws ExpressionException {
        return this.evaluate(ps, null, localized);
    }

    public String evaluate(boolean localized) throws ExpressionException {
        return this.evaluate(null, null, localized);
    }

    public PieceFilter getFilter(PropertySource ps) {
        return new PieceFilter(){

            @Override
            public boolean accept(GamePiece piece) {
                return true;
            }
        };
    }

    public PieceFilter getFilter() {
        return this.getFilter(GameModule.getGameModule());
    }

    public abstract String toBeanShellString();

    public static Expression createExpression(String s) {
        if (s == null || s.trim().length() == 0) {
            return new NullExpression();
        }
        String t = s.trim();
        if (t.startsWith("{") && t.endsWith("}")) {
            return BeanShellExpression.createExpression(s);
        }
        try {
            return new IntExpression(Integer.parseInt(t));
        }
        catch (NumberFormatException numberFormatException) {
            if (t.indexOf(36) >= 0) {
                return new FormattedStringExpression(t);
            }
            return new StringExpression(s);
        }
    }

    public static Expression createPropertyExpression(String s) {
        if (s == null || s.trim().length() == 0) {
            return new NullExpression();
        }
        String t = s.trim();
        if (t.startsWith("{") && t.endsWith("}")) {
            return new BeanShellExpression(t.substring(1, t.length() - 1));
        }
        return new PropertyMatchExpression(t);
    }

    public static Expression createSimplePropertyExpression(String s) {
        if (s == null || s.trim().length() == 0) {
            return new NullExpression();
        }
        String t = s.trim();
        if (t.startsWith("{") && t.endsWith("}")) {
            return new BeanShellExpression(t.substring(1, t.length() - 1));
        }
        return new SinglePropertyExpression(t);
    }

    public int hashCode() {
        return this.expression == null ? 0 : this.expression.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Expression other = (Expression)obj;
        if (this.expression == null && other.expression != null) {
            return false;
        }
        return this.expression.equals(other.expression);
    }
}

