/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.script.expression;

import VASSAL.build.module.documentation.HelpFile;
import VASSAL.configure.BeanShellExpressionConfigurer;
import VASSAL.configure.StringConfigurer;
import VASSAL.counters.EditablePiece;
import VASSAL.tools.BrowserSupport;
import VASSAL.tools.ButtonFactory;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;

public class FunctionBuilder
extends JDialog {
    private static final long serialVersionUID = 1L;
    protected String save;
    protected StringConfigurer target;
    protected String function;
    protected List<BeanShellExpressionConfigurer> configs = new ArrayList<BeanShellExpressionConfigurer>();
    protected EditablePiece targetPiece;

    public FunctionBuilder(StringConfigurer c, JDialog parent, String function, String desc, String[] parmDesc, EditablePiece piece) {
        super(parent, "Function Builder - " + function, true);
        this.target = c;
        this.targetPiece = piece;
        this.save = this.target.getValueString();
        this.function = function;
        this.setLayout((LayoutManager)new MigLayout("fillx,ins 0"));
        JPanel p = new JPanel((LayoutManager)new MigLayout("wrap 1,fillx"));
        p.add((Component)new JLabel(desc), "align center");
        for (String s : parmDesc) {
            BeanShellExpressionConfigurer config = new BeanShellExpressionConfigurer(null, s + ":  ", "", this.targetPiece);
            this.configs.add(config);
            p.add(config.getControls(), "align right,growx");
        }
        JPanel buttonBox = new JPanel((LayoutManager)new MigLayout("", "[]rel[]rel[]"));
        JButton okButton = ButtonFactory.getOkButton();
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FunctionBuilder.this.save();
            }
        });
        buttonBox.add(okButton);
        JButton cancelButton = ButtonFactory.getCancelButton();
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FunctionBuilder.this.cancel();
            }
        });
        buttonBox.add(cancelButton);
        JButton helpButton = ButtonFactory.getHelpButton();
        helpButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BrowserSupport.openURL(HelpFile.getReferenceManualPage("ExpressionBuilder.htm").getContents().toString());
            }
        });
        buttonBox.add(helpButton);
        p.add((Component)buttonBox, "align center");
        this.add((Component)p, "growx");
        this.pack();
        this.setLocationRelativeTo(this.getParent());
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent we) {
                FunctionBuilder.this.cancel();
            }
        });
    }

    public void save() {
        String result = this.function + "(";
        boolean first = true;
        for (BeanShellExpressionConfigurer fec : this.configs) {
            if (!first) {
                result = result + ",";
            }
            result = result + fec.getValueString();
            first = false;
        }
        result = result + ")";
        this.target.setValue(result);
        this.dispose();
    }

    public void cancel() {
        this.dispose();
    }
}

