/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools;

import VASSAL.build.BadDataReport;
import VASSAL.build.GameModule;
import VASSAL.i18n.Resources;
import VASSAL.tools.BugDialog;
import VASSAL.tools.DialogUtils;
import VASSAL.tools.ProblemDialog;
import VASSAL.tools.ThrowableUtils;
import VASSAL.tools.bug.Bug2694Handler;
import VASSAL.tools.bug.BugHandler;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Future;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ErrorDialog {
    private static final Logger logger = LoggerFactory.getLogger(ErrorDialog.class);
    private static final List<BugHandler> BUG_HANDLERS = Collections.synchronizedList(new ArrayList<Bug2694Handler>(Collections.singletonList(new Bug2694Handler())));
    private static final Set<String> reportedDataErrors = Collections.synchronizedSet(new HashSet());

    private ErrorDialog() {
    }

    public static void addBugHandler(BugHandler bh) {
        BUG_HANDLERS.add(bh);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void bug(Throwable thrown) {
        OutOfMemoryError oom = ThrowableUtils.getRecent(OutOfMemoryError.class, thrown);
        if (oom != null) {
            logger.error("", thrown);
            ErrorDialog.show("Error.out_of_memory", new Object[0]);
            return;
        }
        List<BugHandler> list = BUG_HANDLERS;
        synchronized (list) {
            for (BugHandler bh : BUG_HANDLERS) {
                if (!bh.accept(thrown)) continue;
                bh.handle(thrown);
                return;
            }
        }
        if (!DialogUtils.setDisabled(BugDialog.class, true)) {
            logger.error("", thrown);
            JFrame frame = GameModule.getGameModule() == null ? null : GameModule.getGameModule().getFrame();
            SwingUtilities.invokeLater(() -> new BugDialog(frame, thrown).setVisible(true));
        }
    }

    public static Future<?> show(String messageKey, Object ... args) {
        return ProblemDialog.show(0, messageKey, args);
    }

    public static Future<?> show(Component parent, String messageKey, Object ... args) {
        return ProblemDialog.show(0, parent, messageKey, args);
    }

    public static Future<?> show(Throwable thrown, String messageKey, Object ... args) {
        return ProblemDialog.show(0, thrown, messageKey, args);
    }

    public static Future<?> show(Component parent, Throwable thrown, String messageKey, Object ... args) {
        return ProblemDialog.show(0, parent, thrown, messageKey, args);
    }

    public static Future<?> show(Component parent, Throwable thrown, String title, String heading, String message) {
        return ProblemDialog.show(0, parent, thrown, title, heading, message);
    }

    public static Future<?> showDisableable(Object key, String messageKey, Object ... args) {
        return ProblemDialog.showDisableable(0, key, messageKey, args);
    }

    public static Future<?> showDisableable(Component parent, Object key, String messageKey, Object ... args) {
        return ProblemDialog.showDisableable(0, parent, key, messageKey, args);
    }

    public static Future<?> showDisableable(Throwable thrown, Object key, String messageKey, Object ... args) {
        return ProblemDialog.showDisableable(0, thrown, key, messageKey, args);
    }

    public static Future<?> showDisableable(Component parent, Throwable thrown, Object key, String messageKey, Object ... args) {
        return ProblemDialog.showDisableable(0, parent, thrown, key, messageKey, args);
    }

    public static Future<?> showDisableable(Component parent, Throwable thrown, Object key, String title, String heading, String message) {
        return ProblemDialog.showDisableable(0, parent, thrown, key, title, heading, message);
    }

    public static Future<?> showDisableableNoI18N(Throwable thrown, Object key, String title, String heading, String message) {
        return ProblemDialog.showDisableableNoI18N(0, thrown, key, title, heading, message);
    }

    public static Future<?> showDetails(String details, String messageKey, Object ... args) {
        return ProblemDialog.showDetails(0, details, messageKey, args);
    }

    public static Future<?> showDetails(Component parent, String details, String messageKey, Object ... args) {
        return ProblemDialog.showDetails(0, parent, details, messageKey, args);
    }

    public static Future<?> showDetails(Throwable thrown, String details, String messageKey, Object ... args) {
        return ProblemDialog.showDetails(0, thrown, details, messageKey, args);
    }

    public static Future<?> showDetails(Component parent, Throwable thrown, String details, String messageKey, Object ... args) {
        return ProblemDialog.showDetails(0, parent, thrown, details, messageKey, args);
    }

    public static Future<?> showDetails(Component parent, Throwable thrown, String details, String title, String heading, String message) {
        return ProblemDialog.showDetails(0, parent, thrown, details, title, heading, message);
    }

    public static Future<?> showDetailsDisableable(String details, Object key, String messageKey, Object ... args) {
        return ProblemDialog.showDetailsDisableable(0, details, key, messageKey, args);
    }

    public static Future<?> showDetailsDisableable(Component parent, String details, Object key, String messageKey, Object ... args) {
        return ProblemDialog.showDetailsDisableable(0, parent, details, key, messageKey, args);
    }

    public static Future<?> showDetailsDisableable(Throwable thrown, String details, Object key, String messageKey, Object ... args) {
        return ProblemDialog.showDetailsDisableable(0, thrown, details, key, messageKey, args);
    }

    public static Future<?> showDetailsDisableable(Component parent, Throwable thrown, String details, Object key, String messageKey, Object ... args) {
        return ProblemDialog.showDetailsDisableable(0, parent, thrown, details, key, messageKey, args);
    }

    public static Future<?> showDetailsDisableable(Component parent, Throwable thrown, String details, Object key, String title, String heading, String message) {
        return ProblemDialog.showDetailsDisableable(0, parent, thrown, details, key, title, heading, message);
    }

    public static void dataError(BadDataReport e) {
        logger.warn(e.getMessage() + ": " + e.getData());
        if (e.getCause() != null) {
            logger.error("", e.getCause());
        }
        if (!reportedDataErrors.contains(e.getData())) {
            reportedDataErrors.add(e.getData());
            GameModule.getGameModule().warn(Resources.getString("Error.data_error_message", e.getMessage(), e.getData()));
        }
    }

    public static void main(String[] args) throws Exception {
        String loremIpsum = "Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.\n\nLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.";
        while (!DialogUtils.isDisabled(0)) {
            ErrorDialog.showDisableable(null, null, (Object)0, "Oh Shit!", "Oh Shit!", "Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.\n\nLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.");
            Thread.sleep(1000L);
        }
        System.exit(0);
    }
}

