/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools;

import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JTextField;
import javax.swing.KeyStroke;

public class HotkeySpecifier
extends JTextField
implements KeyListener {
    private static final long serialVersionUID = 1L;
    private int key;
    private KeyStroke stroke;

    public HotkeySpecifier() {
        this(0);
    }

    public HotkeySpecifier(int key) {
        this.key = key;
        this.setText(key == 0 ? "" : KeyEvent.getKeyText(key));
        this.stroke = KeyStroke.getKeyStroke((char)key);
        this.addKeyListener(this);
    }

    public int getKey() {
        return this.key;
    }

    public KeyStroke getKeyStroke() {
        return this.stroke;
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
        this.stroke = KeyStroke.getKeyStrokeForEvent(e);
    }

    @Override
    public void keyReleased(KeyEvent e) {
        this.setText(HotkeySpecifier.getString(this.stroke));
    }

    public static String getString(KeyStroke k) {
        Object s = KeyEvent.getKeyText(k.getKeyCode());
        if ((k.getModifiers() & 0x40) > 0) {
            s = KeyEvent.getKeyText(16) + "+" + (String)s;
        }
        if ((k.getModifiers() & 0x80) > 0) {
            s = KeyEvent.getKeyText(17) + "+" + (String)s;
        }
        if ((k.getModifiers() & 0x100) > 0) {
            s = KeyEvent.getKeyText(157) + "+" + (String)s;
        }
        if ((k.getModifiers() & 0x200) > 0) {
            s = KeyEvent.getKeyText(18) + "+" + (String)s;
        }
        return s;
    }

    public static KeyStroke getStrokeForString(String s) {
        int index = s.indexOf(44);
        return KeyStroke.getKeyStroke(Integer.parseInt(s.substring(0, index)), Integer.parseInt(s.substring(index + 1)));
    }

    public static String getStringForStroke(KeyStroke stroke) {
        return stroke.getKeyCode() + "," + stroke.getModifiers();
    }
}

