/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools;

import VASSAL.build.GameModule;
import VASSAL.configure.Configurer;
import VASSAL.configure.IconConfigurer;
import VASSAL.configure.NamedHotKeyConfigurer;
import VASSAL.configure.StringConfigurer;
import VASSAL.i18n.Localization;
import VASSAL.i18n.Resources;
import VASSAL.tools.NamedKeyStroke;
import VASSAL.tools.NamedKeyStrokeListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.KeyStroke;

public class LaunchButton
extends JButton {
    private static final long serialVersionUID = 1L;
    public static final String UNTRANSLATED_TEXT = "unTranslatedText";
    protected String tooltipAtt;
    protected String nameAtt;
    protected String keyAtt;
    protected String iconAtt;
    protected IconConfigurer iconConfig;
    protected String toolTipText;
    protected NamedKeyStrokeListener keyListener;
    protected Configurer nameConfig;
    protected Configurer keyConfig;

    public LaunchButton(String text, String textAttribute, String hotkeyAttribute, ActionListener al) {
        this(text, textAttribute, hotkeyAttribute, null, al);
    }

    public LaunchButton(String text, String tooltipAttribute, String textAttribute, String hotkeyAttribute, String iconAttribute, ActionListener al) {
        this(text, textAttribute, hotkeyAttribute, iconAttribute, al);
        this.tooltipAtt = tooltipAttribute;
    }

    public LaunchButton(String text, String textAttribute, String hotkeyAttribute, String iconAttribute, final ActionListener al) {
        super(text);
        this.nameAtt = textAttribute;
        this.keyAtt = hotkeyAttribute;
        this.iconAtt = iconAttribute;
        this.iconConfig = new IconConfigurer(this.iconAtt, null, null);
        this.setAlignmentY(0.0f);
        this.keyListener = new NamedKeyStrokeListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (LaunchButton.this.isEnabled() && LaunchButton.this.getParent() != null && LaunchButton.this.getParent().isShowing()) {
                    al.actionPerformed(e);
                }
            }
        });
        if (al != null) {
            GameModule.getGameModule().addKeyStrokeListener(this.keyListener);
            this.addActionListener(al);
        }
        this.setFocusable(false);
        this.checkVisibility();
    }

    public String getNameAttribute() {
        return this.nameAtt;
    }

    public String getHotkeyAttribute() {
        return this.keyAtt;
    }

    public String getIconAttribute() {
        return this.iconAtt;
    }

    public String getAttributeValueString(String key) {
        if (key.equals(this.nameAtt)) {
            return this.getText();
        }
        if (key.equals(this.keyAtt)) {
            return NamedHotKeyConfigurer.encode(this.keyListener.getNamedKeyStroke());
        }
        if (key.equals(this.iconAtt)) {
            return this.iconConfig.getValueString();
        }
        if (key.equals(this.tooltipAtt)) {
            return this.toolTipText;
        }
        return null;
    }

    public void setAttribute(String key, Object value) {
        if (key != null) {
            if (key.equals(this.nameAtt)) {
                if (Localization.getInstance().isTranslationInProgress()) {
                    this.putClientProperty(UNTRANSLATED_TEXT, this.getText());
                }
                this.setText((String)value);
                this.checkVisibility();
            } else if (key.equals(this.keyAtt)) {
                if (value instanceof String) {
                    value = NamedHotKeyConfigurer.decode((String)value);
                }
                if (value instanceof NamedKeyStroke) {
                    this.keyListener.setKeyStroke((NamedKeyStroke)value);
                } else {
                    this.keyListener.setKeyStroke((KeyStroke)value);
                }
                this.setToolTipText(this.toolTipText);
            } else if (key.equals(this.tooltipAtt)) {
                this.toolTipText = (String)value;
                this.setToolTipText(this.toolTipText);
            } else if (key.equals(this.iconAtt)) {
                if (value instanceof String) {
                    this.iconConfig.setValue((String)value);
                    this.setIcon(this.iconConfig.getIconValue());
                }
                this.checkVisibility();
            }
        }
    }

    @Override
    public void setToolTipText(String text) {
        this.toolTipText = text;
        if (this.keyListener.getKeyStroke() != null) {
            Object object = text = text == null ? "" : (String)text + " ";
            if (!this.keyListener.getNamedKeyStroke().isNamed()) {
                text = (String)text + "[" + NamedHotKeyConfigurer.getString(this.keyListener.getKeyStroke()) + "]";
            }
        }
        super.setToolTipText((String)text);
    }

    public Configurer getNameConfigurer() {
        if (this.nameConfig == null && this.nameAtt != null) {
            this.nameConfig = new StringConfigurer(this.nameAtt, Resources.getString("Editor.button_text_label"), this.getText());
        }
        return this.nameConfig;
    }

    public Configurer getHotkeyConfigurer() {
        if (this.keyConfig == null && this.keyAtt != null) {
            this.keyConfig = new NamedHotKeyConfigurer(this.keyAtt, Resources.getString("Editor.hotkey_label"), this.keyListener.getNamedKeyStroke());
        }
        return this.keyConfig;
    }

    protected void checkVisibility() {
        this.setVisible(this.getText() != null && this.getText().length() > 0 || this.getIcon() != null);
    }
}

