/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools.concurrent;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class ConcurrentSoftHashMap<K, V>
extends AbstractMap<K, V>
implements ConcurrentMap<K, V> {
    private final ConcurrentMap<K, SoftValue<K, V>> map = new ConcurrentHashMap<K, SoftValue<K, V>>();
    private final ReferenceQueue<V> queue = new ReferenceQueue();
    private Set<Map.Entry<K, V>> entrySet;

    private void processQueue() {
        SoftValue sv;
        while ((sv = (SoftValue)this.queue.poll()) != null) {
            this.map.remove(sv.key, sv);
        }
    }

    @Override
    public int size() {
        this.processQueue();
        return this.map.size();
    }

    @Override
    public boolean containsKey(Object key) {
        if (key == null) {
            throw new NullPointerException();
        }
        this.processQueue();
        return this.map.containsKey(key);
    }

    @Override
    public V get(Object key) {
        if (key == null) {
            throw new NullPointerException();
        }
        SoftValue sv = (SoftValue)this.map.get(key);
        if (sv != null) {
            Object value = sv.get();
            if (value == null) {
                this.map.remove(key, sv);
            }
            return (V)value;
        }
        return null;
    }

    @Override
    public V put(K key, V value) {
        if (key == null) {
            throw new NullPointerException();
        }
        if (value == null) {
            throw new NullPointerException();
        }
        this.processQueue();
        SoftValue<K, V> oldSV = this.map.put(key, new SoftValue<K, V>(key, value, this.queue));
        return oldSV == null ? null : (V)oldSV.get();
    }

    @Override
    public V remove(Object key) {
        if (key == null) {
            throw new NullPointerException();
        }
        this.processQueue();
        SoftValue oldSV = (SoftValue)this.map.remove(key);
        return oldSV == null ? null : (V)oldSV.get();
    }

    @Override
    public void clear() {
        this.map.clear();
        while (this.queue.poll() != null) {
        }
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        this.processQueue();
        if (this.entrySet == null) {
            this.entrySet = new AbstractSet<Map.Entry<K, V>>(){

                @Override
                public Iterator<Map.Entry<K, V>> iterator() {
                    return new Iterator<Map.Entry<K, V>>(){
                        private final Iterator<Map.Entry<K, SoftValue<K, V>>> i;
                        {
                            this.i = ConcurrentSoftHashMap.this.map.entrySet().iterator();
                        }

                        @Override
                        public boolean hasNext() {
                            return this.i.hasNext();
                        }

                        @Override
                        public Map.Entry<K, V> next() {
                            Map.Entry e = this.i.next();
                            return new SimpleEntry(e.getKey(), e.getValue().get());
                        }

                        @Override
                        public void remove() {
                            this.i.remove();
                        }
                    };
                }

                @Override
                public int size() {
                    return ConcurrentSoftHashMap.this.size();
                }

                @Override
                public boolean contains(Object v) {
                    return ConcurrentSoftHashMap.this.containsValue(v);
                }
            };
        }
        return this.entrySet;
    }

    @Override
    public V putIfAbsent(K key, V value) {
        if (key == null) {
            throw new NullPointerException();
        }
        if (value == null) {
            throw new NullPointerException();
        }
        this.processQueue();
        SoftValue<K, V> oldSV = this.map.putIfAbsent(key, new SoftValue<K, V>(key, value, this.queue));
        return oldSV == null ? null : (V)oldSV.get();
    }

    @Override
    public boolean remove(Object key, Object value) {
        if (key == null) {
            throw new NullPointerException();
        }
        if (value == null) {
            throw new NullPointerException();
        }
        this.processQueue();
        return this.map.remove(key, new SoftValue<Object, Object>(key, value, null));
    }

    @Override
    public boolean replace(K key, V oldValue, V newValue) {
        if (key == null) {
            throw new NullPointerException();
        }
        if (oldValue == null) {
            throw new NullPointerException();
        }
        if (newValue == null) {
            throw new NullPointerException();
        }
        this.processQueue();
        return this.map.replace(key, new SoftValue<K, V>(key, oldValue, null), new SoftValue<K, V>(key, newValue, this.queue));
    }

    @Override
    public V replace(K key, V value) {
        if (key == null) {
            throw new NullPointerException();
        }
        if (value == null) {
            throw new NullPointerException();
        }
        this.processQueue();
        SoftValue<K, V> oldSV = this.map.replace(key, new SoftValue<K, V>(key, value, this.queue));
        return oldSV == null ? null : (V)oldSV.get();
    }

    private static final class SoftValue<K, V>
    extends SoftReference<V> {
        private final K key;

        private SoftValue(K key, V value, ReferenceQueue<V> queue) {
            super(value, queue);
            this.key = key;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || o.getClass() != this.getClass()) {
                return false;
            }
            SoftValue sv = (SoftValue)o;
            return this.key.equals(sv.key) && this.get() == null ? sv.get() == null : this.get().equals(sv.get());
        }

        public int hashCode() {
            return this.get() == null ? 0 : this.get().hashCode();
        }
    }

    public static class SimpleEntry<K, V>
    implements Map.Entry<K, V> {
        private final K key;
        private V value;

        public SimpleEntry(K key, V value) {
            this.key = key;
            this.value = value;
        }

        public SimpleEntry(Map.Entry<? extends K, ? extends V> entry) {
            this.key = entry.getKey();
            this.value = entry.getValue();
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V value) {
            V oldValue = this.value;
            this.value = value;
            return oldValue;
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return SimpleEntry.eq(this.key, e.getKey()) && SimpleEntry.eq(this.value, e.getValue());
        }

        @Override
        public int hashCode() {
            return (this.key == null ? 0 : this.key.hashCode()) ^ (this.value == null ? 0 : this.value.hashCode());
        }

        public String toString() {
            return this.key + "=" + this.value;
        }

        private static boolean eq(Object o1, Object o2) {
            return o1 == null ? o2 == null : o1.equals(o2);
        }
    }
}

