/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools.image.svg;

import VASSAL.tools.image.ImageIOException;
import VASSAL.tools.image.ImageNotFoundException;
import java.awt.Dimension;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.batik.anim.dom.SAXSVGDocumentFactory;
import org.apache.batik.dom.GenericDOMImplementation;
import org.apache.batik.dom.util.DOMUtilities;
import org.apache.batik.dom.util.SAXDocumentFactory;
import org.apache.batik.dom.util.XLinkSupport;
import org.apache.batik.util.XMLResourceDescriptor;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SVGImageUtils {
    protected static final SAXSVGDocumentFactory factory = new SAXSVGDocumentFactory(XMLResourceDescriptor.getXMLParserClassName());

    private SVGImageUtils() {
    }

    public static Dimension getImageSize(InputStream in) throws IOException {
        return SVGImageUtils.getImageSize("", in);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Dimension getImageSize(String name, InputStream in) throws IOException {
        Document doc;
        try (InputStream inputStream = in;){
            SAXSVGDocumentFactory sAXSVGDocumentFactory = factory;
            synchronized (sAXSVGDocumentFactory) {
                doc = factory.createDocument(null, in);
            }
        }
        catch (FileNotFoundException e) {
            throw new ImageNotFoundException(name, (Throwable)e);
        }
        catch (IOException | DOMException e) {
            throw new ImageIOException(name, (Throwable)e);
        }
        Element root = doc.getDocumentElement();
        try {
            int width = (int)((double)Float.parseFloat(root.getAttributeNS(null, "width").replaceFirst("px", "")) + 0.5);
            int height = (int)((double)Float.parseFloat(root.getAttributeNS(null, "height").replaceFirst("px", "")) + 0.5);
            return new Dimension(width, height);
        }
        catch (NumberFormatException e) {
            throw new ImageIOException(name, (Throwable)e);
        }
    }

    public static List<String> getExternalReferences(String path) throws IOException {
        ArrayList<String> reflist = new ArrayList<String>();
        reflist.add(path);
        return SVGImageUtils.getExternalReferences(path, reflist);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static List<String> getExternalReferences(String path, List<String> known) throws IOException {
        HashSet<String> follow = new HashSet<String>();
        URL here = new URL("file", null, new File(path).getCanonicalPath());
        Document doc = null;
        try {
            SAXSVGDocumentFactory sAXSVGDocumentFactory = factory;
            synchronized (sAXSVGDocumentFactory) {
                doc = factory.createDocument(here.toString());
            }
        }
        catch (DOMException e) {
            throw new IOException(e);
        }
        NodeList usenodes = doc.getElementsByTagName("use");
        for (int i = 0; i < usenodes.getLength(); ++i) {
            Element e = (Element)usenodes.item(i);
            URL url = new URL(new URL(e.getBaseURI()), XLinkSupport.getXLinkHref((Element)e));
            if (url.getProtocol().equals("file")) {
                String refpath = url.getPath();
                if (known.contains(refpath)) continue;
                follow.add(refpath);
                known.add(refpath);
                continue;
            }
            throw new IOException("unsupported protocol '" + url.getProtocol() + "' in xlink:href");
        }
        for (String s : follow) {
            known.addAll(SVGImageUtils.getExternalReferences(s, known));
        }
        return known;
    }

    public static byte[] relativizeExternalReferences(String path) throws IOException {
        SAXDocumentFactory fac = new SAXDocumentFactory((DOMImplementation)new GenericDOMImplementation(), XMLResourceDescriptor.getXMLParserClassName());
        URL here = new URL("file", null, new File(path).getCanonicalPath());
        StringWriter sw = new StringWriter();
        try {
            Document doc = fac.createDocument(here.toString());
            SVGImageUtils.relativizeElement(doc.getDocumentElement());
            DOMUtilities.writeDocument((Document)doc, (Writer)sw);
        }
        catch (DOMException e) {
            throw new IOException(e);
        }
        sw.flush();
        return sw.toString().getBytes();
    }

    protected static void relativizeElement(Element e) {
        NodeList children = e.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node n = children.item(i);
            if (n.getNodeType() != 1) continue;
            SVGImageUtils.relativizeElement((Element)n);
        }
        if (e.hasAttributeNS("http://www.w3.org/1999/xlink", "href")) {
            try {
                URL url = new URL(new URL(e.getBaseURI()), XLinkSupport.getXLinkHref((Element)e));
                String anchor = url.getRef();
                String name = new File(url.getPath()).getName();
                XLinkSupport.setXLinkHref((Element)e, (String)(name + "#" + anchor));
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        e.removeAttributeNS("http://www.w3.org/XML/1998/namespace", "base");
    }
}

