/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools.imageop;

import VASSAL.build.BadDataReport;
import VASSAL.counters.GamePiece;
import VASSAL.tools.ErrorDialog;
import VASSAL.tools.image.ImageIOException;
import VASSAL.tools.image.ImageNotFoundException;
import VASSAL.tools.image.UnrecognizedImageTypeException;
import VASSAL.tools.imageop.AbstractOpImpl;
import VASSAL.tools.imageop.CropOp;
import VASSAL.tools.imageop.CropOpBitmapImpl;
import VASSAL.tools.imageop.GamePieceOp;
import VASSAL.tools.imageop.GamePieceOpImpl;
import VASSAL.tools.imageop.ImageOp;
import VASSAL.tools.imageop.ImageSourceOpBitmapImpl;
import VASSAL.tools.imageop.OrthoRotateOpBitmapImpl;
import VASSAL.tools.imageop.RotateOp;
import VASSAL.tools.imageop.RotateScaleOp;
import VASSAL.tools.imageop.RotateScaleOpBitmapImpl;
import VASSAL.tools.imageop.RotateScaleOpSVGImpl;
import VASSAL.tools.imageop.SVGOp;
import VASSAL.tools.imageop.ScaleOp;
import VASSAL.tools.imageop.ScaleOpBitmapImpl;
import VASSAL.tools.imageop.ScaleOpTiledBitmapImpl;
import VASSAL.tools.imageop.SourceOp;
import VASSAL.tools.imageop.SourceOpBitmapImpl;
import VASSAL.tools.imageop.SourceOpSVGImpl;
import VASSAL.tools.imageop.SourceOpTiledBitmapImpl;
import VASSAL.tools.opcache.OpFailedException;
import java.awt.image.BufferedImage;

public class Op {
    protected Op() {
    }

    public static SourceOp load(String name) {
        if (!((String)name).startsWith("/")) {
            name = "images/" + (String)name;
        }
        if (((String)name).endsWith(".svg")) {
            return new SourceOpSVGImpl((String)name);
        }
        return new SourceOpBitmapImpl((String)name);
    }

    public static SourceOp load(BufferedImage image) {
        return new ImageSourceOpBitmapImpl(image);
    }

    public static SourceOp loadLarge(String name) {
        if (!((String)name).startsWith("/")) {
            name = "images/" + (String)name;
        }
        if (((String)name).endsWith(".svg")) {
            return new SourceOpSVGImpl((String)name);
        }
        return new SourceOpTiledBitmapImpl((String)name);
    }

    public static ScaleOp scale(ImageOp sop, double scale) {
        if (sop instanceof SVGOp) {
            return new RotateScaleOpSVGImpl((SVGOp)sop, 0.0, scale);
        }
        if (sop instanceof SourceOpTiledBitmapImpl) {
            return new ScaleOpTiledBitmapImpl(sop, scale);
        }
        return new ScaleOpBitmapImpl(sop, scale);
    }

    public static RotateOp rotate(ImageOp sop, double angle) {
        if (sop instanceof SVGOp) {
            return new RotateScaleOpSVGImpl((SVGOp)sop, angle, 1.0);
        }
        if (angle % 90.0 == 0.0) {
            return new OrthoRotateOpBitmapImpl(sop, (int)angle);
        }
        return new RotateScaleOpBitmapImpl(sop, angle, 1.0);
    }

    public static RotateScaleOp rotateScale(ImageOp sop, double angle, double scale) {
        if (sop instanceof SVGOp) {
            return new RotateScaleOpSVGImpl((SVGOp)sop, angle, scale);
        }
        return new RotateScaleOpBitmapImpl(sop, angle, scale);
    }

    public static CropOp crop(ImageOp sop, int x0, int y0, int x1, int y1) {
        return new CropOpBitmapImpl(sop, x0, y0, x1, y1);
    }

    public static GamePieceOp piece(GamePiece gp) {
        return new GamePieceOpImpl(gp);
    }

    public static void clearCache() {
        AbstractOpImpl.clearCache();
    }

    public static boolean handleException(Exception e) {
        for (Throwable c = e; c != null; c = c.getCause()) {
            if (c instanceof OpFailedException) {
                return true;
            }
            if (c instanceof ImageNotFoundException) {
                ErrorDialog.dataError(new BadDataReport("Image not found", ((ImageNotFoundException)c).getFile().getName(), null));
                return true;
            }
            if (c instanceof UnrecognizedImageTypeException) {
                ErrorDialog.dataError(new BadDataReport("Unrecognized image type", ((UnrecognizedImageTypeException)c).getFile().getName(), c));
                return true;
            }
            if (!(c instanceof ImageIOException)) continue;
            ErrorDialog.dataError(new BadDataReport("Error reading image", ((ImageIOException)c).getFile().getName(), c));
            return true;
        }
        return false;
    }
}

