/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools.imageop;

import VASSAL.tools.imageop.ImageOp;
import VASSAL.tools.imageop.Op;
import VASSAL.tools.imageop.OpMultiResolutionImage;
import java.awt.Image;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;

public class OwningOpMultiResolutionImage
extends OpMultiResolutionImage {
    protected SortedMap<Double, Image> imgs = new TreeMap<Double, Image>();

    public OwningOpMultiResolutionImage(ImageOp sop) {
        super(sop);
    }

    @Override
    public Image getResolutionVariant(double w, double h) {
        Image img = (Image)this.imgs.get(w);
        if (img == null) {
            img = Op.scale(this.sop, w / (double)this.sop.getWidth()).getImage();
            this.imgs.put(w, img);
        }
        return img;
    }

    @Override
    public List<Image> getResolutionVariants() {
        return Collections.unmodifiableList(new ArrayList<Image>(this.imgs.values()));
    }
}

