/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools.swing;

import VASSAL.tools.concurrent.RangedRunnable;
import VASSAL.tools.lang.Pair;
import VASSAL.tools.swing.EDT;

public abstract class Progressor
extends RangedRunnable<Integer> {
    protected final int max;

    public Progressor(int init, int max) {
        super(init);
        if (init < 0) {
            throw new IllegalArgumentException();
        }
        if (init > max) {
            throw new IllegalArgumentException();
        }
        if (max < 0) {
            throw new IllegalArgumentException();
        }
        this.max = max;
    }

    public synchronized void set(int prog) {
        if (prog < 0) {
            throw new IllegalArgumentException("prog == " + prog);
        }
        if (prog > this.max) {
            throw new IllegalArgumentException("prog == " + prog);
        }
        int cur = this.get();
        if (prog == cur) {
            return;
        }
        if (prog < cur) {
            throw new IllegalArgumentException("prog == " + prog + ", get() == " + this.get());
        }
        this.setLast(prog, 100 * prog / this.max > 100 * (Integer)this.range.first / this.max);
    }

    public synchronized int get() {
        return this.range.second != null ? (Integer)this.range.second : (Integer)this.range.first;
    }

    public synchronized void increment() {
        this.add(1);
    }

    public synchronized void add(int p) {
        if (p != 0) {
            this.set(this.get() + p);
        }
    }

    public void setPct(int pct) {
        this.set(pct * this.max / 100);
    }

    public int getPct() {
        return 100 * this.get() / this.max;
    }

    @Override
    protected abstract void run(Pair<Integer, Integer> var1);

    @Override
    protected void submit() {
        EDT.execute(this);
    }
}

