/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools.swing;

import java.awt.Toolkit;
import java.awt.dnd.DragGestureEvent;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.util.Map;
import javax.swing.SwingUtilities;
import org.apache.commons.lang3.SystemUtils;

public class SwingUtils {
    public static final Map<?, ?> FONT_HINTS = (Map)Toolkit.getDefaultToolkit().getDesktopProperty("awt.font.desktophints");
    private static final InputClassifier INPUT_CLASSIFIER = SystemUtils.IS_OS_MAC_OSX ? new MacInputClassifier() : new DefaultInputClassifier();

    public static AffineTransform descaleTransform(AffineTransform t) {
        return new AffineTransform(1.0, 0.0, 0.0, 1.0, t.getTranslateX(), t.getTranslateY());
    }

    public static boolean isLeftMouseButton(MouseEvent e) {
        return INPUT_CLASSIFIER.isLeftMouseButton(e);
    }

    public static boolean isRightMouseButton(MouseEvent e) {
        return INPUT_CLASSIFIER.isRightMouseButton(e);
    }

    public static boolean isControlDown(MouseEvent e) {
        return INPUT_CLASSIFIER.isControlDown(e);
    }

    public static boolean isDragTrigger(DragGestureEvent e) {
        InputEvent te = e.getTriggerEvent();
        return !(te instanceof MouseEvent) || SwingUtils.isLeftMouseButton((MouseEvent)te);
    }

    private static interface InputClassifier {
        public boolean isLeftMouseButton(MouseEvent var1);

        public boolean isRightMouseButton(MouseEvent var1);

        public boolean isControlDown(MouseEvent var1);
    }

    private static class MacInputClassifier
    implements InputClassifier {
        private static final int B1_MASK = 1152;

        private MacInputClassifier() {
        }

        @Override
        public boolean isLeftMouseButton(MouseEvent e) {
            switch (e.getID()) {
                case 500: 
                case 501: 
                case 502: {
                    return e.getButton() == 1 && (e.getModifiersEx() & 0x80) == 0;
                }
                case 504: 
                case 505: 
                case 506: {
                    return (e.getModifiersEx() & 0x480) == 1024;
                }
            }
            return (e.getModifiersEx() & 0x480) == 1024 || e.getButton() == 1 && (e.getModifiersEx() & 0x80) == 0;
        }

        @Override
        public boolean isRightMouseButton(MouseEvent e) {
            switch (e.getID()) {
                case 500: 
                case 501: 
                case 502: {
                    return e.getButton() == 3 || e.getButton() == 1 && (e.getModifiersEx() & 0x80) != 0;
                }
                case 504: 
                case 505: 
                case 506: {
                    return (e.getModifiersEx() & 0x1000) != 0 || (e.getModifiersEx() & 0x480) == 1152;
                }
            }
            return (e.getModifiersEx() & 0x1000) != 0 || (e.getModifiersEx() & 0x480) == 1152 || e.getButton() == 3 || e.getButton() == 1 && (e.getModifiersEx() & 0x80) != 0;
        }

        @Override
        public boolean isControlDown(MouseEvent e) {
            return e.isMetaDown();
        }
    }

    private static class DefaultInputClassifier
    implements InputClassifier {
        private DefaultInputClassifier() {
        }

        @Override
        public boolean isLeftMouseButton(MouseEvent e) {
            return SwingUtilities.isLeftMouseButton(e);
        }

        @Override
        public boolean isRightMouseButton(MouseEvent e) {
            return SwingUtilities.isRightMouseButton(e);
        }

        @Override
        public boolean isControlDown(MouseEvent e) {
            return e.isControlDown();
        }
    }
}

