/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module;

import VASSAL.build.AbstractConfigurable;
import VASSAL.build.AutoConfigurable;
import VASSAL.build.Buildable;
import VASSAL.build.GameModule;
import VASSAL.build.module.Chatter;
import VASSAL.build.module.GameComponent;
import VASSAL.build.module.Map;
import VASSAL.build.module.PlayerRoster;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.build.module.map.MenuDisplayer;
import VASSAL.build.module.properties.PropertySource;
import VASSAL.command.Command;
import VASSAL.command.NullCommand;
import VASSAL.configure.Configurer;
import VASSAL.configure.ConfigurerFactory;
import VASSAL.configure.GamePieceFormattedStringConfigurer;
import VASSAL.configure.HotKeyConfigurer;
import VASSAL.configure.IconConfigurer;
import VASSAL.configure.PropertyExpression;
import VASSAL.configure.StringArrayConfigurer;
import VASSAL.configure.StringEnumConfigurer;
import VASSAL.configure.VisibilityCondition;
import VASSAL.counters.BasicPiece;
import VASSAL.counters.BoundsTracker;
import VASSAL.counters.Decorator;
import VASSAL.counters.GamePiece;
import VASSAL.counters.PieceFilter;
import VASSAL.counters.PieceIterator;
import VASSAL.counters.PropertiesPieceFilter;
import VASSAL.counters.PropertyExporter;
import VASSAL.counters.Stack;
import VASSAL.i18n.Resources;
import VASSAL.i18n.TranslatableConfigurerFactory;
import VASSAL.preferences.PositionOption;
import VASSAL.tools.FormattedString;
import VASSAL.tools.LaunchButton;
import VASSAL.tools.NamedKeyStroke;
import VASSAL.tools.ScrollPane;
import VASSAL.tools.WriteErrorDialog;
import VASSAL.tools.filechooser.FileChooser;
import VASSAL.tools.swing.SwingUtils;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class Inventory
extends AbstractConfigurable
implements GameComponent,
PlayerRoster.SideChangeListener {
    protected LaunchButton launch;
    protected CounterInventory results;
    protected JTree tree;
    public static final String VERSION = "2.1";
    public static final String HOTKEY = "hotkey";
    public static final String BUTTON_TEXT = "text";
    public static final String NAME = "name";
    public static final String ICON = "icon";
    public static final String TOOLTIP = "tooltip";
    protected String mapSeparator = "\n";
    protected String groupSeparator = "   ";
    public static final String FILTER = "include";
    protected PropertyExpression piecePropertiesFilter = new PropertyExpression();
    public static final String GROUP_BY = "groupBy";
    protected String[] groupBy = new String[]{""};
    public static final String NON_LEAF_FORMAT = "nonLeafFormat";
    protected String nonLeafFormat = "$PropertyValue$";
    public static final String CENTERONPIECE = "centerOnPiece";
    protected boolean centerOnPiece = true;
    public static final String FORWARD_KEYSTROKE = "forwardKeystroke";
    protected boolean forwardKeystroke = true;
    public static final String SHOW_MENU = "showMenu";
    protected boolean showMenu = true;
    public static final String SIDES = "sides";
    protected String[] sides = null;
    public static final String KEYSTROKE = "keystroke";
    protected KeyStroke keyStroke = null;
    public static final String CUTBELOWROOT = "cutRoot";
    protected int cutBelowRoot = 0;
    public static final String CUTABOVELEAVES = "cutLeaves";
    protected int cutAboveLeaves = 0;
    public static final String LEAF_FORMAT = "leafFormat";
    protected String pieceFormat = "$PieceName$";
    public static final String PIECE_ZOOM = "pieceZoom";
    protected double pieceZoom = 0.25;
    public static final String DRAW_PIECES = "drawPieces";
    protected boolean drawPieces = true;
    public static final String FOLDERS_ONLY = "foldersOnly";
    protected boolean foldersOnly = false;
    public static final String SORT_PIECES = "sortPieces";
    protected boolean sortPieces = true;
    public static final String SORT_FORMAT = "sortFormat";
    protected String sortFormat = "$PieceName$";
    public static final String ALPHA = "alpha";
    public static final String LENGTHALPHA = "length";
    public static final String NUMERIC = "numeric";
    public static final String[] SORT_OPTIONS = new String[]{"alpha", "length", "numeric"};
    protected String sortStrategy = "alpha";
    public static final String SORTING = "sorting";
    protected JDialog frame;
    private VisibilityCondition piecesVisible = new VisibilityCondition(){

        @Override
        public boolean shouldBeVisible() {
            return !Inventory.this.foldersOnly;
        }
    };

    public Inventory() {
        ActionListener al = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Inventory.this.launch();
            }
        };
        this.launch = new LaunchButton(null, TOOLTIP, BUTTON_TEXT, HOTKEY, ICON, al);
        this.setAttribute(NAME, Resources.getString("Inventory.inventory"));
        this.setAttribute(BUTTON_TEXT, Resources.getString("Inventory.inventory"));
        this.setAttribute(TOOLTIP, Resources.getString("Inventory.show_inventory"));
        this.setAttribute(ICON, "/images/inventory.gif");
        this.launch.setEnabled(false);
        this.launch.setVisible(false);
    }

    public static String getConfigureTypeName() {
        return Resources.getString("Editor.Inventory.component_type");
    }

    @Override
    public void addTo(Buildable b) {
        GameModule.getGameModule().addSideChangeListenerToPlayerRoster(this);
        this.launch.setAlignmentY(0.0f);
        GameModule.getGameModule().getToolBar().add(this.getComponent());
        GameModule.getGameModule().getGameState().addGameComponent(this);
        this.frame = new JDialog(GameModule.getGameModule().getPlayerWindow());
        this.frame.setTitle(this.getConfigureName());
        String key = "Inventory." + this.getConfigureName();
        GameModule.getGameModule().getPrefs().addOption(new PositionOption(key, this.frame));
        this.frame.setLayout(new BoxLayout(this.frame.getContentPane(), 1));
        this.frame.add(this.initTree());
        this.frame.add(this.initButtons());
        this.frame.setSize(250, 350);
    }

    protected Component initTree() {
        this.tree = new JTree();
        this.tree.setRootVisible(false);
        this.tree.setShowsRootHandles(true);
        this.tree.setRowHeight(0);
        this.tree.setCellRenderer(this.initTreeCellRenderer());
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                GamePiece piece;
                if (Inventory.this.centerOnPiece && (piece = Inventory.this.getSelectedCounter()) != null && piece.getMap() != null) {
                    piece.getMap().centerAt(piece.getPosition());
                }
            }
        });
        this.tree.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                this.maybePopup(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                this.maybePopup(e);
            }

            private void maybePopup(MouseEvent e) {
                CounterNode node;
                GamePiece piece;
                TreePath path;
                if (Inventory.this.showMenu && e.isPopupTrigger() && (path = Inventory.this.tree.getPathForLocation(e.getX(), e.getY())) != null && path.getLastPathComponent() instanceof CounterNode && (piece = (node = (CounterNode)path.getLastPathComponent()).getCounter().getPiece()) != null) {
                    JPopupMenu menu = MenuDisplayer.createPopup(piece);
                    menu.addPropertyChangeListener("visible", new PropertyChangeListener(){

                        @Override
                        public void propertyChange(PropertyChangeEvent evt) {
                            if (Boolean.FALSE.equals(evt.getNewValue())) {
                                SwingUtilities.invokeLater(new Runnable(){

                                    @Override
                                    public void run() {
                                        Inventory.this.refresh();
                                    }
                                });
                            }
                        }
                    });
                    menu.show(Inventory.this.tree, e.getX(), e.getY());
                }
            }
        });
        this.tree.addKeyListener(new HotKeySender());
        ScrollPane scrollPane = new ScrollPane(this.tree, 20, 30);
        this.refresh();
        return scrollPane;
    }

    protected TreeCellRenderer initTreeCellRenderer() {
        return new DefaultTreeCellRenderer(){
            private static final long serialVersionUID = -250332615261355856L;

            @Override
            public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                GamePiece piece;
                super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf && !Inventory.this.foldersOnly, row, hasFocus);
                if (value instanceof CounterNode && (piece = ((CounterNode)value).getCounter().getPiece()) != null) {
                    final Rectangle r = piece.getShape().getBounds();
                    r.x = (int)Math.round((double)r.x * Inventory.this.pieceZoom);
                    r.y = (int)Math.round((double)r.y * Inventory.this.pieceZoom);
                    r.width = (int)Math.round((double)r.width * Inventory.this.pieceZoom);
                    r.height = (int)Math.round((double)r.height * Inventory.this.pieceZoom);
                    this.setIcon(Inventory.this.drawPieces ? new Icon(){

                        @Override
                        public int getIconHeight() {
                            return r.height;
                        }

                        @Override
                        public int getIconWidth() {
                            return r.width;
                        }

                        @Override
                        public void paintIcon(Component c, Graphics g, int x, int y) {
                            Graphics2D g2d = (Graphics2D)g;
                            double os_scale = g2d.getDeviceConfiguration().getDefaultTransform().getScaleX();
                            AffineTransform orig_t = g2d.getTransform();
                            g2d.setTransform(SwingUtils.descaleTransform(orig_t));
                            piece.draw(g, (int)((double)(-r.x) * os_scale), (int)((double)(-r.y) * os_scale), c, Inventory.this.pieceZoom * os_scale);
                            g2d.setTransform(orig_t);
                        }
                    } : null);
                }
                return this;
            }
        };
    }

    protected Component initButtons() {
        Box buttonBox = Box.createHorizontalBox();
        JButton writeButton = new JButton(Resources.getString("General.save"));
        writeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Inventory.this.inventoryToText();
            }
        });
        buttonBox.add(writeButton);
        JButton refreshButton = new JButton(Resources.getString("General.refresh"));
        refreshButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Inventory.this.refresh();
            }
        });
        buttonBox.add(refreshButton);
        JButton closeButton = new JButton(Resources.getString("General.close"));
        closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Inventory.this.frame.setVisible(false);
            }
        });
        buttonBox.add(closeButton);
        return buttonBox;
    }

    protected void inventoryToText() {
        StringBuilder output = new StringBuilder("");
        FileChooser fc = GameModule.getGameModule().getFileChooser();
        if (fc.showSaveDialog() == 1) {
            return;
        }
        File file = fc.getSelectedFile();
        this.mapSeparator = System.getProperty("line.separator");
        output.append(this.results.getResultString());
        try (FileWriter fw = new FileWriter(file);
             BufferedWriter bw = new BufferedWriter(fw);
             PrintWriter p = new PrintWriter(bw);){
            p.print(output);
            Chatter.DisplayText c = new Chatter.DisplayText(GameModule.getGameModule().getChatter(), Resources.getString("Inventory.wrote", file));
            c.execute();
        }
        catch (IOException e) {
            WriteErrorDialog.error(e, file);
        }
    }

    public GamePiece getSelectedCounter() {
        GamePiece piece = null;
        CounterNode node = (CounterNode)this.tree.getLastSelectedPathComponent();
        if (node != null && node.isLeaf()) {
            piece = node.getCounter().getPiece();
        }
        return piece;
    }

    protected Component getComponent() {
        return this.launch;
    }

    @Override
    public void removeFrom(Buildable b) {
        GameModule.getGameModule().getToolBar().remove(this.getComponent());
        GameModule.getGameModule().getGameState().removeGameComponent(this);
    }

    @Override
    public void add(Buildable b) {
    }

    @Override
    public void remove(Buildable b) {
    }

    protected void launch() {
        this.refresh();
        this.frame.setVisible(true);
    }

    private void buildTreeModel() {
        for (Map map : Map.getMapList()) {
            map.getPieces();
        }
        ArrayList<String> path = new ArrayList<String>();
        for (String value : this.groupBy) {
            path.add(value);
        }
        this.results = new CounterInventory(new Counter(this.getConfigureName()), path, this.sortPieces);
        PieceIterator pieceIterator = new PieceIterator(GameModule.getGameModule().getGameState().getAllPieces().iterator(), (PieceFilter)this.piecePropertiesFilter);
        while (pieceIterator.hasMoreElements()) {
            ArrayList<String> groups = new ArrayList<String>();
            GamePiece p = pieceIterator.nextPiece();
            if (!(p instanceof Decorator) && !(p instanceof BasicPiece)) continue;
            for (String s : this.groupBy) {
                String prop;
                if (s.length() <= 0 || (prop = (String)p.getProperty(s)) == null) continue;
                groups.add(prop);
            }
            int count = 1;
            if (this.nonLeafFormat.length() > 0) {
                count = this.getTotalValue(p);
            }
            Counter c = new Counter(p, groups, count, this.pieceFormat, this.sortFormat);
            this.results.insert(c);
        }
    }

    protected int getTotalValue(GamePiece p) {
        String s = (String)p.getProperty(this.nonLeafFormat);
        int count = 1;
        try {
            count = Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            count = 1;
        }
        return count;
    }

    @Override
    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("Inventory.htm");
    }

    public Class<?>[] getAllowableConfigureComponents() {
        return new Class[0];
    }

    @Override
    public String[] getAttributeDescriptions() {
        return new String[]{Resources.getString("Editor.name_label"), Resources.getString("Editor.button_text_label"), Resources.getString("Editor.tooltip_text_label"), Resources.getString("Editor.button_icon_label"), Resources.getString("Editor.hotkey_label"), Resources.getString("Editor.Inventory.show_pieces"), Resources.getString("Editor.Inventory.sort_group_properties"), Resources.getString("Editor.Inventory.label_folders"), Resources.getString("Editor.Inventory.show_folders"), Resources.getString("Editor.Inventory.label_pieces"), Resources.getString("Editor.Inventory.sort"), Resources.getString("Editor.Inventory.label_sort"), Resources.getString("Editor.Inventory.sort_method"), Resources.getString("Editor.Inventory.center_piece"), Resources.getString("Editor.Inventory.forward_keystroke"), Resources.getString("Editor.Inventory.rightclick_piece"), Resources.getString("Editor.Inventory.draw_piece"), Resources.getString("Editor.Inventory.zoom"), Resources.getString("Editor.Inventory.available")};
    }

    @Override
    public Class<?>[] getAttributeTypes() {
        return new Class[]{String.class, String.class, String.class, IconConfig.class, NamedKeyStroke.class, PropertyExpression.class, String[].class, String.class, Boolean.class, PieceFormatConfig.class, Boolean.class, PieceFormatConfig.class, SortConfig.class, Boolean.class, Boolean.class, Boolean.class, Boolean.class, Double.class, String[].class};
    }

    @Override
    public String[] getAttributeNames() {
        return new String[]{NAME, BUTTON_TEXT, TOOLTIP, ICON, HOTKEY, FILTER, GROUP_BY, NON_LEAF_FORMAT, FOLDERS_ONLY, LEAF_FORMAT, SORT_PIECES, SORT_FORMAT, SORTING, CENTERONPIECE, FORWARD_KEYSTROKE, SHOW_MENU, DRAW_PIECES, PIECE_ZOOM, SIDES};
    }

    @Override
    public void setAttribute(String key, Object o) {
        if (NAME.equals(key)) {
            this.setConfigureName((String)o);
        } else if (FILTER.equals(key)) {
            this.piecePropertiesFilter.setExpression((String)o);
        } else if (GROUP_BY.equals(key)) {
            if (o instanceof String) {
                o = StringArrayConfigurer.stringToArray((String)o);
            }
            this.groupBy = o;
        } else if (NON_LEAF_FORMAT.equals(key)) {
            this.nonLeafFormat = (String)o;
        } else if (LEAF_FORMAT.equals(key)) {
            this.pieceFormat = (String)o;
        } else if (CENTERONPIECE.equals(key)) {
            this.centerOnPiece = this.getBooleanValue(o);
        } else if (SHOW_MENU.equals(key)) {
            this.showMenu = this.getBooleanValue(o);
        } else if (DRAW_PIECES.equals(key)) {
            this.drawPieces = this.getBooleanValue(o);
        } else if (FOLDERS_ONLY.equals(key)) {
            this.foldersOnly = this.getBooleanValue(o);
            this.cutAboveLeaves = this.foldersOnly ? 1 : 0;
        } else if (PIECE_ZOOM.equals(key)) {
            if (o instanceof String) {
                o = Double.valueOf((String)o);
            }
            this.pieceZoom = (Double)o;
        } else if (FORWARD_KEYSTROKE.equals(key)) {
            this.forwardKeystroke = this.getBooleanValue(o);
        } else if (SIDES.equals(key)) {
            if (o instanceof String) {
                o = StringArrayConfigurer.stringToArray((String)o);
            }
            this.sides = o;
        } else if (KEYSTROKE.equals(key)) {
            if (o instanceof String) {
                o = HotKeyConfigurer.decode((String)o);
            }
            this.keyStroke = (KeyStroke)o;
        } else if (CUTBELOWROOT.equals(key)) {
            this.cutBelowRoot = o instanceof String ? Integer.parseInt((String)o) : (Integer)o;
        } else if (CUTABOVELEAVES.equals(key)) {
            this.cutAboveLeaves = o instanceof String ? Integer.parseInt((String)o) : (Integer)o;
        } else if (SORT_PIECES.equals(key)) {
            this.sortPieces = this.getBooleanValue(o);
        } else if (SORT_FORMAT.equals(key)) {
            this.sortFormat = (String)o;
        } else if (SORTING.equals(key)) {
            this.sortStrategy = (String)o;
        } else {
            this.launch.setAttribute(key, o);
        }
    }

    @Override
    public VisibilityCondition getAttributeVisibility(String name) {
        if (PIECE_ZOOM.equals(name)) {
            return new VisibilityCondition(){

                @Override
                public boolean shouldBeVisible() {
                    return Inventory.this.drawPieces && !Inventory.this.foldersOnly;
                }
            };
        }
        if (List.of(LEAF_FORMAT, CENTERONPIECE, FORWARD_KEYSTROKE, SHOW_MENU, DRAW_PIECES).contains(name)) {
            return this.piecesVisible;
        }
        return super.getAttributeVisibility(name);
    }

    protected boolean getBooleanValue(Object o) {
        if (o instanceof String) {
            o = Boolean.valueOf((String)o);
        }
        return (Boolean)o;
    }

    @Override
    public String getAttributeValueString(String key) {
        if (NAME.equals(key)) {
            return this.getConfigureName();
        }
        if (FILTER.equals(key)) {
            return this.piecePropertiesFilter.getExpression();
        }
        if (GROUP_BY.equals(key)) {
            return StringArrayConfigurer.arrayToString(this.groupBy);
        }
        if (NON_LEAF_FORMAT.equals(key)) {
            return this.nonLeafFormat;
        }
        if (LEAF_FORMAT.equals(key)) {
            return this.pieceFormat;
        }
        if (CENTERONPIECE.equals(key)) {
            return String.valueOf(this.centerOnPiece);
        }
        if (FORWARD_KEYSTROKE.equals(key)) {
            return String.valueOf(this.forwardKeystroke);
        }
        if (SHOW_MENU.equals(key)) {
            return String.valueOf(this.showMenu);
        }
        if (DRAW_PIECES.equals(key)) {
            return String.valueOf(this.drawPieces);
        }
        if (FOLDERS_ONLY.equals(key)) {
            return String.valueOf(this.foldersOnly);
        }
        if (PIECE_ZOOM.equals(key)) {
            return String.valueOf(this.pieceZoom);
        }
        if (SIDES.equals(key)) {
            return StringArrayConfigurer.arrayToString(this.sides);
        }
        if (KEYSTROKE.equals(key)) {
            return HotKeyConfigurer.encode(this.keyStroke);
        }
        if (CUTBELOWROOT.equals(key)) {
            return "" + this.cutBelowRoot;
        }
        if (CUTABOVELEAVES.equals(key)) {
            return "" + this.cutAboveLeaves;
        }
        if (SORT_PIECES.equals(key)) {
            return "" + this.sortPieces;
        }
        if (SORT_FORMAT.equals(key)) {
            return this.sortFormat;
        }
        if (SORTING.equals(key)) {
            return this.sortStrategy;
        }
        return this.launch.getAttributeValueString(key);
    }

    @Override
    public Command getRestoreCommand() {
        return null;
    }

    @Override
    public void setup(boolean gameStarting) {
        this.launch.setEnabled(gameStarting && this.enabledForPlayersSide());
        if (gameStarting) {
            this.setupLaunch();
        }
    }

    protected void setupLaunch() {
        this.launch.setEnabled(this.enabledForPlayersSide());
        if (this.launch.getClientProperty("hidden") == null) {
            this.launch.setVisible(this.launch.isEnabled());
        }
    }

    @Override
    public void sideChanged(String oldSide, String newSide) {
        this.setupLaunch();
    }

    protected boolean enabledForPlayersSide() {
        if (this.sides == null || this.sides.length == 0) {
            return true;
        }
        for (String side : this.sides) {
            if (!side.equalsIgnoreCase(PlayerRoster.getMySide())) continue;
            return true;
        }
        return false;
    }

    protected Command sendHotKeyToPieces(KeyStroke keyStroke) {
        NullCommand c = new NullCommand();
        TreePath[] tp = this.tree.getSelectionPaths();
        HashSet<GamePiece> pieces = new HashSet<GamePiece>();
        for (TreePath treePath : tp) {
            CounterNode node = (CounterNode)treePath.getLastPathComponent();
            if (node.isLeaf()) {
                pieces.add(node.getCounter().getPiece());
                continue;
            }
            Iterator<CounterNode> j = node.iterator();
            while (j.hasNext()) {
                CounterNode childNode = j.next();
                if (!childNode.isLeaf()) continue;
                pieces.add(childNode.getCounter().getPiece());
            }
        }
        for (GamePiece piece : pieces) {
            GameModule.getGameModule().sendAndLog(piece.keyEvent(keyStroke));
        }
        return c;
    }

    protected Command myUndoCommand() {
        return null;
    }

    private void refresh() {
        int i;
        HashSet<String> expanded = new HashSet<String>();
        int n = this.tree.getRowCount();
        for (i = 0; i < n; ++i) {
            if (!this.tree.isExpanded(i)) continue;
            expanded.add(this.tree.getPathForRow(i).getLastPathComponent().toString());
        }
        this.buildTreeModel();
        this.tree.setModel(this.results);
        for (i = 0; i < this.tree.getRowCount(); ++i) {
            if (!expanded.contains(this.tree.getPathForRow(i).getLastPathComponent().toString())) continue;
            this.tree.expandRow(i);
        }
    }

    public class HotKeySender
    implements KeyListener {
        BoundsTracker tracker;

        public void keyCommand(KeyStroke stroke) {
            Command comm;
            CounterNode node;
            if (Inventory.this.forwardKeystroke && (node = (CounterNode)Inventory.this.tree.getLastSelectedPathComponent()) != null && (comm = this.getCommand(node, stroke)) != null && !comm.isNull()) {
                this.tracker.repaint();
                GameModule.getGameModule().sendAndLog(comm);
                this.tracker = null;
                Inventory.this.refresh();
            }
        }

        protected Command getCommand(CounterNode node, KeyStroke stroke) {
            GamePiece p = node.getCounter() == null ? null : node.getCounter().getPiece();
            Command comm = null;
            if (p != null) {
                p.setProperty("snapshot", ((PropertyExporter)((Object)p)).getProperties());
                if (this.tracker == null) {
                    this.tracker = new BoundsTracker();
                    this.tracker.addPiece(p);
                }
                comm = p.keyEvent(stroke);
            } else {
                comm = new NullCommand();
                int n = node.getChildCount();
                for (int i = 0; i < n; ++i) {
                    comm = comm.append(this.getCommand((CounterNode)node.getChild(i), stroke));
                }
            }
            return comm;
        }

        @Override
        public void keyPressed(KeyEvent e) {
            this.keyCommand(SwingUtils.getKeyStrokeForEvent(e));
        }

        @Override
        public void keyReleased(KeyEvent e) {
            this.keyCommand(SwingUtils.getKeyStrokeForEvent(e));
        }

        @Override
        public void keyTyped(KeyEvent e) {
            this.keyCommand(SwingUtils.getKeyStrokeForEvent(e));
        }
    }

    public class CounterInventory
    implements TreeModel {
        protected List<TreeModelListener> treeModelListeners = new ArrayList<TreeModelListener>();
        protected java.util.Map<String, CounterNode> inventory;
        protected CounterNode root;
        protected String resultString;
        protected List<String> path;
        protected boolean changed;
        protected boolean sort;

        public CounterInventory(Counter c, List<String> path, boolean sort) {
            this.root = new CounterNode(c.getName(), c);
            this.path = path;
            this.inventory = new HashMap<String, CounterNode>();
            this.sort = sort;
            this.changed = true;
        }

        public void insert(Counter counter) {
            String[] path = counter.getPath();
            StringBuilder hash = new StringBuilder();
            CounterNode insertNode = this.root;
            CounterNode newNode = null;
            for (int j = 0; path != null && j < path.length; ++j) {
                hash.append(path[j]);
                if (this.inventory.get(hash.toString()) == null) {
                    newNode = new CounterNode(path[j], new Counter(path[j], counter.getPiece()), insertNode.getLevel() + 1);
                    this.inventory.put(hash.toString(), newNode);
                    insertNode.addChild(newNode, this.sort);
                }
                insertNode = this.inventory.get(hash.toString());
            }
            newNode = new CounterNode(counter.toString(), counter, insertNode.getLevel() + 1);
            insertNode.addChild(newNode, this.sort);
            this.changed = true;
        }

        private void updateEntries() {
            this.root.updateValues();
        }

        public String getResultString() {
            if (this.changed) {
                this.updateTree();
            }
            this.changed = false;
            return this.root.toResultString();
        }

        public String[] getResultStringArray() {
            return new String[]{this.getResultString()};
        }

        @Override
        public Object getRoot() {
            if (this.changed) {
                this.updateTree();
            }
            return this.root;
        }

        private void updateTree() {
            this.updateEntries();
            if (Inventory.this.cutBelowRoot > 0) {
                this.root.cutLevel(Inventory.this.cutBelowRoot);
            }
            for (int i = Inventory.this.cutAboveLeaves; i > 0; --i) {
                this.root.cutLeaves();
            }
            this.changed = false;
        }

        @Override
        public int getChildCount(Object parent) {
            CounterNode counter = (CounterNode)parent;
            return counter.getChildCount();
        }

        @Override
        public boolean isLeaf(Object node) {
            CounterNode counter = (CounterNode)node;
            return counter.isLeaf();
        }

        @Override
        public void addTreeModelListener(TreeModelListener l) {
            this.treeModelListeners.add(l);
        }

        @Override
        public void removeTreeModelListener(TreeModelListener l) {
            this.treeModelListeners.remove(l);
        }

        public void fireNodesRemoved(Object[] path, int[] childIndices, Object[] children) {
            TreeModelEvent e = new TreeModelEvent((Object)this, path, childIndices, children);
            for (TreeModelListener l : this.treeModelListeners) {
                l.treeNodesRemoved(e);
            }
        }

        @Override
        public Object getChild(Object parent, int index) {
            CounterNode counter = (CounterNode)parent;
            return counter.getChild(index);
        }

        @Override
        public int getIndexOfChild(Object parent, Object child) {
            CounterNode counter = (CounterNode)parent;
            return counter.getIndexOfChild(child);
        }

        @Override
        public void valueForPathChanged(TreePath path, Object newValue) {
            throw new UnsupportedOperationException();
        }
    }

    public class CounterNode
    implements Comparable<CounterNode> {
        protected final String entry;
        protected final Counter counter;
        protected List<CounterNode> children;
        protected int level = 0;

        public CounterNode(String entry, Counter counter, int level) {
            this(entry, counter);
            this.level = level;
        }

        protected CounterNode(String entry, Counter counter) {
            this.entry = entry;
            this.counter = counter;
            counter.setNode(this);
            this.children = new ArrayList<CounterNode>();
        }

        public String toString() {
            if (this.counter != null) {
                return this.counter.toString();
            }
            return this.getEntry();
        }

        protected String separator() {
            StringBuilder sep = new StringBuilder();
            if (this.getLevel() > 0) {
                sep.append(Inventory.this.mapSeparator);
            }
            for (int i = 0; i < this.getLevel(); ++i) {
                sep.append(Inventory.this.groupSeparator);
            }
            return sep.toString();
        }

        public String toResultString() {
            StringBuilder name = new StringBuilder();
            name.append(this.separator());
            if (this.counter != null) {
                name.append(this.counter);
            } else {
                name.append(this.getEntry());
            }
            for (CounterNode child : this.children) {
                name.append(child.toResultString());
            }
            return name.toString();
        }

        public String getEntry() {
            return this.entry;
        }

        public Counter getCounter() {
            return this.counter;
        }

        public void addChild(CounterNode counterNode, boolean sort) {
            this.children.add(counterNode);
            if (sort) {
                this.sortChildren();
            }
        }

        public void addChild(int i, CounterNode counterNode, boolean sort) {
            this.children.add(i, counterNode);
            if (sort) {
                this.sortChildren();
            }
        }

        protected void sortChildren() {
            if (Inventory.this.sortStrategy.equals(Inventory.ALPHA)) {
                Collections.sort(this.children);
            } else if (Inventory.this.sortStrategy.equals(Inventory.LENGTHALPHA)) {
                this.children.sort(new LengthAlpha());
            } else if (Inventory.this.sortStrategy.equals(Inventory.NUMERIC)) {
                this.children.sort(new Numerical());
            } else {
                Collections.sort(this.children);
            }
        }

        public void removeChild(CounterNode child) {
            this.children.remove(child);
        }

        public int getChildCount() {
            return this.children.size();
        }

        public boolean isLeaf() {
            return this.children.isEmpty();
        }

        public Object getChild(int index) {
            return this.children.get(index);
        }

        public int getIndexOfChild(Object child) {
            return this.children.indexOf(child);
        }

        public int getLevel() {
            return this.level;
        }

        public void setLevel(int level) {
            this.level = level;
        }

        public int updateValues() {
            int value = 0;
            if (this.counter != null) {
                value = this.counter.getValue();
            }
            for (CounterNode child : this.children) {
                value += child.updateValues();
            }
            this.counter.setValue(value);
            return this.counter.getValue();
        }

        public Iterator<CounterNode> iterator() {
            return this.children.iterator();
        }

        public void cutLevel(int cut) {
            if (cut == 0) {
                this.children.clear();
                return;
            }
            for (CounterNode child : this.children) {
                child.cutLevel(cut - 1);
            }
        }

        public void cutLeaves() {
            ArrayList<CounterNode> toBeRemoved = new ArrayList<CounterNode>();
            for (CounterNode child : this.children) {
                if (child.isLeaf()) {
                    toBeRemoved.add(child);
                    continue;
                }
                child.cutLeaves();
            }
            this.children.removeAll(toBeRemoved);
        }

        @Override
        public int compareTo(CounterNode node) {
            return this.toSortKey().compareTo(node.toSortKey());
        }

        protected String toSortKey() {
            String sortKey = this.getEntry();
            if (this.counter != null) {
                sortKey = this.counter.toSortKey();
            }
            if (!this.children.isEmpty()) {
                sortKey = this.toString();
            }
            return sortKey;
        }

        protected class LengthAlpha
        extends CompareCounterNodes
        implements Comparator<CounterNode> {
            protected LengthAlpha() {
            }

            @Override
            public int compare(CounterNode left, CounterNode right) {
                int rightLength;
                if (!this.argsOK(left, right)) {
                    return this.compareStrangeArgs(left, right);
                }
                int leftLength = left.toSortKey().length();
                if (leftLength < (rightLength = right.toSortKey().length())) {
                    return -1;
                }
                if (leftLength > rightLength) {
                    return 1;
                }
                return left.compareTo(right);
            }
        }

        protected class Numerical
        extends CompareCounterNodes
        implements Comparator<CounterNode> {
            protected final String regex = "\\d+";
            protected final Pattern p;

            protected Numerical() {
                this.regex = "\\d+";
                this.p = Pattern.compile("\\d+");
            }

            protected int getInt(String key) {
                int found = Integer.MIN_VALUE;
                Matcher match = this.p.matcher(key);
                if (!match.find()) {
                    return found;
                }
                int start = match.start();
                found = Integer.parseInt(key.substring(start, match.end()));
                if (start > 0 && key.charAt(start - 1) == '-') {
                    found *= -1;
                }
                return found;
            }

            @Override
            public int compare(CounterNode left, CounterNode right) {
                int r;
                if (!this.argsOK(left, right)) {
                    return this.compareStrangeArgs(left, right);
                }
                int l = this.getInt(left.toSortKey());
                if (l < (r = this.getInt(right.toSortKey()))) {
                    return -1;
                }
                if (l > r) {
                    return 1;
                }
                return 0;
            }
        }

        protected class Alpha
        extends CompareCounterNodes
        implements Comparator<CounterNode> {
            protected Alpha() {
            }

            @Override
            public int compare(CounterNode left, CounterNode right) {
                if (!this.argsOK(left, right)) {
                    return this.compareStrangeArgs(left, right);
                }
                return left.compareTo(right);
            }
        }

        protected class CompareCounterNodes {
            protected CompareCounterNodes() {
            }

            protected boolean argsOK(Object arg0, Object arg1) {
                return arg0 instanceof CounterNode && arg1 instanceof CounterNode;
            }

            protected int compareStrangeArgs(Object arg0, Object arg1) {
                if (arg0 == null) {
                    return 1;
                }
                if (arg0.equals(arg1)) {
                    return 0;
                }
                if (arg1 == null) {
                    return -1;
                }
                if (arg0 instanceof CounterNode && !(arg1 instanceof CounterNode)) {
                    return -1;
                }
                if (arg1 instanceof CounterNode && !(arg0 instanceof CounterNode)) {
                    return 1;
                }
                throw new IllegalArgumentException("These CounterNodes are not strange!");
            }
        }
    }

    public class Counter
    implements PropertySource {
        protected GamePiece piece;
        protected GamePiece source;
        protected List<String> groups;
        protected int value;
        protected String localName;
        protected FormattedString format;
        protected FormattedString sortingFormat;
        protected CounterNode node;

        public Counter(String name) {
            this(name, null);
        }

        public Counter(String name, GamePiece p) {
            this(null, null, 0, this$0.nonLeafFormat, this$0.sortFormat);
            this.localName = name;
            this.source = p;
        }

        public Counter(GamePiece piece, List<String> groups, int value, String format, String sortFormat) {
            this.piece = piece;
            this.value = value;
            this.groups = groups;
            this.format = new FormattedString(format);
            this.sortingFormat = new FormattedString(sortFormat);
        }

        public String getName() {
            if (this.piece != null) {
                return this.piece.getName();
            }
            return this.localName;
        }

        public int hashCode() {
            return this.getName().hashCode();
        }

        public String toString() {
            return this.format.getLocalizedText(this);
        }

        public String toSortKey() {
            return this.sortingFormat.getLocalizedText(this);
        }

        public String[] getPath() {
            return this.groups.toArray(new String[0]);
        }

        public int getValue() {
            return this.value;
        }

        public void setValue(int value) {
            this.value = value;
        }

        public GamePiece getPiece() {
            return this.piece;
        }

        public void setPiece(GamePiece piece) {
            this.piece = piece;
        }

        public boolean equals(Object o) {
            if (!(o instanceof Counter)) {
                return false;
            }
            Counter c = (Counter)o;
            return this.getPath().equals(c.getPath());
        }

        @Override
        public Object getProperty(Object key) {
            Object value = null;
            String s = (String)key;
            if (s.startsWith("sum_")) {
                if (this.piece != null) {
                    value = this.piece.getProperty(s.substring(4));
                } else {
                    int sum = 0;
                    int n = Inventory.this.results.getChildCount(this.node);
                    for (int i = 0; i < n; ++i) {
                        try {
                            CounterNode childNode = (CounterNode)Inventory.this.results.getChild(this.node, i);
                            sum += Integer.parseInt((String)childNode.getCounter().getProperty(key));
                            continue;
                        }
                        catch (NumberFormatException e) {
                            ++sum;
                        }
                    }
                    value = String.valueOf(sum);
                }
            } else {
                if ("PropertyValue".equals(s)) {
                    return this.localName;
                }
                if (this.piece != null) {
                    value = this.piece.getProperty(key);
                } else if (this.source != null) {
                    value = this.source.getProperty(key);
                }
            }
            return value;
        }

        @Override
        public Object getLocalizedProperty(Object key) {
            return this.getProperty(key);
        }

        public void setNode(CounterNode node) {
            this.node = node;
        }
    }

    public static class IconConfig
    implements ConfigurerFactory {
        @Override
        public Configurer getConfigurer(AutoConfigurable c, String key, String name) {
            return new IconConfigurer(key, name, "/images/inventory.gif");
        }
    }

    public static class PieceFormatConfig
    implements TranslatableConfigurerFactory {
        @Override
        public Configurer getConfigurer(AutoConfigurable c, String key, String name) {
            return new GamePieceFormattedStringConfigurer(key, name);
        }
    }

    public static class SortConfig
    implements ConfigurerFactory {
        @Override
        public Configurer getConfigurer(AutoConfigurable c, String key, String name) {
            return new StringEnumConfigurer(key, name, SORT_OPTIONS);
        }
    }

    protected static class Selector
    implements PieceFilter {
        protected PieceFilter filter;

        public Selector(String include) {
            if (include != null && include.length() > 0) {
                this.filter = PropertiesPieceFilter.parse(include);
            }
        }

        @Override
        public boolean accept(GamePiece piece) {
            if (Boolean.TRUE.equals(piece.getProperty("Invisible"))) {
                return false;
            }
            if (piece instanceof Stack) {
                return false;
            }
            if (piece.getMap() == null) {
                return false;
            }
            if (this.filter != null) {
                return this.filter.accept(piece);
            }
            return true;
        }
    }
}

