/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module.map;

import VASSAL.build.module.map.PieceCollection;
import VASSAL.build.module.map.SimplePieceCollection;
import VASSAL.counters.Deck;
import VASSAL.counters.GamePiece;
import VASSAL.counters.Stack;
import java.util.ArrayList;
import java.util.Arrays;

public abstract class CompoundPieceCollection
implements PieceCollection {
    protected SimplePieceCollection[] layers;
    protected int bottomLayer = 0;
    protected boolean[] enabled;

    protected CompoundPieceCollection(int layerCount) {
        this.initLayers(layerCount);
    }

    protected void initLayers(int layerCount) {
        this.layers = new SimplePieceCollection[layerCount];
        this.enabled = new boolean[layerCount];
        for (int i = 0; i < this.layers.length; ++i) {
            this.layers[i] = new SimplePieceCollection();
            this.enabled[i] = true;
        }
    }

    public int getLayerForPiece(GamePiece p) {
        return 0;
    }

    public String getLayerNameForPiece(GamePiece p) {
        return "";
    }

    public int getLayerForName(String layerName) {
        return -1;
    }

    protected PieceCollection getCollectionForPiece(GamePiece p) {
        return this.layers[this.getLayerForPiece(p)];
    }

    @Override
    public void add(GamePiece p) {
        this.getCollectionForPiece(p).add(p);
    }

    @Override
    public void clear() {
        for (SimplePieceCollection layer : this.layers) {
            layer.clear();
        }
    }

    @Override
    public GamePiece[] getPieces() {
        return this.getPieces(false);
    }

    protected GamePiece[] getPieces(boolean includeDisabled) {
        ArrayList<GamePiece> l = new ArrayList<GamePiece>();
        int layer = this.bottomLayer;
        for (int i = 0; i < this.layers.length; ++i) {
            if (includeDisabled || !includeDisabled && this.enabled[layer]) {
                l.addAll(Arrays.asList(this.layers[layer].getPieces()));
            }
            if (++layer < this.layers.length) continue;
            layer = 0;
        }
        return l.toArray(new GamePiece[0]);
    }

    @Override
    public GamePiece[] getAllPieces() {
        return this.getPieces(true);
    }

    @Override
    public int indexOf(GamePiece p) {
        int layer = this.getLayerForPiece(p);
        int index = this.layers[layer].indexOf(p);
        if (index >= 0) {
            for (int i = 0; i < layer - 1; ++i) {
                index += this.layers[i].getPieces().length;
            }
        }
        return index;
    }

    @Override
    public void remove(GamePiece p) {
        this.getCollectionForPiece(p).remove(p);
    }

    @Override
    public void moveToBack(GamePiece p) {
        this.getCollectionForPiece(p).moveToBack(p);
    }

    @Override
    public void moveToFront(GamePiece p) {
        this.getCollectionForPiece(p).moveToFront(p);
    }

    @Override
    public boolean canMerge(GamePiece p1, GamePiece p2) {
        boolean canMerge = false;
        canMerge = p1 instanceof Deck || p2 instanceof Deck ? true : (p1 instanceof Stack ? (p2 instanceof Stack ? this.canStacksMerge((Stack)p1, (Stack)p2) : this.canStackAndPieceMerge((Stack)p1, p2)) : (p2 instanceof Stack ? this.canStackAndPieceMerge((Stack)p2, p1) : this.canPiecesMerge(p1, p2)));
        return canMerge;
    }

    protected boolean canStacksMerge(Stack s1, Stack s2) {
        return this.canPiecesMerge(s1.topPiece(), s2.topPiece());
    }

    protected boolean canStackAndPieceMerge(Stack s, GamePiece p) {
        boolean canMerge = false;
        GamePiece top = s.topPiece();
        if (top != null) {
            canMerge = this.canPiecesMerge(top, p);
        }
        return canMerge;
    }

    protected boolean canPiecesMerge(GamePiece p1, GamePiece p2) {
        boolean canMerge = false;
        if (p1 != null && p2 != null) {
            canMerge = !Boolean.TRUE.equals(p1.getProperty("NoStack")) && !Boolean.TRUE.equals(p2.getProperty("NoStack")) && !Boolean.TRUE.equals(p1.getProperty("Invisible")) && !Boolean.TRUE.equals(p2.getProperty("Invisible"));
        }
        return canMerge;
    }

    public int getLayerCount() {
        return this.layers.length;
    }

    public void setBottomLayer(int layer) {
        this.bottomLayer = layer;
        if (this.bottomLayer < 0) {
            this.bottomLayer = this.getLayerCount() - 1;
        }
        if (this.bottomLayer >= this.getLayerCount()) {
            this.bottomLayer = 0;
        }
    }

    public int getBottomLayer() {
        return this.bottomLayer;
    }

    public int getTopLayer() {
        int layer = this.bottomLayer - 1;
        if (layer < 0) {
            layer = this.getLayerCount() - 1;
        }
        return layer;
    }

    public void rotate(boolean rotateUp, boolean skipNullLayers) {
        if (skipNullLayers) {
            for (int i = 0; i < this.layers.length; ++i) {
                this.rotate(rotateUp);
                if (this.layers[this.getTopLayer()].getPieces().length <= 0) continue;
                return;
            }
        } else {
            this.rotate(rotateUp);
        }
    }

    public void rotate(boolean rotateUp) {
        if (rotateUp) {
            this.setBottomLayer(this.bottomLayer - 1);
        } else {
            this.setBottomLayer(this.bottomLayer + 1);
        }
    }

    public void setLayerEnabled(int layer, boolean b) {
        if (layer >= 0 && layer < this.layers.length) {
            this.enabled[layer] = b;
        }
    }

    public void toggleLayerEnabled(int layer) {
        if (layer >= 0 && layer < this.layers.length) {
            this.enabled[layer] = !this.enabled[layer];
        }
    }

    public void setLayerEnabled(String layer, boolean b) {
        this.setLayerEnabled(this.getLayerForName(layer), b);
    }

    public void toggleLayerEnabled(String layer) {
        this.toggleLayerEnabled(this.getLayerForName(layer));
    }

    public void reset() {
        this.setBottomLayer(0);
        for (int i = 0; i < this.layers.length; ++i) {
            this.enabled[i] = true;
        }
    }
}

